/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.BgSchemeRefDimInfo;
import com.kingdee.eas.ma.mbg.BgSchemeRefMemberCollection;
import com.kingdee.eas.ma.mbg.BgSchemeRefMemberInfo;
import com.kingdee.eas.ma.mbg.BgSchemeTypeFactory;
import com.kingdee.eas.ma.mbg.IBgSchemeType;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgBgPeriodTypeUtils;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MbgSchemeUpdate
extends AbstractMbgUpdate {
    private static final Logger logger = Logger.getLogger(MbgSchemeUpdate.class);

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        this.startUpdateScheme();
    }

    private void startUpdateScheme() throws EASBizException, BOSException {
        this.dealBgSchemeNode();
        this.dealBgShcemeType();
        this.addBgScenarioToScheme();
    }

    private void dealBgSchemeNode() throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        conn = this.getConnection();
        HashMap<String, String> childSchemeMap = new HashMap<String, String>();
        try {
            String querySql = "select Fid, FRootId from t_mbg_bgscheme where Fid <> FRootId ";
            pstmt = conn.prepareStatement(querySql);
            rst = pstmt.executeQuery();
            String id = null;
            String rootId = null;
            while (rst.next()) {
                id = rst.getString("Fid");
                rootId = rst.getString("FRootId");
                if (id == null || StringUtils.isEmpty((String)id) || rootId == null || StringUtils.isEmpty((String)rootId)) continue;
                childSchemeMap.put(rst.getString("Fid"), rst.getString("FRootId"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!childSchemeMap.isEmpty()) {
                String updateSql = "update t_mbg_bgschemenode set fbgschemeid = ? where fbgschemeid = ?";
                pstmt = conn.prepareStatement(updateSql);
                int index = 0;
                String key2 = null;
                for (String key2 : childSchemeMap.keySet()) {
                    pstmt.setString(1, (String)childSchemeMap.get(key2));
                    pstmt.setString(2, key2);
                    pstmt.addBatch();
                    if (++index < 50) continue;
                    pstmt.executeBatch();
                    index = 0;
                }
                if (index > 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
                String deleteSql = "delete from t_mbg_bgscheme where fid <> frootid and frootid is not null and len(frootid) > 0 ";
                pstmt = conn.prepareStatement(deleteSql);
                pstmt.execute();
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"MbgSchemeUpdate error!", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void dealBgShcemeType() throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection();
            HashMap<String, String> schemeAndType = MbgBgPeriodTypeUtils.buildBgPeriodTypeMap(conn, true);
            if (schemeAndType.isEmpty()) {
                return;
            }
            if (schemeAndType.values().contains("lVIAAABXGOSQxGui")) {
                ObjectUuidPK pk = new ObjectUuidPK("lVIAAABXGOSQxGui");
                IBgSchemeType iBgSchemeType = BgSchemeTypeFactory.getLocalInstance(this.getContext());
                if (!iBgSchemeType.exists((IObjectPK)pk)) {
                    String shareType = BgNFSHelper.getHardCodeRes(this.getContext(), "shareType");
                    String preType = BgNFSHelper.getHardCodeRes(this.getContext(), "preType");
                    pstmt = conn.prepareStatement("insert into  T_MBG_BgSchemeType(FID,FSchemeType,FCreateOrgUnitID,FName_l2,FNumber,FDescription_l2,FControlUnitID) values ('lVIAAABXGOSQxGui',70,'00000000-0000-0000-0000-000000000000CCE7AED4','" + shareType + "','GYYZ','" + preType + "','00000000-0000-0000-0000-000000000000CCE7AED4')");
                    pstmt.execute();
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            if (!schemeAndType.isEmpty()) {
                String updateSql = "update T_MBG_BgScheme set FBgSchemeTypeID = ? where FId = ? ";
                pstmt = conn.prepareStatement(updateSql);
                int index = 0;
                String bgSchemeID2 = null;
                for (String bgSchemeID2 : schemeAndType.keySet()) {
                    pstmt.setString(1, schemeAndType.get(bgSchemeID2));
                    pstmt.setString(2, bgSchemeID2);
                    pstmt.addBatch();
                    if (++index < 50) continue;
                    pstmt.executeBatch();
                    index = 0;
                }
                if (index > 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"MbgSchemeUpdate error!", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    private void addBgScenarioToScheme() throws BOSException, EASBizException {
        HashMap<String, BgSchemeRefDimInfo> refDimMap = new HashMap<String, BgSchemeRefDimInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement("Select refDim.FID refDim_FID, refMember.FID refMember_FID, refMember.FNumber refMember_FNumber, refMember.FSeq refMember_FSeq, refMember.FName refMember_FName FROM T_MBG_BgSchemeRefDim refDim Inner Join T_MBG_BgSchemeRefMember refMember ON refDim.FID = FRefDimId");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String id = rst.getString("refDim_FID");
                BgSchemeRefDimInfo dimInfo = null;
                if (refDimMap.containsKey(id)) {
                    dimInfo = (BgSchemeRefDimInfo)refDimMap.get(id);
                } else {
                    dimInfo = new BgSchemeRefDimInfo();
                    dimInfo.setId(BOSUuid.read((String)id));
                    refDimMap.put(id, dimInfo);
                }
                BgSchemeRefMemberInfo memberInfo = new BgSchemeRefMemberInfo();
                memberInfo.setId(BOSUuid.read((String)rst.getString("refMember_FID")));
                memberInfo.setNumber(rst.getString("refMember_FNumber"));
                memberInfo.setName(rst.getString("refMember_FName"));
                memberInfo.setSeq(rst.getInt("refMember_FSeq"));
                dimInfo.getMembers().add(memberInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (!refDimMap.isEmpty()) {
            BOSObjectType bosType = new BgSchemeRefMemberInfo().getBOSType();
            for (BgSchemeRefDimInfo dimInfo : refDimMap.values()) {
                BgSchemeRefMemberCollection members = dimInfo.getMembers();
                Integer max = 0;
                Boolean hasActualScena = false;
                Boolean hasDateScena = false;
                if (members.size() > 0) {
                    BgSchemeRefMemberInfo refMember = null;
                    Integer seq = null;
                    String refMemNum = null;
                    for (int k = 0; k < members.size(); ++k) {
                        refMember = members.get(k);
                        if (refMember == null) continue;
                        seq = refMember.getSeq();
                        refMemNum = refMember.getNumber();
                        if (seq > max) {
                            max = seq;
                        }
                        if (this.getCacheHelper().getBgDataScenario().getNumber().equalsIgnoreCase(refMemNum)) {
                            hasDateScena = true;
                        }
                        if (!this.getCacheHelper().getBgActualScenario().getNumber().equalsIgnoreCase(refMemNum)) continue;
                        hasActualScena = true;
                    }
                }
                if (!hasDateScena.booleanValue()) {
                    Object[] objectArray = new Object[6];
                    objectArray[0] = BOSUuid.create((BOSObjectType)bosType).toString();
                    max = max + 1;
                    objectArray[1] = max;
                    objectArray[2] = dimInfo.getId().toString();
                    objectArray[3] = 301;
                    objectArray[4] = this.getCacheHelper().getBgDataScenario().getName();
                    objectArray[5] = this.getCacheHelper().getBgDataScenario().getNumber();
                    params.add(objectArray);
                }
                if (hasActualScena.booleanValue()) continue;
                Object[] objectArray = new Object[6];
                objectArray[0] = BOSUuid.create((BOSObjectType)bosType).toString();
                max = max + 1;
                objectArray[1] = max;
                objectArray[2] = dimInfo.getId().toString();
                objectArray[3] = 301;
                objectArray[4] = this.getCacheHelper().getBgActualScenario().getName();
                objectArray[5] = this.getCacheHelper().getBgActualScenario().getNumber();
                params.add(objectArray);
            }
        }
        if (!params.isEmpty()) {
            try {
                conn = this.getConnection();
                String sql = "Insert Into T_MBG_BgSchemeRefMember(FID, FSeq, FRefDimID, FMemberType, FName, FNumber) Values (?, ?, ?, ?, ?, ?)";
                MbgSqlHelper.executeBatch((Connection)conn, (String)sql, params);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }
}

