/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.ClosureUtils;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class MbgTableUpdate
extends AbstractMbgUpdate {
    private static final Logger logger = Logger.getLogger(MbgTableUpdate.class);

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (BgDBUtils.existColumn((Connection)conn, (String)"T_Mbg_BgForm", (String)"FBgTemplateRootId") == BgDBUtils.NO) {
                MbgSqlHelper.execute((Connection)conn, (String)"Alter Table T_Mbg_BgForm add FBgTemplateRootId NVarchar(44)");
            }
            this.updateDataTable(conn);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void updateDataTable(Connection conn) throws BOSException, SQLException {
        List refCubes = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)"Select FRefCube FROM T_Mbg_BgScheme Where FRefCube IS NOT NULL", null);
        if (refCubes == null || refCubes.isEmpty()) {
            return;
        }
        String bgCube2 = null;
        String dailyCube = null;
        String ctrlCube = null;
        for (String bgCube2 : refCubes) {
            String acCube = BgCubeUtils.getActualCubeName1(bgCube2);
            dailyCube = BgCubeUtils.getDailyActualCubeName(bgCube2);
            ctrlCube = BgCubeUtils.getControlCubeName(bgCube2);
            this.addProcessField(conn, bgCube2);
            this.addProcessField(conn, acCube);
            this.addProcessField(conn, dailyCube);
            this.addProcessField(conn, ctrlCube);
            if (BgDBUtils.existColumn((Connection)conn, (String)bgCube2, (String)"FScenario") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + bgCube2 + " ADD FScenario INT DEFAULT 0 NOT NULL"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + bgCube2 + " set FScenario = " + this.getCacheHelper().getBgDataScenario().getScenarioId()));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)acCube, (String)"FScenario") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + acCube + " ADD FScenario INT DEFAULT 0 NOT NULL"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + acCube + " set FScenario = " + BgScenarioHelper.ACTUAL_SCENARIO_VALUE));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)dailyCube, (String)"FScenario") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + dailyCube + " ADD FScenario INT DEFAULT 0 NOT NULL"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + dailyCube + " set FScenario = " + BgScenarioHelper.ACTUAL_SCENARIO_VALUE));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)ctrlCube, (String)"FScenario") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + ctrlCube + " ADD FScenario INT DEFAULT 0 NOT NULL"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + ctrlCube + " set FScenario = " + BgScenarioHelper.ACTUAL_SCENARIO_VALUE));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)bgCube2, (String)"FVersion") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + bgCube2 + " ADD FVersion INT DEFAULT 0 NOT NULL"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + bgCube2 + " set FVersion = " + BgVersionHelper.DEF_VERSION_VALUE));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)acCube, (String)"FVersion") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + acCube + " ADD FVersion INT DEFAULT 0 NOT NULL"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + acCube + " set FVersion = " + BgVersionHelper.DEF_VERSION_VALUE));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)dailyCube, (String)"FVersion") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + dailyCube + " ADD FVersion INT DEFAULT 0 NOT NULL"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + dailyCube + " set FVersion = " + BgVersionHelper.DEF_VERSION_VALUE));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)ctrlCube, (String)"FVersion") != BgDBUtils.NO) continue;
            BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + ctrlCube + " ADD FVersion INT DEFAULT 0 NOT NULL"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update " + ctrlCube + " set FVersion = " + BgVersionHelper.DEF_VERSION_VALUE));
        }
    }

    private void addProcessField(Connection conn, String bgCube) throws SQLException {
        if (BgDBUtils.existColumn((Connection)conn, (String)bgCube, (String)"FIndex") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + bgCube + " ADD FIndex INT"));
        }
        if (BgDBUtils.existColumn((Connection)conn, (String)bgCube, (String)"FBefore") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + bgCube + " ADD FBefore NVARCHAR(1500)"));
        }
        if (BgDBUtils.existColumn((Connection)conn, (String)bgCube, (String)"FPeriodNumber") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + bgCube + " ADD FPeriodNumber NVARCHAR(200)"));
        }
        if (BgDBUtils.existColumn((Connection)conn, (String)bgCube, (String)"FAfter") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("ALTER TABLE " + bgCube + " ADD FAfter NVARCHAR(1000)"));
        }
    }

    public void afterUpdate() throws BOSException {
        Connection conn = null;
        try {
            List refCubes;
            conn = this.getConnection();
            if (BgDBUtils.existColumn((Connection)conn, (String)"T_Mbg_BgForm", (String)"FBgTemplateRootId") == BgDBUtils.YES) {
                MbgSqlHelper.execute((Connection)conn, (String)"Alter Table T_Mbg_BgForm Drop Column FBgTemplateRootId");
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_Mbg_BgScheme set FRootId = ''");
            List bgPeriodTypeIds = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)"Select FID FROM T_MBG_BgPeriodType", null);
            if (bgPeriodTypeIds != null) {
                ClosureUtils utils = new ClosureUtils();
                for (String id : bgPeriodTypeIds) {
                    utils.checkBgPeriodData(this.getContext(), BOSUuid.read((String)id));
                }
            }
            if ((refCubes = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)"Select FRefCube FROM T_Mbg_BgScheme Where FRefCube IS NOT NULL", null)) == null || refCubes.isEmpty()) {
                return;
            }
            String bgCube2 = null;
            String dailyCube = null;
            String ctrlCube = null;
            for (String bgCube2 : refCubes) {
                String acCube = BgCubeUtils.getActualCubeName1(bgCube2);
                dailyCube = BgCubeUtils.getDailyActualCubeName(bgCube2);
                ctrlCube = BgCubeUtils.getControlCubeName(bgCube2);
                this.deleteProcessField(conn, bgCube2);
                this.deleteProcessField(conn, acCube);
                this.deleteProcessField(conn, dailyCube);
                this.deleteProcessField(conn, ctrlCube);
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + bgCube2 + " Set FVersion = 1"));
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + dailyCube + " Set FVersion = 1"));
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + ctrlCube + " Set FVersion = 1"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void deleteProcessField(Connection conn, String bgCube) throws BOSException {
        if (BgDBUtils.existColumn((Connection)conn, (String)bgCube, (String)"FIndex") == BgDBUtils.YES) {
            MbgSqlHelper.execute((Connection)conn, (String)("Alter Table " + bgCube + " Drop Column FIndex"));
        }
        if (BgDBUtils.existColumn((Connection)conn, (String)bgCube, (String)"FBefore") == BgDBUtils.YES) {
            MbgSqlHelper.execute((Connection)conn, (String)("Alter Table " + bgCube + " Drop Column FBefore"));
        }
        if (BgDBUtils.existColumn((Connection)conn, (String)bgCube, (String)"FPeriodNumber") == BgDBUtils.YES) {
            MbgSqlHelper.execute((Connection)conn, (String)("Alter Table " + bgCube + " Drop Column FPeriodNumber"));
        }
        if (BgDBUtils.existColumn((Connection)conn, (String)bgCube, (String)"FAfter") == BgDBUtils.YES) {
            MbgSqlHelper.execute((Connection)conn, (String)("Alter Table " + bgCube + " Drop Column FAfter"));
        }
    }
}

