/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgBookProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgTemplateDisplateProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgViewManagerProcessor;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class MbgTemplateUpdate
extends AbstractMbgUpdate {
    private static Logger logger = Logger.getLogger((String)MbgTemplateUpdate.class.getName());

    @Override
    public void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            MbgBookProcessor processor = new MbgBookProcessor(conn, this.getBgScenarioNumber(), this.getCacheHelper(), this.getBookQuerySql(), this.getBookUpdateSql());
            processor.startProcess();
            MbgViewManagerProcessor processor1 = new MbgViewManagerProcessor(conn, this.getBgScenarioNumber(), this.getCacheHelper(), this.getViewQuerySql(), this.getViewUpdateSql());
            processor1.startProcess();
            this.otherUpdate(conn);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected String getBgScenarioNumber() {
        return this.getCacheHelper().getBgDataScenario().getNumber();
    }

    protected void otherUpdate(Connection conn) throws Exception {
        MbgTemplateDisplateProcessor disp = new MbgTemplateDisplateProcessor(conn, this.getCacheHelper());
        disp.startProcess();
    }

    protected String getBookQuerySql() {
        return "Select FID " + MbgViewManagerProcessor.idField + ", FData " + MbgViewManagerProcessor.dataField + ", FRootID " + MbgViewManagerProcessor.templateRootIdField + " FROM T_Mbg_BgTemplate Where FFormType <> " + 4 + " Order By FRootID";
    }

    protected String getBookUpdateSql() {
        return "Update T_Mbg_BgTemplate set FData = ? Where FID = ?";
    }

    protected String getViewQuerySql() {
        return "Select temp.FID " + MbgViewManagerProcessor.idField + ", viewDim.FData " + MbgViewManagerProcessor.dataField + ", temp.FRootID " + MbgViewManagerProcessor.templateRootIdField + " FROM T_Mbg_BgViewDimension viewDim, T_Mbg_BgTemplate temp Where temp.FID = viewDim.FTemplateId AND viewDim.FData IS NOT NULL";
    }

    public String getViewUpdateSql() {
        return "Update T_Mbg_BgViewDimension set FData = ? Where FTemplateId = ?";
    }
}

