/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateConfigInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgUpdateCacheHelper {
    private static Logger logger = Logger.getLogger((String)MbgUpdateCacheHelper.class.getName());
    private Context context = null;
    private MbgUpdateConfigInfo updateConfig;
    private BgScenarioInfo bgDataScenario = null;
    private BgScenarioInfo bgActualScenario = null;
    private BgVersionInfo exeVersion = null;
    private Map<String, DimensionInfo> dimensionMap = new HashMap<String, DimensionInfo>();
    private Map<String, MbgUpdateOrgInfo> templateUpdateMap = new HashMap<String, MbgUpdateOrgInfo>();
    private Map<String, Integer> templatePeriodMap = new HashMap<String, Integer>();
    private Map<String, Integer> schemePeriodMap = new HashMap<String, Integer>();
    private Map<String, MbgUpdateOrgInfo> bgSchemeUpdateMap = new HashMap<String, MbgUpdateOrgInfo>();
    private Map<String, MbgUpdateOrgInfo> bgSchemeIdUpdateMap = new HashMap<String, MbgUpdateOrgInfo>();
    private Map<String, String> bgDataCubeMap = new HashMap<String, String>();
    private Map<String, String> bgSchemeRootMap = new HashMap<String, String>();
    private Map<String, String> oldPeriodMap = new HashMap<String, String>();
    private Map<String, BgPeriodInfo> bgPeriodMap = null;

    public MbgUpdateCacheHelper(Context context, MbgUpdateConfigInfo updateConfig) {
        this.context = context;
        this.updateConfig = updateConfig;
    }

    public Context getContext() {
        return this.context;
    }

    public MbgUpdateConfigInfo getUpdateConfig() {
        return this.updateConfig;
    }

    public void initCacheHelper() throws BOSException, EASBizException {
        this.initBgScenario();
        this.initBgVerision();
        this.initDimension();
        this.initConfig();
        this.initBgScheme();
        this.initOldPeriod();
        this.initTemplatePeriod();
    }

    private void initTemplatePeriod() throws BOSException {
        IRowSet rst;
        block7: {
            String sql = "Select bgTemplate.FRootId, bgScheme.FPeriod FROM T_Mbg_BgTemplate bgTemplate, T_Mbg_BgScheme bgScheme, T_Mbg_BgSchemeNode sNode Where bgTemplate.FID = sNode.FBgTemplateId AND bgScheme.FID = sNode.FBgSchemeId GROUP BY bgTemplate.FRootId, bgScheme.FPeriod";
            rst = null;
            rst = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
            if (rst != null) break block7;
            SQLUtils.cleanup((ResultSet)rst);
            return;
        }
        try {
            while (rst.next()) {
                String id = rst.getString("FRootId");
                int type = rst.getInt("FPeriod");
                if (this.templatePeriodMap.containsKey(id)) {
                    this.templatePeriodMap.put(id, type);
                    continue;
                }
                this.templatePeriodMap.put(id, type);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    private void initOldPeriod() throws BOSException {
        BgPeriodCollection col = BgPeriodFactory.getLocalInstance((Context)this.getContext()).getBgPeriodCollection("select id, number");
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                this.oldPeriodMap.put(col.get(i).getId().toString(), col.get(i).getNumber());
            }
        }
    }

    public void initBgVerision() throws BOSException, EASBizException {
        this.exeVersion = BgVersionFactory.getLocalInstance((Context)this.getContext()).getBgVersionInfo("select id, number, name, versionId where number in('Ve')");
    }

    public void initBgScenario() throws BOSException {
        BgScenarioCollection scenarios = BgScenarioFactory.getLocalInstance((Context)this.getContext()).getBgScenarioCollection("select id, number, name, scenarioId where number in('BgData', 'ActData')");
        for (int i = 0; i < scenarios.size(); ++i) {
            if ("BgData".equals(scenarios.get(i).getNumber())) {
                this.bgDataScenario = scenarios.get(i);
                continue;
            }
            if (!"ActData".equals(scenarios.get(i).getNumber())) continue;
            this.bgActualScenario = scenarios.get(i);
        }
    }

    private void initBgScheme() throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            pstmt = conn.prepareStatement("Select FID, FRootId, FRefCube, FPeriod FROM T_MBG_BgScheme");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String refCube = rst.getString("FRefCube");
                String id = rst.getString("FID");
                String rootId = rst.getString("FRootId");
                int period = rst.getInt("FPeriod");
                this.bgSchemeRootMap.put(id, rootId);
                if (StringUtils.isEmpty((String)refCube)) continue;
                this.bgDataCubeMap.put(rootId, refCube);
                this.schemePeriodMap.put(rootId, period);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"initBgDataCube", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void initConfig() {
        if (this.updateConfig == null) {
            return;
        }
        for (MbgUpdateOrgInfo config : this.updateConfig.getOrgConfig().values()) {
            this.templateUpdateMap.put(config.getBgTemplate().getRootId().toString(), config);
            this.bgSchemeUpdateMap.put(config.getBgScheme().getNumber(), config);
            if (config.getBgScheme() == null || config.getBgScheme().getId() == null) continue;
            this.bgSchemeIdUpdateMap.put(config.getBgScheme().getId().toString(), config);
        }
    }

    private void initDimension() throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            pstmt = conn.prepareStatement("Select FID, FNumber, FName_L1, FName_L2, FName_L3, FRefField FROM T_MBG_Dim Where FIsSystemDef = 1");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                DimensionInfo dimension = new DimensionInfo();
                dimension.setId(BOSUuid.read((String)rst.getString("FID")));
                dimension.setNumber(rst.getString("FNumber"));
                dimension.setName(rst.getString("FName_L1"), LocaleUtils.locale_L1);
                dimension.setName(rst.getString("FName_L2"), LocaleUtils.locale_L2);
                dimension.setName(rst.getString("FName_L3"), LocaleUtils.locale_L3);
                dimension.setRefField(rst.getString("FRefField"));
                this.dimensionMap.put(dimension.getNumber(), dimension);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    public MbgUpdateOrgInfo getUpdateInfoByTemplate(String tmplateRootId) {
        return this.templateUpdateMap.get(tmplateRootId);
    }

    public MbgUpdateOrgInfo getUpdateInfoByBgSchemeNumber(String bgSchemeNumber) {
        return this.bgSchemeUpdateMap.get(bgSchemeNumber);
    }

    public MbgUpdateOrgInfo getUpdateInfoByBgSchemeId(String bgSchemeId) {
        return this.bgSchemeIdUpdateMap.get(bgSchemeId);
    }

    public BgScenarioInfo getBgDataScenario() {
        return this.bgDataScenario;
    }

    public BgScenarioInfo getBgActualScenario() {
        return this.bgActualScenario;
    }

    public BgVersionInfo getExeVersion() {
        return this.exeVersion;
    }

    public Map<String, DimensionInfo> getDimensionMap() {
        return this.dimensionMap;
    }

    public Map<String, String> getBgDataCubeMap() {
        return this.bgDataCubeMap;
    }

    public Map<String, String> getOldPeriodMap() {
        return this.oldPeriodMap;
    }

    public Map<String, String> getBgSchemeRootMap() {
        return this.bgSchemeRootMap;
    }

    public Map<String, BgPeriodInfo> getBgPeriodMap() throws BOSException {
        if (this.bgPeriodMap == null) {
            this.bgPeriodMap = new HashMap<String, BgPeriodInfo>();
            BgPeriodCollection col = BgPeriodFactory.getLocalInstance((Context)this.getContext()).getBgPeriodCollection("select id, number");
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    this.bgPeriodMap.put(col.get(i).getNumber(), col.get(i));
                }
            }
        }
        return this.bgPeriodMap;
    }

    public int getPeriodEnumByTemplateRootId(String bgTempRootId) {
        if (this.templatePeriodMap.containsKey(bgTempRootId)) {
            return this.templatePeriodMap.get(bgTempRootId);
        }
        return 4;
    }

    public int getPeriodEnumBySchemeRootId(String bgSchemeRootId) {
        if (this.bgSchemeIdUpdateMap.containsKey(bgSchemeRootId) && this.bgSchemeIdUpdateMap.get(bgSchemeRootId).getPeriodType() != null) {
            return this.bgSchemeIdUpdateMap.get(bgSchemeRootId).getPeriodType().getValue();
        }
        if (this.bgSchemeRootMap.containsKey(bgSchemeRootId)) {
            bgSchemeRootId = this.bgSchemeRootMap.get(bgSchemeRootId);
        }
        if (this.schemePeriodMap.containsKey(bgSchemeRootId)) {
            return this.schemePeriodMap.get(bgSchemeRootId);
        }
        return 4;
    }
}

