/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateCalculateInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateConfigInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgUpdateCheckCalcRuleHelper {
    private static final Logger logger = CoreUIObject.getLogger(MbgUpdateCheckCalcRuleHelper.class);

    public static List<MbgUpdateCalculateInfo> check(Context ctx, MbgUpdateConfigInfo configInfo) {
        ArrayList<MbgUpdateCalculateInfo> returnVal = new ArrayList<MbgUpdateCalculateInfo>();
        try {
            returnVal.addAll(MbgUpdateCheckCalcRuleHelper.getNotAssociatedSchemeIDs(ctx));
            returnVal.addAll(MbgUpdateCheckCalcRuleHelper.getAssociatedSchemeIDs(ctx));
        }
        catch (BOSException e) {
            logger.error((Object)"MbgUpdateCheckCalcRuleHelper", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"MbgUpdateCheckCalcRuleHelper", (Throwable)e);
        }
        return returnVal;
    }

    private static List<MbgUpdateCalculateInfo> getAssociatedSchemeIDs(Context ctx) throws BOSException, SQLException {
        ArrayList<MbgUpdateCalculateInfo> list = new ArrayList<MbgUpdateCalculateInfo>();
        HashMap map = new HashMap();
        String sql = "select t1.fbizcalcid,t1.fbgschemeid ,t2.fperiod, t2.fname_" + ctx.getLocale() + ",t2.fnumber, t3.fname_" + ctx.getLocale() + ", t3.fnumber from T_MBG_BizCalcSchemeRelation t1\tleft join t_mbg_bgscheme t2 on t2.fid = t1.fbgschemeid\tleft join T_MBG_BizCalc  t3 on t3.fid = t1.fbizcalcid where t1.fbizcalcid in( select fid FROM  T_MBG_BizCalc where fid in ( select fbizcalcid from (select count(fbizcalcid) as amount , fbizcalcid from  T_MBG_BizCalcSchemeRelation group by fbizcalcid ) temp where temp.amount > 1 ) and fid in( select fbizschemeid from T_MBG_BizCalcRule where fbgperiodnum is not null))";
        ISQLExecutor iSql = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = iSql.executeSQL();
        String fid = null;
        String fbgschemeid = null;
        int fperiod = -1;
        MbgUpdateCalculateInfo firstInfo = null;
        while (rs.next()) {
            BizCalcInfo bizCalc;
            BgSchemeInfo bgScheme;
            fid = rs.getString(1);
            fbgschemeid = rs.getString(2);
            fperiod = rs.getInt(3);
            if (fid != null && fperiod != -1 && map.containsKey(fid) && !((Set)map.get(fid)).isEmpty() && !((Set)map.get(fid)).contains(fperiod)) {
                MbgUpdateCalculateInfo info = new MbgUpdateCalculateInfo();
                bgScheme = new BgSchemeInfo();
                bgScheme.setId(BOSUuid.read((String)fbgschemeid));
                bgScheme.setName(rs.getString(4));
                bgScheme.setNumber(rs.getString(5));
                info.setBgScheme(bgScheme);
                bizCalc = new BizCalcInfo();
                bizCalc.setId(BOSUuid.read((String)fid));
                bizCalc.setName(rs.getString(6));
                bizCalc.setNumber(rs.getString(7));
                info.setBizCalc(bizCalc);
                if (((Set)map.get(fid)).size() == 1) {
                    list.add(firstInfo);
                }
                list.add(info);
                ((Set)map.get(fid)).add(new Integer(fperiod));
                continue;
            }
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(fperiod));
            map.put(fid, set);
            firstInfo = new MbgUpdateCalculateInfo();
            bgScheme = new BgSchemeInfo();
            bgScheme.setId(BOSUuid.read((String)fbgschemeid));
            bgScheme.setName(rs.getString(4));
            bgScheme.setNumber(rs.getString(5));
            firstInfo.setBgScheme(bgScheme);
            bizCalc = new BizCalcInfo();
            bizCalc.setId(BOSUuid.read((String)fid));
            bizCalc.setName(rs.getString(6));
            bizCalc.setNumber(rs.getString(7));
            firstInfo.setBizCalc(bizCalc);
        }
        return list;
    }

    private static List<MbgUpdateCalculateInfo> getNotAssociatedSchemeIDs(Context ctx) throws BOSException, SQLException {
        ArrayList<MbgUpdateCalculateInfo> returnVal = new ArrayList<MbgUpdateCalculateInfo>();
        String sql = "select fid,fname_" + ctx.getLocale() + ",fnumber FROM  T_MBG_BizCalc where fid in (select fbizschemeid from T_MBG_BizCalcRule where fbgperiodnum is not null) and fid not in (select fbizcalcid from T_MBG_BizCalcSchemeRelation)";
        ISQLExecutor iSql = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = iSql.executeSQL();
        String fid = null;
        MbgUpdateCalculateInfo info = null;
        while (rs.next()) {
            fid = rs.getString(1);
            if (fid == null) continue;
            info = new MbgUpdateCalculateInfo();
            BizCalcInfo bizCalc = new BizCalcInfo();
            bizCalc.setId(BOSUuid.read((String)fid));
            bizCalc.setName(rs.getString(2));
            bizCalc.setNumber(rs.getString(3));
            info.setBizCalc(bizCalc);
            returnVal.add(info);
        }
        return returnVal;
    }
}

