/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeNodeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeNodeFactory;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateConfigInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgUpdateCheckOrgHelper {
    private static Logger logger = Logger.getLogger((String)" com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCheckOrgHelper");
    public static final String ID = "id";
    public static final String ROOT_ID = "rootID";
    public static final String ORG_UNIT_ID = "orgUnitID";
    public static final String ORG_UNIT_NAME = "orgUnitName";
    public static final String LONG_NUMBER = "longNumber";
    public static final String BGSCHEME_ID = "bgschemeid";

    public static List<MbgUpdateOrgInfo> check(Context ctx, MbgUpdateConfigInfo configInfo) {
        List<MbgUpdateOrgInfo> orgInfoList = null;
        try {
            orgInfoList = MbgUpdateCheckOrgHelper.checkUpdateOrgInfo(ctx);
        }
        catch (BOSException e) {
            logger.debug((Object)"", (Throwable)e);
        }
        return MbgUpdateCheckOrgHelper.doSort(orgInfoList);
    }

    public static List<MbgUpdateOrgInfo> checkUpdateOrgInfo(Context ctx) throws BOSException {
        ArrayList<MbgUpdateOrgInfo> mbgUpdateOrgInfosList = new ArrayList<MbgUpdateOrgInfo>();
        HashSet<MbgUpdateOrgInfo> removeOrgSet = new HashSet<MbgUpdateOrgInfo>();
        Map<String, Map<String, Map<String, String>>> rootSchemeMap = MbgUpdateCheckOrgHelper.checkRootBgScheme(ctx);
        for (String schemeRootID : rootSchemeMap.keySet()) {
            Map<String, Map<String, String>> detailSchemeMap = MbgUpdateCheckOrgHelper.checkDetailScheme(rootSchemeMap.get(schemeRootID));
            Map<String, Map<String, Map<String, String>>> rootTemplateMap = MbgUpdateCheckOrgHelper.checkRootBgTemplate(ctx, schemeRootID);
            Set<MbgUpdateOrgInfo> orgInfoSet = MbgUpdateCheckOrgHelper.checkDetailTemplate(ctx, detailSchemeMap, rootTemplateMap);
            removeOrgSet.clear();
            for (MbgUpdateOrgInfo orgInfo : orgInfoSet) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)orgInfo.getBgTemplate().getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bgScheme.orgUnit.id", (Object)orgInfo.getSourceOrg().getId(), CompareType.EQUALS));
                if (orgInfo.getBgScheme() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)orgInfo.getBgScheme().getId(), CompareType.EQUALS));
                }
                view.setFilter(filter);
                view.getSelector().addObjectCollection((IObjectCollection)MbgUpdateCheckOrgHelper.getBgSchemeSelectors());
                BgSchemeNodeCollection colls = BgSchemeNodeFactory.getLocalInstance(ctx).getBgSchemeNodeCollection(view);
                BgSchemeInfo schemeInfo = null;
                if (colls.get(0) != null) {
                    schemeInfo = colls.get(0).getBgScheme();
                    orgInfo.setBgScheme(schemeInfo);
                    continue;
                }
                removeOrgSet.add(orgInfo);
            }
            orgInfoSet.removeAll(removeOrgSet);
            mbgUpdateOrgInfosList.addAll(orgInfoSet);
        }
        return mbgUpdateOrgInfosList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Map<String, Map<String, Map<String, String>>> checkRootBgScheme(Context ctx) {
        HashMap<String, Map<String, Map<String, String>>> rootMap = new HashMap<String, Map<String, Map<String, String>>>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = null;
        ResultSet rst = null;
        sql = "select S.FID, S.FNUMBER, S.FROOTID,  S.FORGUNITID, O.FPARENTID, O.FNAME_" + ctx.getLocale() + " oFName, O.FLONGNUMBER  from T_MBG_BGSCHEME S INNER JOIN  T_ORG_CostCenter O ON S.FORGUNITID = O.FID  order by S.FROOTID ";
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            String rootID = null;
            while (rst.next()) {
                if (!rst.getString("FROOTID").equals(rootID)) {
                    rootID = rst.getString("FROOTID");
                    rootMap.put(rootID, new HashMap());
                }
                HashMap<String, String> schemeView = new HashMap<String, String>();
                schemeView.put(ID, rst.getString("FID"));
                schemeView.put(ROOT_ID, rst.getString("FROOTID"));
                schemeView.put(ORG_UNIT_ID, rst.getString("FORGUNITID"));
                schemeView.put(ORG_UNIT_NAME, rst.getString("oFName"));
                schemeView.put(LONG_NUMBER, rst.getString("FLONGNUMBER"));
                ((Map)rootMap.get(rootID)).put(schemeView.get(ORG_UNIT_ID), schemeView);
            }
        }
        catch (SQLDataException ex) {
            logger.debug((Object)"", (Throwable)ex);
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException ex2) {
            logger.debug((Object)"", (Throwable)ex2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return rootMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Map<String, Map<String, Map<String, String>>> checkRootBgTemplate(Context ctx, String schemeRootID) {
        HashMap<String, Map<String, Map<String, String>>> rootTemplateMap = new HashMap<String, Map<String, Map<String, String>>>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT T.FID, T.FNUMBER, T.FROOTID, T.FORGUNITID, O.FNAME_" + ctx.getLocale() + " OFName, O.FLONGNUMBER , S.FBGSCHEMEID ").append(" FROM t_mbg_bgschemenode S ").append(" JOIN t_mbg_bgtemplate T ON T.FID = S.FBGTEMPLATEID ").append(" JOIN t_org_costcenter O ON T.FORGUNITID = O.FID  ").append(" WHERE (T.FBgTypeID IS NULL OR T.FBgTypeId <> 'bgMAAAAKIcA7rHKd') AND S.FBGSCHEMEID in ( SELECT FID FROM t_mbg_bgscheme WHERE FROOTID = ? ) ").append(" order by T.FROOTID ");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sqlBuf.toString());
            pstmt.setString(1, schemeRootID);
            rst = pstmt.executeQuery();
            String rootID = null;
            while (rst.next()) {
                if (!rst.getString("FROOTID").equals(rootID)) {
                    rootID = rst.getString("FROOTID");
                    rootTemplateMap.put(rootID, new HashMap());
                }
                HashMap<String, String> templateView = new HashMap<String, String>();
                templateView.put(ID, rst.getString("FID"));
                templateView.put(ORG_UNIT_ID, rst.getString("FORGUNITID"));
                templateView.put(ORG_UNIT_NAME, rst.getString("OFName"));
                templateView.put(ROOT_ID, rst.getString("FROOTID"));
                templateView.put(LONG_NUMBER, rst.getString("FLONGNUMBER"));
                templateView.put(BGSCHEME_ID, rst.getString("FBGSCHEMEID"));
                ((Map)rootTemplateMap.get(rootID)).put(templateView.get(ORG_UNIT_ID), templateView);
            }
        }
        catch (SQLDataException ex) {
            logger.debug((Object)"", (Throwable)ex);
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException ex2) {
            logger.debug((Object)"", (Throwable)ex2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return rootTemplateMap;
    }

    public static Map<String, Map<String, String>> checkDetailScheme(Map<String, Map<String, String>> schemeMap) {
        HashMap<String, Map<String, String>> leafSchemeMap = new HashMap<String, Map<String, String>>(schemeMap);
        HashSet<String> removeOrgUintID = new HashSet<String>();
        block0: for (String orgUnitID : schemeMap.keySet()) {
            String parentLongNumber = schemeMap.get(orgUnitID).get(LONG_NUMBER);
            for (String leafOrgUnitID : leafSchemeMap.keySet()) {
                String longNumber = schemeMap.get(leafOrgUnitID).get(LONG_NUMBER);
                if (!longNumber.startsWith(parentLongNumber + "!")) continue;
                removeOrgUintID.add(orgUnitID);
                continue block0;
            }
        }
        for (String removeID : removeOrgUintID) {
            leafSchemeMap.remove(removeID);
        }
        return leafSchemeMap;
    }

    public static Set<MbgUpdateOrgInfo> checkDetailTemplate(Context ctx, Map<String, Map<String, String>> detailSchemeMap, Map<String, Map<String, Map<String, String>>> rootTemplateMap) throws BOSException {
        HashSet<MbgUpdateOrgInfo> updateOrgInfoSet = new HashSet<MbgUpdateOrgInfo>();
        Map<String, Map<String, String>> templateMap = null;
        HashMap<String, Map<String, String>> leafTemplateMap = null;
        HashSet<String> removeOrgUintID = new HashSet<String>();
        HashSet templateIDSet = new HashSet();
        HashMap tempOrgSchemeMap = new HashMap();
        for (String rootID : rootTemplateMap.keySet()) {
            templateMap = rootTemplateMap.get(rootID);
            leafTemplateMap = new HashMap<String, Map<String, String>>(templateMap);
            removeOrgUintID.clear();
            block1: for (String orgUnitID : templateMap.keySet()) {
                String parentLongNumber = templateMap.get(orgUnitID).get(LONG_NUMBER);
                for (String leafOrgUnitID : templateMap.keySet()) {
                    if (!tempOrgSchemeMap.containsKey(templateMap.get(leafOrgUnitID).get(ID))) {
                        tempOrgSchemeMap.put(templateMap.get(leafOrgUnitID).get(ID), new HashMap());
                    }
                    ((Map)tempOrgSchemeMap.get(templateMap.get(leafOrgUnitID).get(ID))).put(leafOrgUnitID, templateMap.get(leafOrgUnitID).get(BGSCHEME_ID));
                    String longNumber = templateMap.get(leafOrgUnitID).get(LONG_NUMBER);
                    if (!longNumber.startsWith(parentLongNumber + "!")) continue;
                    removeOrgUintID.add(orgUnitID);
                    continue block1;
                }
            }
            for (String removeID : removeOrgUintID) {
                leafTemplateMap.remove(removeID);
            }
            for (String leafSchemeOrgUnitID : detailSchemeMap.keySet()) {
                leafTemplateMap.remove(leafSchemeOrgUnitID);
            }
            for (String leafOrgUnitID : leafTemplateMap.keySet()) {
                templateIDSet.add(((Map)leafTemplateMap.get(leafOrgUnitID)).get(ID));
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, templateIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)MbgUpdateCheckOrgHelper.getBgTemplateSelectors());
        BgTemplateCollection colls = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(view);
        if (colls != null) {
            HashSet<String> orgIds = new HashSet<String>();
            Object orgId = null;
            for (int i = 0; i < colls.size(); ++i) {
                String bgschemeid;
                BgTemplateInfo templateInfo = colls.get(i);
                MbgUpdateOrgInfo orgInfo = new MbgUpdateOrgInfo();
                orgInfo.setBgTemplate(templateInfo);
                orgInfo.setSourceOrg((OrgUnitInfo)templateInfo.getOrgUnit());
                orgIds.add(orgInfo.getSourceOrg().getId().toString());
                if (tempOrgSchemeMap.containsKey(templateInfo.getId().toString()) && ((Map)tempOrgSchemeMap.get(templateInfo.getId().toString())).containsKey(templateInfo.getOrgUnit().getId().toString()) && (bgschemeid = (String)((Map)tempOrgSchemeMap.get(templateInfo.getId().toString())).get(templateInfo.getOrgUnit().getId().toString())) != null) {
                    orgInfo.setBgScheme(new BgSchemeInfo());
                    orgInfo.getBgScheme().setId(BOSUuid.read((String)bgschemeid));
                }
                updateOrgInfoSet.add(orgInfo);
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo(ID, orgIds, CompareType.INCLUDE));
            evi.setSelector(new SelectorItemCollection());
            CostCenterOrgUnitCollection orgCol = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi);
            HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
            for (int i = 0; i < orgCol.size(); ++i) {
                orgMap.put(orgCol.get(i).getId().toString(), orgCol.get(i).castToFullOrgUnitInfo());
            }
            FullOrgUnitInfo fullOrg = null;
            for (MbgUpdateOrgInfo orgInfo : updateOrgInfoSet) {
                fullOrg = (FullOrgUnitInfo)orgMap.get(orgInfo.getSourceOrg().getId().toString());
                orgInfo.setSourceOrg((OrgUnitInfo)fullOrg);
                orgInfo.getBgTemplate().setOrgUnit(fullOrg);
            }
        }
        return updateOrgInfoSet;
    }

    public static SelectorItemCollection getBgSchemeSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgScheme.id");
        sic.add("bgScheme.CU.id");
        sic.add("bgScheme.creator.id");
        sic.add("bgScheme.createTime");
        sic.add("bgScheme.lastUpdateUser.id");
        sic.add("bgScheme.lastUpdateTime");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.description");
        sic.add("bgScheme.simpleName");
        sic.add("bgScheme.dateForm");
        sic.add("bgScheme.dateTo");
        sic.add("bgScheme.period");
        sic.add("bgScheme.idFormal");
        sic.add("bgScheme.isFiling");
        sic.add("bgScheme.orgUnit.id");
        sic.add("bgScheme.bgSchemeNodes.id");
        sic.add("bgScheme.refDims.id");
        sic.add("bgScheme.refCube");
        return sic;
    }

    public static SelectorItemCollection getBgTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(ID);
        sic.add("CU.id");
        sic.add("creator.id");
        sic.add("createTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateTime");
        sic.add("orgRela.id");
        sic.add("sheetParam.id");
        sic.add("name");
        sic.add("number");
        sic.add("description");
        sic.add("savePoint.id");
        sic.add("orgSavePoint.id");
        sic.add("data");
        sic.add("parent.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("orgUnit.creator.id");
        sic.add("orgUnit.createTime");
        sic.add("orgUnit.lastUpdateUser.id");
        sic.add("orgUnit.lastUpdateTime");
        sic.add("orgUnit.CU.id");
        sic.add("orgUnit.description");
        sic.add("orgUnit.simpleName");
        sic.add("orgUnit.isLeaf");
        sic.add("orgUnit.level");
        sic.add("orgUnit.longNumber");
        sic.add("orgUnit.displayName");
        sic.add("orgUnit.viewID");
        sic.add("orgUnit.orgUnitID");
        sic.add("orgUnit.isOUSealUp");
        sic.add("orgUnit.code");
        sic.add("orgUnit.parent.id");
        sic.add("bgType.id");
        sic.add("bgMeasureUnit.id");
        sic.add("defaultMeasureUnit.id");
        sic.add("bgExamineNodes.id");
        sic.add("formType");
        sic.add("postils.id");
        sic.add("templateStatus");
        sic.add("root.id");
        sic.add("sourceType");
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Map checkOrgBgDataAndAcData(Context ctx, List orgInfos) {
        HashMap resultMap = new HashMap();
        if (orgInfos == null) {
            return resultMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = null;
        StringBuffer sqlBuf = null;
        ResultSet rst = null;
        HashMap schemeMap = new HashMap();
        String schemeNumber = null;
        for (MbgUpdateOrgInfo orgInfo : orgInfos) {
            if (!schemeMap.keySet().contains(orgInfo.getBgScheme().getNumber())) {
                schemeNumber = orgInfo.getBgScheme().getNumber();
                schemeMap.put(schemeNumber, new HashSet());
            }
            ((Set)schemeMap.get(orgInfo.getBgScheme().getNumber())).add(orgInfo.getTargetOrg().getId().toString());
        }
        sql = "select FROOTID, FNUMBER, FRefCube from T_MBG_BGSCHEME  where FRefCube LIKE 'T_MBG%' ";
        try {
            ArrayList orgIDList;
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            HashMap<String, String> refCubtMap = new HashMap<String, String>();
            while (rst.next()) {
                refCubtMap.put(rst.getString("FNUMBER"), rst.getString("FRefCube"));
            }
            for (String number : schemeMap.keySet()) {
                sqlBuf = new StringBuffer("select FID, isnull(C,0) as FCOUNTER FROM (select count(FORGUNITID) C, FORGUNITID from ").append((String)refCubtMap.get(number)).append(" group by FORGUNITID) R right outer join (select FID FROM T_ORG_BaseUnit) O on R.FORGUNITID = O.FID where O.FID in (");
                for (int i = 1; i < ((Set)schemeMap.get(number)).size(); ++i) {
                    sqlBuf.append("?,");
                }
                sqlBuf.append("?) ");
                pstmt = conn.prepareStatement(sqlBuf.toString());
                orgIDList = new ArrayList((Collection)schemeMap.get(number));
                for (int i = 1; i <= ((Set)schemeMap.get(number)).size(); ++i) {
                    pstmt.setString(i, (String)orgIDList.get(i - 1));
                }
                rst = pstmt.executeQuery();
                HashMap<String, Boolean> orgResult = new HashMap<String, Boolean>();
                while (rst.next()) {
                    orgResult.put(rst.getString("FID"), rst.getInt("FCOUNTER") != 0);
                }
                resultMap.put(number, orgResult);
            }
            for (String number : schemeMap.keySet()) {
                sqlBuf = new StringBuffer("select FID, isnull(C,0) as FCOUNTER FROM (select count(FORGUNITID) C, FORGUNITID from ").append(BgCubeUtils.getActualCubeName1((String)refCubtMap.get(number))).append(" group by FORGUNITID) R right outer join (select FID FROM T_ORG_BaseUnit) O on R.FORGUNITID = O.FID where O.FID in (");
                for (int i = 1; i < ((Set)schemeMap.get(number)).size(); ++i) {
                    sqlBuf.append("?,");
                }
                sqlBuf.append("?) ");
                pstmt = conn.prepareStatement(sqlBuf.toString());
                orgIDList = new ArrayList((Collection)schemeMap.get(number));
                for (int i = 1; i <= ((Set)schemeMap.get(number)).size(); ++i) {
                    pstmt.setString(i, (String)orgIDList.get(i - 1));
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    ((Map)resultMap.get(number)).put(rst.getString("FID"), (Boolean)((Map)resultMap.get(number)).get(rst.getString("FID")) | rst.getInt("FCOUNTER") != 0);
                }
            }
            for (String number : schemeMap.keySet()) {
                sqlBuf = new StringBuffer("select FID, isnull(C,0) as FCOUNTER FROM (select count(FORGUNITID) C, FORGUNITID from ").append(BgCubeUtils.getDailyActualCubeName((String)refCubtMap.get(number))).append(" group by FORGUNITID) R right outer join (select FID FROM T_ORG_BaseUnit) O on R.FORGUNITID = O.FID where O.FID in (");
                for (int i = 1; i < ((Set)schemeMap.get(number)).size(); ++i) {
                    sqlBuf.append("?,");
                }
                sqlBuf.append("?) ");
                pstmt = conn.prepareStatement(sqlBuf.toString());
                orgIDList = new ArrayList((Collection)schemeMap.get(number));
                for (int i = 1; i <= ((Set)schemeMap.get(number)).size(); ++i) {
                    pstmt.setString(i, (String)orgIDList.get(i - 1));
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    ((Map)resultMap.get(number)).put(rst.getString("FID"), (Boolean)((Map)resultMap.get(number)).get(rst.getString("FID")) | rst.getInt("FCOUNTER") != 0);
                }
            }
        }
        catch (SQLDataException ex) {
            logger.debug((Object)"", (Throwable)ex);
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException ex2) {
            logger.debug((Object)"", (Throwable)ex2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return resultMap;
    }

    protected static List<MbgUpdateOrgInfo> doSort(List<MbgUpdateOrgInfo> orgInfos) {
        Collections.sort(orgInfos, (Comparator)new Comparator<MbgUpdateOrgInfo>(){

            @Override
            public int compare(MbgUpdateOrgInfo o1, MbgUpdateOrgInfo o2) {
                return o1.getBgTemplate().getNumber().compareTo(o2.getBgTemplate().getNumber());
            }
        });
        Collections.sort(orgInfos, (Comparator)new Comparator<MbgUpdateOrgInfo>(){

            @Override
            public int compare(MbgUpdateOrgInfo o1, MbgUpdateOrgInfo o2) {
                return o1.getSourceOrg().getNumber().compareTo(o2.getSourceOrg().getNumber());
            }
        });
        Collections.sort(orgInfos, (Comparator)new Comparator<MbgUpdateOrgInfo>(){

            @Override
            public int compare(MbgUpdateOrgInfo o1, MbgUpdateOrgInfo o2) {
                return o1.getBgScheme().getNumber().compareTo(o2.getBgScheme().getNumber());
            }
        });
        return orgInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Set<String>> checkLeafOrg(Context ctx, Set<String> rootLongNumber) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = null;
        ResultSet rst = null;
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        HashSet<String> longNumberSet = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            sql = "select FNUMBER ,FLONGNUMBER  from t_org_costcenter where FLONGNUMBER LIKE ? ";
            for (String longNumber : rootLongNumber) {
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, longNumber + "!%");
                rst = pstmt.executeQuery();
                longNumberSet = new HashSet<String>();
                longNumberSet.add(longNumber);
                while (rst.next()) {
                    longNumberSet.add(rst.getString("FLONGNUMBER"));
                }
                resultMap.put(longNumber, longNumberSet);
            }
        }
        catch (SQLDataException ex) {
            logger.debug((Object)"", (Throwable)ex);
        }
        catch (SQLException ex) {
            logger.debug((Object)"", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        Set parentSet = null;
        HashSet leafSet = null;
        HashSet<String> removeSet = new HashSet<String>();
        for (String key : resultMap.keySet()) {
            parentSet = (Set)resultMap.get(key);
            leafSet = new HashSet(parentSet);
            removeSet.clear();
            block10: for (String parentLongNumber : parentSet) {
                for (String longNumber : leafSet) {
                    if (longNumber.split("!").length <= parentLongNumber.split("!").length || longNumber.indexOf(parentLongNumber) != 0 || longNumber == parentLongNumber) continue;
                    removeSet.add(parentLongNumber);
                    continue block10;
                }
            }
            ((Set)resultMap.get(key)).removeAll(removeSet);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkUpdated(Context ctx) throws BOSException {
        boolean colIsEmpty;
        boolean hasColumn;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            conn = null;
            pstmt = null;
            String sql = null;
            rst = null;
            hasColumn = false;
            colIsEmpty = false;
            try {
                sql = " select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FROOTID' and KSQL_COL_TABNAME='T_MBG_BGSCHEME' ";
                conn = BgDBUtils.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(sql);
                rst = pstmt.executeQuery();
                hasColumn = rst.next();
                if (!hasColumn) break block4;
                sql = " select * from T_MBG_BGSCHEME WHERE FRootID IS NOT NULL AND LEN(FROOTID) > 0";
                pstmt = conn.prepareStatement(sql);
                rst = pstmt.executeQuery();
                colIsEmpty = !rst.next();
            }
            catch (Exception ex) {
                try {
                    logger.debug((Object)"", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return !hasColumn || colIsEmpty;
    }
}

