/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateConfigInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgUpdateCheckSchemeTemplateHelper {
    private static Logger logger = Logger.getLogger((String)" com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCheckSchemeTemplateHelper");

    public static List<MbgUpdateOrgInfo> check(Context ctx, MbgUpdateConfigInfo configInfo) {
        ArrayList<MbgUpdateOrgInfo> orgInfoList = new ArrayList<MbgUpdateOrgInfo>();
        List<MbgUpdateOrgInfo> orgInfoListNoScheme = MbgUpdateCheckSchemeTemplateHelper.checkTemplate(ctx);
        List<MbgUpdateOrgInfo> orgList = MbgUpdateCheckSchemeTemplateHelper.checkSameTemplate(ctx, configInfo, orgInfoListNoScheme);
        List<MbgUpdateOrgInfo> orgInfoListDif = MbgUpdateCheckSchemeTemplateHelper.checkTemplateDifType(ctx);
        if (orgInfoListDif != null) {
            orgInfoList.addAll(orgInfoListDif);
        }
        if (orgInfoListNoScheme != null) {
            orgInfoList.addAll(orgInfoListNoScheme);
        }
        if (orgList != null) {
            orgInfoList.addAll(orgList);
        }
        return orgInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MbgUpdateOrgInfo> checkSameTemplate(Context ctx, MbgUpdateConfigInfo configInfo, List<MbgUpdateOrgInfo> orgInfoListNoScheme) {
        ArrayList<MbgUpdateOrgInfo> orgList = new ArrayList<MbgUpdateOrgInfo>();
        if (configInfo != null) {
            Map<String, MbgUpdateOrgInfo> orgConfigMap = configInfo.getOrgConfig();
            Iterator<MbgUpdateOrgInfo> iter = orgConfigMap.values().iterator();
            while (iter.hasNext()) {
                OrgUnitInfo targetOrgUnit;
                MbgUpdateOrgInfo orgInfo = new MbgUpdateOrgInfo();
                orgInfo = iter.next();
                if (orgInfo == null || (targetOrgUnit = orgInfo.getTargetOrg()) == null) continue;
                Connection conn = null;
                PreparedStatement pstmt = null;
                String sql = null;
                ResultSet rs = null;
                sql = "select fnumber from T_MBG_bgTemplate where FNumber= ? and ForgUnitid = ? and FROOTID=fid";
                try {
                    conn = BgDBUtils.getConnection((Context)ctx);
                    try {
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, orgInfo.getBgTemplate().getNumber().toString());
                        pstmt.setString(2, targetOrgUnit.getId().toString());
                        rs = pstmt.executeQuery();
                        String number = null;
                        while (rs.next()) {
                            number = rs.getString(1);
                            if (number == null || "".equals(number)) {
                                orgInfo.setPeriodType(orgInfo.getBgScheme().getPeriod());
                                orgInfo.setBgScheme(orgInfo.getBgScheme());
                                orgInfo.setSourceOrg(orgInfo.getSourceOrg());
                                orgInfo.setTargetOrg(orgInfo.getTargetOrg());
                                continue;
                            }
                            orgInfo.setDescription("");
                            orgInfo.setBgScheme(orgInfo.getBgScheme());
                            orgInfo.setSourceOrg(orgInfo.getSourceOrg());
                            orgInfo.setPeriodType(orgInfo.getBgScheme().getPeriod());
                            orgInfo.setTargetOrg(orgInfo.getTargetOrg());
                            orgList.add(orgInfo);
                            for (int j = 0; j < orgInfoListNoScheme.size(); ++j) {
                                MbgUpdateOrgInfo noSchemeInfo = orgInfoListNoScheme.get(j);
                                if (!noSchemeInfo.getSourceOrg().getNumber().toString().equals(orgInfo.getTargetOrg().getNumber().toString())) continue;
                                orgInfoListNoScheme.remove(orgInfoListNoScheme.get(j));
                            }
                        }
                    }
                    catch (SQLException e) {
                        logger.debug((Object)"", (Throwable)e);
                    }
                }
                catch (SQLDataException e) {
                    try {
                        logger.debug((Object)"", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                        throw throwable;
                    }
                    SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
                    continue;
                }
                SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
            }
        }
        return orgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MbgUpdateOrgInfo> checkTemplateDifType(Context ctx) {
        ArrayList<MbgUpdateOrgInfo> checkTemplateOrgInfos = new ArrayList<MbgUpdateOrgInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String difType = "select distinct t1.fid, t1.fnumber,t1.FNAME, t3.fid,t3.fname_l2,t3.FNUMBER ,t3.Fperiod,t4.Fid,t4.FNUMBER ,t4.FNAME_l2, t1.FRootId from T_mbg_bgTemplate t1 left join t_mbg_bgschemeNode t2 on t1.fid=t2.FBGTEMPLATEID left join T_MBG_bgscheme t3 on t3.fid = t2.FBGSCHEMEId  left join T_ORG_BaseUnit t4 on t4.fID = t1.FORGUNITID  where t1.fid in  (SELECT FBgTemplateId FROM   (select t.FBGTEMPLATEID, t3.Fperiod from T_mbg_bgSchemeNode t, T_mbg_bgScheme t3 where t3.FID = t.FBGSCHEMEId group by t.FBGTEMPLATEID, t3.FPERIOD ) Group by FBgTemplateID having count(fbgtemplateid)> 1) order by t1.FNAME";
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            try {
                pstmt = conn.prepareStatement(difType);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MbgUpdateOrgInfo orgInfo = new MbgUpdateOrgInfo();
                    BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
                    OrgUnitInfo bgOrgUnitInfo = new OrgUnitInfo();
                    BgSchemeInfo bgSchemeInfo = new BgSchemeInfo();
                    bgTemplateInfo.setId(BOSUuid.read((String)rs.getString(1)));
                    bgTemplateInfo.setNumber(rs.getString(2));
                    bgTemplateInfo.setName(rs.getString(3));
                    bgTemplateInfo.setRootId(BOSUuid.read((String)rs.getString(11)));
                    bgSchemeInfo.setId(BOSUuid.read((String)rs.getString(4)));
                    bgSchemeInfo.setName(rs.getString(5));
                    bgSchemeInfo.setNumber(rs.getString(6));
                    bgSchemeInfo.setPeriod(BgPeriodEnum.getEnum((int)Integer.parseInt(rs.getString(7))));
                    bgOrgUnitInfo.setId(BOSUuid.read((String)rs.getString(8)));
                    bgOrgUnitInfo.setNumber(rs.getString(9));
                    bgOrgUnitInfo.setName(rs.getString(10));
                    orgInfo.setBgTemplate(bgTemplateInfo);
                    orgInfo.setBgScheme(bgSchemeInfo);
                    orgInfo.setSourceOrg(bgOrgUnitInfo);
                    orgInfo.setTargetOrg(orgInfo.getTargetOrg());
                    orgInfo.setPeriodType(BgPeriodEnum.getEnum((int)Integer.parseInt(rs.getString(7))));
                    orgInfo.setPeriodType(bgSchemeInfo.getPeriod());
                    orgInfo.setDescription(null);
                    checkTemplateOrgInfos.add(orgInfo);
                }
            }
            catch (SQLException e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
        catch (SQLDataException e) {
            try {
                logger.debug((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return checkTemplateOrgInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MbgUpdateOrgInfo> checkTemplate(Context ctx) {
        ArrayList<MbgUpdateOrgInfo> TemplateOrgInfos = new ArrayList<MbgUpdateOrgInfo>();
        ArrayList<MbgUpdateOrgInfo> org = new ArrayList<MbgUpdateOrgInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String difType = "select distinct t1.fid,t1.fnumber,t1.FNAME,t4.fid,t4.FNUMBER ,t4.FNAME_l2, t1.FRootId from T_mbg_bgTemplate t1  inner join T_ORG_BaseUnit t4 on t4.fID = t1.FORGUNITID   where t1.fid not in  (SELECT t1.fid FROM T_mbg_bgTemplate t1,T_mbg_bgSchemeNode s where t1.fid = s.FbgTemplateId )";
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            try {
                pstmt = conn.prepareStatement(difType);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MbgUpdateOrgInfo orgInfo = new MbgUpdateOrgInfo();
                    BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
                    OrgUnitInfo bgOrgUnitInfo = new OrgUnitInfo();
                    BgSchemeInfo bgSchemeInfo = new BgSchemeInfo();
                    bgTemplateInfo.setId(BOSUuid.read((String)rs.getString(1)));
                    bgTemplateInfo.setNumber(rs.getString(2));
                    bgTemplateInfo.setName(rs.getString(3));
                    bgTemplateInfo.setRootId(BOSUuid.read((String)rs.getString(7)));
                    bgOrgUnitInfo.setId(BOSUuid.read((String)rs.getString(4)));
                    bgOrgUnitInfo.setNumber(rs.getString(5));
                    bgOrgUnitInfo.setName(rs.getString(6));
                    orgInfo.setBgTemplate(bgTemplateInfo);
                    orgInfo.setSourceOrg(bgOrgUnitInfo);
                    orgInfo.setBgScheme(bgSchemeInfo);
                    orgInfo.setDescription(null);
                    org.add(orgInfo);
                    TemplateOrgInfos.add(orgInfo);
                }
            }
            catch (SQLException e) {
                logger.debug((Object)"", (Throwable)e);
            }
        }
        catch (SQLDataException e) {
            try {
                logger.debug((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return TemplateOrgInfos;
    }
}

