/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgExpressRepairProcess;

public class MbgViewManagerRepairUtils {
    public static byte[] processViewManager(Context ctx, byte[] datas, String sourceTypeNumber, String targetTypeNumber) throws Exception {
        MbgXMLParser parser2 = new MbgXMLParser(ctx);
        IMbgViewManager view = parser2.parse(datas);
        if (view == null) {
            return null;
        }
        MbgExpressRepairProcess processor = new MbgExpressRepairProcess(sourceTypeNumber, targetTypeNumber);
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            IBgDimensionManager dimManager = view.getSheetManagers().get(s).getDimensionManager();
            BgDimensionInfo dimension = dimManager.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER);
            if (dimension == null) {
                return null;
            }
            if (!dimension.getMember().isEmpty()) {
                for (int i = 0; i < dimension.getMember().size(); ++i) {
                    BgDimensionMember member = (BgDimensionMember)dimension.getMember().get(i);
                    member.setNumber(MbgExpressRepairProcess.convertPeriod(member.getNumber(), sourceTypeNumber, targetTypeNumber));
                }
            }
            if (dimManager.getCalcuteCol().isEmpty()) continue;
            for (int c = 0; c < dimManager.getCalcuteCol().size(); ++c) {
                dimManager.getCalcuteCol().get(c).setFormula(processor.process(dimManager.getCalcuteCol().get(c).getFormula()));
            }
        }
        view.setUpdated(true);
        new MbgXMLParser(ctx);
        return MbgXMLParser.unParse(view);
    }

    protected static BgDimensionInfo buildDimension(IBgDimensionManager dimManager, DimensionInfo dimeInfo, String srcNumber, DataBaseInfo[] objectValue) throws DimensionException {
        BgDimensionInfo dim = new BgDimensionInfo(dimManager);
        dim.setLayout("page");
        dim.setNumber(dimeInfo.getNumber());
        dim.setAlias(dimeInfo.getName());
        dim.setNecessary(true);
        dim.setType(dimeInfo.getNumber());
        if (objectValue != null) {
            dim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
            for (int i = 0; i < objectValue.length; ++i) {
                BgDimensionMember member = new BgDimensionMember(dimeInfo.getNumber(), "", objectValue[i].getName(), objectValue[i].getNumber());
                member.setSrcNumber(srcNumber);
                dim.getMember().add(member);
            }
        } else {
            dim.setMemberValueType(DimensionMemberValueModeEnum.Null);
        }
        dim.unParseMember();
        return dim;
    }
}

