/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCacheHelper;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgExpressProcess;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgPeriodUpdateUtils;

public class MbgViewManagerUpdateUtils {
    public static byte[] processViewManager(byte[] datas, MbgUpdateCacheHelper cacheHelper, String bgPeriodTypeNumber, String bgScenario) throws Exception {
        MbgXMLParser parser2 = new MbgXMLParser(cacheHelper.getContext());
        IMbgViewManager view = parser2.parse(datas);
        if (view == null) {
            return null;
        }
        MbgExpressProcess processor = new MbgExpressProcess(cacheHelper, bgPeriodTypeNumber, bgScenario);
        DimensionInfo scenDim = cacheHelper.getDimensionMap().get("BG_Scen");
        DimensionInfo verDim = cacheHelper.getDimensionMap().get(DimensionConstants.DEF_VERSION_NUMBER);
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            IBgDimensionManager dimManager = view.getSheetManagers().get(s).getDimensionManager();
            BgDimensionInfo dimension = dimManager.searchDimension(DimensionConstants.DEF_VERSION_NUMBER);
            if (dimension != null) {
                return null;
            }
            dimension = dimManager.searchDimension(DimensionConstants.DEF_SCENARIO_NUMBER);
            if (dimension != null && ("F-2".equals(dimension.getAttribute()) || DimensionConstants.DEF_SCENARIO_FIELD.equals(dimension.getAttribute()))) {
                dimension.setNumber(DimensionConstants.DEF_ELEMENT_NUMBER);
                for (int m = 0; m < dimension.getMember().size(); ++m) {
                    ((BgDimensionMember)dimension.getMember().get(m)).setType(dimension.getNumber());
                }
            }
            dimension = MbgViewManagerUpdateUtils.buildDimension(dimManager, scenDim, DimensionConstants.DEF_SCENARIO_SRCNUMBER, new DataBaseInfo[]{cacheHelper.getBgDataScenario(), cacheHelper.getBgActualScenario()});
            dimManager.addDimensionInfo(dimension);
            dimension = dimManager.searchDimension(DimensionConstants.DEF_VERSION_NUMBER);
            if (dimension != null) {
                return null;
            }
            dimension = MbgViewManagerUpdateUtils.buildDimension(dimManager, verDim, DimensionConstants.DEF_VERSION_SRCNUMBER, null);
            dimManager.addDimensionInfo(dimension);
            dimension = dimManager.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER);
            if (!dimension.getMember().isEmpty()) {
                for (int i = 0; i < dimension.getMember().size(); ++i) {
                    BgDimensionMember member = (BgDimensionMember)dimension.getMember().get(i);
                    member.setNumber(MbgPeriodUpdateUtils.convertPeriod(member.getNumber(), bgPeriodTypeNumber));
                }
            }
            if (dimManager.getCalcuteCol().isEmpty()) continue;
            for (int c = 0; c < dimManager.getCalcuteCol().size(); ++c) {
                dimManager.getCalcuteCol().get(c).setFormula(processor.process(dimManager.getCalcuteCol().get(c).getFormula()));
            }
        }
        view.setUpdated(true);
        new MbgXMLParser(cacheHelper.getContext());
        return MbgXMLParser.unParse(view);
    }

    protected static BgDimensionInfo buildDimension(IBgDimensionManager dimManager, DimensionInfo dimeInfo, String srcNumber, DataBaseInfo[] objectValue) throws DimensionException {
        BgDimensionInfo dim = new BgDimensionInfo(dimManager);
        dim.setLayout("page");
        dim.setNumber(dimeInfo.getNumber());
        dim.setAlias(dimeInfo.getName());
        dim.setNecessary(true);
        dim.setType(dimeInfo.getNumber());
        if (objectValue != null) {
            dim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
            for (int i = 0; i < objectValue.length; ++i) {
                BgDimensionMember member = new BgDimensionMember(dimeInfo.getNumber(), "", objectValue[i].getName(), objectValue[i].getNumber());
                member.setSrcNumber(srcNumber);
                dim.getMember().add(member);
            }
        } else {
            dim.setMemberValueType(DimensionMemberValueModeEnum.Null);
        }
        dim.unParseMember();
        return dim;
    }
}

