/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCacheHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractMbgUpdateProcessor {
    private Connection conn = null;
    private MbgUpdateCacheHelper cacheHelper = null;
    private int count = 0;

    public AbstractMbgUpdateProcessor(Connection conn, MbgUpdateCacheHelper chacheHelper) {
        this.cacheHelper = chacheHelper;
        this.conn = conn;
    }

    protected Connection getConn() {
        return this.conn;
    }

    public MbgUpdateCacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess() throws Exception {
        System.out.println(this.getClass().getSimpleName() + " Start");
        PreparedStatement pstmtQuery = null;
        PreparedStatement pstmtUpdate = null;
        ResultSet rst = null;
        try {
            pstmtQuery = this.buildQueryPstmt(this.getConn());
            pstmtUpdate = this.buildUpdatePstmt(this.getConn());
            rst = pstmtQuery.executeQuery();
            int batchCount = 0;
            while (rst.next()) {
                ++this.count;
                if (this.count % 50 == 0) {
                    System.out.println(this.getClass().getSimpleName() + " " + this.count);
                }
                if (!this.process(rst, pstmtUpdate)) continue;
                pstmtUpdate.addBatch();
                if (++batchCount != 50) continue;
                pstmtUpdate.executeBatch();
                batchCount = 0;
            }
            if (batchCount > 0) {
                pstmtUpdate.executeBatch();
                batchCount = 0;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, (Statement)pstmtQuery);
            SQLUtils.cleanup(pstmtUpdate);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtQuery);
        SQLUtils.cleanup((Statement)pstmtUpdate);
    }

    protected abstract PreparedStatement buildQueryPstmt(Connection var1) throws SQLException;

    protected abstract PreparedStatement buildUpdatePstmt(Connection var1) throws SQLException;

    protected abstract boolean process(ResultSet var1, PreparedStatement var2) throws Exception;
}

