/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgPeriodUpdateUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;

public class MbgBgPeriodTypeUtils {
    private static BgPeriodTypeCollection bgPeriodTypeColl;
    public static final String EXP_TYPE = "GjMAAAAAUgj/bNjg";
    public static final String FM_TYPE = "lVIAAAA0y6A7rHKd";
    public static final String ZJYZ_ID = "lVIAAAAuzHiQxGui";
    public static final String PYYZ_ID = "lVIAAAAuzHmQxGui";
    public static final String PTYZ_ID = "lVIAAAAuzHqQxGui";
    public static final String GYYZ_ID = "lVIAAABXGOSQxGui";
    private static HashMap<String, String> schemeAndType;

    public static BgPeriodTypeInfo getBgPeriodTypeByPeriod(Context ctx, int periodType) throws BOSException {
        BgPeriodTypeInfo bgPeriodTypeInfo = null;
        BgPeriodTypeCollection coll = MbgBgPeriodTypeUtils.getSysBgPeriodTypeColl(ctx);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            bgPeriodTypeInfo = coll.get(i);
            if (!MbgPeriodUpdateUtils.getBgPeriodType(periodType).equalsIgnoreCase(bgPeriodTypeInfo.getNumber())) continue;
            return bgPeriodTypeInfo;
        }
        return bgPeriodTypeInfo;
    }

    private static BgPeriodTypeCollection getSysBgPeriodTypeColl(Context ctx) throws BOSException {
        if (ctx == null) {
            return null;
        }
        if (bgPeriodTypeColl == null || bgPeriodTypeColl.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(MbgBgPeriodTypeUtils.getSelectors());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)BgPeriodHelper.ALL_BGPERIOD_NUMBER, CompareType.INCLUDE));
            evi.setFilter(filter);
            bgPeriodTypeColl = BgPeriodTypeFactory.getLocalInstance((Context)ctx).getBgPeriodTypeCollection(evi);
        }
        return bgPeriodTypeColl;
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        return sic;
    }

    public static HashMap<String, String> buildBgPeriodTypeMap(Connection conn, Boolean isFilterRoot) throws BOSException {
        if (schemeAndType != null) {
            return schemeAndType;
        }
        schemeAndType = new HashMap();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            HashMap typeMap = new HashMap();
            StringBuffer sql = new StringBuffer();
            sql.append("select s.fid schemeId, t.fid templateId, p.fid typeId ").append("from t_mbg_bgtemplate t ").append("left join t_mbg_bgschemenode n on t.fid = n.fbgtemplateid ").append("left join t_mbg_bgscheme s on s.fid = n.fbgschemeid ").append("left join T_MBG_BgType p on  p.fid = t.FbgtypeID ");
            if (isFilterRoot.booleanValue()) {
                sql.append("where s.fid = s.frootid ");
            }
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            String schemeid2 = null;
            String typeId = null;
            while (rst.next()) {
                schemeid2 = rst.getString("schemeId");
                typeId = rst.getString("typeId");
                if (typeMap.containsKey(schemeid2)) {
                    ((HashSet)typeMap.get(schemeid2)).add(typeId);
                    continue;
                }
                typeMap.put(schemeid2, new HashSet());
                ((HashSet)typeMap.get(schemeid2)).add(typeId);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            HashSet tempSet = null;
            if (!typeMap.isEmpty()) {
                for (String schemeid2 : typeMap.keySet()) {
                    tempSet = (HashSet)typeMap.get(schemeid2);
                    if (tempSet.contains(EXP_TYPE) && tempSet.contains(FM_TYPE)) {
                        schemeAndType.put(schemeid2, GYYZ_ID);
                        continue;
                    }
                    if (tempSet.contains(EXP_TYPE) && !tempSet.contains(FM_TYPE)) {
                        schemeAndType.put(schemeid2, PYYZ_ID);
                        continue;
                    }
                    if (!tempSet.contains(EXP_TYPE) && tempSet.contains(FM_TYPE)) {
                        schemeAndType.put(schemeid2, ZJYZ_ID);
                        continue;
                    }
                    schemeAndType.put(schemeid2, PTYZ_ID);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return schemeAndType;
    }

    static {
        schemeAndType = null;
    }
}

