/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCacheHelper;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgBookUpdateUtils;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgPeriodUpdateUtils;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgSqlUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgViewManagerProcessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class MbgBookProcessor
extends MbgSqlUpdateProcessor {
    private static Logger logger = Logger.getLogger((String)MbgBookProcessor.class.getName());
    private String querySql = null;
    private String updateSql = null;
    private String bgScenation = null;
    private WeakHashMap<String, ByteObject> byteMap = new WeakHashMap();

    public MbgBookProcessor(Connection conn, String bgScenation, MbgUpdateCacheHelper cacheHelper, String querySql, String updateSql) {
        super(conn, cacheHelper, null, null);
        this.querySql = querySql;
        this.updateSql = updateSql;
        this.bgScenation = bgScenation;
    }

    @Override
    public String getQuerySql() {
        return this.querySql;
    }

    @Override
    public String getUpdateSql() {
        return this.updateSql;
    }

    @Override
    protected Object[] processObject(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        String key;
        ByteObject obj;
        String id = rst.getString(MbgViewManagerProcessor.idField);
        byte[] datas = rst.getBytes(MbgViewManagerProcessor.dataField);
        String tmpRootId = rst.getString(MbgViewManagerProcessor.templateRootIdField);
        String bgPeriodTypeNumber = MbgPeriodUpdateUtils.getBgPeriodTypeNumber(tmpRootId, this.getCacheHelper());
        if (datas == null || datas.length == 0) {
            return null;
        }
        System.out.println("id: " + id + " rootid: " + tmpRootId);
        if (this.byteMap.size() > 120) {
            System.out.println("clear byteMap");
            this.byteMap.clear();
        }
        if ((obj = this.byteMap.get(key = tmpRootId + "_" + bgPeriodTypeNumber + "_" + this.bgScenation)) != null) {
            datas = Arrays.equals(datas, obj.sources) ? obj.targets : MbgBookUpdateUtils.processBook(this.getCacheHelper(), datas, bgPeriodTypeNumber, this.bgScenation);
        } else {
            obj = new ByteObject(datas, null);
            datas = MbgBookUpdateUtils.processBook(this.getCacheHelper(), datas, bgPeriodTypeNumber, this.bgScenation);
            obj.targets = datas;
            this.byteMap.put(key, obj);
        }
        if (datas != null) {
            return new Object[]{datas, id};
        }
        return null;
    }

    class ByteObject {
        byte[] sources = null;
        byte[] targets = null;

        ByteObject(byte[] s, byte[] t) {
            this.sources = s;
            this.targets = t;
        }
    }
}

