/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgExpressRepairProcess;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;

public class MbgBookRepairUtils {
    public static byte[] processBook(byte[] datas, String sourceTypeNumber, String targetTypeNumber) throws Exception {
        if (datas == null || datas.length == 0) {
            return null;
        }
        MbgExpressRepairProcess processor = new MbgExpressRepairProcess(sourceTypeNumber, targetTypeNumber);
        Book book = IOHelper.unpackBook((byte[])datas);
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        boolean isUpdate = false;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    if (MbgBookRepairUtils.checkHashUpdated(cell)) {
                        return null;
                    }
                    isUpdate = MbgBookRepairUtils.processBgItem(cell, processor) || isUpdate;
                    isUpdate = MbgBookRepairUtils.processExpression(cell, processor) || isUpdate;
                }
            }
        }
        BgNFSHelper.enableCal(book);
        BgNFSHelper.enableUndo(book);
        if (isUpdate) {
            return IOHelper.packBook((Book)book);
        }
        return null;
    }

    private static boolean checkHashUpdated(Cell cell) {
        return false;
    }

    private static boolean processExpression(Cell cell, MbgExpressRepairProcess processor) throws BOSException {
        boolean isUpdate = false;
        if (BgNFSHelper.checkHasExpression(cell)) {
            String formula = BgNFSHelper.getExpression(cell);
            String expression = processor.process(formula);
            if (expression != null && !expression.equalsIgnoreCase(formula)) {
                cell.setFormula(expression);
                isUpdate = true;
            }
            isUpdate = MbgBookRepairUtils.processExpression(cell, processor, 0) || isUpdate;
            isUpdate = MbgBookRepairUtils.processExpression(cell, processor, 1) || isUpdate;
            isUpdate = MbgBookRepairUtils.processExpression(cell, processor, 2) || isUpdate;
        }
        return isUpdate;
    }

    private static boolean processExpression(Cell cell, MbgExpressRepairProcess processor, int view) throws BOSException {
        String expression;
        String formula = BgNFSHelper.loadExpression(cell, view);
        if (!StringUtils.isEmpty((String)formula) && (expression = processor.process(formula)) != null && !expression.equalsIgnoreCase(formula)) {
            BgNFSHelper.saveExpression(cell, expression, view);
            return true;
        }
        return false;
    }

    private static boolean processBgItem(Cell cell, MbgExpressRepairProcess processor) throws BOSException {
        if (!BgNFSHelper.checkHasFormulaOfCell(cell)) {
            return false;
        }
        String formula = BgNFSHelper.getFormulaOfCell(cell);
        String newFormula = processor.process(formula);
        if (newFormula != null && !formula.equals(newFormula)) {
            BgNFSHelper.setFormulaOfCell(cell, newFormula);
            return true;
        }
        return false;
    }
}

