/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCacheHelper;
import com.kingdee.eas.ma.mbg.update.app.utils.AbstractMbgUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class MbgDataOrgUpdateProcessor
extends AbstractMbgUpdateProcessor {
    private int dataType = 1;

    public MbgDataOrgUpdateProcessor(Connection conn, MbgUpdateCacheHelper chacheHelper, int dataType) {
        super(conn, chacheHelper);
        this.dataType = dataType;
    }

    @Override
    public void startProcess() throws Exception {
        ArrayList<String[]> list;
        String refCube2 = null;
        HashMap<String, ArrayList<String[]>> updateMap = new HashMap<String, ArrayList<String[]>>();
        HashSet<String> keys = new HashSet<String>();
        for (MbgUpdateOrgInfo config : this.getCacheHelper().getUpdateConfig().getOrgConfig().values()) {
            if (config.getBgScheme() == null || config.getBgScheme().getId() == null || config.getTargetOrg() == null || config.getTargetOrg().getId().equals((Object)config.getSourceOrg().getId())) continue;
            refCube2 = this.getCacheHelper().getBgDataCubeMap().get(this.getCacheHelper().getBgSchemeRootMap().get(config.getBgScheme().getId().toString()));
            if (refCube2 == null) {
                throw new NullPointerException("refCube is null: " + config.getBgScheme().getId());
            }
            String key = refCube2 + "_" + config.getTargetOrg().getId() + "_" + config.getSourceOrg().getId();
            if (keys.contains(key)) continue;
            keys.add(key);
            list = (List)updateMap.get(refCube2);
            if (list == null) {
                list = new ArrayList<String[]>();
                updateMap.put(refCube2, list);
            }
            list.add(new String[]{config.getTargetOrg().getId().toString(), config.getSourceOrg().getId().toString()});
        }
        for (String refCube2 : updateMap.keySet()) {
            list = (ArrayList<String[]>)updateMap.get(refCube2);
            MbgSqlHelper.executeBatch((Connection)this.getConn(), (String)("Update " + BgCubeUtils.getCubeName(refCube2, this.dataType) + " set FOrgUnitId = ? Where FOrgUnitId = ?"), (List)list);
        }
    }

    @Override
    protected PreparedStatement buildQueryPstmt(Connection conn) throws SQLException {
        return null;
    }

    @Override
    protected PreparedStatement buildUpdatePstmt(Connection conn) throws SQLException {
        return null;
    }

    @Override
    protected boolean process(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        return false;
    }
}

