/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCacheHelper;
import com.kingdee.eas.ma.mbg.update.app.utils.AbstractMbgUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgPeriodUpdateUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgDataUpdateProcessor
extends AbstractMbgUpdateProcessor {
    private static Logger logger = Logger.getLogger((String)MbgDataUpdateProcessor.class.getName());
    private BgVersionInfo version = null;
    private BgScenarioInfo scenario = null;
    private String cubeName = null;
    private String bgSchemeRootId = null;
    private String bgPeriodTypeNumber = null;
    private static Map<String, String> formulaMap = new HashMap<String, String>();

    public MbgDataUpdateProcessor(Connection conn, MbgUpdateCacheHelper chacheHelper, BgVersionInfo version, BgScenarioInfo scenario) {
        super(conn, chacheHelper);
        this.version = version;
        this.scenario = scenario;
    }

    protected void initBgPeriodTypeNumber() {
        int type = this.getCacheHelper().getPeriodEnumBySchemeRootId(this.bgSchemeRootId);
        this.bgPeriodTypeNumber = MbgPeriodUpdateUtils.getBgPeriodType(type);
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public void setBgSchemeRootId(String bgSchemeRootId) {
        this.bgSchemeRootId = bgSchemeRootId;
        this.initBgPeriodTypeNumber();
    }

    @Override
    public void startProcess() throws Exception {
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FScenario = " + this.scenario.getScenarioId()));
        System.out.println("MbgDataUpdateProcessor 0 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FIndex = CHARINDEX('\",\"', FFormula)"));
        System.out.println("MbgDataUpdateProcessor 1 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FBefore = Left(FFormula, FIndex + 2)"));
        System.out.println("MbgDataUpdateProcessor 2 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FAfter = RIGHT(FFormula, LEN(FFORMULA) - FIndex - 2)"));
        System.out.println("MbgDataUpdateProcessor 3 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FIndex = CHARINDEX('\",\"', FAfter)"));
        System.out.println("MbgDataUpdateProcessor 4 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FPeriodNumber = Left(FAfter, FIndex - 1)"));
        System.out.println("MbgDataUpdateProcessor 5 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FAfter = RIGHT(FAfter, LEN(FAfter) - FIndex + 1)"));
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FAfter = Replace(FAfter, '\"BgData\"', '\"" + this.scenario.getNumber() + "\"')"));
        System.out.println("MbgDataUpdateProcessor 6 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FPeriodNumber = '" + this.bgPeriodTypeNumber + ".' || FPeriodNumber"));
        System.out.println("MbgDataUpdateProcessor 7 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FFormula = FBefore || FPeriodNumber || FAfter"));
        System.out.println("MbgDataUpdateProcessor 8 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FBgPeriodId = (Select FID FROM T_MBG_BGPERIOD p Where p.Fnumber = " + this.cubeName + ".FPeriodNumber) Where exists(Select FID FROM T_MBG_BGPERIOD p1 Where p1.Fnumber = " + this.cubeName + ".FPeriodNumber)"));
    }

    @Override
    protected PreparedStatement buildQueryPstmt(Connection conn) throws SQLException {
        return conn.prepareStatement("Select FID, FFormula, FBgPeriodId FROM " + this.cubeName);
    }

    @Override
    protected PreparedStatement buildUpdatePstmt(Connection conn) throws SQLException {
        return conn.prepareStatement("Update " + this.cubeName + " Set FFormula = ?, FBgPeriodId = ?, FVersion = " + this.version.getVersionId() + ", FScenario = " + this.scenario.getScenarioId() + " Where FID = ?");
    }

    @Override
    protected boolean process(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        String id = rst.getString("FID");
        String formula = rst.getString("FFormula");
        String[] params = (String[])BgNFSHelper.parseFormulaPara(formulaMap, formula).clone();
        params[3] = this.scenario.getNumber();
        params[1] = MbgPeriodUpdateUtils.convertPeriod(params[1], this.bgPeriodTypeNumber);
        pstmtUpdate.setString(1, BgNFSHelper.getFormulaFromParam(params));
        BgPeriodInfo period = this.getCacheHelper().getBgPeriodMap().get(params[1]);
        if (period == null) {
            String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"notFountPeriod", (Locale)this.getCacheHelper().getContext().getLocale()), params[1]);
            System.out.println("BgDataTable:" + this.cubeName + " FID:" + id + " PeriodNumber:" + params[1]);
            throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{msg});
        }
        pstmtUpdate.setString(2, period.getId().toString());
        pstmtUpdate.setString(3, id);
        return true;
    }
}

