/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.ParseException;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.mbg.ActualRecordSourceTypeEnum;
import com.kingdee.eas.ma.mbg.AggregateDataTypeEnum;
import com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCacheHelper;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgPeriodUpdateUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class MbgExpressProcess {
    private static final Logger logger = Logger.getLogger(MbgExpressProcess.class);
    private String bgPeriodTypeNumber = null;
    private MbgUpdateCacheHelper cacheHelper = null;
    private String bgScenario;

    public MbgExpressProcess(MbgUpdateCacheHelper cacheHelper, String bgPeriodTypeNumber, String bgScenario) {
        this.bgPeriodTypeNumber = bgPeriodTypeNumber;
        this.cacheHelper = cacheHelper;
        this.bgScenario = bgScenario;
    }

    public String process(String formula) throws BOSException {
        if (StringUtils.isEmpty((String)formula)) {
            return formula;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)formula);
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return MbgExpressProcess.this.checkExpression(expr);
                }
            });
            _expressions = '=' + expression.toString();
            if (expression instanceof FunctionExpr) {
                FunctionExpr funExpr = (FunctionExpr)expression;
                if ("BgItem".equalsIgnoreCase(funExpr.funcionName)) {
                    _expressions = BgNFSHelper.getFormulaFromParam(BgNFSHelper.parseFormulaPara(_expressions));
                }
            }
        }
        catch (ParseException e) {
            logger.error((Object)formula);
            logger.error((Object)e);
        }
        catch (Exception ex) {
            logger.error((Object)formula);
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        if (_expressions != null && !_expressions.replaceAll(" ", "").equalsIgnoreCase(formula.replaceAll(" ", ""))) {
            return _expressions;
        }
        return null;
    }

    private Expression checkExpression(Expression expression) {
        if (expression instanceof FunctionExpr) {
            expression = this.checkFunctionExpr((FunctionExpr)expression);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = this.checkBinaryOperationExpr((BinaryOperationExpr)expression);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = this.checkUnaryOperationExpr((UnaryOperationExpr)expression);
        }
        return expression;
    }

    private BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr) {
        boExpr.left = this.checkExpression(boExpr.left);
        boExpr.right = this.checkExpression(boExpr.right);
        return boExpr;
    }

    private UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr) {
        return boExpr;
    }

    private Expression checkFunctionExpr(FunctionExpr funExpr) {
        String funName = funExpr.funcionName;
        if ("MbgAggregate".equalsIgnoreCase(funName)) {
            this.checkMbgAggregate(funExpr);
        } else if ("MbgActuals".equalsIgnoreCase(funName)) {
            this.checkMbgActuals(funExpr);
        } else if ("MbgFormula".equalsIgnoreCase(funName)) {
            this.checkMbgFormula(funExpr);
        } else if ("Mbgadjust".equalsIgnoreCase(funName)) {
            this.checkMbgAdjust(funExpr);
        } else if ("MbgRefBgTem".equalsIgnoreCase(funName)) {
            this.checkMbgRefTemp(funExpr);
        } else if ("BgItem".equalsIgnoreCase(funName)) {
            this.checkMbgItem(funExpr);
        }
        return funExpr;
    }

    private void checkMbgRefTemp(FunctionExpr funExpr) {
        if (funExpr.parameters.size() == 7) {
            Object period = this.convertPeriod(funExpr.parameters.get(3), funExpr.parameters.get(1));
            this.setExpression(funExpr, "MbgRefBgTem", new Object[]{funExpr.parameters.get(0), funExpr.parameters.get(1), funExpr.parameters.get(2), period, new StringExpr(""), funExpr.parameters.get(4), funExpr.parameters.get(5), funExpr.parameters.get(6)});
        }
    }

    private void checkMbgItem(FunctionExpr funExpr) {
        funExpr.funcionName = "BgItem";
        Object param = funExpr.parameters.get(3);
        if (param instanceof StringExpr) {
            ((StringExpr)param).value = this.bgScenario;
        }
        if ((param = funExpr.parameters.get(1)) instanceof StringExpr) {
            param = this.convertPeriod(param, null);
        }
    }

    private void checkMbgAdjust(FunctionExpr funExpr) {
        if (funExpr.parameters.size() == 9) {
            Object startPeriod = this.convertPeriod(funExpr.parameters.get(5), funExpr.parameters.get(1));
            Object endPeriod = this.convertPeriod(funExpr.parameters.get(6), funExpr.parameters.get(1));
            this.setExpression(funExpr, "Mbgadjust", new Object[]{funExpr.parameters.get(0), funExpr.parameters.get(1), new StringExpr(this.cacheHelper.getBgDataScenario().getNumber()), funExpr.parameters.get(3), startPeriod, endPeriod, new StringExpr(""), funExpr.parameters.get(4), funExpr.parameters.get(2), funExpr.parameters.get(7), funExpr.parameters.get(8)});
        }
    }

    private void checkMbgFormula(FunctionExpr funExpr) {
        if (funExpr.parameters.size() == 7) {
            this.buildMbgAggregateExpression(funExpr, funExpr.parameters.get(0), funExpr.parameters.get(1), funExpr.parameters.get(3), funExpr.parameters.get(5), funExpr.parameters.get(6), funExpr.parameters.get(4), funExpr.parameters.get(2), new StringExpr(AggregateDataTypeEnum.budget.getName()));
        }
    }

    private void checkMbgActuals(FunctionExpr funExpr) {
        if (funExpr.parameters.size() == 7) {
            funExpr.parameters.add(new StringExpr(""));
        }
        if (funExpr.parameters.size() == 8) {
            Object targetType = funExpr.parameters.get(7);
            if (targetType instanceof StringExpr) {
                StringExpr sourceDataType = (StringExpr)targetType;
                sourceDataType.value = StringUtils.isEmpty((String)sourceDataType.value) || ActualRecordSourceTypeEnum.all.getName().equals(sourceDataType.value) || "1".equalsIgnoreCase(sourceDataType.value) ? AggregateDataTypeEnum.actual.getName() : AggregateDataTypeEnum.addActual.getName();
            }
            this.buildMbgAggregateExpression(funExpr, funExpr.parameters.get(0), funExpr.parameters.get(1), funExpr.parameters.get(3), funExpr.parameters.get(5), funExpr.parameters.get(6), funExpr.parameters.get(4), funExpr.parameters.get(2), targetType);
        }
    }

    private void checkMbgAggregate(FunctionExpr funExpr) {
        if (funExpr.parameters.size() == 8) {
            this.buildMbgAggregateExpression(funExpr, funExpr.parameters.get(0), funExpr.parameters.get(1), funExpr.parameters.get(2), funExpr.parameters.get(3), funExpr.parameters.get(4), funExpr.parameters.get(6), funExpr.parameters.get(5), funExpr.parameters.get(7));
        }
    }

    private void buildMbgAggregateExpression(FunctionExpr funExpr, Object orgUnitNumber, Object bgSchemeNumber, Object itemNumber, Object startPeriod, Object endPeriod, Object currency, Object bgElement, Object dataType) {
        startPeriod = this.convertPeriod(startPeriod, bgSchemeNumber);
        endPeriod = this.convertPeriod(endPeriod, bgSchemeNumber);
        String bgScenarionNumber = "";
        if (dataType instanceof String) {
            dataType = new StringExpr((String)dataType);
        }
        if (dataType instanceof StringExpr) {
            StringExpr sDataType = (StringExpr)dataType;
            bgScenarionNumber = AggregateDataTypeEnum.actual.getName().equalsIgnoreCase(sDataType.value) || "1".equalsIgnoreCase(sDataType.value) || AggregateDataTypeEnum.addActual.getName().equalsIgnoreCase(sDataType.value) || "3".equalsIgnoreCase(sDataType.value) ? this.cacheHelper.getBgActualScenario().getNumber() : this.cacheHelper.getBgDataScenario().getNumber();
        } else {
            bgScenarionNumber = this.cacheHelper.getBgDataScenario().getNumber();
        }
        this.setExpression(funExpr, "MbgAggregate", new Object[]{orgUnitNumber, bgSchemeNumber, new StringExpr(bgScenarionNumber), itemNumber, startPeriod, endPeriod, new StringExpr(""), currency, bgElement, dataType});
    }

    private Object convertPeriod(Object bgPeriodNumber, Object bgSchemeNumber) {
        String typeNumber = this.getTypeNumber(bgSchemeNumber);
        if (bgPeriodNumber instanceof StringExpr) {
            StringExpr expr = (StringExpr)bgPeriodNumber;
            expr.value = MbgPeriodUpdateUtils.convertPeriod(expr.value, typeNumber);
            return expr;
        }
        if (bgPeriodNumber instanceof String) {
            return new StringExpr(MbgPeriodUpdateUtils.convertPeriod((String)bgPeriodNumber, typeNumber));
        }
        return bgPeriodNumber;
    }

    private String getTypeNumber(Object bgSchemeNumber) {
        String number = null;
        if (bgSchemeNumber instanceof StringExpr) {
            number = ((StringExpr)bgSchemeNumber).value;
        } else if (bgSchemeNumber instanceof String) {
            number = (String)bgSchemeNumber;
        }
        if (!StringUtils.isEmpty((String)number) && this.cacheHelper.getUpdateInfoByBgSchemeNumber(number) != null && this.cacheHelper.getUpdateInfoByBgSchemeNumber(number).getPeriodType() != null) {
            int type = this.cacheHelper.getUpdateInfoByBgSchemeNumber(number).getPeriodType().getValue();
            return MbgPeriodUpdateUtils.getBgPeriodType(type);
        }
        return this.bgPeriodTypeNumber;
    }

    private void setExpression(FunctionExpr funExpr, String funName, Object[] params) {
        funExpr.funcionName = funName;
        funExpr.parameters.clear();
        funExpr.parameters.addAll(Arrays.asList(params));
    }
}

