/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.ParseException;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class MbgExpressRepairProcess {
    private static final Logger logger = Logger.getLogger(MbgExpressRepairProcess.class);
    private String sourceTypeNumber = null;
    private String targetTypeNumber = null;

    public MbgExpressRepairProcess(String sourceTypeNumber, String targetTypeNumber) {
        this.sourceTypeNumber = sourceTypeNumber;
        this.targetTypeNumber = targetTypeNumber;
    }

    public String process(String formula) throws BOSException {
        if (StringUtils.isEmpty((String)formula)) {
            return formula;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)formula);
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return MbgExpressRepairProcess.this.checkExpression(expr);
                }
            });
            _expressions = '=' + expression.toString();
            if (expression instanceof FunctionExpr) {
                FunctionExpr funExpr = (FunctionExpr)expression;
                if ("BgItem".equalsIgnoreCase(funExpr.funcionName)) {
                    _expressions = MbgExpressRepairProcess.getFormulaFromParam(BgNFSHelper.parseFormulaPara(_expressions));
                }
            }
        }
        catch (ParseException e) {
            logger.error((Object)formula);
            logger.error((Object)e);
        }
        catch (Exception ex) {
            logger.error((Object)formula);
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        if (_expressions != null && !_expressions.replaceAll(" ", "").equals(formula.replaceAll(" ", ""))) {
            return _expressions;
        }
        return null;
    }

    public static String getFormulaFromParam(String[] parameter) {
        if (parameter == null) {
            return null;
        }
        String formulaStr = null;
        if (parameter.length == 6) {
            formulaStr = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\",true,\"" + StringUtils.cnulls((String)parameter[5]) + "\")").toString();
        } else if (parameter.length == 5) {
            formulaStr = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\",true,\"" + StringUtils.cnulls((String)parameter[4]) + "\")").toString();
        }
        return formulaStr;
    }

    private Expression checkExpression(Expression expression) {
        if (expression instanceof FunctionExpr) {
            expression = this.checkFunctionExpr((FunctionExpr)expression);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = this.checkBinaryOperationExpr((BinaryOperationExpr)expression);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = this.checkUnaryOperationExpr((UnaryOperationExpr)expression);
        }
        return expression;
    }

    private BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr) {
        boExpr.left = this.checkExpression(boExpr.left);
        boExpr.right = this.checkExpression(boExpr.right);
        return boExpr;
    }

    private UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr) {
        return boExpr;
    }

    private Expression checkFunctionExpr(FunctionExpr funExpr) {
        String funName = funExpr.funcionName;
        if ("MbgAggregate".equalsIgnoreCase(funName)) {
            this.checkMbgAggregate(funExpr);
        } else if ("MbgActuals".equalsIgnoreCase(funName)) {
            this.checkMbgActuals(funExpr);
        } else if ("Mbgadjust".equalsIgnoreCase(funName)) {
            this.checkMbgAdjust(funExpr);
        } else if ("MbgRefBgTem".equalsIgnoreCase(funName)) {
            this.checkMbgRefTemp(funExpr);
        } else if ("BgItem".equalsIgnoreCase(funName)) {
            this.checkMbgItem(funExpr);
        }
        return funExpr;
    }

    private void checkMbgRefTemp(FunctionExpr funExpr) {
        if (funExpr.parameters.size() == 8) {
            this.convertPeriod(funExpr.parameters.get(3));
        }
    }

    private void checkMbgItem(FunctionExpr funExpr) {
        funExpr.funcionName = "BgItem";
        Object param = funExpr.parameters.get(1);
        this.convertPeriod(param);
    }

    private void checkMbgAdjust(FunctionExpr funExpr) {
        if (funExpr.parameters.size() == 11) {
            this.convertPeriod(funExpr.parameters.get(4));
            this.convertPeriod(funExpr.parameters.get(5));
        }
    }

    private void checkMbgActuals(FunctionExpr funExpr) {
        this.checkMbgAggregate(funExpr);
    }

    private void checkMbgAggregate(FunctionExpr funExpr) {
        if (funExpr.parameters.size() == 10) {
            this.convertPeriod(funExpr.parameters.get(4));
            this.convertPeriod(funExpr.parameters.get(5));
        }
    }

    private void convertPeriod(Object bgPeriodObj) {
        if (bgPeriodObj instanceof StringExpr) {
            StringExpr bgPeriod = (StringExpr)bgPeriodObj;
            if (bgPeriod.value != null) {
                bgPeriod.value = MbgExpressRepairProcess.convertPeriod(bgPeriod.value, this.sourceTypeNumber, this.targetTypeNumber);
            }
        }
    }

    public static String convertPeriod(String bgPeriodNumber, String sourceTypeNumber, String targetTypeNumber) {
        if (bgPeriodNumber != null && bgPeriodNumber.startsWith(sourceTypeNumber + ".")) {
            return targetTypeNumber + bgPeriodNumber.substring(sourceTypeNumber.length());
        }
        return bgPeriodNumber;
    }
}

