/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCacheHelper;
import com.kingdee.eas.ma.mbg.update.app.utils.AbstractMbgUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;

public class MbgOrgUnitProcessor
extends AbstractMbgUpdateProcessor {
    private String updateSql = null;
    private String[] keys = null;

    public MbgOrgUnitProcessor(Connection conn, MbgUpdateCacheHelper chacheHelper, String updateSql, String[] keys) {
        super(conn, chacheHelper);
        this.updateSql = updateSql;
        this.keys = keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startProcess() throws Exception {
        PreparedStatement pstmtUpdate = null;
        try {
            pstmtUpdate = this.buildUpdatePstmt(this.getConn());
            HashSet<String> keySet = new HashSet<String>();
            int index = 0;
            Object[] ids = null;
            for (MbgUpdateOrgInfo org : this.getCacheHelper().getUpdateConfig().getOrgConfig().values()) {
                String key;
                if (org.getTargetOrg() == null || org.getSourceOrg().getId().equals((Object)org.getTargetOrg().getId()) || (ids = this.getIdsByKeys(org)) == null || keySet.contains(key = Arrays.toString(ids))) continue;
                keySet.add(key);
                pstmtUpdate.setString(1, org.getTargetOrg().getId().toString());
                for (int i = 0; i < ids.length; ++i) {
                    pstmtUpdate.setString(i + 2, (String)ids[i]);
                }
                pstmtUpdate.addBatch();
                if (++index < 50) continue;
                pstmtUpdate.executeBatch();
                index = 0;
            }
            if (index > 0) {
                pstmtUpdate.executeBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmtUpdate);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmtUpdate);
    }

    private String[] getIdsByKeys(MbgUpdateOrgInfo org) {
        String[] ids = new String[this.keys.length];
        Object obj = null;
        for (int i = 0; i < this.keys.length; ++i) {
            obj = BgCommCHelper.getValueByProperties((Object)org, (String)this.keys[i]);
            if (obj == null) {
                return null;
            }
            ids[i] = String.valueOf(obj);
        }
        return ids;
    }

    @Override
    protected PreparedStatement buildQueryPstmt(Connection conn) throws SQLException {
        return null;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    @Override
    protected PreparedStatement buildUpdatePstmt(Connection conn) throws SQLException {
        return conn.prepareStatement(this.getUpdateSql());
    }

    @Override
    protected boolean process(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        return false;
    }
}

