/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCacheHelper;
import com.kingdee.eas.ma.mbg.update.app.utils.AbstractMbgUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgPeriodUpdateUtils;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MbgPeriodIdProcessor
extends AbstractMbgUpdateProcessor {
    private String querySql = null;
    private String updateSql = null;
    public static final String BGPERIOD_ID = "bp_id";
    public static final String BGSCHEME_ID = "bs_id";
    public static final String MAIN_ID = "m_id";

    public MbgPeriodIdProcessor(Connection conn, MbgUpdateCacheHelper chacheHelper, String querySql, String updateSql) {
        super(conn, chacheHelper);
        this.querySql = querySql;
        this.updateSql = updateSql;
    }

    @Override
    public void startProcess() throws Exception {
        super.startProcess();
    }

    @Override
    protected PreparedStatement buildQueryPstmt(Connection conn) throws SQLException {
        return conn.prepareStatement(this.querySql);
    }

    @Override
    protected PreparedStatement buildUpdatePstmt(Connection conn) throws SQLException {
        return conn.prepareStatement(this.updateSql);
    }

    @Override
    protected boolean process(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        String id = rst.getString(MAIN_ID);
        String bgPeriodId = rst.getString(BGPERIOD_ID);
        String bgSchemeId = rst.getString(BGSCHEME_ID);
        String oldBgPeriodNumber = this.getCacheHelper().getOldPeriodMap().get(bgPeriodId);
        if (StringUtils.isEmpty((String)oldBgPeriodNumber)) {
            return false;
        }
        int type = this.getCacheHelper().getPeriodEnumBySchemeRootId(bgSchemeId);
        String bgPeriodTypeNumber = MbgPeriodUpdateUtils.getBgPeriodType(type);
        String newBgPeriodNumber = MbgPeriodUpdateUtils.convertPeriod(oldBgPeriodNumber, bgPeriodTypeNumber);
        BgPeriodInfo newPeriod = this.getCacheHelper().getBgPeriodMap().get(newBgPeriodNumber);
        if (newPeriod == null) {
            return false;
        }
        pstmtUpdate.setString(1, newPeriod.getId().toString());
        pstmtUpdate.setString(2, id);
        return true;
    }
}

