/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.utils;

import com.kingdee.eas.ma.mbg.update.app.impl.MbgUpdateCacheHelper;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.util.StringUtils;

public class MbgPeriodUpdateUtils {
    public static String convertPeriod(String bgPeriodNumber, String bgPeriodTypeNumber) {
        if (StringUtils.isEmpty((String)bgPeriodNumber) || StringUtils.isEmpty((String)bgPeriodTypeNumber) || bgPeriodNumber.startsWith(bgPeriodTypeNumber)) {
            return bgPeriodNumber;
        }
        return bgPeriodTypeNumber + "." + bgPeriodNumber;
    }

    public static String getBgPeriodTypeNumber(String bgTempRootId, MbgUpdateCacheHelper cacheHelper) {
        int periodEnum = MbgPeriodUpdateUtils.getBgPeriodEnum(bgTempRootId, cacheHelper);
        return MbgPeriodUpdateUtils.getBgPeriodType(periodEnum);
    }

    public static String getBgPeriodType(int periodEnum) {
        switch (periodEnum) {
            case 1: {
                return "YEAR";
            }
            case 2: {
                return "HALF";
            }
            case 3: {
                return "QUAR";
            }
            case 4: {
                return "MONT";
            }
            case 7: {
                return "MDAY";
            }
            case 6: {
                return "MWEE";
            }
            case 9: {
                return "PERI";
            }
            case 5: {
                return "YWEE";
            }
        }
        return "MONT";
    }

    private static int getBgPeriodEnum(String bgTempRootId, MbgUpdateCacheHelper cacheHelper) {
        MbgUpdateOrgInfo config = cacheHelper.getUpdateInfoByTemplate(bgTempRootId);
        if (config != null && config.getPeriodType() != null) {
            return config.getPeriodType().getValue();
        }
        return cacheHelper.getPeriodEnumByTemplateRootId(bgTempRootId);
    }
}

