/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.bos.Context;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

abstract class AbstractMbgRepairProcessor {
    public static String idField = "p_id";
    public static String dataField = "p_data";
    private Context ctx = null;
    private Connection conn = null;
    private String sourceTypeNumber = null;
    private String targetTypeNumber = null;
    private String querySql = null;
    private String updateSql = null;
    private int count = 0;

    public AbstractMbgRepairProcessor(Context ctx, Connection conn, String sourceTypeNumber, String targetTypeNumber, String querySql, String updateSql) {
        this.ctx = ctx;
        this.conn = conn;
        this.sourceTypeNumber = sourceTypeNumber;
        this.targetTypeNumber = targetTypeNumber;
        this.querySql = querySql;
        this.updateSql = updateSql;
    }

    public Context getCtx() {
        return this.ctx;
    }

    protected Connection getConn() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess() throws Exception {
        System.out.println(this.getClass().getSimpleName() + " Start");
        PreparedStatement pstmtQuery = null;
        PreparedStatement pstmtUpdate = null;
        ResultSet rst = null;
        try {
            pstmtQuery = this.buildQueryPstmt(this.getConn());
            pstmtUpdate = this.buildUpdatePstmt(this.getConn());
            rst = pstmtQuery.executeQuery();
            int batchCount = 0;
            while (rst.next()) {
                ++this.count;
                if (this.count % 50 == 0) {
                    System.out.println(this.getClass().getSimpleName() + " " + this.count);
                }
                if (!this.process(rst, pstmtUpdate)) continue;
                pstmtUpdate.addBatch();
                if (++batchCount != 50) continue;
                pstmtUpdate.executeBatch();
                batchCount = 0;
            }
            if (batchCount > 0) {
                pstmtUpdate.executeBatch();
                batchCount = 0;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, (Statement)pstmtQuery);
            SQLUtils.cleanup(pstmtUpdate);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtQuery);
        SQLUtils.cleanup((Statement)pstmtUpdate);
    }

    protected boolean process(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        Object[] result = this.processObject(rst, pstmtUpdate);
        if (result != null) {
            for (int i = 0; i < result.length; ++i) {
                pstmtUpdate.setObject(i + 1, result[i]);
            }
            return true;
        }
        return false;
    }

    protected abstract Object[] processObject(ResultSet var1, PreparedStatement var2) throws Exception;

    protected PreparedStatement buildQueryPstmt(Connection conn) throws SQLException {
        return conn.prepareStatement(this.getQuerySql());
    }

    protected PreparedStatement buildUpdatePstmt(Connection conn) throws SQLException {
        return conn.prepareStatement(this.getUpdateSql());
    }

    public String getQuerySql() {
        return this.querySql;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public String getSourceTypeNumber() {
        return this.sourceTypeNumber;
    }

    public String getTargetTypeNumber() {
        return this.targetTypeNumber;
    }
}

