/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.mbg.cube.query.DimData;
import com.kingdee.eas.ma.mbg.cube.query.IDimData;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgDimensionUpdateUtils;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgSqlUpdateProcessor;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MbgAdjustProcessor
extends MbgSqlUpdateProcessor {
    private Map<String, Map<String, List<IDimData>>> tempDatas = null;

    public MbgAdjustProcessor(Connection conn, MbgUpdate820CacheHelper cacheHelper, String querySql, String updateSql, Map<String, Map<String, List<IDimData>>> tempDatas) {
        super(conn, cacheHelper, querySql, updateSql);
        this.tempDatas = tempDatas;
    }

    @Override
    protected Object[] processObject(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        String[] newValues;
        String id = rst.getString("FID");
        String indexName = rst.getString("FIndexMemberName");
        String memberName = rst.getString("FMemberCombinName");
        String formula = rst.getString("FFormula");
        String bgSchemeId = rst.getString("FBgScheme");
        MbgDimensionUpdateUtils updateUtil = this.getCacheHelper().getUpdateUtil(bgSchemeId);
        updateUtil.setNameSplit(",");
        String[] formulaParams = BgNFSHelper.parseFormulaPara(null, formula);
        String itemCombin = formulaParams[0];
        String itemName = indexName;
        if (!StringUtils.isEmpty((String)memberName)) {
            itemName = itemName + "," + memberName;
        }
        if ((newValues = updateUtil.convert(itemCombin, itemName, true)) != null) {
            itemCombin = newValues[0];
            itemName = newValues[1];
            formulaParams[0] = itemCombin;
            formula = BgNFSHelper.getFormulaFromParam(formulaParams);
        }
        String indexNumber = null;
        String memberNumber = null;
        int index = itemCombin.indexOf(",");
        if (index >= 0) {
            indexNumber = itemCombin.substring(0, index);
            memberNumber = itemCombin.substring(index + 1);
            index = itemName.indexOf(",");
            indexName = itemName.substring(0, index);
            memberName = itemName.substring(index + 1);
        } else {
            indexNumber = itemCombin;
            indexName = itemName;
            memberNumber = null;
            memberName = null;
        }
        int state = rst.getInt("FState");
        if (4 != state) {
            String billId = rst.getString("FBgAdjustBill");
            if (!this.tempDatas.containsKey(bgSchemeId)) {
                this.tempDatas.put(bgSchemeId, new HashMap());
            }
            if (!this.tempDatas.get(bgSchemeId).containsKey(billId)) {
                this.tempDatas.get(bgSchemeId).put(billId, new ArrayList());
            }
            BgVersionInfo version = this.getCacheHelper().getBgVersionMap().get(rst.getString("FBgVersionID"));
            DimData mbgData = new DimData();
            mbgData.setMbgDataId(rst.getString("FBgDataId"));
            mbgData.setBgOrgUnitId(rst.getString("FOrgUnit"));
            mbgData.setOrgUnitId(rst.getString("FOrgUnitID"));
            mbgData.setFormula(formula);
            mbgData.setVersionId(version.getId().toString());
            mbgData.setVersionNum(version.getNumber());
            mbgData.setVersionInnId(version.getVersionId());
            mbgData.setValue(rst.getBigDecimal("FAdjustValue"));
            mbgData.setOldValue(rst.getBigDecimal("FOldValue"));
            mbgData.parse();
            this.tempDatas.get(bgSchemeId).get(billId).add(mbgData);
        }
        return new String[]{indexNumber, indexName, memberNumber, memberName, updateUtil.getOtherMemberRef(), formula, id};
    }
}

