/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.eas.ma.mbg.update820to850.app.face.AbstractMbgUpdate820;
import com.kingdee.eas.ma.mbg.update820to850.common.MbgUpdate820MemberInfo;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;

public class MbgBeforeUpdate
extends AbstractMbgUpdate820 {
    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            MbgSqlHelper.execute((Connection)conn, (String)"Update T_MBG_BgElement Set FLongNumber = FNumber Where FLongNumber IS NULL");
            MbgSqlHelper.execute((Connection)conn, (String)"Update T_MBG_BGSCENARIO Set FLongNumber = FNumber Where FLongNumber IS NULL");
            MbgSqlHelper.execute((Connection)conn, (String)"Update T_MBG_BGVERSION Set FLongNumber = FNumber Where FLongNumber IS NULL");
            MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgScheme Set FBgSchemeTypeId = ? Where FBgSchemeTypeId = ?", (Object)new Object[]{"lVIAAAAuzHqQxGui", "lVIAAABXGOSQxGui"});
            for (BgSchemeInfo bgScheme : this.getCacheHelper().getBgSchemeMap().values()) {
                if (StringUtils.isEmpty((String)bgScheme.getRefCube())) continue;
                this.addCombinField(conn, bgScheme.getRefCube());
                this.addCombinField(conn, BgCubeUtils.getDailyActualCubeName(bgScheme.getRefCube()));
                this.alterNull(conn, bgScheme.getRefCube(), "FBgItemCombinId");
                this.alterNull(conn, BgCubeUtils.getDailyActualCubeName(bgScheme.getRefCube()), "FBgItemCombinId");
                this.checkRefField(conn, bgScheme.getRefCube(), this.getCacheHelper().getBgSchemeRefFieldMap().get(bgScheme.getId().toString()));
                this.checkRefField(conn, BgCubeUtils.getActualCubeName1(bgScheme.getRefCube()), this.getCacheHelper().getBgSchemeRefFieldMap().get(bgScheme.getId().toString()));
                this.checkRefField(conn, BgCubeUtils.getControlCubeName(bgScheme.getRefCube()), this.getCacheHelper().getBgSchemeRefFieldMap().get(bgScheme.getId().toString()));
                this.checkRefField(conn, BgCubeUtils.getDailyActualCubeName(bgScheme.getRefCube()), this.getCacheHelper().getBgSchemeRefFieldMap().get(bgScheme.getId().toString()));
            }
            this.storeMemberMap(conn);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void checkRefField(Connection conn, String refCube, Set<String> refFields) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)refCube) || refFields == null || refFields.isEmpty()) {
            return;
        }
        for (String refField : refFields) {
            if (BgDBUtils.existColumn((Connection)conn, (String)refCube, (String)refField) == BgDBUtils.YES) continue;
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter Table " + refCube + " Add " + refField + " NVarchar(84)"));
        }
    }

    private void storeMemberMap(Connection conn) throws SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<MbgUpdate820MemberInfo> allMembers = new ArrayList<MbgUpdate820MemberInfo>();
        if (this.getCacheHelper().getConfig().getAccountMembers() != null) {
            allMembers.addAll(this.getCacheHelper().getConfig().getAccountMembers());
        }
        if (this.getCacheHelper().getConfig().getOtherMembers() != null) {
            allMembers.addAll(this.getCacheHelper().getConfig().getOtherMembers());
        }
        for (MbgUpdate820MemberInfo member : allMembers) {
            if (member.getNumber().equals(member.getNewNumber())) continue;
            paramList.add(new Object[]{member.getSource().getDimension().getRefField(), DimensionFormulaHelper.getCombination(member.getSource().getSrcNumber(), member.getNumber()), DimensionFormulaHelper.getCombination(member.getSource().getSrcNumber(), member.getNewNumber())});
        }
        MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + this.getCacheHelper().getMemberMapTempTable() + "(FRefField, FOldNumber, FNewNumber) values(?, ?, ?)"), paramList);
    }

    private void alterNull(Connection conn, String tableName, String colName) throws BOSException {
        MbgSqlHelper.execute((Connection)conn, (String)("IF EXISTS (SELECT * from KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='" + colName + "' and KSQL_COL_TABNAME='" + tableName + "' and KSQL_COL_NULLABLE = 'N') ALTER TABLE " + tableName + " ALTER COLUMN " + colName + " VARCHAR(44) null"));
    }

    private void addCombinField(Connection conn, String tableName) throws BOSException {
        MbgSqlHelper.execute((Connection)conn, (String)("IF NOT Exists(SELECT * from KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FBgItemCombination' and KSQL_COL_TABNAME='" + tableName + "') Alter Table " + tableName + " Add FBgItemCombination NVARCHAR(" + 300 + ")"));
    }
}

