/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetFactory;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizRefBgTemplateInfo;
import com.kingdee.eas.ma.biz.BizRelyInfo;
import com.kingdee.eas.ma.biz.BizScopeFactory;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.BizStateEnum;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.eas.ma.mbg.update820to850.app.face.AbstractMbgUpdate820;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgCalcTransUtils;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgDimensionUpdateUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class MbgCalcRuleUpdate
extends AbstractMbgUpdate820 {
    private static final Logger logger = Logger.getLogger(MbgCalcRuleUpdate.class);
    private static BizRefBgTemplateInfo bgTemplateInfo = new BizRefBgTemplateInfo();
    private static BizRelyInfo relyInfo = new BizRelyInfo();
    private static final String UPDATE_TAG = "BG";
    private static final int BIZID = 0;
    private static final int BIZNUMBER = 1;
    private static final int RELYID = 2;
    private static final int RELYNUMBR = 3;

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        Connection conn = null;
        IRowSet rst = null;
        StringBuffer sql = new StringBuffer();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String number = null;
        String oldNumber = null;
        String bizId = null;
        String oldId = null;
        String schemeId = null;
        String tmpId = null;
        String formula = null;
        String oldFormula = null;
        String[] rule = null;
        Map<String, MbgDimInfo> mbgDimMap = null;
        HashMap<String, BizCalcInfo> calcMap = new HashMap<String, BizCalcInfo>();
        TreeMap<Integer, String[]> ruleMap = new TreeMap<Integer, String[]>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        });
        HashMap<String, List<String>> schemeRefMap = new HashMap();
        List schemes = null;
        Map<String, List<String>> templateNumMap = null;
        List<String> templateNums = null;
        Map<String, Map<String, String>> schemeTemMap = null;
        ArrayList<Object[]> refTemplates = new ArrayList<Object[]>();
        Map<Object, Object> orgUnitRefMap = new HashMap();
        Map orgUnitMap = null;
        Map<String, List<String[]>> relyMap = null;
        Map<String, List<BizScopeInfo>> scopeMap = null;
        List<BizScopeInfo> scopes = null;
        HashSet<String> clearPeriodSet = new HashSet<String>();
        HashMap<String, MbgDimensionUpdateUtils> utilsMap = new HashMap<String, MbgDimensionUpdateUtils>();
        MbgDimensionUpdateUtils util = null;
        BizCalcInfo calcInfo = null;
        BizCalcInfo tmpCalc = null;
        BizCalcSubsetInfo sub = null;
        BizScopeInfo scope = null;
        CoreBaseCollection calcs = new CoreBaseCollection();
        CoreBaseCollection subs = new CoreBaseCollection();
        CoreBaseCollection scopeColls = new CoreBaseCollection();
        TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
        try {
            conn = this.getConnection();
            mbgDimMap = DimUtils.getDimInfoMap(conn, this.getContext().getLocale());
            schemeRefMap = this.queryRefScheme(conn);
            templateNumMap = this.queryRefTemplate(conn);
            schemeTemMap = this.queryTemplate(conn);
            orgUnitRefMap = this.queryRefOrgUnit(conn);
            relyMap = this.queryRely(conn);
            this.updateSchemeByRely(relyMap, schemeRefMap);
            scopeMap = this.queryBizScope(conn, mbgDimMap);
            sql.append("select t.FID, t.FCreatorID, t.FCreateTime, t.FLastUpdateUserID, t.FLastUpdateTime, t.FControlUnitID, t.FName_" + this.getContext().getLocale() + " AS FName, t.FNumber, t.FDescription_" + this.getContext().getLocale() + " AS FDescription, t.FOrgUnitID, t.FBgSchemeID, t.FState, t.FFormula, r.FSeq, r.FExpression, r.FType, r.FBgIndexNum, r.FBgIndexAlias, r.FDimNum, r.FDimAlias, r.FBgPeriodNum, r.FBgPeriodAlias, r.FBgElementNum, r.FBgElementAlias, r.FCurrencyNum, r.FCurrencyAlias, r.FBgScenarioNum, r.FBgScenarioAlias, r.FBgVersionNum, r.FBgVersionAlias from T_MBG_BizCalc t join T_MBG_BizCalcRule r on t.FID = r.FBizSchemeID order by t.FNumber, r.FSeq");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (true) {
                boolean hasNext = false;
                if (rst.next()) {
                    hasNext = true;
                    bizId = rst.getString("FID");
                    number = rst.getString("FNumber");
                    formula = rst.getString("FFormula");
                    if (!schemeRefMap.containsKey(bizId)) continue;
                    if (!calcMap.containsKey(bizId)) {
                        calcInfo = new BizCalcInfo();
                        calcInfo.setId(BOSUuid.read((String)bizId));
                        calcInfo.setCreator(new UserInfo());
                        calcInfo.getCreator().setId(BOSUuid.read((String)rst.getString("FCreatorID")));
                        calcInfo.setCreateTime(rst.getTimestamp("FCreateTime"));
                        calcInfo.setLastUpdateUser(new UserInfo());
                        calcInfo.getLastUpdateUser().setId(BOSUuid.read((String)rst.getString("FLastUpdateUserID")));
                        calcInfo.setLastUpdateTime(rst.getTimestamp("FLastUpdateTime"));
                        tmpId = rst.getString("FControlUnitID");
                        if (tmpId != null) {
                            calcInfo.setCU(new CtrlUnitInfo());
                            calcInfo.getCU().setId(BOSUuid.read((String)tmpId));
                        }
                        calcInfo.setOrgUnit(new FullOrgUnitInfo());
                        calcInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                        calcInfo.setName(rst.getString("FName"));
                        calcInfo.setNumber(UPDATE_TAG + rst.getString("FNumber"));
                        calcInfo.setDescription(rst.getString("FDescription"));
                        calcInfo.setState(this.getState(calcInfo, orgUnitRefMap));
                        calcInfo.setIsBGExe(false);
                        calcMap.put(bizId, calcInfo);
                    }
                } else {
                    number = "000000000000000000000000000=";
                }
                if (oldNumber == null) {
                    oldNumber = number;
                    oldId = bizId;
                    oldFormula = formula;
                }
                if (!number.equals(oldNumber)) {
                    calcInfo = (BizCalcInfo)calcMap.get(oldId);
                    schemes = (List)schemeRefMap.get(oldId);
                    orgUnitMap = (Map)orgUnitRefMap.get(oldId);
                    templateNums = templateNumMap.get(oldId);
                    scopes = scopeMap.get(oldId);
                    int in = schemes.size();
                    for (int i = 0; i < in; ++i) {
                        int x;
                        int xn;
                        schemeId = (String)schemes.get(i);
                        if (utilsMap.containsKey(schemeId)) {
                            util = (MbgDimensionUpdateUtils)utilsMap.get(schemeId);
                        } else {
                            util = this.getCacheHelper().getUpdateUtil(schemeId);
                            utilsMap.put(schemeId, util);
                        }
                        sub = new BizCalcSubsetInfo();
                        sub.setId(BOSUuid.create((BOSObjectType)sub.getBOSType()));
                        sub.setSeq(1);
                        sub.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdate820Resource", (String)"bizSetName"));
                        try {
                            sub.setBizFormula(MbgCalcTransUtils.tans850(calcInfo, oldFormula, ruleMap, util, clearPeriodSet));
                        }
                        catch (Exception ex) {
                            logger.error((Object)"trans bizCalc formula error:", (Throwable)ex);
                            logger.error((Object)oldFormula);
                            throw new BOSException((Throwable)ex);
                        }
                        if (i == 0) {
                            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BizCalc set FLastUpdateTime = ?, FNumber = ?, FBgSchemeID = ?, FState = ? where FID = ?", (Object[])new Object[]{time, UPDATE_TAG + oldNumber, schemeId, calcInfo.getState().getValue(), oldId});
                            sub.setBizCalc(new BizCalcInfo());
                            sub.getBizCalc().setId(BOSUuid.read((String)oldId));
                            subs.add((CoreBaseInfo)sub);
                            this.updateRefTemplate(oldId, schemeId, templateNums, refTemplates, schemeTemMap);
                            if (scopes != null) {
                                xn = scopes.size();
                                for (x = 0; x < xn; ++x) {
                                    scope = scopes.get(x);
                                    scope.setBgMemberNum(util.convertItem(scope.getBgMemberNum(), false));
                                    scope.setBizCalcSubset(sub);
                                    sub.getScope().add(scope);
                                    scopeColls.add((CoreBaseInfo)scope);
                                }
                            }
                            this.updateScopeByOrgUnit(sub, orgUnitMap, scopeColls);
                            continue;
                        }
                        tmpCalc = calcInfo.clone();
                        tmpCalc.setId(BOSUuid.create((BOSObjectType)tmpCalc.getBOSType()));
                        tmpCalc.setLastUpdateTime(time);
                        tmpCalc.setBgScheme(new BgSchemeInfo());
                        tmpCalc.getBgScheme().setId(BOSUuid.read((String)schemeId));
                        sub.setBizCalc(tmpCalc);
                        subs.add((CoreBaseInfo)sub);
                        tmpCalc.getBizCalcSubset().add(sub);
                        calcs.add((CoreBaseInfo)tmpCalc);
                        this.updateRefTemplate(tmpCalc.getId().toString(), schemeId, templateNums, refTemplates, schemeTemMap);
                        if (scopes != null) {
                            xn = scopes.size();
                            for (x = 0; x < xn; ++x) {
                                scope = scopes.get(x).clone();
                                scope.setId(BOSUuid.create((BOSObjectType)scope.getBOSType()));
                                scope.setBizCalcSubset(sub);
                                sub.getScope().add(scope);
                                scopeColls.add((CoreBaseInfo)scope);
                            }
                        }
                        this.updateScopeByOrgUnit(sub, orgUnitMap, scopeColls);
                    }
                    ruleMap.clear();
                    oldNumber = number;
                    oldId = bizId;
                    oldFormula = formula;
                }
                if (!hasNext) break;
                rule = new String[10];
                rule[0] = String.valueOf(rst.getInt("FType"));
                rule[1] = rst.getString("FExpression");
                rule[2] = rst.getString("FBgIndexNum");
                rule[3] = rst.getString("FDimNum");
                rule[4] = rst.getString("FBgPeriodNum");
                rule[5] = rst.getString("FBgElementNum");
                rule[6] = rst.getString("FCurrencyNum");
                rule[7] = rst.getString("FBgScenarioNum");
                rule[8] = rst.getString("FBgVersionNum");
                ruleMap.put(rst.getInt("FSeq"), rule);
            }
            if (!calcs.isEmpty()) {
                BizCalcFactory.getLocalInstance((Context)this.getContext()).addnewBatchData(calcs);
            }
            if (!subs.isEmpty()) {
                BizCalcSubsetFactory.getLocalInstance((Context)this.getContext()).addnewBatchData(subs);
            }
            if (!scopeColls.isEmpty()) {
                BizScopeFactory.getLocalInstance((Context)this.getContext()).saveBatchData(scopeColls);
            }
            if (!refTemplates.isEmpty()) {
                BgDBUtils.insertValue1((Connection)conn, (String)"Insert Into T_MBG_BizRefBgTemplate(FID, FBizCalcID, FBgTemplateID) values (?,?,?)", refTemplates);
            }
            if (!relyMap.isEmpty()) {
                this.updateRely(conn, relyMap, pool, clearPeriodSet);
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BizCalc set FOrgUnitId = (select FOrgUnitId from T_MBG_BgScheme where FID = T_MBG_BizCalc.FBgSchemeId) where exists (select FID from T_MBG_BgScheme where FID = T_MBG_BizCalc.FBgSchemeId)");
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> queryRefScheme(Connection conn) throws SQLException {
        HashMap<String, List<String>> schemeMap = new HashMap<String, List<String>>();
        if (conn == null) {
            return schemeMap;
        }
        String bizId = null;
        String schemeId = null;
        List<String> schemes = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FBizCalcID, FBgSchemeID from T_MBG_BizCalcSchemeRelation where FBgSchemeID IN (select FID from T_MBG_BgScheme)");
            while (rst.next()) {
                bizId = rst.getString("FBizCalcID");
                schemeId = rst.getString("FBgSchemeID");
                if (schemeMap.containsKey(bizId)) {
                    schemes = (List)schemeMap.get(bizId);
                } else {
                    schemes = new ArrayList();
                    schemeMap.put(bizId, schemes);
                }
                schemes.add(schemeId);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return schemeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> queryRefTemplate(Connection conn) throws SQLException {
        IRowSet rst;
        List<String> templateNums;
        String templateNum;
        String bizId;
        HashMap<String, List<String>> templateMap;
        block7: {
            templateMap = new HashMap<String, List<String>>();
            if (conn == null) {
                return templateMap;
            }
            bizId = null;
            templateNum = null;
            templateNums = null;
            rst = null;
            if (BgDBUtils.existTable((Connection)conn, (String)"T_MBG_BizTmpRelation") != BgDBUtils.NO) break block7;
            HashMap<String, List<String>> hashMap = templateMap;
            SQLUtils.cleanup(rst);
            return hashMap;
        }
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select r.FBizCalcID, t.FNumber from T_MBG_BizTmpRelation r join T_MBG_BgTemplate t on t.FID = r.FTMPLATEID ");
            while (rst.next()) {
                bizId = rst.getString("FBizCalcID");
                templateNum = rst.getString("FNumber");
                if (templateMap.containsKey(bizId)) {
                    templateNums = (List)templateMap.get(bizId);
                } else {
                    templateNums = new ArrayList();
                    templateMap.put(bizId, templateNums);
                }
                templateNums.add(templateNum);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return templateMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String[]>> queryRefOrgUnit(Connection conn) throws SQLException {
        HashMap<String, Map<String, String[]>> bizRefUnitMap = new HashMap<String, Map<String, String[]>>();
        if (conn == null) {
            return bizRefUnitMap;
        }
        String bizId = null;
        Map<String, String[]> orgUnitMap = null;
        String[] orgUnit = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select t.FBIZID, t.FORGUNITID, cc.FNumber, cc.FName_" + this.getContext().getLocale() + " AS FName from T_MBG_BizRelationDist t left join T_ORG_CostCenter cc on t.FORGUNITID = cc.FID"));
            while (rst.next()) {
                bizId = rst.getString("FBIZID");
                orgUnit = new String[]{rst.getString("FORGUNITID"), rst.getString("FNumber"), rst.getString("FName")};
                if (bizRefUnitMap.containsKey(bizId)) {
                    orgUnitMap = (Map)bizRefUnitMap.get(bizId);
                } else {
                    orgUnitMap = new HashMap();
                    bizRefUnitMap.put(bizId, orgUnitMap);
                }
                orgUnitMap.put(orgUnit[0], orgUnit);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bizRefUnitMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> queryTemplate(Connection conn) throws SQLException {
        HashMap<String, Map<String, String>> schemeTemMap = new HashMap<String, Map<String, String>>();
        if (conn == null) {
            return schemeTemMap;
        }
        String schemeId = null;
        String templateId = null;
        Map<String, String> templateMap = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID, FRootId, FNumber, FBgSchemeId from T_MBG_BgTemplate where fid = FRootId ");
            while (rst.next()) {
                schemeId = rst.getString("FBgSchemeId");
                templateId = rst.getString("FID");
                if (schemeTemMap.containsKey(schemeId)) {
                    templateMap = (Map)schemeTemMap.get(schemeId);
                } else {
                    templateMap = new HashMap();
                    schemeTemMap.put(schemeId, templateMap);
                }
                templateMap.put(rst.getString("FNumber"), templateId);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return schemeTemMap;
    }

    private void updateRefTemplate(String bizCalcId, String schemeId, List<String> templateNums, List<Object[]> refTemplates, Map<String, Map<String, String>> schemeTemMap) {
        if (bizCalcId == null || schemeId == null || templateNums == null || refTemplates == null || schemeTemMap == null) {
            return;
        }
        String templateId = null;
        String templateNum = null;
        Object[] refobjs = null;
        if (templateNums != null && !templateNums.isEmpty()) {
            int jn = templateNums.size();
            for (int j = 0; j < jn; ++j) {
                templateNum = templateNums.get(j);
                templateId = schemeTemMap.get(schemeId).get(templateNum);
                if (templateId == null) continue;
                refobjs = new Object[]{BOSUuid.create((BOSObjectType)bgTemplateInfo.getBOSType()).toString(), bizCalcId, templateId};
                refTemplates.add(refobjs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String[]>> queryRely(Connection conn) throws SQLException {
        HashMap<String, List<String[]>> relyMap = new HashMap<String, List<String[]>>();
        if (conn == null) {
            return relyMap;
        }
        if (BgDBUtils.existTable((Connection)conn, (String)"T_MBG_BizRely") == BgDBUtils.NO) {
            return relyMap;
        }
        String bizId = null;
        String relyId = null;
        String number = null;
        String relyNum = null;
        String[] relyStrs = null;
        List<String[]> relys = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select t.FBizCalcID, c1.FNumber, t.FRelyBizId, c2.FNumber AS FRelyNumber from T_MBG_BizRely t left join T_MBG_BizCalc c1 on t.FBizCalcID = c1.FID left join T_MBG_BizCalc c2 on t.FRelyBizId = c2.FID");
            while (rst.next()) {
                bizId = rst.getString("FBizCalcID");
                number = rst.getString("FNumber");
                relyId = rst.getString("FRelyBizId");
                relyNum = rst.getString("FRelyNumber");
                if (relyMap.containsKey(bizId)) {
                    relys = (List)relyMap.get(bizId);
                } else {
                    relys = new ArrayList();
                    relyMap.put(bizId, relys);
                }
                relyStrs = new String[]{bizId, UPDATE_TAG + number, relyId, UPDATE_TAG + relyNum};
                relys.add(relyStrs);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return relyMap;
    }

    private void updateSchemeByRely(Map<String, List<String[]>> relyMap, Map<String, List<String>> schemeMap) {
        if (relyMap == null || relyMap.isEmpty() || schemeMap == null) {
            return;
        }
        Map.Entry<String, List<String[]>> entry2 = null;
        String bizId = null;
        String relyId = null;
        String[] rely = null;
        List<String[]> relys = null;
        List<String> schemeIds = null;
        List<Object> tmpIds = null;
        HashSet<Object> schemeIdSet = new HashSet<Object>();
        for (Map.Entry<String, List<String[]>> entry2 : relyMap.entrySet()) {
            bizId = entry2.getKey();
            relys = entry2.getValue();
            schemeIds = schemeMap.get(bizId);
            if (schemeIds == null || schemeIds.isEmpty()) continue;
            int in = relys.size();
            for (int i = 0; i < in; ++i) {
                rely = relys.get(i);
                relyId = rely[2];
                if (schemeMap.containsKey(relyId)) {
                    tmpIds = schemeMap.get(relyId);
                } else {
                    tmpIds = new ArrayList();
                    schemeMap.put(relyId, tmpIds);
                }
                schemeIdSet.addAll(tmpIds);
                schemeIdSet.addAll(schemeIds);
                tmpIds.clear();
                tmpIds.addAll(schemeIdSet);
            }
        }
    }

    private void updateRely(Connection conn, Map<String, List<String[]>> relyMap, TempTablePool pool, Set<String> clearPeriodSet) throws Exception {
        String clearTable;
        block11: {
            if (conn == null || relyMap == null || relyMap.isEmpty() || pool == null || clearPeriodSet == null) {
                return;
            }
            int size = 0;
            String tmpTable = null;
            String bizNum = null;
            String relyNum = null;
            clearTable = null;
            String[] rely = null;
            List<String[]> relys = null;
            Map.Entry<String, List<String[]>> entry2 = null;
            PreparedStatement pstmt = null;
            try {
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (F1 NVARCHAR(80), F2 NVARCHAR(80))");
                pstmt = conn.prepareStatement("Insert Into " + tmpTable + "(F1, F2) values (?,?)");
                for (Map.Entry<String, List<String[]>> entry2 : relyMap.entrySet()) {
                    relys = entry2.getValue();
                    int in = relys.size();
                    for (int i = 0; i < in; ++i) {
                        rely = relys.get(i);
                        bizNum = rely[1];
                        relyNum = rely[3];
                        pstmt.setString(1, bizNum);
                        pstmt.setString(2, relyNum);
                        pstmt.addBatch();
                        if (++size < 50) continue;
                        pstmt.executeBatch();
                        size = 0;
                    }
                }
                if (size != 0) {
                    pstmt.executeBatch();
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)"truncate table T_MBG_BizRely");
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into T_MBG_BizRely (FID, FBizCalcID, FRelyBizId) select newbosid('" + relyInfo.getBOSType().toString() + "'), c1.FID, c2.FID from " + tmpTable + " t left join T_MBG_BizCalc c1 on t.F1 = c1.FNumber left join T_MBG_BizCalc c2 on t.F2 = c2.FNumber where c1.FBGSCHEMEID = c2.FBGSCHEMEID"));
                clearTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + clearTable + "(FID) values (?)"), clearPeriodSet);
                BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BizCalc set FState = ? where FID IN (select c2.FID from T_MBG_BizRely t left join T_MBG_BizCalc c1 on t.FBizCalcId = c1.FID left join T_MBG_BizCalc c2 on t.FRelyBizId = c2.FID where c1.FState = ? and c2.FID not in (select FID from " + clearTable + "))"), (Object[])new Object[]{2, 2});
                if (tmpTable == null) break block11;
            }
            catch (Exception ex) {
                try {
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    if (clearTable != null) {
                        pool.releaseTable(clearTable);
                    }
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        if (clearTable != null) {
            pool.releaseTable(clearTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<BizScopeInfo>> queryBizScope(Connection conn, Map<String, MbgDimInfo> mbgDimMap) throws SQLException {
        HashMap<String, List<BizScopeInfo>> scopeMap = new HashMap<String, List<BizScopeInfo>>();
        if (conn == null || mbgDimMap == null) {
            return scopeMap;
        }
        String bizId = null;
        List<BizScopeInfo> scopes = null;
        BizScopeInfo scope = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select t.FID, t.FBizCalcID, t.FBgMemberNum, t.FBgMemberAlias, t.FBgMemberType from T_MBG_BizScope t");
            while (rst.next()) {
                bizId = rst.getString("FBizCalcID");
                if (scopeMap.containsKey(bizId)) {
                    scopes = (List)scopeMap.get(bizId);
                } else {
                    scopes = new ArrayList();
                    scopeMap.put(bizId, scopes);
                }
                scope = new BizScopeInfo();
                scope.setId(BOSUuid.read((String)rst.getString("FID")));
                scope.setBgMemberNum(rst.getString("FBgMemberNum"));
                scope.setBgMemberAlias(rst.getString("FBgMemberAlias"));
                scope.setBgMemberType(rst.getInt("FBgMemberType"));
                scope.setBizDataType(BgMemberSelectTypeEnum.Member);
                scope.setFillType(DimensionMemberTypeEnum.Normal);
                scope.setRefField(this.getRefField(scope, mbgDimMap));
                scopes.add(scope);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return scopeMap;
    }

    private void updateScopeByOrgUnit(BizCalcSubsetInfo subCalc, Map<String, String[]> orgUnitMap, CoreBaseCollection scopeColls) {
        if (subCalc == null || orgUnitMap == null || orgUnitMap.isEmpty() || scopeColls == null) {
            return;
        }
        String[] orgUnit2 = null;
        BizScopeInfo scope = null;
        for (String[] orgUnit2 : orgUnitMap.values()) {
            scope = new BizScopeInfo();
            scope.setId(BOSUuid.create((BOSObjectType)scope.getBOSType()));
            scope.setBgMemberNum(orgUnit2[1]);
            scope.setBgMemberAlias(orgUnit2[2]);
            scope.setBgMemberType(BizConstants.BIZ_BGORGUNIT_TYPE_VALUE);
            scope.setBizDataType(BgMemberSelectTypeEnum.Member);
            scope.setFillType(DimensionMemberTypeEnum.Normal);
            scope.setRefField(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
            scope.setBizCalcSubset(subCalc);
            scopeColls.add((CoreBaseInfo)scope);
        }
    }

    private String getRefField(BizScopeInfo scope, Map<String, MbgDimInfo> mbgDimMap) {
        String refField = null;
        if (scope == null) {
            return refField;
        }
        if (BizConstants.BIZ_BGSCENARIO_TYPE_VALUE == scope.getBgMemberType()) {
            refField = DimensionBaseConstants.DEF_SCENARIO_FIELD;
        } else if (BizConstants.BIZ_BGINDEX_TYPE_VALUE == scope.getBgMemberType()) {
            refField = DimensionBaseConstants.DEF_BGINDEX_FIELD;
        } else if (BizConstants.BIZ_BGPERIOD_TYPE_VALUE == scope.getBgMemberType()) {
            refField = DimensionBaseConstants.DEF_PERIOD_FIELD;
        } else if (BizConstants.BIZ_BGVERSION_TYPE_VALUE == scope.getBgMemberType()) {
            refField = DimensionBaseConstants.DEF_VERSION_FIELD;
        } else if (BizConstants.BIZ_CURRENCY_TYPE_VALUE == scope.getBgMemberType()) {
            refField = DimensionBaseConstants.DEF_CURRENCY_FIELD;
        } else if (BizConstants.BIZ_BGELEMENT_TYPE_VALUE == scope.getBgMemberType()) {
            refField = DimensionBaseConstants.DEF_ELEMENT_FIELD;
        } else if (BizConstants.BIZ_EXTDIM_TYPE_VALUE == scope.getBgMemberType()) {
            String srcNumber = DimUtils.getSrcNumber(scope.getBgMemberNum());
            if (mbgDimMap.containsKey(srcNumber)) {
                refField = mbgDimMap.get(srcNumber).getRefField();
            }
        } else if (BizConstants.BIZ_BGORGUNIT_TYPE_VALUE == scope.getBgMemberType()) {
            refField = DimensionBaseConstants.DEF_ORGUNIT_FIELD;
        }
        return refField;
    }

    private BizStateEnum getState(BizCalcInfo calcInfo, Map<String, Map<String, String[]>> orgUnitRefMap) {
        Map<String, String[]> orgUnitIds;
        if (calcInfo == null || orgUnitRefMap == null) {
            return BizStateEnum.DISABLE;
        }
        String bizId = calcInfo.getId().toString();
        if (orgUnitRefMap.containsKey(bizId) && (orgUnitIds = orgUnitRefMap.get(bizId)) != null && !orgUnitIds.isEmpty()) {
            return BizStateEnum.SAVED;
        }
        return BizStateEnum.TEMPSAVED;
    }
}

