/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgSqlUpdateProcessor;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

class MbgCtrlSettingsUpdateProcessor
extends MbgSqlUpdateProcessor {
    public MbgCtrlSettingsUpdateProcessor(Connection conn, MbgUpdate820CacheHelper cacheHelper, String querySql, String updateSql) {
        super(conn, cacheHelper, querySql, updateSql);
    }

    @Override
    protected Object[] processObject(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        String id = rst.getString("FID");
        String bgSchemeId = rst.getString("FSchemeId");
        String bgIndexNumber = rst.getString("FBgIndexNumber");
        String bgIndexName = rst.getString("FBgIndexName");
        String bgDimNumber = rst.getString("FBgDimNumber");
        String bgDimName = rst.getString("FBgDimName");
        if ("000000000000000000000000000=".equals(bgDimNumber)) {
            bgDimNumber = null;
        }
        boolean accShowNumber = false;
        boolean otherShowNumber = false;
        StringBuffer itemNumber = new StringBuffer();
        StringBuffer itemName = new StringBuffer();
        accShowNumber = this.build(bgIndexNumber, bgIndexName, itemNumber, itemName);
        otherShowNumber = this.build(bgDimNumber, bgDimName, itemNumber, itemName);
        String[] newValues = this.getCacheHelper().getUpdateUtil(bgSchemeId).convert(itemNumber.toString(), itemName.toString(), false);
        if (newValues == null) {
            return null;
        }
        int index = newValues[0].indexOf(",");
        if (index > 0) {
            bgIndexNumber = newValues[0].substring(0, index);
            bgIndexName = newValues[1].substring(0, newValues[1].indexOf(DimensionConstants.TICK_SEPARATOR));
            if (accShowNumber) {
                bgIndexName = "[" + DimensionFormulaHelper.getMemberNumber(bgIndexNumber) + "]" + bgIndexName;
            }
            if (StringUtils.isEmpty((String)bgDimName)) {
                bgDimNumber = newValues[0].substring(index + 1).replaceAll(":#", "");
            } else {
                bgDimNumber = newValues[0].substring(index + 1);
                String[] names = newValues[1].split(DimensionConstants.TICK_SEPARATOR);
                String[] numbers = bgDimNumber.split(",");
                bgDimName = "";
                String onlyNumber = "";
                MbgDimInfo mbgDim = null;
                for (int i = 0; i < numbers.length; ++i) {
                    if (i > 0) {
                        onlyNumber = onlyNumber + ",";
                        bgDimName = bgDimName + ",";
                    }
                    onlyNumber = onlyNumber + DimensionFormulaHelper.getMemberNumber(numbers[i]);
                    mbgDim = this.getCacheHelper().getMbgDimBySrc(DimensionFormulaHelper.getSrcNumber(numbers[i]));
                    if (mbgDim == null) {
                        return null;
                    }
                    bgDimName = bgDimName + mbgDim.getName() + ":" + names[i + 1];
                }
                if (otherShowNumber) {
                    bgDimName = "[" + onlyNumber + "]" + bgDimName;
                }
            }
            return new Object[]{bgIndexNumber, bgIndexName, bgDimNumber, bgDimName, id};
        }
        return new Object[]{newValues[0], accShowNumber ? "[" + newValues[0] + "]" + newValues[1] : newValues[1], null, null, id};
    }

    private boolean build(String number, String name, StringBuffer itemNumber, StringBuffer itemName) {
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        boolean isShowNumber = false;
        if (!StringUtils.isEmpty((String)name) && name.startsWith("[") && name.indexOf("]") > 0) {
            name = name.substring(name.indexOf("]") + 1);
            isShowNumber = true;
        }
        String[] itemComb = number.split(",");
        String[] nameComb = null;
        if (!StringUtils.isEmpty((String)name)) {
            nameComb = name.split(",");
        }
        for (int i = 0; i < itemComb.length; ++i) {
            if (itemNumber.length() > 0) {
                itemNumber.append(",");
                itemName.append(DimensionConstants.TICK_SEPARATOR);
            }
            if (itemComb[i].indexOf(":") > 0) {
                itemNumber.append(itemComb[i]);
                if (nameComb != null && nameComb[i].indexOf(":") > 0) {
                    itemName.append(nameComb[i].substring(nameComb[i].indexOf(":") + 1));
                    continue;
                }
                if (nameComb == null) continue;
                itemName.append(nameComb[i]);
                continue;
            }
            itemNumber.append(DimensionFormulaHelper.getCombination(itemComb[i], "#"));
            itemName.append("#");
        }
        return isShowNumber;
    }
}

