/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgExpressRepairProcess;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.AbstractMbgRepairProcessor;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

class MbgDataUpdateProcessor
extends AbstractMbgRepairProcessor {
    Map<String, String> periodId_number = null;
    Map<String, String> periodNumber_id = null;
    private String cubeName = null;

    public MbgDataUpdateProcessor(Context ctx, Connection conn, String sourceTypeNumber, String targetTypeNumber, String querySql, String updateSql, Map<String, String> periodId_number, Map<String, String> periodNumber_id) {
        super(ctx, conn, sourceTypeNumber, targetTypeNumber, querySql, updateSql);
        this.periodId_number = periodId_number;
        this.periodNumber_id = periodNumber_id;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    @Override
    protected PreparedStatement buildQueryPstmt(Connection conn) throws SQLException {
        return conn.prepareStatement("Select FID, FFormula, FBgPeriodId FROM " + this.cubeName);
    }

    @Override
    protected PreparedStatement buildUpdatePstmt(Connection conn) throws SQLException {
        return conn.prepareStatement("Update " + this.cubeName + " Set FFormula = ?, FBgPeriodId = ? Where FID = ?");
    }

    @Override
    protected Object[] processObject(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        String id = rst.getString("FID");
        String formula = rst.getString("FFormula");
        String[] params = BgNFSHelper.parseFormulaPara(null, formula);
        String oldBgPeriodNumber = params[1];
        String newPeriodNumber = MbgExpressRepairProcess.convertPeriod(oldBgPeriodNumber, this.getSourceTypeNumber(), this.getTargetTypeNumber());
        if (newPeriodNumber == null || newPeriodNumber.equals(oldBgPeriodNumber) || !this.periodNumber_id.containsKey(newPeriodNumber)) {
            return null;
        }
        params[1] = newPeriodNumber;
        return new String[]{BgNFSHelper.getFormulaFromParam(params), this.periodNumber_id.get(newPeriodNumber), id};
    }
}

