/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgSqlUpdateProcessor;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import java.util.Map;

class MbgDimItemProcessor
extends MbgSqlUpdateProcessor {
    private boolean hasName = true;
    static final String dimItemField = "dimItem";
    static final String dimItemNameField = "dimItemName";
    static final String idField = "id";
    Map<String, String> bizPropMap = null;
    Map<String, String> bizPropNameMap = null;

    public MbgDimItemProcessor(Connection conn, MbgUpdate820CacheHelper cacheHelper, String querySql, String updateSql, boolean hasName, Map<String, String> bizPropMap, Map<String, String> bizPropNameMap) {
        super(conn, cacheHelper, querySql, updateSql);
        this.hasName = hasName;
        this.bizPropMap = bizPropMap;
        this.bizPropNameMap = bizPropNameMap;
    }

    @Override
    protected Object[] processObject(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        String id = rst.getString(idField);
        String number = rst.getString(dimItemField);
        if (this.bizPropMap.containsKey(number)) {
            if (this.hasName) {
                return new Object[]{this.bizPropMap.get(number), this.bizPropNameMap.get(number), id};
            }
            return new Object[]{this.bizPropMap.get(number), id};
        }
        String[] dimItem = number.split("\\@");
        String[] dimItemName = null;
        if (this.hasName) {
            dimItemName = rst.getString(dimItemNameField).split("\\@");
        }
        String[] dimItemSplit = null;
        String[] dimNameSplit = null;
        DimensionSourceInfo source = null;
        MbgDimInfo mbgDim = null;
        for (int i = 0; i < dimItem.length; ++i) {
            dimItemSplit = dimItem[i].split("\\|");
            if (this.hasName && dimNameSplit != null && dimItemName != null) {
                dimNameSplit = dimItemName[i].split("\\|");
            }
            if ((source = this.getCacheHelper().getConfig().getSrcSourceMap().get(dimItemSplit[1])) == null) continue;
            if (MbgUpdateHelper.DEF_INDEX_NUMBER.equals(source.getDimension().getNumber())) {
                dimItemSplit[1] = DimensionConstants.DEF_INDEX_SRCNUMBER;
                if (this.hasName && dimNameSplit != null) {
                    dimNameSplit[1] = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)DimensionConstants.DEF_ACCOUNT_NUMBER, (Locale)this.getCacheHelper().getCtx().getLocale());
                }
            } else {
                mbgDim = this.getCacheHelper().getMbgDimByNumber(source.getDimension().getNumber());
                dimItemSplit[1] = mbgDim.getSrcNumber();
                if (this.hasName && dimNameSplit != null) {
                    dimNameSplit[1] = mbgDim.getName();
                }
            }
            dimItem[i] = dimItemSplit[0] + "|" + dimItemSplit[1];
            if (!this.hasName || dimNameSplit == null || dimItemName == null) continue;
            dimItemName[i] = dimNameSplit[0] + "|" + dimNameSplit[1];
        }
        StringBuffer newNumber = new StringBuffer();
        StringBuffer newName = new StringBuffer();
        for (int i = 0; i < dimItem.length; ++i) {
            if (i > 0) {
                newNumber.append("@");
            }
            newNumber.append(dimItem[i]);
            if (!this.hasName) continue;
            if (i > 0) {
                newName.append("@");
            }
            if (dimItemName == null || dimItemName[i] == null) continue;
            newName.append(dimItemName[i]);
        }
        this.bizPropMap.put(number, newNumber.toString());
        if (this.hasName) {
            this.bizPropNameMap.put(number, newName.toString());
        }
        if (!number.equals(newNumber.toString()) || this.hasName && !newName.toString().equals(dimItemName)) {
            if (this.hasName) {
                return new Object[]{newNumber.toString(), newName.toString(), id};
            }
            return new Object[]{newNumber.toString(), id};
        }
        return null;
    }
}

