/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgExpressRepairProcess;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.AbstractMbgRepairProcessor;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

class MbgPeriodIdRepairProcessor
extends AbstractMbgRepairProcessor {
    Map<String, String> periodId_number = null;
    Map<String, String> periodNumber_id = null;
    public static final String BGPERIOD_ID = "bp_id";
    public static final String MAIN_ID = "m_id";

    public MbgPeriodIdRepairProcessor(Context ctx, Connection conn, String sourceTypeNumber, String targetTypeNumber, String querySql, String updateSql, Map<String, String> periodId_number, Map<String, String> periodNumber_id) {
        super(ctx, conn, sourceTypeNumber, targetTypeNumber, querySql, updateSql);
        this.periodId_number = periodId_number;
        this.periodNumber_id = periodNumber_id;
    }

    @Override
    protected Object[] processObject(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        String id = rst.getString(MAIN_ID);
        String bgPeriodId = rst.getString(BGPERIOD_ID);
        String oldBgPeriodNumber = this.periodId_number.get(bgPeriodId);
        if (StringUtils.isEmpty((String)oldBgPeriodNumber)) {
            return null;
        }
        String newBgPeriodNumber = MbgExpressRepairProcess.convertPeriod(oldBgPeriodNumber, this.getSourceTypeNumber(), this.getTargetTypeNumber());
        if (newBgPeriodNumber == null || newBgPeriodNumber.equals(oldBgPeriodNumber) || !this.periodNumber_id.containsKey(newBgPeriodNumber)) {
            return null;
        }
        return new String[]{this.periodNumber_id.get(newBgPeriodNumber), id};
    }
}

