/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.utils.BgLocaleHelper;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeRefMemberInfo;
import com.kingdee.eas.ma.mbg.BgSchemeRefMemberTypeEnum;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.eas.ma.mbg.update820to850.app.face.AbstractMbgUpdate820;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgSchemeEndTimeProcessor;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class MbgSchemeUpdate
extends AbstractMbgUpdate820 {
    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection();
            HashMap bgSchemeRefMembers = new HashMap();
            String bgSchemeId = null;
            BgSchemeRefMemberInfo member = null;
            Integer memberType = null;
            pstmt = conn.prepareStatement("Select rMember.FMemberType, rMember.FNumber, rMember.FName, rDim.FBgSchemeID FROM T_MBG_BGSCHEMEREFMEMBER rMember Inner Join T_MBG_BGSCHEMEREFDIM rDim ON rMember.FRefDimId = rDim.FID Order By rDim.FBgSchemeId, rMember.FSeq");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeId = rst.getString("FBgSchemeId");
                memberType = rst.getInt("FMemberType");
                if (!bgSchemeRefMembers.containsKey(bgSchemeId)) {
                    bgSchemeRefMembers.put(bgSchemeId, new HashMap());
                }
                if (!((Map)bgSchemeRefMembers.get(bgSchemeId)).containsKey(memberType)) {
                    ((Map)bgSchemeRefMembers.get(bgSchemeId)).put(memberType, new LinkedHashMap());
                }
                member = new BgSchemeRefMemberInfo();
                member.setNumber(rst.getString("FNumber"));
                member.setName(rst.getString("FName"));
                if (((Map)((Map)bgSchemeRefMembers.get(bgSchemeId)).get(memberType)).containsKey(member.getNumber())) continue;
                ((Map)((Map)bgSchemeRefMembers.get(bgSchemeId)).get(memberType)).put(member.getNumber(), member);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            HashMap<String, Map<String, BgOrgViewInfo>> orgViewMap = new HashMap<String, Map<String, BgOrgViewInfo>>();
            BgOrgViewInfo orgView = null;
            String orgUnitId = null;
            String number = null;
            pstmt = conn.prepareStatement("Select FID, FNumber, FName_L1, FName_L2, FName_L3, FOrgUnitId FROM T_MBG_BgOrgView Where FOrgUnitId IS NOT NULL AND FNumber IS NOT NULL");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                number = rst.getString("FNumber");
                orgUnitId = rst.getString("FOrgUnitId");
                orgView = new BgOrgViewInfo();
                orgView.setId(BOSUuid.read((String)rst.getString("FID")));
                orgView.setNumber(number);
                orgView.setOrgUnit(new CostCenterOrgUnitInfo());
                orgView.getOrgUnit().setId(BOSUuid.read((String)orgUnitId));
                orgView.setName(rst.getString("FName_L1"), LocaleUtils.locale_l1);
                orgView.setName(rst.getString("FName_L2"), LocaleUtils.locale_l2);
                orgView.setName(rst.getString("FName_L3"), LocaleUtils.locale_l3);
                if (!orgViewMap.containsKey(number)) {
                    orgViewMap.put(number, new HashMap());
                }
                ((Map)orgViewMap.get(number)).put(orgUnitId, orgView);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            HashMap<String, String> bgSchemeOrgViewNumberMap = new HashMap<String, String>();
            pstmt = conn.prepareStatement("Select bgScheme.FID, orgView.FNumber FROM T_MBg_BgScheme bgScheme Inner Join T_MBG_BgOrgView orgView ON bgScheme.FBgOrgViewId = orgView.FID");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeOrgViewNumberMap.put(rst.getString("FID"), rst.getString("FNumber"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            HashMap<String, BgDimSettingsCollection> bgDimSettings = new HashMap<String, BgDimSettingsCollection>();
            CoreBaseCollection allSettings = new CoreBaseCollection();
            CoreBaseCollection allSettingsMember = new CoreBaseCollection();
            BgSchemeInfo bgSchemeInfo2 = null;
            BgDimSettingsCollection settingsCol = null;
            BgDimSettingsInfo settingInfo = null;
            BgDimSettingsMemberInfo settingMember = null;
            ArrayList<Integer> fields = new ArrayList<Integer>();
            String refField = null;
            int sourceType = -1;
            MbgViewInfo mbgView = null;
            for (BgSchemeInfo bgSchemeInfo2 : this.getCacheHelper().getBgSchemeMap().values()) {
                bgSchemeId = bgSchemeInfo2.getId().toString();
                sourceType = bgSchemeInfo2.getBgSchemeType().getSchemeType().getValue();
                settingsCol = new BgDimSettingsCollection();
                bgDimSettings.put(bgSchemeInfo2.getId().toString(), settingsCol);
                settingInfo = this.createNewSettingsInfo(bgSchemeInfo2, settingsCol, DimensionConstants.DEF_ORGUNIT_NUMBER);
                settingMember = this.createNewSettingMemberInfo(settingInfo, MemberTypeEnum.budget, (DataBaseInfo)this.getOrgViewInfo(bgSchemeInfo2, bgSchemeOrgViewNumberMap, orgViewMap), allSettingsMember);
                settingInfo = this.createNewSettingsInfo(bgSchemeInfo2, settingsCol, DimensionConstants.DEF_SCENARIO_NUMBER);
                this.createNewSettingMemberCollection(settingInfo, MemberTypeEnum.member, DimensionConstants.DEF_SCENARIO_NUMBER, allSettingsMember);
                settingInfo = this.createNewSettingsInfo(bgSchemeInfo2, settingsCol, DimensionConstants.DEF_ACCOUNT_NUMBER);
                settingMember = this.createNewSettingMemberInfo(settingInfo, MemberTypeEnum.view, (DataBaseInfo)this.getCacheHelper().getAccountViewMap().get(bgSchemeInfo2.getOrgUnit().getId().toString() + "_" + sourceType), allSettingsMember);
                settingInfo = this.createNewSettingsInfo(bgSchemeInfo2, settingsCol, DimensionConstants.DEF_PERIOD_NUMBER);
                this.createNewSettingMemberCollection(settingInfo, MemberTypeEnum.view, DimensionConstants.DEF_PERIOD_NUMBER, allSettingsMember);
                settingInfo = this.createNewSettingsInfo(bgSchemeInfo2, settingsCol, DimensionConstants.DEF_VERSION_NUMBER);
                this.createNewSettingMemberCollection(settingInfo, MemberTypeEnum.view, DimensionConstants.DEF_VERSION_NUMBER, allSettingsMember);
                settingInfo = this.createNewSettingsInfo(bgSchemeInfo2, settingsCol, DimensionConstants.DEF_CURRENCY_NUMBER);
                this.createNewSettingMemberCollection(settingInfo, MemberTypeEnum.view, DimensionConstants.DEF_CURRENCY_NUMBER, allSettingsMember);
                settingInfo = this.createNewSettingsInfo(bgSchemeInfo2, settingsCol, DimensionConstants.DEF_ELEMENT_NUMBER);
                this.createNewSettingMemberCollection(settingInfo, MemberTypeEnum.member, DimensionConstants.DEF_ELEMENT_NUMBER, allSettingsMember);
                fields.clear();
                if (this.getCacheHelper().getBgSchemeRefFieldMap().containsKey(bgSchemeId)) {
                    Iterator<String> itField = this.getCacheHelper().getBgSchemeRefFieldMap().get(bgSchemeId).iterator();
                    while (itField.hasNext()) {
                        fields.add(DimensionCommonHelper.getField(itField.next()));
                    }
                    Collections.sort(fields);
                    for (Integer field : fields) {
                        refField = "F" + field;
                        mbgView = this.getCacheHelper().getMbgView(refField, sourceType);
                        settingInfo = this.createNewSettingsInfo(bgSchemeInfo2, settingsCol, mbgView.getMbgDim().getNumber());
                        for (int l = 0; l < BgLocaleHelper.locales.length; ++l) {
                            settingInfo.setDimName(mbgView.getMbgDim().getName(BgLocaleHelper.locales[l]), BgLocaleHelper.locales[l]);
                        }
                        settingMember = this.createNewSettingMemberInfo(settingInfo, MemberTypeEnum.view, (DataBaseInfo)mbgView, allSettingsMember);
                    }
                }
                allSettings.addObjectCollection((IObjectCollection)settingsCol);
            }
            BgDimSettingsFactory.getLocalInstance(this.getContext()).addnewBatchData(allSettings);
            BgDimSettingsMemberFactory.getLocalInstance(this.getContext()).addnewBatchData(allSettingsMember);
            String querySql = "Select FID, FDateTo FROM T_MBG_BgScheme";
            String updateSql = "Update T_MBG_BgScheme Set FDateTo = ? Where FID = ?";
            MbgSchemeEndTimeProcessor processor = new MbgSchemeEndTimeProcessor(conn, this.getCacheHelper(), querySql, updateSql);
            processor.startProcess();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void createNewSettingMemberCollection(BgDimSettingsInfo settingInfo, MemberTypeEnum memberType, String dimNumber, CoreBaseCollection allSettingMember) {
        Map<String, DataBaseInfo> baseDataMap = this.getCacheHelper().getBaseDataMap().get(dimNumber);
        Iterator<DataBaseInfo> it = baseDataMap.values().iterator();
        while (it.hasNext()) {
            this.createNewSettingMemberInfo(settingInfo, memberType, it.next(), allSettingMember);
        }
    }

    private void createNewSettingMemberCollection(BgDimSettingsInfo settingInfo, MemberTypeEnum memberType, BgSchemeRefMemberTypeEnum refMemberType, String dimNumber, Map<Integer, Map<String, BgSchemeRefMemberInfo>> memberMap, CoreBaseCollection allSettingMember) {
        Map<String, BgSchemeRefMemberInfo> members = memberMap.get(refMemberType.getValue());
        Map<String, DataBaseInfo> baseDataMap = this.getCacheHelper().getBaseDataMap().get(dimNumber);
        boolean hasAct = false;
        for (BgSchemeRefMemberInfo memberInfo : members.values()) {
            if ("ActData".equals(memberInfo.getNumber())) {
                hasAct = true;
            }
            this.createNewSettingMemberInfo(settingInfo, memberType, baseDataMap.get(memberInfo.getNumber()), allSettingMember);
        }
        if (!hasAct && DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimNumber)) {
            this.createNewSettingMemberInfo(settingInfo, memberType, baseDataMap.get("ActData"), allSettingMember);
        }
    }

    private BgOrgViewInfo getOrgViewInfo(BgSchemeInfo bgSchemeInfo, Map<String, String> bgSchemeOrgViewNumberMap, Map<String, Map<String, BgOrgViewInfo>> orgViewMap) {
        return orgViewMap.get(bgSchemeOrgViewNumberMap.get(bgSchemeInfo.getId().toString())).get(bgSchemeInfo.getOrgUnit().getId().toString());
    }

    private BgDimSettingsMemberInfo createNewSettingMemberInfo(BgDimSettingsInfo settingInfo, MemberTypeEnum memberType, DataBaseInfo dataBase, CoreBaseCollection allSettingMember) {
        BgDimSettingsMemberInfo info = new BgDimSettingsMemberInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setBgDimSettings(settingInfo);
        info.setSeq(settingInfo.getMembers().size());
        info.setType(memberType);
        info.setNumber(dataBase.getNumber());
        BgLocaleHelper.copyMultiLangField((IObjectValue)info, (IObjectValue)dataBase, (String)"name", (String)"name");
        info.setMemberID(dataBase.getId());
        settingInfo.getMembers().add(info);
        allSettingMember.add((CoreBaseInfo)info);
        return info;
    }

    private BgDimSettingsInfo createNewSettingsInfo(BgSchemeInfo bgSchemeInfo, BgDimSettingsCollection settingsCol, String dimNumber) {
        BgDimSettingsInfo info = new BgDimSettingsInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        settingsCol.add(info);
        info.setSeq(settingsCol.size());
        info.setBgScheme(bgSchemeInfo);
        info.setDimNumber(dimNumber);
        for (int i = 0; i < BgLocaleHelper.locales.length; ++i) {
            info.setDimName(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)dimNumber, (Locale)BgLocaleHelper.locales[i]), BgLocaleHelper.locales[i]);
        }
        return info;
    }
}

