/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgItemInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820ExecuteHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgDimensionUpdateUtils;
import com.kingdee.eas.ma.mbg.update820to850.common.MbgUpdate820ConfigInfo;
import com.kingdee.eas.ma.mbg.update820to850.common.MbgUpdate820TemplateInfo;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MbgUpdate820CacheHelper {
    private Context ctx = null;
    private MbgUpdate820ConfigInfo config = null;
    private Map<String, Set<String>> bgSchemeRefFieldMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> bgSchemeSuperOrgMap = new HashMap<String, Set<String>>();
    private Map<String, BgSchemeInfo> bgSchemeMap = new HashMap<String, BgSchemeInfo>();
    private Map<String, String> refFieldMap = new HashMap<String, String>();
    private Map<String, MbgViewInfo> mbgViewMap = new HashMap<String, MbgViewInfo>();
    private Map<String, MbgDimInfo> mbgDimMap = new HashMap<String, MbgDimInfo>();
    private Map<String, MbgMemberInfo> mbgMemberSumMap = new HashMap<String, MbgMemberInfo>();
    private Map<String, MbgMemberInfo> mbgMemberLeafMap = new HashMap<String, MbgMemberInfo>();
    private Map<String, Map<String, DataBaseInfo>> baseDataMap = new HashMap<String, Map<String, DataBaseInfo>>();
    private Map<String, BgAccountViewInfo> accountViewMap = new HashMap<String, BgAccountViewInfo>();
    private Map<String, DimensionRelationshipGroupInfo> relationGroup = new HashMap<String, DimensionRelationshipGroupInfo>();
    private Map<String, Map<String, MbgUpdate820TemplateInfo>> templateMap = new HashMap<String, Map<String, MbgUpdate820TemplateInfo>>();
    private Map<String, Map<String, MbgDimInfo>> bgSchemeDimMap = null;
    private Map<String, String> relationMap = new HashMap<String, String>();
    private Map<String, MbgDimensionUpdateUtils> updateUtils = new HashMap<String, MbgDimensionUpdateUtils>();
    private static Map<String, Boolean> treeMap = null;
    private String memberTempTable = null;
    private String ctrlSettiingTempTable = null;
    private String memberMapTempTable = null;
    private String itemMapTempTable = null;
    private TempTablePool pool = null;
    private List<String[]> needAddColumns = new ArrayList<String[]>();
    private Map<String, MbgDimInfo> srcMbgDimMap = null;
    private Map<String, BgVersionInfo> bgVersionMap = null;
    private Map<String, String> propMap = new HashMap<String, String>();

    public List<String[]> getNeedAddColumns() {
        return this.needAddColumns;
    }

    public String getMemberTempTable() {
        return this.memberTempTable;
    }

    public String getCtrlSettiingTempTable() {
        return this.ctrlSettiingTempTable;
    }

    public String getMemberMapTempTable() {
        return this.memberMapTempTable;
    }

    public String getItemMapTempTable() {
        return this.itemMapTempTable;
    }

    public static Map<String, Boolean> getTreeMap() {
        return treeMap;
    }

    public Map<String, BgSchemeInfo> getBgSchemeMap() {
        return this.bgSchemeMap;
    }

    public Map<String, Set<String>> getBgSchemeRefFieldMap() {
        return this.bgSchemeRefFieldMap;
    }

    public Map<String, Set<String>> getBgSchemeSuperOrgMap() {
        return this.bgSchemeSuperOrgMap;
    }

    public Map<String, String> getRefFieldMap() {
        return this.refFieldMap;
    }

    public static String convertMbgDimNumber(String number) {
        if (DimensionConstants.necessary.contains(number) || DimensionConstants.DEF_ACCOUNT_NUMBER.equals(number) || MbgUpdateHelper.DEF_INDEX_NUMBER.equals(number)) {
            return number;
        }
        return number.replaceAll("_", "-");
    }

    public MbgDimInfo getMbgDimByNumber(String number) {
        return this.mbgDimMap.get(MbgUpdate820CacheHelper.convertMbgDimNumber(number));
    }

    public void addMbgDim(MbgDimInfo mbgDim) {
        this.mbgDimMap.put(mbgDim.getNumber(), mbgDim);
    }

    public MbgDimInfo getMbgDimBySrc(String srcNumber) {
        if (this.srcMbgDimMap == null) {
            this.srcMbgDimMap = new HashMap<String, MbgDimInfo>();
            for (MbgDimInfo mbgDim : this.mbgDimMap.values()) {
                this.srcMbgDimMap.put(mbgDim.getSrcNumber(), mbgDim);
            }
        }
        return this.srcMbgDimMap.get(srcNumber);
    }

    public void addMbgView(String oldRefField, MbgViewInfo mbgView) {
        this.mbgViewMap.put(oldRefField + "_" + mbgView.getMbgDim().getSourceType().getValue(), mbgView);
    }

    public MbgViewInfo getMbgView(String oldRefField, int sourceType) {
        return this.mbgViewMap.get(oldRefField + "_" + sourceType);
    }

    public Map<String, MbgMemberInfo> getMbgMemberLeafMap() {
        return this.mbgMemberLeafMap;
    }

    public Map<String, MbgMemberInfo> getMbgMemberSumMap() {
        return this.mbgMemberSumMap;
    }

    public Map<String, Map<String, DataBaseInfo>> getBaseDataMap() {
        return this.baseDataMap;
    }

    public Map<String, BgVersionInfo> getBgVersionMap() {
        if (this.bgVersionMap == null) {
            this.bgVersionMap = new HashMap<String, BgVersionInfo>();
            Map<String, DataBaseInfo> v = this.getBaseDataMap().get(DimensionConstants.DEF_VERSION_NUMBER);
            for (DataBaseInfo db : v.values()) {
                this.bgVersionMap.put(db.getId().toString(), (BgVersionInfo)db);
            }
        }
        return this.bgVersionMap;
    }

    public Map<String, BgAccountViewInfo> getAccountViewMap() {
        return this.accountViewMap;
    }

    public Map<String, DimensionRelationshipGroupInfo> getRelationGroup() {
        return this.relationGroup;
    }

    public Map<String, String> getRelationMap() {
        return this.relationMap;
    }

    public Map<String, Map<String, MbgUpdate820TemplateInfo>> getTemplateMap() {
        return this.templateMap;
    }

    public Map<String, Map<String, MbgDimInfo>> getBgSchemeDimMap() {
        if (this.bgSchemeDimMap == null) {
            this.bgSchemeDimMap = new HashMap<String, Map<String, MbgDimInfo>>();
            String bgSchemeId2 = null;
            MbgViewInfo mbgView = null;
            int sourceType = -1;
            for (String bgSchemeId2 : this.getBgSchemeMap().keySet()) {
                sourceType = this.getBgSchemeMap().get(bgSchemeId2).getBgSchemeType().getSchemeType().getValue();
                this.bgSchemeDimMap.put(bgSchemeId2, new HashMap());
                if (!this.getBgSchemeRefFieldMap().containsKey(bgSchemeId2)) continue;
                Iterator<String> itR = this.getBgSchemeRefFieldMap().get(bgSchemeId2).iterator();
                while (itR.hasNext()) {
                    mbgView = this.getMbgView(itR.next(), sourceType);
                    this.bgSchemeDimMap.get(bgSchemeId2).put(mbgView.getMbgDim().getNumber(), mbgView.getMbgDim());
                }
            }
        }
        return this.bgSchemeDimMap;
    }

    public List<Integer> getAccAndOtherFields(String bgSchemeId) {
        Set<String> refFields = this.getBgSchemeRefFieldMap().get(bgSchemeId);
        if (refFields == null) {
            refFields = new HashSet<String>();
        }
        BgSchemeInfo bgScheme = this.getBgSchemeMap().get(bgSchemeId);
        int sourceType = bgScheme.getBgSchemeType().getSchemeType().getValue();
        ArrayList<Integer> accAndOtherFields = new ArrayList<Integer>();
        accAndOtherFields.add(new Integer(2));
        MbgViewInfo mbgView = null;
        for (String refField : refFields) {
            mbgView = this.getMbgView(refField, sourceType);
            if (mbgView != null) {
                accAndOtherFields.add(DimensionCommonHelper.getField(mbgView.getMbgDim().getRefField()));
                continue;
            }
            accAndOtherFields.add(DimensionCommonHelper.getField(refField));
        }
        Collections.sort(accAndOtherFields);
        return accAndOtherFields;
    }

    public MbgDimensionUpdateUtils getUpdateUtil(String bgSchemeId) {
        MbgDimensionUpdateUtils util = null;
        if (!this.updateUtils.containsKey(bgSchemeId)) {
            util = new MbgDimensionUpdateUtils(this, bgSchemeId);
            this.updateUtils.put(bgSchemeId, util);
        } else {
            util = this.updateUtils.get(bgSchemeId);
        }
        util.setNameSplit(DimensionConstants.TICK_SEPARATOR);
        return util;
    }

    public Map<String, String> getPropMap() {
        return this.propMap;
    }

    public MbgUpdate820CacheHelper(Context ctx, MbgUpdate820ConfigInfo config) {
        this.ctx = ctx;
        this.config = config;
        this.pool = TempTablePool.getInstance((Context)ctx);
    }

    public Context getCtx() {
        return this.ctx;
    }

    public MbgUpdate820ConfigInfo getConfig() {
        return this.config;
    }

    public void initCacheHelper() throws BOSException, EASBizException {
        this.initBaseData();
        this.initPropMap();
        this.initBgScheme();
        this.initTreeInfo();
        this.createTempTable();
    }

    private void initPropMap() throws BOSException, EASBizException {
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Context)this.getCtx(), (String)"Select propSrc.FID, dimProp.FNumber FROM T_MBG_DIMPROPSRC propSrc Inner Join T_MBG_DIMPROP dimProp ON propSrc.FDIMPROPID = dimProp.FID");
            while (rst.next()) {
                this.propMap.put(rst.getString("FID"), rst.getString("FNumber"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    private void initBaseData() throws BOSException, EASBizException {
        this.readBaseData((IDataBase)BgScenarioFactory.getLocalInstance((Context)this.getCtx()), DimensionConstants.DEF_SCENARIO_NUMBER);
        this.readBaseData((IDataBase)BgElementFactory.getLocalInstance((Context)this.getCtx()), DimensionConstants.DEF_ELEMENT_NUMBER);
        this.readBaseData((IDataBase)CurrencyFactory.getLocalInstance((Context)this.getCtx()), DimensionConstants.DEF_CURRENCY_NUMBER);
        this.readBaseData((IDataBase)BgVersionFactory.getLocalInstance((Context)this.getCtx()), DimensionConstants.DEF_VERSION_NUMBER);
        this.readBaseData((IDataBase)BgPeriodTypeFactory.getLocalInstance((Context)this.getCtx()), DimensionConstants.DEF_PERIOD_NUMBER);
    }

    private void readBaseData(IDataBase instance, String dimNumber) throws BOSException, EASBizException {
        DataBaseCollection col = null;
        col = DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber) ? instance.getDataBaseCollection("where isLeaf = 1 order by number") : (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimNumber) ? instance.getDataBaseCollection("where id <> '11111111-1111-1111-1111-111111111111DEB58FDC' and id <> '22222222-2222-2222-2222-222222222222DEB58FDC' order by number") : instance.getDataBaseCollection("order by number"));
        LinkedHashMap<String, DataBaseInfo> subMap = new LinkedHashMap<String, DataBaseInfo>();
        this.baseDataMap.put(dimNumber, subMap);
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                subMap.put(col.get(i).getNumber(), col.get(i));
            }
        }
    }

    public void releaseTempTable() {
        if (this.memberTempTable != null) {
            this.pool.releaseTable(this.memberTempTable);
        }
        if (this.memberMapTempTable != null) {
            this.pool.releaseTable(this.memberMapTempTable);
        }
        if (this.itemMapTempTable != null) {
            this.pool.releaseTable(this.itemMapTempTable);
        }
    }

    private void createTempTable() throws BOSException {
        try {
            this.memberTempTable = MbgUpdate820ExecuteHelper.createMembersTable(this.pool);
            this.ctrlSettiingTempTable = MbgUpdate820ExecuteHelper.createCtrlSettingTable(this.getCtx(), this.pool);
            this.memberMapTempTable = MbgUpdate820ExecuteHelper.createMemberMapTable(this.pool);
            this.itemMapTempTable = MbgUpdate820ExecuteHelper.createItemMapTable(this.pool);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initTreeInfo() throws BOSException, EASBizException {
        if (treeMap == null) {
            treeMap = new HashMap<String, Boolean>();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            pstmt = conn.prepareStatement("Select FSrcId FROM T_MBG_DimSrc Where FSrcTyp = 0");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                if (treeMap.containsKey(rst.getString("FSrcId"))) continue;
                treeMap.put(rst.getString("FSrcId"), null);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            EntityObjectInfo treeBase = new EntityObjectInfo();
            treeBase.setPackage("com.kingdee.eas.framework.app");
            treeBase.setName("TreeBase");
            EntityObjectInfo entity = null;
            for (Map.Entry<String, Boolean> entry : treeMap.entrySet()) {
                if (entry.getValue() != null) continue;
                entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(BOSObjectType.create((String)entry.getKey()));
                entry.setValue(entity.isSubFrom((BusinessObjectInfo)treeBase));
            }
            treeMap.put(new BgItemInfo().getBOSType().toString(), Boolean.TRUE);
            treeMap.put(new GeneralAsstActTypeInfo().getBOSType().toString(), Boolean.TRUE);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void initBgScheme() throws BOSException, EASBizException {
        HashMap<String, CostCenterOrgUnitInfo> orgUnitMap = new HashMap<String, CostCenterOrgUnitInfo>();
        HashSet<String> queryNumbers = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("*");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("orgUnit.number");
        evi.getSelector().add("orgUnit.name");
        evi.getSelector().add("bgSchemeType.*");
        BgSchemeCollection col = BgSchemeFactory.getLocalInstance(this.getCtx()).getBgSchemeCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            this.bgSchemeMap.put(col.get(i).getId().toString(), col.get(i));
            queryNumbers.add(col.get(i).getOrgUnit().getNumber());
        }
        this.queryCostCenter(this.ctx, queryNumbers, orgUnitMap);
        queryNumbers.clear();
        for (Object orgUnit : orgUnitMap.values()) {
            queryNumbers.addAll(Arrays.asList(orgUnit.getLongNumber().split("!")));
        }
        queryNumbers.removeAll(orgUnitMap.keySet());
        this.queryCostCenter(this.ctx, queryNumbers, orgUnitMap);
        String bgSchemeId = null;
        for (BgSchemeInfo bgScheme : this.bgSchemeMap.values()) {
            bgSchemeId = bgScheme.getId().toString();
            if (!this.bgSchemeSuperOrgMap.containsKey(bgSchemeId)) {
                this.bgSchemeSuperOrgMap.put(bgSchemeId, new HashSet());
            }
            String[] lns = ((CostCenterOrgUnitInfo)orgUnitMap.get(bgScheme.getOrgUnit().getNumber())).getLongNumber().split("!");
            for (int i = 0; i < lns.length - 1; ++i) {
                if (orgUnitMap.get(lns[i]) == null) {
                    throw new NullPointerException("orgUnitMap.get(lns[i]) == null:" + lns[i] + " OrgUnitMap.keySet:" + Arrays.toString(orgUnitMap.keySet().toArray()));
                }
                if (((CostCenterOrgUnitInfo)orgUnitMap.get(lns[i])).getId() == null) {
                    throw new NullPointerException("orgUnitMap.get(lns[i]).getId() == null:" + lns[i] + " OrgUnitMap.keySet:" + Arrays.toString(orgUnitMap.keySet().toArray()));
                }
                this.bgSchemeSuperOrgMap.get(bgSchemeId).add(((CostCenterOrgUnitInfo)orgUnitMap.get(lns[i])).getId().toString());
            }
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Context)this.getCtx(), (String)"Select FBgSchemeId, FBgDimNumber FROM T_MBG_BGSCHEMEREFDIM");
            while (rst.next()) {
                bgSchemeId = rst.getString("FBgSchemeId");
                String[] refFields = rst.getString("FBgDimNumber").split(";");
                if (refFields.length <= 1) continue;
                if (!this.bgSchemeRefFieldMap.containsKey(bgSchemeId)) {
                    this.bgSchemeRefFieldMap.put(bgSchemeId, new HashSet());
                }
                for (int i = 1; i < refFields.length; ++i) {
                    this.bgSchemeRefFieldMap.get(bgSchemeId).add(refFields[i]);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    private void queryCostCenter(Context ctx, Set<String> orgNumber, Map<String, CostCenterOrgUnitInfo> orgUnitMap) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", orgNumber, CompareType.INCLUDE));
        CostCenterOrgUnitCollection col = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                orgUnitMap.put(col.get(i).getNumber(), col.get(i));
            }
        }
    }
}

