/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.DimSrcTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionPropSrcInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.MbgUpdateFacadeFactory;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.eas.ma.mbg.update820to850.app.face.IMbgUpdate820;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgAfterUpdate;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgBeforeUpdate;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgRepairData;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.eas.ma.mbg.update820to850.common.MbgUpdate820MemberInfo;
import com.kingdee.eas.ma.mbg.update820to850.common.MbgUpdate820UtilConfig;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MbgUpdate820ExecuteHelper {
    private static Logger logger = Logger.getLogger((String)MbgUpdate820ExecuteHelper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List _executeUpdate(Context ctx, MbgUpdate820CacheHelper helper) throws BOSException, EASBizException {
        MbgUpdate820ExecuteHelper.beforeExecute(ctx, helper);
        try {
            ctx.put((Object)"MBG_IS_UPDATING", (Object)Boolean.TRUE);
            ArrayList<MbgUpdateResultInfo> result = new ArrayList<MbgUpdateResultInfo>();
            IMbgUpdate820 update = null;
            List<String> updateConfig = MbgUpdate820UtilConfig.getUpdateConfig();
            for (int i = 0; i < updateConfig.size(); ++i) {
                logger.error((Object)("Start " + updateConfig.get(i)));
                MbgUpdateFacadeFactory.getLocalInstance(ctx).processChange(update == null ? null : update.getName(), updateConfig.get(i));
                update = MbgUpdate820ExecuteHelper.loadIntance(updateConfig.get(i), helper);
                result.add(update.update());
                logger.error((Object)("End " + updateConfig.get(i)));
            }
            if (update != null) {
                MbgUpdateFacadeFactory.getLocalInstance(ctx).processChange(update.getName(), null);
            }
            ArrayList<MbgUpdateResultInfo> arrayList = result;
            return arrayList;
        }
        finally {
            ctx.remove((Object)"MBG_IS_UPDATING");
            helper.releaseTempTable();
        }
    }

    private static IMbgUpdate820 loadIntance(String className, MbgUpdate820CacheHelper helper) throws BOSException, EASBizException {
        IMbgUpdate820 update = null;
        try {
            Class<?> cls = Class.forName("com.kingdee.eas.ma.mbg.update820to850.app.impl." + className);
            update = (IMbgUpdate820)cls.newInstance();
            update.setCacheHelper(helper);
            update.setName(className);
        }
        catch (InstantiationException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return update;
    }

    public static void beforeExecute(Context ctx, MbgUpdate820CacheHelper helper) throws EASBizException, BOSException {
        MbgBeforeUpdate u1 = (MbgBeforeUpdate)MbgUpdate820ExecuteHelper.loadIntance("MbgBeforeUpdate", helper);
        if (u1 != null) {
            u1.update();
        }
    }

    public static void afterUpdate(Context ctx, MbgUpdate820CacheHelper helper) throws EASBizException, BOSException {
        MbgAfterUpdate u1 = (MbgAfterUpdate)MbgUpdate820ExecuteHelper.loadIntance("MbgAfterUpdate", helper);
        if (u1 != null) {
            u1.update();
        }
    }

    public static void repairData(Context ctx, String bgTemplateId, boolean isRepairData, String sourceTypeNumber, String targetTypeNumber) throws EASBizException, BOSException {
        MbgRepairData.repairData(ctx, bgTemplateId, isRepairData, sourceTypeNumber, targetTypeNumber);
    }

    public static String createMembersTable(TempTablePool pool) throws Exception {
        String tempTable = pool.createTempTable("Create Table T_MBG_UpdateMember(FNumber NVarchar(80) NOT NULL, FNewNumber NVarchar(80), FName_L1 NVarchar(255), FName_L2 NVarchar(255), FName_L3 NVarchar(255), FLongNumber NVarchar(1024), FParentID Varchar(44), FParentNumber NVarchar(80), FLevel INT DEFAULT 0 NOT NULL, FIsLeaf INT DEFAULT 1 NOT NULL, FDimNumber NVarchar(80) NOT NULL, FSourceId Varchar(44) NOT NULL, FSourceOrder INT NOT NULL, FBgIndexSortID Varchar(44), CONSTRAINT PK_MBG_UM" + new SecureRandom().nextInt(99999999) + " Primary Key(FNumber, FDimNumber, FSourceOrder, FSourceId))");
        pool.createIndex(tempTable, "FNumber", false, false);
        return tempTable;
    }

    public static String createCtrlSettingTable(Context ctx, TempTablePool pool) throws Exception {
        String tableName = "T_MBG_UpdateCtrlSetting";
        if (BgDBUtils.existTable((Context)ctx, (String)tableName) == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Context)ctx, (String)("Select Top 1 * Into " + tableName + " FROM T_MBG_BGCONTROLSETTING"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Alter Table " + tableName + " Add FNewRootId Varchar(44)"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Alter Table " + tableName + " Add FNewId Varchar(44)"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Alter Table " + tableName + " Add FNewBgIndexNumber NVARCHAR(80)"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Alter Table " + tableName + " Add FNewBgIndexName NVARCHAR(80)"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Alter Table " + tableName + " Add FNewBgDimNumber NVARCHAR(200)"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Alter Table " + tableName + " Add FNewBgDimName NVARCHAR(200)"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Alter Table " + tableName + " Add FLevel INT"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Alter Table " + tableName + " Add FMinLevel INT"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Alter Table " + tableName + " Add CONSTRAINT PK_MBG_UPCtrlSet PRIMARY KEY(FID)"));
            BgDBUtils.executeUpdate((Context)ctx, (String)("Create Index IX_MBG_UPCtrlRL On " + tableName + "(FRootId, FLevel)"));
        }
        return tableName;
    }

    public static String createMemberMapTable(TempTablePool pool) throws Exception {
        String tempTable = pool.createTempTable("Create Table T_MBG_MemberMap(FRefField Varchar(4) NOT NULL, FOldNumber NVARCHAR(84) NOT NULL , FNewNumber NVARCHAR(84) NOT NULL, CONSTRAINT PK_MBG_MM" + new SecureRandom().nextInt(99999999) + " Primary Key(FRefField, FOldNumber))");
        return tempTable;
    }

    public static String createItemMapTable(TempTablePool pool) throws Exception {
        String tempTable = pool.createTempTable("Create Table T_MBG_ItemMap(FBizProp NVarchar(512) NOT NULL, FMbgItemValue NVARCHAR(256) NOT NULL , FNewItemValue NVARCHAR(256), CONSTRAINT PK_MBG_IM" + new SecureRandom().nextInt(99999999) + " Primary Key(FBizProp, FMbgItemValue))");
        return tempTable;
    }

    public static String readMembers(Connection conn, String tempTable, IObjectCollection sources, boolean isNeedLongNumber) throws Exception {
        MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempTable));
        DimensionSourceInfo source = null;
        boolean isTreeBase = false;
        String numberField = null;
        String nameField_l1 = null;
        String nameField_l2 = null;
        String nameField_l3 = null;
        String where = null;
        String treeField = null;
        String treeValue = null;
        for (int i = 0; i < sources.size(); ++i) {
            source = (DimensionSourceInfo)sources.getObject(i);
            numberField = MbgUpdate820ExecuteHelper.getNumberField(source);
            if (numberField.equalsIgnoreCase("FLongNumber")) {
                numberField = "REPLACE(" + numberField + ", '!', '.')";
            }
            nameField_l1 = MbgUpdate820ExecuteHelper.getNameField(source, LocaleUtils.locale_l1);
            nameField_l2 = MbgUpdate820ExecuteHelper.getNameField(source, LocaleUtils.locale_l2);
            nameField_l3 = MbgUpdate820ExecuteHelper.getNameField(source, LocaleUtils.locale_l3);
            if (isNeedLongNumber) {
                isTreeBase = !Boolean.FALSE.equals(MbgUpdate820CacheHelper.getTreeMap().get(source.getSrcID()));
            }
            where = MbgUpdate820ExecuteHelper.getWhere(source);
            if (isNeedLongNumber) {
                treeField = "FLongNumber, FLevel, FIsLeaf, FParentID, ";
                if (isTreeBase) {
                    treeValue = "T_CSL_RptItem".equalsIgnoreCase(source.getSrcTable()) ? "MIN(FLongNumber), MAX(FLevel), MIN(FIsLeaf), MAX(FParent), " : "MIN(FLongNumber), MAX(FLevel), MIN(FIsLeaf), MAX(FParentID), ";
                    where = !StringUtils.isEmpty((String)where) ? where + " AND " : " Where ";
                    where = where + " FLevel IS NOT NULL ";
                } else {
                    treeValue = numberField + ", 1, 1, null, ";
                }
            } else {
                treeField = "";
                treeValue = "";
            }
            MbgSqlHelper.execute((Connection)conn, (String)("Insert Into " + tempTable + "(FNumber, FName_L1, FName_L2, FName_L3, " + treeField + "FDimNumber, FSourceId, FSourceOrder) Select " + numberField + ", Max(" + nameField_l1 + "), Max(" + nameField_l2 + "), Max(" + nameField_l3 + "), " + treeValue + "'" + MbgUpdate820CacheHelper.convertMbgDimNumber(source.getDimension().getNumber()) + "', '" + source.getId().toString() + "', " + source.getOrder() + " FROM " + source.getSrcTable() + " t0 " + where + " Group By " + numberField));
            if (isNeedLongNumber && isTreeBase) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempTable + " t0 Set FParentNumber = (Select FNumber FROM " + source.getSrcTable() + " t1 Where t1.FID = t0.FParentId) Where FSourceId = ?"), (Object)new Object[]{source.getId().toString()});
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempTable + " t0 Set FParentNumber = (Select MAX(FNumber) FROM " + tempTable + " t1 Where t1.FLongNumber = LEFT(t0.FLongNumber, (LEN(t0.FLongNumber) - LEN(t0.FNumber) - 1)) AND t0.FSourceId = t1.FSourceId) Where FLevel > 1 AND FParentNumber IS NULL AND FSourceId = ?"), (Object)new Object[]{source.getId().toString()});
            }
            if (!MbgUpdateHelper.DEF_INDEX_NUMBER.equals(source.getDimension().getNumber())) continue;
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempTable + " t0 Set FBgIndexSortID = (Select FBgIndexSortID FROM T_MBG_DimExpression t1 Where t0.FNumber = t1.FNumber AND t1.FDimSrcId = ?) Where FSourceId = ?"), (Object)new Object[]{source.getId().toString(), source.getId().toString()});
        }
        return tempTable;
    }

    public static void convertNumberName(Connection conn, String tempTable, List members, boolean isNeedLongNumber) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set FNewNumber = FNumber");
        MbgSqlHelper.execute((Connection)conn, (String)sql.toString());
        sql.setLength(0);
        sql.append("Update " + tempTable + " Set FNewNumber = ?, FName_L1 = ?, FName_L2 = ?, FName_L3 = ? Where FNumber = ? AND FSourceId = ?");
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        ArrayList<String[]> paramList1 = new ArrayList<String[]>();
        MbgUpdate820MemberInfo member = null;
        for (int i = 0; i < members.size(); ++i) {
            member = (MbgUpdate820MemberInfo)members.get(i);
            paramList.add(new String[]{member.getNewNumber(), member.getNewName_l1(), member.getNewName_l2(), member.getNewName_l3(), member.getNumber(), member.getSource().getId().toString()});
            paramList1.add(new String[]{member.getNewNumber(), member.getNumber(), member.getSource().getId().toString()});
        }
        MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), paramList);
        if (isNeedLongNumber) {
            List levels;
            sql.setLength(0);
            sql.append("Update " + tempTable + " Set FParentNumber = ? Where FParentNumber = ? AND FSourceId = ?");
            MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), paramList1);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempTable + " Set FParentNumber = '" + "000000000000000000000000000=" + "' Where FParentNumber IS NULL"));
            if (members != null && !members.isEmpty() && (levels = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("Select MAX(FLevel) FROM " + tempTable), null)) != null && !levels.isEmpty()) {
                int maxLevel = ((Number)levels.get(0)).intValue();
                for (int i = 1; i <= maxLevel; ++i) {
                    if (i == 1) {
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempTable + " t0 Set FLongNumber = FNewNumber Where FLevel = ?"), (Object)new Object[]{i});
                        continue;
                    }
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempTable + " t0 Set FLongNumber = (Select FLongNumber || '!' || t0.FNewNumber FROM " + tempTable + " t1 Where t1.FNewNumber = t0.FParentNumber AND t0.FSourceId = t1.FSourceId) Where FLevel = ?"), (Object)new Object[]{i});
                }
            }
        }
    }

    private static String getWhere(DimensionSourceInfo source) {
        if (source.getSrcTable().equalsIgnoreCase("T_BD_AccountView")) {
            return "Where exists (Select FACCOUNTTABLEID FROM T_ORG_COMPANY t1 Where t0.FAccountTableID = t1.FACCOUNTTABLEID)";
        }
        if (DimSrcTypeEnum.BaseData.equals((Object)source.getSrcType())) {
            return "";
        }
        if (DimSrcTypeEnum.ItemGroup.equals((Object)source.getSrcType())) {
            return "Where FBgItemGroupId = '" + source.getSrcID() + "'";
        }
        if (DimSrcTypeEnum.GeneralItem.equals((Object)source.getSrcType())) {
            return "Where FGroupId = '" + source.getSrcID() + "'";
        }
        return "";
    }

    private static String getNameField(DimensionSourceInfo source, Locale locale) {
        DimensionPropSrcInfo prop = MbgUpdate820ExecuteHelper.getPropSrc(source, "name");
        if (prop.isDimSrcPropIsMultiLang()) {
            return prop.getDimSrcFieldName() + "_" + locale;
        }
        return prop.getDimSrcFieldName();
    }

    private static String getNumberField(DimensionSourceInfo source) {
        DimensionPropSrcInfo prop = MbgUpdate820ExecuteHelper.getPropSrc(source, "number");
        if (prop == null) {
            prop = MbgUpdate820ExecuteHelper.getPropSrc(source, "longNumber");
        }
        return prop.getDimSrcFieldName();
    }

    private static DimensionPropSrcInfo getPropSrc(DimensionSourceInfo source, String propKey) {
        for (int i = 0; i < source.getProperties().size(); ++i) {
            if (!propKey.equals(source.getProperties().get(i).getDimSrcPropName())) continue;
            return source.getProperties().get(i);
        }
        return null;
    }
}

