/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.utils;

import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public abstract class AbstractMbgUpdateProcessor {
    private static Logger logger = Logger.getLogger((String)AbstractMbgUpdateProcessor.class.getName());
    private Connection conn = null;
    private MbgUpdate820CacheHelper cacheHelper = null;

    public AbstractMbgUpdateProcessor(Connection conn, MbgUpdate820CacheHelper chacheHelper) {
        this.cacheHelper = chacheHelper;
        this.conn = conn;
    }

    protected Connection getConn() {
        return this.conn;
    }

    public MbgUpdate820CacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    public void startProcess() throws Exception {
        PreparedStatement pstmtQuery = null;
        PreparedStatement pstmtUpdate = null;
        ResultSet rst = null;
        try {
            pstmtQuery = this.buildQueryPstmt(this.getConn());
            pstmtUpdate = this.buildUpdatePstmt(this.getConn());
            rst = pstmtQuery.executeQuery();
            int batchCount = 0;
            while (rst.next()) {
                if (!this.process(rst, pstmtUpdate)) continue;
                pstmtUpdate.addBatch();
                if (++batchCount != 50) continue;
                pstmtUpdate.executeBatch();
                batchCount = 0;
            }
            if (batchCount > 0) {
                pstmtUpdate.executeBatch();
                batchCount = 0;
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmtQuery);
                SQLUtils.cleanup(pstmtUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtQuery);
        SQLUtils.cleanup((Statement)pstmtUpdate);
    }

    protected abstract PreparedStatement buildQueryPstmt(Connection var1) throws SQLException;

    protected abstract PreparedStatement buildUpdatePstmt(Connection var1) throws SQLException;

    protected abstract boolean process(ResultSet var1, PreparedStatement var2) throws Exception;
}

