/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.utils;

import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizStateEnum;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FormulaExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.NameExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgDimensionUpdateUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MbgCalcTransUtils {
    private static final Logger logger = Logger.getLogger(MbgCalcTransUtils.class);
    public static final int type = 0;
    public static final int expression = 1;
    public static final int indexNum = 2;
    public static final int dimNum = 3;
    public static final int periodNum = 4;
    public static final int elementNum = 5;
    public static final int currencyNum = 6;
    public static final int scenarioNum = 7;
    public static final int versionNum = 8;
    private static final String VARIABLE_KEY = "\\.N(\\+|\\-|)\\d*!(HY|MW|TD|Y|HY|M|Q|D|W)";
    private static final char[] calcMems = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static String tans850(BizCalcInfo calcInfo, String formula, Map<Integer, String[]> ruleMap, MbgDimensionUpdateUtils utils, Set<String> clearPeriodSet) throws Exception {
        if (calcInfo == null || StringUtils.isEmpty((String)formula) || ruleMap == null || ruleMap.isEmpty() || utils == null || clearPeriodSet == null) {
            return null;
        }
        String expKey = null;
        String[] rule = null;
        HashMap<String, IExpress> rules = new HashMap<String, IExpress>();
        int in = ruleMap.size();
        for (int i = 1; i <= in; ++i) {
            rule = ruleMap.get(i);
            expKey = MbgCalcTransUtils.getMemberChar(i - 1);
            formula = MbgCalcTransUtils.replace(formula, rule[1], expKey);
            rules.put(expKey, MbgCalcTransUtils.transRule(rule, utils));
        }
        MbgCalcTransUtils.checkPeriodVariable(calcInfo, rules, clearPeriodSet);
        IExpress expr = MbgExprParseHelper.parse((String)formula, null, (boolean)false);
        if (expr != null) {
            MbgCalcTransUtils.transExpress(expr, rules);
            formula = expr.toString() + ";";
        }
        return formula;
    }

    private static void transExpress(IExpress expr, Map<String, IExpress> rules) {
        if (expr == null || rules == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            MbgCalcTransUtils.transExpress((BinaryExpr)expr, rules);
        }
    }

    private static void transExpress(BinaryExpr expr, Map<String, IExpress> rules) {
        if (expr == null || rules == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            MbgCalcTransUtils.transExpress((BinaryExpr)expr.left, rules);
        } else if (expr.left instanceof NameExpr) {
            expr.left = MbgCalcTransUtils.transExpress((NameExpr)expr.left, rules);
        }
        if (expr.right instanceof BinaryExpr) {
            MbgCalcTransUtils.transExpress((BinaryExpr)expr.right, rules);
        } else if (expr.right instanceof NameExpr) {
            expr.right = MbgCalcTransUtils.transExpress((NameExpr)expr.right, rules);
        }
    }

    private static IExpress transExpress(NameExpr expr, Map<String, IExpress> rules) {
        if (expr == null || rules == null) {
            return expr;
        }
        return rules.get(expr.name);
    }

    private static IExpress transRule(String[] rule, MbgDimensionUpdateUtils utils) {
        FormulaExpr expr = null;
        if (rule == null || utils == null) {
            return expr;
        }
        int ruletype = Integer.valueOf(rule[0]);
        if (BizConstants.CONSTANT_VALUE != ruletype) {
            if (BizConstants.EXPRESSION_VALUE == ruletype) {
                expr = new FormulaExpr();
                Expression _express = null;
                try {
                    if (rule[1] != null && rule[1].charAt(0) != '=') {
                        rule[1] = "=" + rule[1];
                    }
                    if ((_express = ExcelFormulaPaserHelper.parse((String)rule[1])) instanceof com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr) {
                        com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr funExpr = (com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr)_express;
                        expr.formulaName = funExpr.funcionName;
                        expr.params = funExpr.parameters;
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"trans Expression Error(820to850):", (Throwable)ex);
                }
            } else {
                String[] tmpStrs;
                expr = new MdxMemberExpr();
                MemberExpr param = null;
                if (!StringUtils.isEmpty((String)rule[2]) && (param = (MemberExpr)MbgCalcTransUtils.transMember(rule[2], utils)) != null) {
                    ((MdxMemberExpr)expr).params.add(param);
                }
                if (!StringUtils.isEmpty((String)rule[3]) && (tmpStrs = rule[3].split(",")) != null) {
                    int in = tmpStrs.length;
                    for (int i = 0; i < in; ++i) {
                        param = (MemberExpr)MbgCalcTransUtils.transMember(tmpStrs[i], utils);
                        if (param == null) continue;
                        ((MdxMemberExpr)expr).params.add(param);
                    }
                }
                if (!StringUtils.isEmpty((String)rule[4])) {
                    param = new MemberExpr();
                    param.srcNumber = DimensionBaseConstants.DEF_PERIOD_SRCNUMBER;
                    param.number = rule[4];
                    ((MdxMemberExpr)expr).params.add(param);
                }
                if (!StringUtils.isEmpty((String)rule[5])) {
                    param = new MemberExpr();
                    param.srcNumber = DimensionBaseConstants.DEF_ELEMENT_SRCNUMBER;
                    param.number = rule[5];
                    ((MdxMemberExpr)expr).params.add(param);
                }
                if (!StringUtils.isEmpty((String)rule[6])) {
                    param = new MemberExpr();
                    param.srcNumber = DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER;
                    param.number = rule[6];
                    ((MdxMemberExpr)expr).params.add(param);
                }
                if (!StringUtils.isEmpty((String)rule[7])) {
                    param = new MemberExpr();
                    param.srcNumber = DimensionBaseConstants.DEF_SCENARIO_SRCNUMBER;
                    param.number = rule[7];
                    ((MdxMemberExpr)expr).params.add(param);
                }
                if (!StringUtils.isEmpty((String)rule[8])) {
                    param = new MemberExpr();
                    param.srcNumber = DimensionBaseConstants.DEF_VERSION_SRCNUMBER;
                    param.number = rule[8];
                    ((MdxMemberExpr)expr).params.add(param);
                }
            }
        }
        return expr;
    }

    private static IExpress transMember(String dimNumber, MbgDimensionUpdateUtils utils) {
        MemberExpr expr = null;
        if (StringUtils.isEmpty((String)dimNumber) || utils == null) {
            return expr;
        }
        String _dimNumber = utils.convertItem(dimNumber, false);
        String[] tmpStrs = _dimNumber.split(":");
        if (tmpStrs != null && tmpStrs.length == 2) {
            expr = new MemberExpr();
            expr.srcNumber = tmpStrs[0];
            expr.number = tmpStrs[1];
        }
        return expr;
    }

    public static void checkPeriodVariable(BizCalcInfo calcInfo, Map<String, IExpress> ruleMap, Set<String> clearPeriodSet) {
        if (calcInfo == null || ruleMap == null || ruleMap.isEmpty() || clearPeriodSet == null) {
            return;
        }
        String prefix = null;
        String tmpPreFix = null;
        String tmpVar = null;
        String periodKey = null;
        String periodNum = null;
        String tmpValue = null;
        int type = 0;
        int var = 0;
        HashMap<String, Integer> variable = new HashMap<String, Integer>();
        HashMap<String, Integer> tmpVarMap = new HashMap<String, Integer>();
        MdxMemberExpr mdxExpr = null;
        MemberExpr member = null;
        MemberExpr periodMember = null;
        Pattern pattern = null;
        Matcher matcher = null;
        IExpress expr = ruleMap.get("A");
        if (expr instanceof MdxMemberExpr) {
            mdxExpr = (MdxMemberExpr)expr;
            int in = mdxExpr.params.size();
            for (int i = 0; i < in; ++i) {
                expr = (IExpress)mdxExpr.params.get(i);
                if (!(expr instanceof MemberExpr)) continue;
                member = (MemberExpr)expr;
                if (!member.srcNumber.equals(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER)) continue;
                periodMember = member;
                type = BgNPeriodHelper.parserBgPeriodType((String)member.number);
                if (BgPeriodNVariableHelper.checkCanConvert((String)member.number)) {
                    prefix = member.number.substring(0, 4);
                    pattern = Pattern.compile(VARIABLE_KEY);
                    matcher = pattern.matcher(member.number);
                    while (matcher.find()) {
                        tmpVar = matcher.group();
                        periodKey = tmpVar.substring(tmpVar.indexOf("!") + 1);
                        tmpValue = tmpVar.substring(tmpVar.indexOf("N") + 1, tmpVar.indexOf("!"));
                        var = StringUtils.isEmpty((String)tmpValue) ? 0 : Integer.valueOf(tmpValue);
                        variable.put(periodKey, var);
                    }
                    continue;
                }
                periodNum = member.number;
            }
            if (!variable.isEmpty()) {
                calcInfo.setState(BizStateEnum.TEMPSAVED);
                mdxExpr.params.remove(periodMember);
                clearPeriodSet.add(calcInfo.getId().toString());
            }
        }
        Map.Entry<String, IExpress> entry2 = null;
        for (Map.Entry<String, IExpress> entry2 : ruleMap.entrySet()) {
            if (entry2.getKey().equals("A") || !((expr = entry2.getValue()) instanceof MdxMemberExpr)) continue;
            mdxExpr = (MdxMemberExpr)expr;
            tmpVarMap.clear();
            int in = mdxExpr.params.size();
            for (int i = 0; i < in; ++i) {
                expr = (IExpress)mdxExpr.params.get(i);
                if (!(expr instanceof MemberExpr)) continue;
                member = (MemberExpr)expr;
                if (!member.srcNumber.equals(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER) || !BgPeriodNVariableHelper.checkCanConvert((String)member.number)) continue;
                if (periodNum != null) {
                    try {
                        member.number = BgPeriodNVariableHelper.getBgPeriodByN((String)periodNum, (String)member.number, (int)type);
                    }
                    catch (BgPeriodException ex) {
                        logger.error((Object)"period variable trans error:", (Throwable)ex);
                    }
                    continue;
                }
                tmpPreFix = member.number.substring(0, 4);
                int tmpType = BgNPeriodHelper.parserBgPeriodType((String)member.number);
                if (tmpPreFix.equals(prefix) && type == tmpType) {
                    pattern = Pattern.compile(VARIABLE_KEY);
                    matcher = pattern.matcher(member.number);
                    while (matcher.find()) {
                        tmpVar = matcher.group();
                        periodKey = tmpVar.substring(tmpVar.indexOf("!") + 1);
                        tmpValue = tmpVar.substring(tmpVar.indexOf("N") + 1, tmpVar.indexOf("!"));
                        var = StringUtils.isEmpty((String)tmpValue) ? 0 : Integer.valueOf(tmpValue);
                        tmpVarMap.put(periodKey, var);
                    }
                }
                if ((expr = MbgCalcTransUtils.getFunctionExpr(variable, tmpVarMap)) != null) {
                    mdxExpr.params.set(i, expr);
                    continue;
                }
                mdxExpr.params.set(i, null);
            }
        }
    }

    private static IExpress getFunctionExpr(Map<String, Integer> leafMap, Map<String, Integer> rightMap) {
        if (leafMap == null || rightMap.isEmpty() || rightMap.isEmpty()) {
            return null;
        }
        FunctionExpr expr = new FunctionExpr();
        expr.functionName = "Lead";
        int year = 0;
        if (rightMap.containsKey("Y")) {
            year = rightMap.get("Y");
        }
        if (leafMap.containsKey("Y")) {
            int lyear = leafMap.get("Y");
            year -= lyear;
        }
        if (rightMap.containsKey("M")) {
            int month = rightMap.get("M");
            if (leafMap.containsKey("M")) {
                int lmonth = leafMap.get("M");
                month -= lmonth;
            }
            if (year != 0) {
                month += year * 12;
            }
            if (month != 0) {
                expr.params.add(String.valueOf(month));
                expr.params.add("");
            }
        } else if (rightMap.containsKey("Q")) {
            int querter = rightMap.get("Q");
            if (leafMap.containsKey("Q")) {
                int lquerter = leafMap.get("Q");
                querter -= lquerter;
            }
            if (year != 0) {
                querter += year * 4;
            }
            if (querter != 0) {
                expr.params.add(String.valueOf(querter));
                expr.params.add("");
            }
        } else if (rightMap.containsKey("HY")) {
            int halfyear = rightMap.get("HY");
            if (leafMap.containsKey("HY")) {
                int lhalfyear = leafMap.get("HY");
                halfyear -= lhalfyear;
            }
            if (year != 0) {
                halfyear += year * 2;
            }
            if (halfyear != 0) {
                expr.params.add(String.valueOf(halfyear));
                expr.params.add("");
            }
        } else if (rightMap.containsKey("Y") && year != 0) {
            expr.params.add(String.valueOf(year));
            expr.params.add("");
        }
        if (expr.params.isEmpty()) {
            return null;
        }
        return expr;
    }

    public static final String replace(String str, String oldChars, String newChars) {
        block0: {
            int len = newChars.length();
            int pos = str.indexOf(oldChars);
            if (pos <= -1) break block0;
            String firstPart = str.substring(0, pos);
            String lastPart = str.substring(pos + oldChars.length(), str.length());
            str = firstPart + newChars + lastPart;
        }
        return str;
    }

    public static String getMemberChar(int memberIndex) {
        String str = "" + calcMems[memberIndex % calcMems.length];
        while (memberIndex / calcMems.length > 0) {
            str = calcMems[memberIndex % calcMems.length] + str;
            memberIndex /= calcMems.length;
        }
        return str;
    }
}

