/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.utils;

import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.AbstractMbgUpdateProcessor;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgDimensionUpdateUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.WeakHashMap;

public class MbgDataUpdateProcessor
extends AbstractMbgUpdateProcessor {
    private String cubeName = null;
    private String bgSchemeId = null;
    public static int CONTROL_TYPE = 999;
    private List<Integer> accAndOtherFields = null;
    private String querySql = null;
    private String updateSql = null;
    private static WeakHashMap<String, String> formulaMap = new WeakHashMap();
    private MbgDimensionUpdateUtils expressProcessor = null;

    public MbgDataUpdateProcessor(Connection conn, MbgUpdate820CacheHelper cacheHelper, String bgSchemeId, int dataType) {
        super(conn, cacheHelper);
        this.bgSchemeId = bgSchemeId;
        this.cubeName = BgCubeUtils.getCubeName(cacheHelper.getBgSchemeMap().get(bgSchemeId).getRefCube(), dataType);
        this.accAndOtherFields = cacheHelper.getAccAndOtherFields(bgSchemeId);
        this.querySql = "Select FID, FFormula FROM " + this.cubeName;
        StringBuffer _us = new StringBuffer("Update ").append(this.cubeName).append(" Set FFormula = ?, FBgItemCombination = ?");
        String refField = null;
        for (int i = 0; i < this.accAndOtherFields.size(); ++i) {
            refField = "F" + this.accAndOtherFields.get(i);
            if (cacheHelper.getRefFieldMap().containsKey(refField)) {
                refField = cacheHelper.getRefFieldMap().get(refField);
            }
            _us.append(", ").append(refField).append(" = ?");
        }
        _us.append(" Where FID = ?");
        this.updateSql = _us.toString();
        this.expressProcessor = new MbgDimensionUpdateUtils(cacheHelper, bgSchemeId);
    }

    @Override
    public void startProcess() throws Exception {
        if (StringUtils.isEmpty((String)this.cubeName)) {
            return;
        }
        String refField = null;
        String srcNumber = null;
        String newRefField = null;
        String leafMember = null;
        MbgViewInfo mbgView = null;
        int sourceType = this.getCacheHelper().getBgSchemeMap().get(this.bgSchemeId).getBgSchemeType().getSchemeType().getValue();
        for (int i = 0; i < this.accAndOtherFields.size(); ++i) {
            newRefField = "F" + this.accAndOtherFields.get(i);
            refField = newRefField;
            if (!DimensionConstants.DEF_BGINDEX_FIELD.equals(refField)) {
                if (this.getCacheHelper().getRefFieldMap().containsKey(refField)) {
                    refField = this.getCacheHelper().getRefFieldMap().get(refField);
                }
                mbgView = this.getCacheHelper().getMbgView(refField, sourceType);
            }
            if (!DimensionConstants.DEF_BGINDEX_FIELD.equals(refField) && mbgView != null) {
                System.out.println("MbgDataUpdateProcessor 0 " + this.cubeName + " " + refField);
                leafMember = DimensionFormulaHelper.getCombination(mbgView.getMbgDim().getSrcNumber(), this.getCacheHelper().getMbgMemberLeafMap().get(mbgView.getMbgDim().getNumber()).getNumber());
                MbgSqlHelper.executeBatch((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set " + refField + " = ? Where " + refField + " IS NULL"), (Object)new Object[]{leafMember});
            }
            if (this.getCacheHelper().getConfig().getMemberMapFields().contains(refField)) {
                System.out.println("MbgDataUpdateProcessor 1 " + this.cubeName + " " + refField);
                MbgSqlHelper.executeBatch((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set " + refField + " = (Select FNewNumber FROM " + this.getCacheHelper().getMemberMapTempTable() + " t1 Where t1.FRefField = ? AND t1.FOldNumber = " + this.cubeName + "." + refField + ") Where exists(Select 1 FROM " + this.getCacheHelper().getMemberMapTempTable() + " t2 Where t2.FRefField = ? AND t2.FOldNumber = " + this.cubeName + "." + refField + ")"), (Object)new Object[]{refField, refField});
            }
            srcNumber = !DimensionConstants.DEF_BGINDEX_FIELD.equals(refField) && mbgView != null ? mbgView.getMbgDim().getSrcNumber() : DimensionConstants.DEF_INDEX_SRCNUMBER;
            System.out.println("MbgDataUpdateProcessor 2 " + this.cubeName + " " + refField);
            MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set " + refField + " = '" + srcNumber + "' || RIGHT(" + refField + ", LEN(" + refField + ") - 3)"));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Update ").append(this.cubeName).append(" Set FBgItemCombination = ");
        for (int i = 0; i < this.accAndOtherFields.size(); ++i) {
            refField = "F" + this.accAndOtherFields.get(i);
            if (!DimensionConstants.DEF_BGINDEX_FIELD.equals(refField) && this.getCacheHelper().getRefFieldMap().containsKey(refField)) {
                refField = this.getCacheHelper().getRefFieldMap().get(refField);
            }
            if (i > 0) {
                sql.append(" || ',' || ");
            }
            sql.append(refField);
        }
        System.out.println("MbgDataUpdateProcessor 3 " + this.cubeName);
        MbgSqlHelper.execute((Connection)this.getConn(), (String)sql.toString());
        MbgSqlHelper.execute((Connection)this.getConn(), (String)("Update " + this.cubeName + " Set FFormula = '=BgItem(\"' || FBgItemCombination || RIGHT(FFormula, LEN(FFormula) - CHARINDEX('\",\"', FFormula) + 1)"));
        System.out.println("MbgDataUpdateProcessor end " + this.cubeName + " " + refField);
    }

    @Override
    protected PreparedStatement buildQueryPstmt(Connection conn) throws SQLException {
        return conn.prepareStatement(this.querySql);
    }

    @Override
    protected PreparedStatement buildUpdatePstmt(Connection conn) throws SQLException {
        return conn.prepareStatement(this.updateSql);
    }

    @Override
    protected boolean process(ResultSet rst, PreparedStatement pstmtUpdate) throws Exception {
        String id = rst.getString("FID");
        String formula = rst.getString("FFormula");
        String[] params = (String[])BgNFSHelper.parseFormulaPara(formulaMap, formula).clone();
        String numberCombin = params[0];
        params[0] = numberCombin = this.expressProcessor.convertItem(numberCombin, true);
        String[] numbers = DimensionFormulaHelper.splitCombinations(numberCombin);
        pstmtUpdate.setString(1, BgNFSHelper.getFormulaFromParam(params));
        pstmtUpdate.setString(2, numberCombin);
        for (int i = 0; i < numbers.length; ++i) {
            pstmtUpdate.setString(3 + i, numbers[i]);
        }
        pstmtUpdate.setString(3 + numbers.length, id);
        return true;
    }

    public static void process(Connection conn, MbgUpdate820CacheHelper cacheHelper, int dataType) throws Exception {
        MbgDataUpdateProcessor processor = null;
        for (String bgSchemeId : cacheHelper.getBgSchemeMap().keySet()) {
            processor = new MbgDataUpdateProcessor(conn, cacheHelper, bgSchemeId, dataType);
            processor.startProcess();
        }
    }
}

