/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.utils;

import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.eas.ma.mbg.update820to850.common.MbgUpdate820MemberInfo;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MbgDimensionUpdateUtils {
    private MbgUpdate820CacheHelper cacheHelper = null;
    private int sourceType = -1;
    private Map<Integer, String> numberMap = new LinkedHashMap<Integer, String>();
    private Map<Integer, String> nameMap = new LinkedHashMap<Integer, String>();
    private List<Integer> accAndOtherFields = null;
    private String numberSplit = ",";
    private String nameSplit = DimensionConstants.TICK_SEPARATOR;
    private boolean isNeedSort = true;
    private String otherMemberRef = null;

    public MbgDimensionUpdateUtils(MbgUpdate820CacheHelper cacheHelper, String bgSchemeId) {
        this.cacheHelper = cacheHelper;
        BgSchemeInfo bgScheme = cacheHelper.getBgSchemeMap().get(bgSchemeId);
        this.sourceType = bgScheme.getBgSchemeType().getSchemeType().getValue();
        this.accAndOtherFields = cacheHelper.getAccAndOtherFields(bgSchemeId);
    }

    public void setNumberSplit(String numberSplit) {
        this.numberSplit = numberSplit;
    }

    public void setNameSplit(String nameSplit) {
        this.nameSplit = nameSplit;
    }

    public void setNeedSort(boolean isNeedSort) {
        this.isNeedSort = isNeedSort;
    }

    public String[] convert(String numberCombin, String nameCombin) {
        return this.convert(numberCombin, nameCombin, false);
    }

    public String[] convert(String numberCombin, String nameCombin, boolean isAddDefault) {
        if (StringUtils.isEmpty((String)numberCombin) || numberCombin.indexOf(":") < 0) {
            return null;
        }
        this.numberMap.clear();
        this.nameMap.clear();
        String[] numberCombins = numberCombin.split(this.numberSplit);
        String[] nameCombins = null;
        if (!StringUtils.isEmpty((String)nameCombin)) {
            nameCombins = nameCombin.split(this.nameSplit);
        }
        String srcNumber = null;
        String newSrcNumber = null;
        String number = null;
        String newNumber = null;
        String refField = null;
        String newRefField = null;
        Integer field = null;
        MbgViewInfo mbgView = null;
        MbgUpdate820MemberInfo member = null;
        for (int i = 0; i < numberCombins.length; ++i) {
            srcNumber = DimensionFormulaHelper.getSrcNumber(numberCombins[i]);
            newNumber = number = DimensionFormulaHelper.getMemberNumber(numberCombins[i]);
            if (this.cacheHelper.getConfig().getSrcSourceMap().get(srcNumber) == null) {
                newSrcNumber = srcNumber;
                if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(srcNumber)) {
                    newRefField = DimensionConstants.DEF_ORGUNIT_FIELD;
                } else if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumber)) {
                    newRefField = DimensionConstants.DEF_PERIOD_FIELD;
                } else if (DimensionConstants.DEF_ELEMENT_SRCNUMBER.equals(srcNumber)) {
                    newRefField = DimensionConstants.DEF_ELEMENT_FIELD;
                } else if (DimensionConstants.DEF_CURRENCY_SRCNUMBER.equals(srcNumber)) {
                    newRefField = DimensionConstants.DEF_CURRENCY_FIELD;
                } else if (DimensionConstants.DEF_SCENARIO_SRCNUMBER.equals(srcNumber)) {
                    newRefField = DimensionConstants.DEF_SCENARIO_FIELD;
                } else if (DimensionConstants.DEF_VERSION_SRCNUMBER.equals(srcNumber)) {
                    newRefField = DimensionConstants.DEF_VERSION_FIELD;
                } else {
                    newSrcNumber = DimensionConstants.DEF_INDEX_SRCNUMBER;
                    newRefField = DimensionConstants.DEF_BGINDEX_FIELD;
                }
                newNumber = number;
            } else {
                refField = this.cacheHelper.getConfig().getSrcSourceMap().get(srcNumber).getDimension().getRefField();
                mbgView = this.cacheHelper.getMbgView(refField, this.sourceType);
                if (mbgView != null) {
                    newSrcNumber = mbgView.getMbgDim().getSrcNumber();
                    newRefField = mbgView.getMbgDim().getRefField();
                } else {
                    newSrcNumber = DimensionConstants.DEF_BGINDEX_FIELD.equals(refField) ? DimensionConstants.DEF_INDEX_SRCNUMBER : srcNumber;
                    newRefField = refField;
                }
                member = this.cacheHelper.getConfig().getMemberMap().get(numberCombins[i]);
                if (member != null) {
                    newNumber = member.getNewNumber();
                }
            }
            field = DimensionCommonHelper.getField(newRefField);
            this.numberMap.put(field, DimensionFormulaHelper.getCombination(newSrcNumber, newNumber));
            if (nameCombins == null) continue;
            if (member != null) {
                this.nameMap.put(field, member.getNewName(this.cacheHelper.getCtx().getLocale()));
                continue;
            }
            this.nameMap.put(field, nameCombins[i]);
        }
        List<Integer> fields = new ArrayList<Integer>(this.numberMap.keySet());
        if (isAddDefault) {
            fields = this.accAndOtherFields;
        } else if (this.isNeedSort) {
            Collections.sort(fields);
        }
        StringBuffer newNumbers = new StringBuffer();
        StringBuffer newNames = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            field = fields.get(i);
            if (this.numberMap.containsKey(field)) {
                if (newNumbers.length() > 0) {
                    newNumbers.append(",");
                }
                newNumbers.append(this.numberMap.get(field));
                if (newNames.length() > 0) {
                    newNames.append(this.nameSplit);
                }
                newNames.append(this.nameMap.get(field));
                continue;
            }
            if (!isAddDefault) continue;
            refField = "F" + field;
            if (this.cacheHelper.getRefFieldMap().containsKey(refField)) {
                refField = this.cacheHelper.getRefFieldMap().get(refField);
            }
            mbgView = this.cacheHelper.getMbgView(refField, this.sourceType);
            if (newNumbers.length() > 0) {
                newNumbers.append(this.numberSplit);
            }
            newNumbers.append(DimensionFormulaHelper.getCombination(mbgView.getMbgDim().getSrcNumber(), this.cacheHelper.getMbgMemberLeafMap().get(mbgView.getMbgDim().getNumber()).getNumber()));
            if (newNames.length() > 0) {
                newNames.append(this.nameSplit);
            }
            newNames.append(this.cacheHelper.getMbgMemberLeafMap().get(mbgView.getMbgDim().getNumber()).getName());
        }
        if (!newNumbers.toString().equals(numberCombin) || nameCombin != null && !newNames.toString().equals(nameCombin)) {
            if (nameCombin == null) {
                return new String[]{newNumbers.toString(), null};
            }
            return new String[]{newNumbers.toString(), newNames.toString()};
        }
        return null;
    }

    public String convertItem(String numberCombin, boolean isAddDefaut) {
        String[] newValue = this.convert(numberCombin, null, isAddDefaut);
        if (newValue != null) {
            return newValue[0];
        }
        return numberCombin;
    }

    public String getOtherMemberRef() {
        if (this.otherMemberRef == null && this.accAndOtherFields.size() > 1) {
            for (int i = 1; i < this.accAndOtherFields.size(); ++i) {
                this.otherMemberRef = i == 1 ? "F" + this.accAndOtherFields.get(i) : this.otherMemberRef + "," + "F" + this.accAndOtherFields.get(i);
            }
        }
        return this.otherMemberRef;
    }
}

