/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.ParseException;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.mbg.ActualRecordSourceTypeEnum;
import com.kingdee.eas.ma.mbg.AggregateDataTypeEnum;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgDimensionUpdateUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class MbgExpressProcess {
    private static final Logger logger = Logger.getLogger(MbgExpressProcess.class);
    private MbgDimensionUpdateUtils updateUtils = null;

    public MbgExpressProcess(MbgUpdate820CacheHelper cacheHelper, String bgSchemeId) {
        this.updateUtils = cacheHelper.getUpdateUtil(bgSchemeId);
    }

    public String process(String formula) throws BOSException {
        if (StringUtils.isEmpty((String)formula)) {
            return formula;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)formula);
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return MbgExpressProcess.this.checkExpression(expr);
                }
            });
            _expressions = '=' + expression.toString();
            if (expression instanceof FunctionExpr) {
                FunctionExpr funExpr = (FunctionExpr)expression;
                if ("BgItem".equalsIgnoreCase(funExpr.funcionName) && (_expressions = BgNFSHelper.getFormulaFromParam(BgNFSHelper.parseFormulaPara(_expressions))) != null) {
                    _expressions = _expressions.replaceAll(",TRUE,", ",true,");
                }
            }
        }
        catch (ParseException e) {
            logger.error((Object)formula);
            logger.error((Object)e);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)formula);
            logger.error((Object)ex);
            return null;
        }
        if (_expressions != null && !_expressions.replaceAll(" ", "").equalsIgnoreCase(formula.replaceAll(" ", ""))) {
            return _expressions;
        }
        return null;
    }

    private Expression checkExpression(Expression expression) {
        if (expression instanceof FunctionExpr) {
            expression = this.checkFunctionExpr((FunctionExpr)expression);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = this.checkBinaryOperationExpr((BinaryOperationExpr)expression);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = this.checkUnaryOperationExpr((UnaryOperationExpr)expression);
        }
        return expression;
    }

    private BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr) {
        boExpr.left = this.checkExpression(boExpr.left);
        boExpr.right = this.checkExpression(boExpr.right);
        return boExpr;
    }

    private UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr) {
        return boExpr;
    }

    private Expression checkFunctionExpr(FunctionExpr funExpr) {
        String funName = funExpr.funcionName;
        if ("MbgAggregate".equalsIgnoreCase(funName)) {
            this.checkMbgAggregate(funExpr);
        } else if ("MbgBgAvlBal".equalsIgnoreCase(funName)) {
            this.checkMbgAvlBal(funExpr);
        } else if ("MbgActuals".equalsIgnoreCase(funName)) {
            this.checkMbgActuals(funExpr);
        } else if ("MbgFormula".equalsIgnoreCase(funName)) {
            this.checkMbgFormula(funExpr);
        } else if ("Mbgadjust".equalsIgnoreCase(funName)) {
            this.checkMbgAdjust(funExpr);
        } else if ("MbgRefBgTem".equalsIgnoreCase(funName)) {
            this.checkMbgRefTemp(funExpr);
        } else if ("BgItem".equalsIgnoreCase(funName)) {
            this.checkMbgItem(funExpr);
        }
        return funExpr;
    }

    private void checkMbgAvlBal(FunctionExpr funExpr) {
        if (funExpr.parameters.size() != 9) {
            return;
        }
        Object param = funExpr.parameters.get(3);
        if (param instanceof StringExpr) {
            ((StringExpr)param).value = this.convertItem(((StringExpr)param).value, false);
        }
        funExpr.parameters.add(3, new StringExpr("ActData"));
    }

    private void checkMbgRefTemp(FunctionExpr funExpr) {
    }

    private void checkMbgItem(FunctionExpr funExpr) {
        funExpr.funcionName = "BgItem";
        Object param = funExpr.parameters.get(0);
        if (param instanceof StringExpr) {
            ((StringExpr)param).value = this.convertItem(((StringExpr)param).value, true);
        }
    }

    private void checkMbgAdjust(FunctionExpr funExpr) {
        Object param;
        if (funExpr.parameters.size() == 11 && (param = funExpr.parameters.get(3)) instanceof StringExpr) {
            ((StringExpr)param).value = this.convertItem(((StringExpr)param).value, false);
        }
    }

    private void checkMbgFormula(FunctionExpr funExpr) {
        funExpr.funcionName = "MbgAggregate";
        funExpr.parameters.add(new StringExpr(AggregateDataTypeEnum.budget.getName()));
        this.checkMbgAggregate(funExpr);
    }

    private void checkMbgActuals(FunctionExpr funExpr) {
        funExpr.funcionName = "MbgAggregate";
        if (funExpr.parameters.size() == 7) {
            funExpr.parameters.add(new StringExpr(""));
            funExpr.parameters.add(2, new StringExpr("BgData"));
        }
        funExpr.parameters.add(6, new StringExpr(""));
        Object targetType = funExpr.parameters.get(9);
        if (targetType instanceof StringExpr) {
            StringExpr sourceDataType = (StringExpr)targetType;
            sourceDataType.value = StringUtils.isEmpty((String)sourceDataType.value) || ActualRecordSourceTypeEnum.all.getName().equals(sourceDataType.value) || "1".equalsIgnoreCase(sourceDataType.value) ? AggregateDataTypeEnum.actual.getName() : AggregateDataTypeEnum.addActual.getName();
        }
        this.checkMbgAggregate(funExpr);
    }

    private void checkMbgAggregate(FunctionExpr funExpr) {
        Object param;
        if (funExpr.parameters.size() == 10 && (param = funExpr.parameters.get(3)) instanceof StringExpr) {
            ((StringExpr)param).value = this.convertItem(((StringExpr)param).value, false);
        }
    }

    private String convertItem(String value, boolean isAddDef) {
        String[] newValues = this.updateUtils.convert(value, null, isAddDef);
        if (newValues != null) {
            return newValues[0];
        }
        return value;
    }
}

