/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update820to850.app.utils;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.mbg.DimensionDisplayModeEnum;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.common.BgAttributeColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgDimensionUpdateUtils;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgExpressProcess;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MbgViewManagerUpdateUtils {
    public static byte[] processViewManager(byte[] datas, MbgUpdate820CacheHelper cacheHelper, String bgSchemeId) throws Exception {
        MbgXMLParser parser2 = new MbgXMLParser(cacheHelper.getCtx());
        IMbgViewManager view = parser2.parse(datas);
        if (view == null) {
            return null;
        }
        MbgExpressProcess processor = new MbgExpressProcess(cacheHelper, bgSchemeId);
        MbgDimensionUpdateUtils updateUtils = cacheHelper.getUpdateUtil(bgSchemeId);
        updateUtils.setNeedSort(false);
        for (int i = 0; i < view.getRelationMaps().size(); ++i) {
            MbgViewManagerUpdateUtils.convertRelationMap(bgSchemeId, cacheHelper, view.getRelationMaps().get(i), updateUtils);
        }
        MbgViewInfo mbgView = null;
        MbgDimInfo mbgDim2 = null;
        Map<String, MbgDimInfo> dimMap = cacheHelper.getBgSchemeDimMap().get(bgSchemeId);
        int sourceType = cacheHelper.getBgSchemeMap().get(bgSchemeId).getBgSchemeType().getSchemeType().getValue();
        HashSet<String> dimNumbers = new HashSet<String>();
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            IBgDimensionManager dimManager = view.getSheetManagers().get(s).getDimensionManager();
            BgDimensionInfo dimension = dimManager.searchDimension("BG_Scen");
            if (dimension != null) {
                dimension = dimManager.searchDimension("BG_Scenario");
                if (dimension != null) {
                    dimension.setNumber(DimensionConstants.DEF_ELEMENT_NUMBER);
                    dimension.parse();
                }
                dimension = dimManager.searchDimension("BG_Scen");
                dimension.setNumber(DimensionConstants.DEF_SCENARIO_NUMBER);
                dimension.parse();
            }
            dimNumbers.clear();
            if (!dimManager.getCalcuteCol().isEmpty()) {
                for (int c = 0; c < dimManager.getCalcuteCol().size(); ++c) {
                    String expr = processor.process(dimManager.getCalcuteCol().get(c).getFormula());
                    if (expr == null) continue;
                    dimManager.getCalcuteCol().get(c).setFormula(expr);
                }
            }
            if (!dimManager.getAttributeCol().isEmpty()) {
                BgAttributeColumn attCol = null;
                for (int c = dimManager.getAttributeCol().size() - 1; c >= 0; --c) {
                    attCol = dimManager.getAttributeCol().get(c);
                    if (!cacheHelper.getPropMap().containsKey(attCol.getPropertyId())) {
                        dimManager.getAttributeCol().remove(c);
                        continue;
                    }
                    if ("P01".equals(cacheHelper.getPropMap().get(attCol.getPropertyId()))) {
                        attCol.setRefColumn(DimensionDisplayModeEnum.Number.getName());
                        continue;
                    }
                    if (!"P02".equals(cacheHelper.getPropMap().get(attCol.getPropertyId()))) continue;
                    attCol.setRefColumn(DimensionDisplayModeEnum.Name.getName());
                }
            }
            for (int d = 0; d < dimManager.getDimension().size(); ++d) {
                dimension = (BgDimensionInfo)dimManager.getDimension().get(d);
                if (MbgUpdateHelper.DEF_INDEX_NUMBER.equals(dimension.getNumber())) {
                    dimension.setNumber(DimensionConstants.DEF_ACCOUNT_NUMBER);
                    MbgViewManagerUpdateUtils.convertMember(dimension.getMember(), dimension, updateUtils);
                    MbgViewManagerUpdateUtils.convertMember(dimension.getCanAddMember(), dimension, updateUtils);
                    MbgViewManagerUpdateUtils.convertRelation(dimension.getMappingList(), bgSchemeId, cacheHelper);
                }
                if ((mbgView = cacheHelper.getMbgView(dimension.getAttribute(), sourceType)) != null) {
                    dimension.setAttribute(mbgView.getMbgDim().getRefField());
                    dimension.setNumber(mbgView.getMbgDim().getNumber());
                    dimension.setAlias(mbgView.getMbgDim().getName());
                    dimension.setName(mbgView.getMbgDim().getName());
                    dimension.setType(dimension.getNumber());
                    dimension.parse();
                    MbgViewManagerUpdateUtils.convertMember(dimension.getMember(), dimension, updateUtils);
                    MbgViewManagerUpdateUtils.convertMember(dimension.getCanAddMember(), dimension, updateUtils);
                    MbgViewManagerUpdateUtils.convertRelation(dimension.getMappingList(), bgSchemeId, cacheHelper);
                } else {
                    MbgViewManagerUpdateUtils.convertRelation(dimension.getMappingList(), bgSchemeId, cacheHelper);
                }
                dimNumbers.add(dimension.getNumber());
            }
            ArrayList<BgDimensionInfo> addDimensions = new ArrayList<BgDimensionInfo>();
            for (MbgDimInfo mbgDim2 : dimMap.values()) {
                if (dimNumbers.contains(mbgDim2.getNumber())) continue;
                dimension = MbgViewManagerUpdateUtils.buildDimension(dimManager, mbgDim2, new DataBaseInfo[]{(DataBaseInfo)cacheHelper.getMbgMemberSumMap().get(mbgDim2.getNumber()), (DataBaseInfo)cacheHelper.getMbgMemberLeafMap().get(mbgDim2.getNumber())});
                addDimensions.add(dimension);
                dimManager.addDimensionInfo(dimension);
            }
            if (dimManager.getDescriptionCol().isEmpty()) continue;
            for (int i = 0; i < dimManager.getDescriptionCol().size(); ++i) {
                dimManager.getDescriptionCol().get(i).getDimensions().addAll(addDimensions);
            }
        }
        view.setUpdated(true);
        new MbgXMLParser(cacheHelper.getCtx());
        return MbgXMLParser.unParse(view);
    }

    private static void convertRelationMap(String bgSchemeId, MbgUpdate820CacheHelper cacheHelper, MbgRelationMap mbgRelationMap, MbgDimensionUpdateUtils updateUtils) {
        MbgViewManagerUpdateUtils.convertRelationGroup(bgSchemeId, cacheHelper, mbgRelationMap.getGroup());
        for (int i = 0; i < mbgRelationMap.getRelationShips().size(); ++i) {
            MbgViewManagerUpdateUtils.convertRelationShip(bgSchemeId, cacheHelper, mbgRelationMap.getRelationShips().get(i), updateUtils);
        }
    }

    private static void convertRelationShip(String bgSchemeId, MbgUpdate820CacheHelper cacheHelper, DimensionRelationshipInfo relationShip, MbgDimensionUpdateUtils updateUtils) {
        String[] result = updateUtils.convert(relationShip.getDimensionNumber(), relationShip.getDimensionName());
        if (result != null) {
            relationShip.setDimensionNumber(result[0]);
            relationShip.setDimensionName(result[1]);
        }
    }

    private static void convertRelation(List<DimensionRelationshipGroupInfo> mappingList, String bgSchemeId, MbgUpdate820CacheHelper cacheHelper) {
        if (mappingList == null || mappingList.isEmpty()) {
            return;
        }
        DimensionRelationshipGroupInfo group = null;
        for (int i = 0; i < mappingList.size(); ++i) {
            group = mappingList.get(i);
            MbgViewManagerUpdateUtils.convertRelationGroup(bgSchemeId, cacheHelper, group);
        }
    }

    protected static void convertRelationGroup(String bgSchemeId, MbgUpdate820CacheHelper cacheHelper, DimensionRelationshipGroupInfo group) {
        String key = group.getId() + "_" + bgSchemeId;
        if (!cacheHelper.getRelationGroup().containsKey(key)) {
            return;
        }
        group.putAll((IObjectValue)cacheHelper.getRelationGroup().get(key));
    }

    private static void convertMember(List members, BgDimensionInfo dimension, MbgDimensionUpdateUtils processor) {
        if (members == null || members.isEmpty()) {
            return;
        }
        BgDimensionMember member = null;
        String newCombin = null;
        for (int i = 0; i < members.size(); ++i) {
            if (!(members.get(i) instanceof BgDimensionMember)) continue;
            member = (BgDimensionMember)members.get(i);
            newCombin = processor.convertItem(member.getCombNumber(), false);
            member.setAttribute(dimension.getAttribute());
            member.setType(dimension.getNumber());
            member.setSrcNumber(DimensionFormulaHelper.getSrcNumber(newCombin));
            member.setNumber(DimensionFormulaHelper.getMemberNumber(newCombin));
        }
    }

    protected static BgDimensionInfo buildDimension(IBgDimensionManager dimManager, MbgDimInfo dimeInfo, DataBaseInfo[] objectValue) throws DimensionException {
        BgDimensionInfo dim = new BgDimensionInfo(dimManager);
        dim.setLayout("page");
        dim.setNumber(dimeInfo.getNumber());
        dim.setAlias(dimeInfo.getName());
        dim.setNecessary(false);
        dim.setType(dimeInfo.getNumber());
        dim.setAttribute(dimeInfo.getRefField());
        if (objectValue != null) {
            dim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
            for (int i = 0; i < objectValue.length; ++i) {
                BgDimensionMember member = new BgDimensionMember(dimeInfo.getNumber(), dimeInfo.getRefField(), objectValue[i].getName(), objectValue[i].getNumber());
                member.setSrcNumber(dimeInfo.getSrcNumber());
                dim.getMember().add(member);
            }
        } else {
            dim.setMemberValueType(DimensionMemberValueModeEnum.Null);
        }
        dim.unParseMember();
        return dim;
    }
}

