/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgDimSettings;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgLongNameFormat;
import com.kingdee.eas.ma.mbg.utils.BgNameFormat;
import com.kingdee.eas.ma.mbg.utils.BgNumAndNameFormat;
import com.kingdee.eas.ma.mbg.utils.BgObjectValueRender;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCellRenderHelper {
    private static final Logger logger = Logger.getLogger(BgCellRenderHelper.class);
    public static final String NUMBERANDNAME = "0";
    public static final String NAME = "1";
    public static final String LONGNAME = "2";
    private String bgIndexNameStyle = "1";
    private String bgOrgUnitNameStyle = "1";
    private Map<String, Map<String, String>> accountMap = null;

    public void setBgOrgUnitNameStyle(String bgOrgUnitNameStyle) {
        this.bgOrgUnitNameStyle = bgOrgUnitNameStyle;
    }

    public String getBgOrgUnitNameStyle() {
        return this.bgOrgUnitNameStyle;
    }

    public String getBgIndexNameStyle() {
        return this.bgIndexNameStyle;
    }

    public void setBgIndexNameStyle(String bgIndexNameStyle) {
        if (!StringUtils.isEmpty((String)bgIndexNameStyle)) {
            this.bgIndexNameStyle = bgIndexNameStyle;
        }
    }

    public Map<String, Map<String, String>> getAccountMap() {
        return this.accountMap;
    }

    public void setAccountMap(Map<String, Map<String, String>> accountMap) {
        this.accountMap = accountMap;
    }

    public void init() {
        this.init(null);
    }

    public void init(Context ctx) {
        if (ctx == null) {
            this.initValue();
        } else {
            this.initValue(ctx);
        }
    }

    private void initValue(Context ctx) {
        this.setBgIndexNameStyle(BgParamNHelper.getMbgShowStyle((Context)ctx));
        this.setBgOrgUnitNameStyle(BgParamNHelper.getBgOrgShowStyle((Context)ctx));
    }

    private void initValue() {
        this.setBgIndexNameStyle(BgParamCHelper.getMbgShowStyle());
        this.setBgOrgUnitNameStyle(BgParamCHelper.getBgOrgShowStyle());
    }

    public static String getAccountViewIdByBgScheme(BgSchemeInfo schemeInfo) {
        return BgCellRenderHelper.getAccountViewIdByBgScheme(null, schemeInfo);
    }

    public static String getAccountViewIdByBgScheme(Context ctx, BgSchemeInfo schemeInfo) {
        if (schemeInfo == null || schemeInfo.getId() == null) {
            return null;
        }
        String accountViewId = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)schemeInfo.getId().toString()));
        evi.setSelector(BgCellRenderHelper.getSelectors());
        IBgDimSettings iBgDimSetting = null;
        try {
            iBgDimSetting = ctx == null ? BgDimSettingsFactory.getRemoteInstance() : BgDimSettingsFactory.getLocalInstance(ctx);
            CoreBaseCollection settings = iBgDimSetting.getCollection(evi);
            for (int s = 0; s < settings.size(); ++s) {
                BgDimSettingsInfo sett = (BgDimSettingsInfo)settings.get(s);
                if (!sett.getDimNumber().equalsIgnoreCase(DimensionConstants.DEF_ACCOUNT_NUMBER)) continue;
                for (int m = 0; m < sett.getMembers().size(); ++m) {
                    BgDimSettingsMemberInfo settM = sett.getMembers().get(m);
                    accountViewId = settM.getMemberID().toString();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return accountViewId;
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("members.*");
        sic.add("bgScheme.id");
        return sic;
    }

    public static ObjectValueRender getMemberComRender() {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat(new IDataFormat(){

            public String format(Object arg0) {
                String displayName = null;
                if (arg0 instanceof BgDimensionMember) {
                    BgDimensionMember dim = (BgDimensionMember)arg0;
                    String[] numberArr = dim.getNumber().split(",");
                    String[] nameArr = null;
                    nameArr = dim.getName().indexOf(DimensionConstants.TICK_SEPARATOR) > 0 ? dim.getName().split(DimensionConstants.TICK_SEPARATOR) : dim.getName().split(",");
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < numberArr.length; ++i) {
                        String name;
                        String number = numberArr[i];
                        String string = name = nameArr[i].split(":").length > 1 ? nameArr[i].split(":")[1] : nameArr[i].split(":")[0];
                        if (i != numberArr.length - 1) {
                            sb.append(number + "(" + name + "),");
                            continue;
                        }
                        sb.append(number + "(" + name + ")");
                    }
                    displayName = sb.toString();
                } else if (arg0 != null) {
                    displayName = arg0.toString();
                }
                return displayName;
            }
        });
        return avr;
    }

    public static ObjectValueRender getMemberComRender4Element() {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat(new IDataFormat(){

            public String format(Object arg0) {
                String displayName = null;
                if (arg0 instanceof BgDimensionMember) {
                    BgDimensionMember dim = (BgDimensionMember)arg0;
                    displayName = dim.getName();
                }
                return displayName;
            }
        });
        return avr;
    }

    public static ObjectValueRender getMemberComRender4Measure() {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat(new IDataFormat(){

            public String format(Object arg0) {
                String displayName = null;
                if (arg0 instanceof MeasureUnitInfo) {
                    MeasureUnitInfo dim = (MeasureUnitInfo)arg0;
                    displayName = dim.getName();
                }
                return displayName;
            }
        });
        return avr;
    }

    public String getIndexDisplayName(Context ctx, String bgAccountViewId, String indexNumber, List<String> indexName) {
        String displayName = "";
        if (indexName != null) {
            for (String tmpStr : indexName) {
                displayName = displayName + tmpStr + "_";
            }
            if (displayName.length() > 0) {
                displayName = displayName.substring(0, displayName.length() - 1);
            }
            displayName = this.getIndexDisplayName(ctx, bgAccountViewId, indexNumber, displayName);
        }
        return displayName;
    }

    public String getIndexDisplayName(String bgAccountViewId, String indexNumber, String indexName) {
        return this.getIndexDisplayName(null, bgAccountViewId, indexNumber, indexName);
    }

    public String getIndexDisplayName(Context ctx, String bgAccountViewId, String indexNumber, String indexName) {
        String displayName = null;
        if (StringUtils.isEmpty((String)indexNumber)) {
            return null;
        }
        String[] combins = DimensionFormulaHelper.splitCombinations(indexNumber);
        StringBuffer number = new StringBuffer();
        for (String combin : combins) {
            if (number.length() > 0) {
                number.append(",");
            }
            number.append(DimensionFormulaHelper.getMemberNumber(combin));
        }
        if (NUMBERANDNAME.equals(this.bgIndexNameStyle)) {
            displayName = number + "(" + indexName + ")";
        } else if (NAME.equals(this.bgIndexNameStyle)) {
            displayName = indexName;
        } else if (LONGNAME.equals(this.bgIndexNameStyle)) {
            Map<String, String> tmpMap;
            if (bgAccountViewId == null) {
                return number + "(" + indexName + ")";
            }
            if (this.getAccountMap() == null) {
                this.accountMap = new HashMap<String, Map<String, String>>();
            }
            if (!this.getAccountMap().containsKey(bgAccountViewId)) {
                this.getInitAccounts(ctx, bgAccountViewId);
            }
            if (this.getAccountMap().containsKey(bgAccountViewId) && (tmpMap = this.getAccountMap().get(bgAccountViewId)).containsKey(number.toString())) {
                displayName = tmpMap.get(number.toString());
            }
            if (displayName == null) {
                displayName = number + "(" + indexName + ")";
            }
        }
        return displayName;
    }

    public String getIndexDisplayName(String bgAccountViewId, BgDimensionMember member) {
        return this.getIndexDisplayName(null, bgAccountViewId, member);
    }

    private String getIndexDisplayName(Context ctx, String bgAccountViewId, BgDimensionMember member) {
        String displayName = null;
        String indexName = member.getName();
        String indexNumber = member.getNumber();
        if (NUMBERANDNAME.equals(this.bgIndexNameStyle)) {
            displayName = indexNumber + "(" + indexName + ")";
        } else if (NAME.equals(this.bgIndexNameStyle)) {
            displayName = indexName;
        } else if (LONGNAME.equals(this.bgIndexNameStyle)) {
            if (bgAccountViewId == null) {
                return indexNumber + "(" + indexName + ")";
            }
            if (this.getAccountMap() == null) {
                this.accountMap = new HashMap<String, Map<String, String>>();
            }
            if (!this.getAccountMap().containsKey(bgAccountViewId)) {
                this.getInitAccounts(ctx, bgAccountViewId);
            }
            if (this.getAccountMap().containsKey(bgAccountViewId)) {
                Map<String, String> tmpMap = this.getAccountMap().get(bgAccountViewId);
                if (tmpMap.containsKey(indexNumber)) {
                    displayName = tmpMap.get(indexNumber);
                }
            } else {
                displayName = indexNumber + "(" + indexName + ")";
            }
        }
        return displayName;
    }

    public ObjectValueRender getOVRender(String bgAccountViewId) throws EASBizException, BOSException {
        BgObjectValueRender avr = new BgObjectValueRender();
        avr.setBgAccountViewId(bgAccountViewId);
        if (bgAccountViewId == null || NUMBERANDNAME.equals(this.bgIndexNameStyle)) {
            avr.setFormat(new BgNumAndNameFormat());
        } else if (NAME.equals(this.bgIndexNameStyle)) {
            avr.setFormat(new BgNameFormat());
        } else if (LONGNAME.equals(this.bgIndexNameStyle)) {
            if (this.getAccountMap() == null) {
                this.accountMap = new HashMap<String, Map<String, String>>();
            }
            if (!this.getAccountMap().containsKey(bgAccountViewId)) {
                this.getInitAccounts(null, bgAccountViewId);
            }
            avr.setFormat(new BgLongNameFormat(this.getAccountMap(), bgAccountViewId));
        }
        return avr;
    }

    private Map<String, String> getInitAccounts(Context ctx, String viewId) {
        HashMap<String, String> accountMap = new HashMap<String, String>();
        if (viewId == null) {
            return accountMap;
        }
        try {
            IBgAccount iBgAccount = null;
            iBgAccount = ctx == null ? BgAccountFactory.getRemoteInstance() : BgAccountFactory.getLocalInstance((Context)ctx);
            if (iBgAccount == null) {
                return accountMap;
            }
            BgAccountCollection colls = iBgAccount.getBgAccountCollection("select number, name, displayName where bgAccountView = '" + viewId + "'");
            if (colls != null && colls.size() > 0) {
                BgAccountInfo info = null;
                int size = colls.size();
                for (int index = 0; index < size; ++index) {
                    info = colls.get(index);
                    if (info.getNumber() == null) continue;
                    if (!this.getAccountMap().containsKey(viewId)) {
                        this.getAccountMap().put(viewId, new HashMap());
                    }
                    if (!StringUtils.isEmpty((String)info.getDisplayName())) {
                        this.getAccountMap().get(viewId).put(info.getNumber(), info.getDisplayName());
                        continue;
                    }
                    this.getAccountMap().get(viewId).put(info.getNumber(), info.getName());
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("BgCellRenderHelper getInitAccounts error:" + e.getMessage()));
        }
        return accountMap;
    }

    public String getOrgUnitString(Object orgUnit) {
        OrgUnitInfo orgUnitInfo = null;
        if (orgUnit instanceof OrgUnitInfo) {
            orgUnitInfo = (OrgUnitInfo)orgUnit;
        } else if (orgUnit instanceof BgOrgUnitInfo) {
            orgUnitInfo = ((BgOrgUnitInfo)orgUnit).castToFullOrgUnitInfo();
        }
        if (orgUnitInfo == null) {
            return StringUtils.cnulls((Object)orgUnit);
        }
        String number = StringUtils.cnulls((String)orgUnitInfo.getNumber());
        String name = StringUtils.cnulls((String)orgUnitInfo.getName());
        String longName = StringUtils.cnulls((String)orgUnitInfo.getDisplayName());
        if (this.getBgOrgUnitNameStyle().equals(NAME)) {
            return name;
        }
        if (this.getBgOrgUnitNameStyle().equals(NUMBERANDNAME)) {
            return number + "(" + name + ")";
        }
        if (StringUtils.isEmpty((String)longName)) {
            return name;
        }
        return longName;
    }
}

