/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IMBGFormFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.RelationUtils;
import com.kingdee.eas.ma.mbg.utils.BgData;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgCheckDimensionRelationDataUtils {
    private Context ctx;
    private BOSUuid formId;
    private List<String> orgIds;
    private BgFormInfo info;
    private String cubeName;
    private String cubeEntryName;
    private List<String> formIds;
    private Map<String[], String> dimName;
    private RelationUtils relationUtils;

    public BgCheckDimensionRelationDataUtils(BgSchemeDimensionHelper schemeHelper) {
        this.dimName = new HashMap<String[], String>();
        this.relationUtils = RelationUtils.getInstance(schemeHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BgCheckDimensionRelationDataUtils(Context ctx, BOSUuid formId, List<String> orgIds) throws Exception {
        List<String> allOrgId;
        ResultSet rst;
        Statement pstmt;
        Connection conn;
        String orgUnitTmpTable;
        TempTablePool pool;
        BOSUuid currencyId;
        BOSUuid bgPeriodId;
        BOSUuid rootTemplateId;
        block8: {
            this.dimName = new HashMap<String[], String>();
            this.ctx = ctx;
            this.formId = formId;
            this.info = BgViewServerHelper.getBgFormInfo(ctx, formId, false);
            if (this.info == null) {
                return;
            }
            BOSUuid bgSchemeId = this.info.getBgScheme().getId();
            BgSchemeInfo bgScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgSchemeId);
            if (bgScheme == null) {
                return;
            }
            this.cubeName = BgCubeUtils.getCubeName(bgScheme.getRefCube(), 1);
            this.cubeEntryName = BgCubeUtils.getCubeEntryName(bgScheme.getRefCube(), 1);
            rootTemplateId = this.getInfo().getBgTemplate().getRootId();
            bgPeriodId = this.getInfo().getBgPeriod().getId();
            currencyId = this.getInfo().getCurrency().getId();
            pool = TempTablePool.getInstance((Context)ctx);
            orgUnitTmpTable = null;
            conn = null;
            pstmt = null;
            rst = null;
            conn = BgDBUtils.getConnection((Context)ctx);
            allOrgId = this.getAllOrgOfSchemeDisp();
            if (allOrgId != null && !allOrgId.isEmpty()) break block8;
            pool.releaseTable(orgUnitTmpTable);
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            return;
        }
        try {
            if (orgIds != null && !orgIds.isEmpty()) {
                this.orgIds = new ArrayList<String>();
                for (String org : orgIds) {
                    if (!allOrgId.contains(org)) continue;
                    this.orgIds.add(org);
                }
            } else {
                this.orgIds = allOrgId;
            }
            orgUnitTmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), this.getOrgIds());
            this.formIds = this.getBgFormIds(conn, orgUnitTmpTable, rootTemplateId, bgPeriodId, currencyId);
        }
        catch (Throwable throwable) {
            pool.releaseTable(orgUnitTmpTable);
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            throw throwable;
        }
        pool.releaseTable(orgUnitTmpTable);
        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BgData> queryDataOfNotRelationCreate() throws Exception {
        Set<String> formData = this.queryFormDataID();
        Set<String> relationData = this.queryDataOfRelationCreate();
        HashSet<String> needDeleDataId = new HashSet<String>();
        for (String id : formData) {
            if (relationData.contains(id)) continue;
            needDeleDataId.add(id);
        }
        if (needDeleDataId.isEmpty()) {
            return null;
        }
        ArrayList<BgData> list = new ArrayList<BgData>();
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        String formulaTable = null;
        Connection conn = null;
        IRowSet rs = null;
        String name = "FName_" + this.ctx.getLocale().getDisplayName();
        try {
            conn = BgDBUtils.getConnection((Context)this.ctx);
            formulaTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + formulaTable + " (FID) values (?) "), needDeleDataId);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT dat.FID ID,dat.FFORMULA FORMULA,dat.FVALUE VALUE,dat.FBGITEMCOMBINATION ITEMCOMBIN,dat.FSTATE STATE,org." + name + " ORGNAME,per." + name + " PERIODNAME,ele." + name + " ELEMENTNAME,cur." + name + " CURRENCYNAMEFROM ");
            sql.append(" FROM " + this.getCubeName() + " dat");
            sql.append(" LEFT JOIN T_ORG_COSTCENTER org ON org.FID = dat.FORGUNITID");
            sql.append(" LEFT JOIN T_MBG_BGPERIOD per ON per.FID = dat.FBgPeriodID");
            sql.append(" LEFT JOIN T_MBG_BGELEMENT ele ON ele.FID = dat.FBgElementID");
            sql.append(" LEFT JOIN T_BD_CURRENCY cur ON cur.FID = dat.FCurrencyID");
            sql.append(" WHERE dat.FID IN (");
            sql.append(" SELECT FID FROM " + formulaTable + " ");
            sql.append(")");
            rs = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rs.next()) {
                BgData data = new BgData();
                data.setFid(rs.getString("ID"));
                data.setFormula(rs.getString("FORMULA"));
                data.setValue(rs.getBigDecimal("VALUE"));
                data.setItemCombin(rs.getString("ITEMCOMBIN"));
                data.setState(rs.getInt("STATE"));
                data.setOrgName(rs.getString("ORGNAME"));
                data.setPeriodName(rs.getString("PERIODNAME"));
                data.setElementName(rs.getString("ELEMENTNAME"));
                data.setCurrencyName(rs.getString("CURRENCYNAMEFROM"));
                data.setTableName(this.getCubeName());
                list.add(data);
            }
        }
        catch (Throwable throwable) {
            pool.releaseTable(formulaTable);
            SQLUtils.cleanup(rs, null, (Connection)conn);
            throw throwable;
        }
        pool.releaseTable(formulaTable);
        SQLUtils.cleanup((ResultSet)rs, null, (Connection)conn);
        return list;
    }

    public Set<String> queryFormDataID() throws Exception {
        if (this.ctx == null || this.formId == null || this.getInfo() == null || StringUtils.isEmpty((String)this.getCubeName()) || StringUtils.isEmpty((String)this.getCubeEntryName())) {
            return null;
        }
        HashSet<String> dataIDS = new HashSet<String>();
        List<String> bgFormIds = this.getFormIds();
        if (!bgFormIds.isEmpty()) {
            for (String bgFormId : bgFormIds) {
                this.queryBaseData(bgFormId, dataIDS);
            }
        }
        return dataIDS;
    }

    public Set<String> queryDataOfRelationCreate() throws Exception {
        if (this.getFormIds() == null || this.getFormIds().isEmpty()) {
            return null;
        }
        HashSet<String> dataSetIDS = new HashSet<String>();
        IBgDimensionManager manager = null;
        IMbgViewManager view = null;
        BgFormInfo formInfo = null;
        IMBGFormFacade iMBGFormFacade = MBGFormFacadeFactory.getLocalInstance(this.ctx);
        int size = this.getFormIds().size();
        for (int index = 0; index < size; ++index) {
            formInfo = BgViewServerHelper.getBgFormInfo(this.ctx, BOSUuid.read((String)this.getFormIds().get(index)), false);
            view = (IMbgViewManager)DimensionCommonHelper.getBgFormView(this.ctx, formInfo);
            view = iMBGFormFacade.loadViewManager(formInfo.getId().toString(), null, view, null, formInfo.getOrgUnit().getId().toString(), true, false);
            if (view == null || view.getSheetManagers() == null) continue;
            int in = view.getSheetManagers().size();
            for (int i = 0; i < in; ++i) {
                Set<String> temp;
                Set<String> fomulaSet;
                manager = view.getSheetManagers().get(i).getDimensionManager();
                if (manager == null || (fomulaSet = this.getFormulaOfRelationCreate(view, manager, formInfo)) == null || fomulaSet.isEmpty() || (temp = this.queryDimensionRelationDataID(fomulaSet, formInfo)) == null || temp.isEmpty()) continue;
                dataSetIDS.addAll(temp);
            }
        }
        return dataSetIDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> queryDimensionRelationDataID(Set<String> fomulaSet, BgFormInfo formInfo) throws Exception {
        if (fomulaSet == null || fomulaSet.isEmpty() || formInfo == null) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        String formulaTable = null;
        Connection conn = null;
        String org = formInfo.getOrgUnit().getId().toString();
        IRowSet rs = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.ctx);
            formulaTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID NVARCHAR(200))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + formulaTable + " (FID) values (?) "), fomulaSet);
            String sql = "SELECT FID FROM " + this.getCubeName() + " WHERE FORGUNITID=? AND FFORMULA IN (SELECT FID FROM " + formulaTable + ")";
            rs = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new String[]{org});
            while (rs.next()) {
                ids.add(rs.getString("FID"));
            }
        }
        catch (Throwable throwable) {
            pool.releaseTable(formulaTable);
            SQLUtils.cleanup(rs, null, (Connection)conn);
            throw throwable;
        }
        pool.releaseTable(formulaTable);
        SQLUtils.cleanup((ResultSet)rs, null, (Connection)conn);
        return ids;
    }

    public Set<String> getFormulaOfRelationCreate(IMbgViewManager view, IBgDimensionManager manager, BgFormInfo formInfo) {
        if (StringUtils.isEmpty((String)this.cubeName) || manager == null || formInfo == null) {
            return null;
        }
        if (view.getRelationMaps() == null || view.getRelationMaps().isEmpty()) {
            return null;
        }
        List<IDimension> bgDims = DimUtils.transDimension(manager, formInfo);
        Set<String> refFields = DimUtils.getDimKey(bgDims);
        List<String[]> relationData = this.getRelationDatas(view, manager, bgDims);
        if (relationData.isEmpty()) {
            return null;
        }
        String[] relField = relationData.get(0);
        if (relField == null || relField.length == 0) {
            return null;
        }
        int eIndex = -1;
        int cIndex = -1;
        int pIndex = -1;
        String[] itemIndex = null;
        ArrayList<String[]> items = new ArrayList<String[]>();
        int jn = relField.length;
        for (int j = 0; j < jn; ++j) {
            if (DimensionConstants.DEF_ORGUNIT_FIELD.equals(relField[j])) continue;
            if (DimensionConstants.DEF_PERIOD_FIELD.equals(relField[j])) {
                pIndex = j;
                continue;
            }
            if (DimensionConstants.DEF_ELEMENT_FIELD.equals(relField[j])) {
                eIndex = j;
                continue;
            }
            if (DimensionConstants.DEF_CURRENCY_FIELD.equals(relField[j])) {
                cIndex = j;
                continue;
            }
            if (!refFields.contains(relField[j])) continue;
            itemIndex = new String[]{relField[j], String.valueOf(j)};
            items.add(itemIndex);
        }
        if (eIndex == -1 || cIndex == -1 || pIndex == -1) {
            return null;
        }
        Collections.sort(items, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                String index1 = o1[0].substring(1);
                String index2 = o2[0].substring(1);
                return Integer.valueOf(index1).compareTo(Integer.valueOf(index2));
            }
        });
        int[] iIndex = new int[items.size()];
        int jn2 = items.size();
        for (int j = 0; j < jn2; ++j) {
            iIndex[j] = new Integer(((String[])items.get(j))[1]);
        }
        HashSet<String> set = new HashSet<String>();
        int in = relationData.size();
        for (int i = 1; i < in; ++i) {
            String formula;
            String[] parameter = relationData.get(i);
            String[] formulaParametes = new String[4];
            formulaParametes[0] = this.getItemNumber(iIndex, parameter);
            if (formulaParametes[0] != null) {
                formulaParametes[1] = parameter[pIndex];
                formulaParametes[2] = parameter[eIndex];
                formulaParametes[4] = parameter[cIndex];
            }
            if (StringUtils.isEmpty((String)(formula = BgNFSHelper.getFormulaFromParam(formulaParametes)))) continue;
            set.add(formula);
        }
        return set;
    }

    private List<String[]> getRelationDatas(IMbgViewManager view, IBgDimensionManager manager, List<IDimension> bgDims) {
        List<String[]> relationData = null;
        if (view == null || manager == null || bgDims == null) {
            return relationData;
        }
        if (view.getRelationMaps() != null && !view.getRelationMaps().isEmpty()) {
            relationData = this.relationUtils.queryRelation(view.getRelationMaps(), manager);
        }
        if (relationData != null) {
            relationData = this.getFormulaByRelation(relationData, bgDims);
        }
        return relationData;
    }

    private List<String[]> getFormulaByRelation(List<String[]> relationData, List<IDimension> dims) {
        int i;
        if (relationData == null || relationData.isEmpty() || dims == null) {
            return relationData;
        }
        IDimension bgPeriodDim = DimUtils.getDimension(dims, DimensionConstants.DEF_PERIOD_NUMBER);
        IDimension bgElementDim = DimUtils.getDimension(dims, DimensionConstants.DEF_ELEMENT_NUMBER);
        IDimension currencyDim = DimUtils.getDimension(dims, DimensionConstants.DEF_CURRENCY_NUMBER);
        if (bgPeriodDim == null || bgElementDim == null || currencyDim == null) {
            return relationData;
        }
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String[]> tmpRelData = new ArrayList<String[]>();
        HashSet<String> refFields = new HashSet<String>();
        String field = null;
        String[] tmpStrs = null;
        String[] relField = relationData.get(0);
        int in = relationData.size();
        for (i = 1; i < in; ++i) {
            tmpRelData.add(relationData.get(i));
        }
        relationData.clear();
        in = relField.length;
        for (i = 0; i < in; ++i) {
            fields.add(relField[i]);
        }
        refFields.addAll(fields);
        for (IDimension dimension : dims) {
            field = dimension.getField();
            if (refFields.contains(field)) continue;
            fields.add(field);
            refFields.add(field);
            tmpStrs = new String[relField.length + 1];
            System.arraycopy(relField, 0, tmpStrs, 0, relField.length);
            tmpStrs[relField.length] = field;
            relField = tmpStrs;
            if (DimUtils.checkBaseDimension(dimension)) {
                for (IMember member : dimension.getDimensionMember()) {
                    if (!tmpRelData.isEmpty()) {
                        for (String[] relData : tmpRelData) {
                            tmpStrs = new String[relData.length + 1];
                            System.arraycopy(relData, 0, tmpStrs, 0, relData.length);
                            tmpStrs[relData.length] = member.getNumber();
                            relationData.add(tmpStrs);
                        }
                    } else {
                        tmpStrs = new String[relField.length];
                        tmpStrs[relField.length - 1] = member.getNumber();
                        relationData.add(tmpStrs);
                    }
                    String name = member.getName();
                    this.dimName.put(tmpStrs, name);
                }
            } else {
                for (IMember member : dimension.getDimensionMember()) {
                    if (!tmpRelData.isEmpty()) {
                        for (String[] relData : tmpRelData) {
                            tmpStrs = new String[relData.length + 1];
                            System.arraycopy(relData, 0, tmpStrs, 0, relData.length);
                            tmpStrs[relData.length] = member.getDimNumber();
                            relationData.add(tmpStrs);
                        }
                    } else {
                        tmpStrs = new String[relField.length];
                        tmpStrs[relField.length - 1] = member.getDimNumber();
                        relationData.add(tmpStrs);
                    }
                    String name = member.getName();
                    this.dimName.put(tmpStrs, name);
                }
            }
            tmpRelData.clear();
            tmpRelData.addAll(relationData);
            relationData.clear();
        }
        relationData.add(relField);
        relationData.addAll(tmpRelData);
        return relationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> queryBaseData(String bgFormId, Set<String> dataIDS) throws Exception {
        Connection conn = BgDBUtils.getConnection((Context)this.ctx);
        if (StringUtils.isEmpty((String)this.cubeName) || StringUtils.isEmpty((String)this.cubeEntryName) || StringUtils.isEmpty((String)bgFormId)) {
            return dataIDS;
        }
        String querySql = "select FID from " + this.getCubeName() + " where FID in (select FDataID from " + this.getCubeEntryName() + " where FFormID = ?)";
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)querySql, (Object[])new Object[]{bgFormId});
            while (rst.next()) {
                dataIDS.add(rst.getString("FID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, null, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return dataIDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllOrgOfSchemeDisp() throws Exception {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        Connection conn = BgDBUtils.getConnection((Context)this.ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID from T_ORG_CostCenter t join T_MBG_BgScheme s on t.FID = s.FOrgUnitID where s.FRootID = ? order by t.FLongNumber");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{this.getInfo().getBgScheme().getId().toString()});
            while (rst.next()) {
                orgUnitIds.add(rst.getString("FID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, null, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return orgUnitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBgFormIds(Connection conn, String orgUnitTmpTable, BOSUuid rootTemplateId, BOSUuid bgPeriodId, BOSUuid currencyId) throws SQLException {
        ArrayList<String> bgFormIds = new ArrayList<String>();
        if (conn == null || StringUtils.isEmpty((String)orgUnitTmpTable) || rootTemplateId == null || bgPeriodId == null || currencyId == null) {
            return bgFormIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FID from T_MBG_BgForm f join T_ORG_CostCenter cc on f.FOrgUnitID = cc.FID join T_MBG_BgTemplate t on f.FBgTemplateID = t.FID join T_MBG_BgPeriod p on f.FBgPeriodID = p.FID join T_BD_Currency c on f.FCurrencyID = c.FID where t.FRootID = ? and p.FID = ? and c.FID = ? and cc.FID in (select FID from " + orgUnitTmpTable + ")");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{rootTemplateId.toString(), bgPeriodId.toString(), currencyId.toString()});
            while (rst.next()) {
                bgFormIds.add(rst.getString("FID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgFormIds;
    }

    private String getItemNumber(int[] itemIndex, String[] rowData) {
        int index = 0;
        StringBuffer number = new StringBuffer();
        for (int i = 0; i < itemIndex.length; ++i) {
            index = itemIndex[i];
            if (rowData[index] == null) continue;
            number.append(rowData[index] + ",");
        }
        if (number.length() > 0) {
            number = number.delete(number.length() - 1, number.length());
        }
        return number.toString();
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public BOSUuid getFormId() {
        return this.formId;
    }

    public void setFormId(BOSUuid formId) {
        this.formId = formId;
    }

    public List<String> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<String> orgIds) {
        this.orgIds = orgIds;
    }

    public BgFormInfo getInfo() {
        return this.info;
    }

    public void setInfo(BgFormInfo info) {
        this.info = info;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public String getCubeEntryName() {
        return this.cubeEntryName;
    }

    public void setCubeEntryName(String cubeEntryName) {
        this.cubeEntryName = cubeEntryName;
    }

    public List<String> getFormIds() {
        return this.formIds;
    }

    public void setFormIds(List<String> formIds) {
        this.formIds = formIds;
    }
}

