/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgDataQueryUtils {
    private static final String TMP_TABLE_NAME = "#TMP_TABLE_NAME#";
    private boolean isQueryTmpData = false;

    private BgDataQueryUtils() {
    }

    public static BgDataQueryUtils getInstance() {
        return new BgDataQueryUtils();
    }

    public void setQueryTmpData(boolean isQueryTmpData) {
        this.isQueryTmpData = isQueryTmpData;
    }

    public boolean isQueryTmpData() {
        return this.isQueryTmpData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BigDecimal> queryDetailData(Context ctx, String bgSchemeNum, String orgUnitNum, List<IFormula> formulas, int valueType) throws Exception {
        Map<String, BigDecimal> detailDataMap = new HashMap<String, BigDecimal>();
        if (ctx == null || bgSchemeNum == null || orgUnitNum == null || formulas == null || formulas.isEmpty()) {
            return detailDataMap;
        }
        FormulaInfo formula = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            BOSUuid orgUnitId = this.queryOrgUnitId(conn, orgUnitNum);
            if (orgUnitId == null) {
                HashMap<String, BigDecimal> hashMap = detailDataMap;
                return hashMap;
            }
            String _orgUnitId = orgUnitId.toString();
            ArrayList<Object[]> dataParams = new ArrayList<Object[]>();
            Object[] sqlData = null;
            int in = formulas.size();
            for (int i = 0; i < in; ++i) {
                formula = (FormulaInfo)formulas.get(i);
                int jn = formula.getFormulas().length;
                for (int j = 0; j < jn; ++j) {
                    sqlData = new Object[]{_orgUnitId, formula.getFormulas()[j], formula.getBgVersionNumber()};
                    dataParams.add(sqlData);
                }
            }
            Map<String, BigDecimal> tmpMap = this.queryDetailData(ctx, conn, bgSchemeNum, dataParams, valueType);
            if (tmpMap != null) {
                detailDataMap = tmpMap;
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return detailDataMap;
    }

    public Map<String, BigDecimal> queryDetailData(Context ctx, Connection conn, String bgSchemeNum, List<Object[]> dataParams, int valueType) throws Exception {
        Map<String, BigDecimal> detailDataMap = new HashMap<String, BigDecimal>();
        if (ctx == null || StringUtils.isEmpty((String)bgSchemeNum)) {
            return detailDataMap;
        }
        String cubeName = this.queryCubeData(conn, bgSchemeNum);
        if (StringUtils.isEmpty((String)cubeName)) {
            return detailDataMap;
        }
        Map<String, BigDecimal> tmpMap = this.queryData(ctx, conn, cubeName, dataParams, valueType);
        if (tmpMap != null) {
            detailDataMap = tmpMap;
        }
        return detailDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BigDecimal> queryDetailData(Context ctx, BOSUuid bgSchemeId, List<Object[]> dataParams, int valueType) throws Exception {
        Map<String, BigDecimal> detailDataMap = new HashMap<String, BigDecimal>();
        if (ctx == null || bgSchemeId == null) {
            return detailDataMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            String cubeName = this.queryCubeData(conn, bgSchemeId);
            if (StringUtils.isEmpty((String)cubeName)) {
                HashMap<String, BigDecimal> hashMap = detailDataMap;
                return hashMap;
            }
            Map<String, BigDecimal> tmpMap = this.queryData(ctx, conn, cubeName, dataParams, valueType);
            if (tmpMap != null) {
                detailDataMap = tmpMap;
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return detailDataMap;
    }

    private Map<String, BigDecimal> queryData(Context ctx, Connection conn, String cubeName, List<Object[]> dataParams, int valueType) throws Exception {
        if (ctx == null || conn == null) {
            return null;
        }
        String[] sqls = new String[]{this.getTmpTableSql(), this.getInsertTmpTableSql(), this.getQuerySql(cubeName, valueType)};
        return this.queryDetailData(ctx, conn, cubeName, sqls, dataParams, valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BigDecimal> queryDetailData(Context ctx, Connection conn, String cubeName, String[] sqls, List<Object[]> sqlParams, int valueType) throws Exception {
        HashMap<String, BigDecimal> detailDataMap = new HashMap<String, BigDecimal>();
        if (ctx == null || conn == null || cubeName == null || sqls == null || sqlParams == null || sqlParams.isEmpty()) {
            return detailDataMap;
        }
        String tmpTableName = null;
        TempTablePool pool = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, Integer> bgVersionMap = new HashMap<String, Integer>();
        HashMap<Integer, String> bgVersionInnIdMap = new HashMap<Integer, String>();
        BgVersionInfo version = null;
        BgVersionCollection colls = BgVersionHelper.getVersionColls((Context)ctx);
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            version = colls.get(i);
            bgVersionMap.put(version.getNumber(), version.getVersionId());
            bgVersionInnIdMap.put(version.getVersionId(), version.getNumber());
        }
        Object[] sqlData = null;
        int in2 = sqlParams.size();
        for (int i = 0; i < in2; ++i) {
            sqlData = sqlParams.get(i);
            sqlData[2] = bgVersionMap.get(sqlData[2]);
        }
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tmpTableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)sqls[0]);
            sqls[1] = sqls[1].replaceAll(TMP_TABLE_NAME, tmpTableName);
            BgDBUtils.executeBatch((Connection)conn, (String)sqls[1], sqlParams);
            sqls[2] = sqls[2].replaceAll(TMP_TABLE_NAME, tmpTableName);
            pstmt = conn.prepareStatement(sqls[2]);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                detailDataMap.put(DimUtils.getDimDataKey(rst.getString(1), (String)bgVersionInnIdMap.get(rst.getInt(3))), rst.getBigDecimal(2));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTableName);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTableName);
        return detailDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BOSUuid queryOrgUnitId(Connection conn, String orgUnitNum) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)orgUnitNum)) {
            return null;
        }
        BOSUuid orgUnitId = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_ORG_CostCenter where FNumber = ?", (Object[])new Object[]{orgUnitNum});
            if (rst.next()) {
                orgUnitId = BOSUuid.read((String)rst.getString("FID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgUnitId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String queryCubeData(Connection conn, BOSUuid bgSchemeId) throws SQLException {
        if (conn == null || bgSchemeId == null) {
            return null;
        }
        String _bgSchemeId = bgSchemeId.toString();
        String cubeName = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FRefCube from T_MBG_BgScheme where FID = ?", (Object[])new Object[]{_bgSchemeId});
            if (rst.next()) {
                cubeName = rst.getString("FRefCube");
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return cubeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String queryCubeData(Connection conn, String bgSchemeNum) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)bgSchemeNum)) {
            return null;
        }
        String cubeName = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FRefCube from T_MBG_BgScheme where FNumber = ?", (Object[])new Object[]{bgSchemeNum});
            if (rst.next()) {
                cubeName = rst.getString("FRefCube");
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return cubeName;
    }

    protected String getTmpTableSql() {
        return "Create Table TMP_TABEL_NAME (FOrgUnitId VARCHAR(44), FFormula NVARCHAR(300), FVersion INT)";
    }

    protected String getInsertTmpTableSql() {
        return "Insert Into #TMP_TABLE_NAME# (FOrgUnitId, FFormula, FVersion) values (?,?,?)";
    }

    protected String getQuerySql(String cubeName, int valueType) {
        if (StringUtils.isEmpty((String)cubeName)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        if (valueType == 1 || valueType == 2) {
            sql.append("select t.FFormula, " + (this.isQueryTmpData() ? "t.FTmpValue" : "t.FValue") + ", t.FVersion from " + cubeName + " t join " + TMP_TABLE_NAME + " n on t.FOrgUnitId = n.FOrgUnitId and t.FFormula = n.FFormula and t.FVersion = n.FVersion");
            if (valueType == 2) {
                sql.append(" where t.FState = 9");
            }
        } else if (valueType == 4) {
            sql.append("select t.FFormula, t.FValue, t.FVersion from " + BgCubeUtils.getActualCubeName(cubeName) + " t join " + TMP_TABLE_NAME + " n on t.FOrgUnitId = n.FOrgUnitId and t.FFormula = n.FFormula and t.FVersion = n.FVersion");
        } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
            sql.append("select t.FFormula, t.FValue, t.FVersion from " + BgCubeUtils.getDailyActualCubeName(cubeName) + " t join " + TMP_TABLE_NAME + " n on t.FOrgUnitId = n.FOrgUnitId and t.FFormula = n.FFormula and t.FVersion = n.FVersion");
            if (valueType == 32) {
                sql.append(" where t.FState = 9");
            }
            if (valueType == 2048) {
                sql.append(" where t.FState = 1");
            }
        }
        return sql.toString();
    }
}

