/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.BgDataEntryFactory;
import com.kingdee.eas.ma.mbg.BgDataFactory;
import com.kingdee.eas.ma.mbg.BgDataInfo;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeException;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgDataSynStateBizHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgDataSynStateBizHelper.class);
    public static final String OPERATOR_BACK_PLAN = "OPERATOR_BACK_PLAN";
    public static final String OPERATOR_BASISAPPROVED = "OPERATOR_BASISAPPROVED";
    public static final String OPERATOR_APPROVED = "OPERATOR_APPROVED";
    public static final String OPERATOT_UNAPPROVED = "OPERATOT_UNAPPROVED";
    public static final String OPERATOT_REPORT = "OPERATOT_REPORT";
    public static final String OPERATOT_BACK = "OPERATOT_BACK";
    public static final String OPERATOT_ADJUST = "OPERATOT_ADJUST";
    public static final String OPERATOT_APPROVING = "OPERATOT_APPROVING";
    public static final String OPERATOT_SUBMIT = "OPERATOT_SUBMIT";
    public static final String OPERATOT_SAVEBUDGET = "OPERATOT_SAVEBUDGET";

    private static ICoreBase getBgDataUpdateInterface(Context ctx) throws BOSException {
        if (null != ctx) {
            return BgDataFactory.getLocalInstance(ctx);
        }
        return BgDataFactory.getRemoteInstance();
    }

    private static ICoreBase getBgDataEntryInterface(Context ctx) throws BOSException {
        if (null != ctx) {
            return BgDataEntryFactory.getLocalInstance(ctx);
        }
        return BgDataEntryFactory.getRemoteInstance();
    }

    private static SelectorItemCollection getUpdateSelector() {
        SelectorItemCollection sels = new SelectorItemCollection();
        sels.add("id");
        sels.add("dataState");
        return sels;
    }

    private static BgDataStateEnum getDataStateByFormState(BgFormStateEnum bgFormState) {
        if (bgFormState == null) {
            return null;
        }
        if (BgFormStateEnum.Edited.equals((Object)bgFormState)) {
            return BgDataStateEnum.Edited;
        }
        if (BgFormStateEnum.Approved.equals((Object)bgFormState)) {
            return BgDataStateEnum.Approved;
        }
        if (BgFormStateEnum.BasisApproved.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Adjusted.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Cancelled.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Approving.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.History.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Collect.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.REFERRING.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Decomposer.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Report.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Certificate.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Back.equals((Object)bgFormState)) {
            return BgDataStateEnum.Edited;
        }
        if (BgFormStateEnum.PeriodAdjusted.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.UnReport.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.CANTEDIT.equals((Object)bgFormState)) {
            return BgDataStateEnum.Edited;
        }
        if (!BgFormStateEnum.UnCertificate.equals((Object)bgFormState) && !BgFormStateEnum.Count.equals((Object)bgFormState) && (BgFormStateEnum.AdjustApproving.equals((Object)bgFormState) || BgFormStateEnum.RollApproving.equals((Object)bgFormState))) {
            return BgDataStateEnum.UnEditeable;
        }
        return null;
    }

    private static Connection getConnection(Context ctx) throws BOSException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            logger.error((Object)"", (Throwable)sqle);
            throw new BOSException((Throwable)sqle);
        }
    }

    private static boolean comparDataState(BgDataStateEnum updateDataState, BgDataStateEnum oriDataState, boolean updFlag) {
        if (updateDataState == null) {
            return false;
        }
        if (oriDataState == null) {
            return true;
        }
        if (updateDataState.equals((Object)oriDataState) || updateDataState.getValue() == oriDataState.getValue()) {
            return false;
        }
        return updFlag ? updateDataState.getValue() > oriDataState.getValue() : updateDataState.getValue() < oriDataState.getValue();
    }

    public static void updateDataStateByFormID(Context ctx, String bgFormId, BgDataStateEnum bgDataState, boolean updFlag, String operator) throws EASBizException, BOSException, SQLException {
        if (ctx == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId);
        BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet(ctx, bgFormIds, bgDataState, updFlag, operator);
    }

    public static void updateDataStateByFormID(Context ctx, String bgFormId, boolean updFlag, String operator) throws EASBizException, BOSException, SQLException {
        if (ctx == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId);
        BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet(ctx, bgFormIds, updFlag, operator);
    }

    public static void updateDataStateBatchByFromIdSet(Context ctx, Collection ids, boolean updFlag, String operator) throws EASBizException, BOSException, SQLException {
        BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet(ctx, ids, null, updFlag, operator);
    }

    public static void updateDataStateBatchByFromIdSet(Context ctx, Collection ids, BgDataStateEnum bgDataState, boolean updFlag, String operator) throws EASBizException, BOSException, SQLException {
        if (ids == null) {
            return;
        }
        if (ctx == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int index = 0;
        HashMap<BOSUuid, BgSchemeInfo> cubeMap = new HashMap<BOSUuid, BgSchemeInfo>();
        BgSchemeInfo schemeInfo = null;
        try {
            conn = BgDataSynStateBizHelper.getConnection(ctx);
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                Map<String, CoreBaseCollection> dataState;
                BgFormInfo bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)it.next().toString()));
                bgForm = BgDataSynStateBizHelper.getBgFormInfo(ctx, bgForm.getId(), true, false);
                if (bgDataState == null) {
                    bgDataState = BgDataSynStateBizHelper.getDataStateByFormState(bgForm.getState());
                }
                if (cubeMap.containsKey(bgForm.getBgScheme().getId())) {
                    schemeInfo = (BgSchemeInfo)cubeMap.get(bgForm.getBgScheme().getId());
                } else {
                    schemeInfo = BgViewServerHelper.getBgSchemeInfo(ctx.getLocale(), conn, bgForm.getBgScheme().getId());
                    schemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, schemeInfo.getId());
                    cubeMap.put(bgForm.getBgScheme().getId(), schemeInfo);
                }
                if ((dataState = BgDataSynStateBizHelper.getBgDataMapByBgForm(ctx, conn, bgForm, schemeInfo)) == null || dataState.isEmpty() || schemeInfo == null) continue;
                String refCube = schemeInfo.getRefCube();
                if (refCube == null) {
                    throw new BgSchemeException(BgSchemeException.NOTFOUNDSCHEMEREFCUBE);
                }
                for (String cubeName : dataState.keySet()) {
                    index = 0;
                    pstmt = conn.prepareStatement("update " + cubeName + " set FState = ? where FID = ?");
                    for (BgDataInfo tempData : dataState.get(cubeName)) {
                        if (!BgDataSynStateBizHelper.comparDataState(bgDataState, tempData.getDataState(), updFlag)) continue;
                        pstmt.setInt(1, bgDataState.getValue());
                        pstmt.setString(2, tempData.getId().toString());
                        pstmt.addBatch();
                        if (50 >= ++index) continue;
                        pstmt.executeBatch();
                        pstmt.clearBatch();
                        index = 0;
                    }
                    if (index > 0) {
                        pstmt.executeBatch();
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BgFormInfo getBgFormInfo(Context ctx, BOSUuid bgFormId, boolean loadData, boolean stateOnly) throws EASBizException, BOSException {
        PreparedStatement pstmt;
        Connection conn;
        BgFormInfo bgFormInfo;
        block18: {
            if (bgFormId == null) {
                return null;
            }
            bgFormInfo = null;
            conn = null;
            pstmt = null;
            ResultSet rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select bgf.FID, bgf.FNumber, bgf.FName, bgf.FControlUnitID, bgf.FOrgUnitID, bgf.FBgSchemeID, bgf.FBgTemplateId , bgt.FFormType ," + (loadData ? " bgf.FData, bgf.FAdjustMapData, " : "") + " bgf.FBgPeriodID, bgf.FCurrencyID, bgf.FMeasureUnitID, bgf.FDataSource, bgf.FVersionNo, bgf.FAdjustID, bgf.FState  From T_MBg_BgForm bgf left join T_MBg_BgTemplate bgt on bgf.FBgTemplateId = bgt.fid where bgf.FID = ?");
            StringBuffer sql2 = new StringBuffer();
            sql2.append("Select bgf.FID, bgf.FBgTemplateId ,bgf.FOrgUnitID, bgt.FFormType, bgf.FState  From T_MBg_BgForm bgf left join T_MBg_BgTemplate bgt on bgf.FBgTemplateId = bgt.fid where bgf.FID = ?");
            try {
                conn = BgDataSynStateBizHelper.getConnection(ctx);
                if (stateOnly) {
                    pstmt = conn.prepareStatement(sql2.toString());
                    pstmt.setString(1, bgFormId.toString());
                    rst = pstmt.executeQuery();
                    if (!rst.next()) break block18;
                    bgFormInfo = new BgFormInfo();
                    bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    bgFormInfo.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                    if (rst.getString("FOrgUnitID") != null) {
                        bgFormInfo.setOrgUnit(new FullOrgUnitInfo());
                        bgFormInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                    }
                    if (rst.getString("FBgTemplateId") != null) {
                        BgTemplateInfo template = new BgTemplateInfo();
                        template.setId(BOSUuid.read((String)rst.getString("FBgTemplateId")));
                        template.setFormType(rst.getInt("FFormType") > 0 ? BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")) : null);
                        bgFormInfo.setBgTemplate(template);
                    }
                    break block18;
                }
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgFormId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block18;
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgFormInfo.setNumber(rst.getString("FNumber"));
                bgFormInfo.setName(rst.getString("FName"));
                bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
                bgFormInfo.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                bgFormInfo.setDataSource(BgFormDataSourceEnum.getEnum(rst.getInt("FDataSource")));
                if (loadData) {
                    bgFormInfo.setZipData(MbgSqlHelper.getBytes((ResultSet)rst, (String)"FData"));
                    bgFormInfo.setAdjustMapData(MbgSqlHelper.getBytes((ResultSet)rst, (String)"FAdjustMapData"));
                }
                if (rst.getString("FControlUnitID") != null) {
                    bgFormInfo.setCU(new CtrlUnitInfo());
                    bgFormInfo.getCU().setId(BOSUuid.read((String)rst.getString("FControlUnitID")));
                }
                if (rst.getString("FOrgUnitID") != null) {
                    bgFormInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgFormInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                }
                if (rst.getString("FBgSchemeID") != null) {
                    bgFormInfo.setBgScheme(new BgSchemeInfo());
                    bgFormInfo.getBgScheme().setId(BOSUuid.read((String)rst.getString("FBgSchemeID")));
                }
                if (rst.getString("FBgTemplateId") != null) {
                    BgTemplateInfo template = new BgTemplateInfo();
                    template.setId(BOSUuid.read((String)rst.getString("FBgTemplateId")));
                    template.setFormType(rst.getInt("FFormType") > 0 ? BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")) : null);
                    bgFormInfo.setBgTemplate(template);
                }
                if (rst.getString("FBgPeriodID") != null) {
                    bgFormInfo.setBgPeriod(new BgPeriodInfo());
                    bgFormInfo.getBgPeriod().setId(BOSUuid.read((String)rst.getString("FBgPeriodID")));
                }
                if (rst.getString("FCurrencyID") != null) {
                    bgFormInfo.setCurrency(new CurrencyInfo());
                    bgFormInfo.getCurrency().setId(BOSUuid.read((String)rst.getString("FCurrencyID")));
                }
                if (rst.getString("FMeasureUnitID") != null) {
                    bgFormInfo.setMeasureUnit(new MeasureUnitInfo());
                    bgFormInfo.getMeasureUnit().setId(BOSUuid.read((String)rst.getString("FMeasureUnitID")));
                }
                if (rst.getString("FAdjustID") != null) {
                    bgFormInfo.setAdjust(new BgFormInfo());
                    bgFormInfo.getAdjust().setId(BOSUuid.read((String)rst.getString("FAdjustID")));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.warn((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (IOException ex2) {
                        logger.warn((Object)ex2.getMessage());
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return bgFormInfo;
    }

    private static Map<String, CoreBaseCollection> getBgDataMapByBgForm(Context ctx, Connection conn, BgFormInfo bgForm, BgSchemeInfo schemeInfo) throws BOSException, EASBizException {
        HashMap<String, CoreBaseCollection> bgDataCol = null;
        if (conn == null || bgForm == null || schemeInfo == null) {
            return bgDataCol;
        }
        bgDataCol = new HashMap<String, CoreBaseCollection>();
        BgDataInfo dataInfo = null;
        CoreBaseCollection col = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String entryName = BgCubeUtils.getBudgetEntryCubeName(schemeInfo.getRefCube());
        try {
            if (schemeInfo.getRefCube() == null) {
                throw new BgSchemeException(BgSchemeException.NOTFOUNDSCHEMEREFCUBE);
            }
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, schemeInfo.getId().toString(), schemeInfo.getRefCube());
            Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
            for (String cube : cubeNames) {
                col = new CoreBaseCollection();
                pstmt = conn.prepareStatement("select FID, FState from " + cube + " where FID IN (select FDataID from " + entryName + " where FFormId = ?)");
                pstmt.setString(1, bgForm.getId().toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    dataInfo = new BgDataInfo();
                    dataInfo.setBgItemCombinId(cube);
                    dataInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    dataInfo.setDataState(BgDataStateEnum.getEnum(rst.getInt("FState")));
                    col.add((CoreBaseInfo)dataInfo);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (col.isEmpty()) continue;
                bgDataCol.put(cube, col);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"getBgDataMapByBgForm Error:", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
        return bgDataCol;
    }

    private static SelectorItemCollection getMixSelector(String str, SelectorItemCollection sels) {
        StringBuffer strff = null;
        SelectorItemCollection newSels = null;
        if (str == null) {
            if (sels != null) {
                return sels;
            }
            return null;
        }
        newSels = new SelectorItemCollection();
        for (SelectorItemInfo sel : sels) {
            strff = new StringBuffer(str);
            strff.append(".");
            if (sel.getPropertyName() == null) continue;
            strff.append(sel.getPropertyName());
            newSels.add(strff.toString());
        }
        return newSels;
    }

    private static ICoreBase getBgFormUpdateInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgFormFactory.getRemoteInstance();
        }
        return BgFormFactory.getLocalInstance(ctx);
    }

    public static BgTemFormTypeEnum getBgFormType(Context ctx, String id) throws EASBizException, BOSException {
        if (id == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        BgFormInfo bgform = (BgFormInfo)BgDataSynStateBizHelper.getBgFormUpdateInterface(ctx).getValue("select bgTemplate.id, state, bgTemplate.formType where id = '" + id + "'");
        return bgform.getBgTemplate().getFormType();
    }

    public static BgFormInfo getBgFormInfo(Context ctx, String id) throws EASBizException, BOSException {
        if (id == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        return (BgFormInfo)BgDataSynStateBizHelper.getBgFormUpdateInterface(ctx).getValue("select bgTemplate.id, state, bgTemplate.formType, processType,bgScheme.id,orgUnit.id,number,name where id = '" + id + "'");
    }
}

