/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaParser;
import com.kingdee.eas.fi.rpt.excelformula.IBreakableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.IExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.Parse2RPN;
import com.kingdee.eas.fi.rpt.excelformula.RptFormula;
import com.kingdee.eas.fi.rpt.excelformula.RptFormulaComp;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.AreaExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgExcelFormulaPaserHelper {
    private static final Logger logger = Logger.getLogger(BgExcelFormulaPaserHelper.class);
    public static Map<String, Object> easFormuls = new HashMap<String, Object>();

    public static Expression parse(String line) throws Exception {
        if (line != null && line.trim().length() > 0 && line.charAt(0) == '=') {
            line = line.substring(1);
        }
        Parse2RPN p = new Parse2RPN(line);
        p.parse();
        ExcelFormulaParser fp = new ExcelFormulaParser(p.getTokens());
        return fp.parse();
    }

    public static FunctionExpr getOuterLastFunction(String line) throws Exception {
        if (line != null && line.trim().length() > 0 && line.charAt(0) == '=') {
            line = line.substring(1);
        }
        Expression ex = BgExcelFormulaPaserHelper.parse(line);
        return BgExcelFormulaPaserHelper.getOuterLastFunction(ex);
    }

    public static FunctionExpr getOuterLastFunction(Expression ex) throws Exception {
        return (FunctionExpr)BgExcelFormulaPaserHelper.walkToLast(ex);
    }

    private static Expression walkToLast(Expression ex) {
        if (ex instanceof FunctionExpr) {
            return ex;
        }
        if (ex instanceof BinaryOperationExpr) {
            Expression expression = ((BinaryOperationExpr)ex).right;
            return BgExcelFormulaPaserHelper.walkToLast(expression);
        }
        return null;
    }

    public static void walk(Expression exp, IExpressionHandler handler) {
        handler.handle(exp);
        if (exp instanceof BinaryOperationExpr) {
            BgExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).left, handler);
            BgExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).right, handler);
        } else if (exp instanceof UnaryOperationExpr) {
            BgExcelFormulaPaserHelper.walk(((UnaryOperationExpr)exp).operand, handler);
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                BgExcelFormulaPaserHelper.walk((Expression)ps.get(i), handler);
            }
        } else if (exp instanceof Area3DExpr) {
            BgExcelFormulaPaserHelper.walk((Expression)((Area3DExpr)exp).area, handler);
        } else if (exp instanceof Ref3DExpr) {
            BgExcelFormulaPaserHelper.walk((Expression)((Ref3DExpr)exp).ref, handler);
        }
    }

    public static void walk(Expression exp, IBreakableExpressionHandler handler) {
        boolean b = handler.handle(exp);
        if (!b) {
            return;
        }
        if (exp instanceof BinaryOperationExpr) {
            BgExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).left, handler);
            BgExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).right, handler);
        } else if (exp instanceof UnaryOperationExpr) {
            BgExcelFormulaPaserHelper.walk(((UnaryOperationExpr)exp).operand, handler);
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                BgExcelFormulaPaserHelper.walk((Expression)ps.get(i), handler);
            }
        } else if (exp instanceof Area3DExpr) {
            BgExcelFormulaPaserHelper.walk((Expression)((Area3DExpr)exp).area, handler);
        } else if (exp instanceof Ref3DExpr) {
            BgExcelFormulaPaserHelper.walk((Expression)((Ref3DExpr)exp).ref, handler);
        }
    }

    public static Expression walk(Expression exp, IEditableExpressionHandler handler) {
        Expression expression = handler.handle(exp);
        if (exp instanceof BinaryOperationExpr) {
            ((BinaryOperationExpr)exp).left = BgExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).left, handler);
            ((BinaryOperationExpr)exp).right = BgExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).right, handler);
        } else if (exp instanceof UnaryOperationExpr) {
            ((UnaryOperationExpr)exp).operand = BgExcelFormulaPaserHelper.walk(((UnaryOperationExpr)exp).operand, handler);
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                Expression param = (Expression)ps.get(i);
                ps.set(i, BgExcelFormulaPaserHelper.walk(param, handler));
            }
        } else if (exp instanceof Area3DExpr) {
            ((Area3DExpr)exp).area = (AreaExpr)BgExcelFormulaPaserHelper.walk((Expression)((Area3DExpr)exp).area, handler);
        } else if (exp instanceof Ref3DExpr) {
            ((Ref3DExpr)exp).ref = (ReferenceExpr)BgExcelFormulaPaserHelper.walk((Expression)((Ref3DExpr)exp).ref, handler);
        }
        return expression;
    }

    public static String toReducedBracketsString(Expression exp) {
        StringBuffer sb = new StringBuffer();
        BgExcelFormulaPaserHelper.reducedBrackets(sb, exp, -1);
        return sb.toString();
    }

    private static void reducedBrackets(StringBuffer sb, Expression expr, int lastOperationType) {
        if (expr instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expr;
            sb.append(functionExpr.funcionName);
            sb.append('(');
            for (int i = 0; i < functionExpr.parameters.size(); ++i) {
                Object obj = functionExpr.parameters.get(i);
                if (i > 0) {
                    sb.append(',').append(' ');
                }
                BgExcelFormulaPaserHelper.reducedBrackets(sb, (Expression)obj, -1);
            }
            sb.append(')');
        } else if (expr instanceof BinaryOperationExpr) {
            BgExcelFormulaPaserHelper.reducedBinaryBrackets(sb, (BinaryOperationExpr)expr, lastOperationType);
        } else if (expr instanceof UnaryOperationExpr) {
            BgExcelFormulaPaserHelper.reducedUnaryBrackets(sb, (UnaryOperationExpr)expr, lastOperationType);
        } else {
            sb.append(expr.toString());
        }
    }

    private static void reducedUnaryBrackets(StringBuffer sb, UnaryOperationExpr expr, int lastOperationType) {
        boolean isPercent = false;
        if ("%".equals(expr.getOperation()) && expr.operand != null) {
            try {
                new BigDecimal(expr.operand.toString());
                isPercent = true;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        if (!isPercent) {
            sb.append(expr.getOperation());
        }
        if (expr.operand instanceof BinaryOperationExpr) {
            BinaryOperationExpr binaryExpr = (BinaryOperationExpr)expr.operand;
            if ((binaryExpr.operationType == 5 || binaryExpr.operationType == 6) && expr.operationType != 3) {
                BgExcelFormulaPaserHelper.reducedBrackets(sb, expr.operand, expr.operationType);
            } else {
                sb.append('(');
                BgExcelFormulaPaserHelper.reducedBrackets(sb, expr.operand, expr.operationType);
                sb.append(')');
            }
        } else if (expr.operand instanceof IntExpr) {
            BgExcelFormulaPaserHelper.reducedBrackets(sb, expr.operand, expr.operationType);
            if (isPercent) {
                sb.append(expr.getOperation());
            }
        } else {
            sb.append('(');
            BgExcelFormulaPaserHelper.reducedBrackets(sb, expr.operand, expr.operationType);
            if (isPercent) {
                sb.append(expr.getOperation());
            }
            sb.append(')');
        }
    }

    private static void reducedBinaryBrackets(StringBuffer sb, BinaryOperationExpr expr, int lastOperationType) {
        BgExcelFormulaPaserHelper.reducedLeftBrackets(sb, expr.left, expr.operationType);
        sb.append(expr.getOperation());
        BgExcelFormulaPaserHelper.reducedRightBrackets(sb, expr.right, expr.operationType);
    }

    private static void reducedLeftBrackets(StringBuffer sb, Expression left, int lastOperationType) {
        if (left instanceof BinaryOperationExpr) {
            BinaryOperationExpr expr = (BinaryOperationExpr)left;
            int operationType = expr.operationType;
            if (!(lastOperationType != 5 && lastOperationType != 6 || operationType != 7 && operationType != 8)) {
                sb.append('(');
                BgExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
                sb.append(')');
            } else {
                BgExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
            }
        } else {
            BgExcelFormulaPaserHelper.reducedBrackets(sb, left, lastOperationType);
        }
    }

    private static void reducedRightBrackets(StringBuffer sb, Expression right, int lastOperationType) {
        if (right instanceof BinaryOperationExpr) {
            BinaryOperationExpr expr = (BinaryOperationExpr)right;
            int operationType = expr.operationType;
            if (6 == lastOperationType) {
                sb.append('(');
                BgExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
                sb.append(')');
            } else if (!(lastOperationType != 5 && lastOperationType != 8 || operationType != 7 && operationType != 8)) {
                sb.append('(');
                BgExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
                sb.append(')');
            } else {
                BgExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
            }
        } else {
            BgExcelFormulaPaserHelper.reducedBrackets(sb, right, lastOperationType);
        }
    }

    public static boolean isHavSpecialExpr(Expression exp) {
        if (BgExcelFormulaPaserHelper.isReferenceExprORareaExpr(exp)) {
            return true;
        }
        if (exp instanceof BinaryOperationExpr) {
            if (BgExcelFormulaPaserHelper.isHavSpecialExpr(((BinaryOperationExpr)exp).left)) {
                return true;
            }
            if (BgExcelFormulaPaserHelper.isHavSpecialExpr(((BinaryOperationExpr)exp).right)) {
                return true;
            }
        } else if (exp instanceof UnaryOperationExpr) {
            if (BgExcelFormulaPaserHelper.isHavSpecialExpr(((UnaryOperationExpr)exp).operand)) {
                return true;
            }
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                if (!BgExcelFormulaPaserHelper.isHavSpecialExpr((Expression)ps.get(i))) continue;
                return true;
            }
        } else if (exp instanceof Area3DExpr ? BgExcelFormulaPaserHelper.isHavSpecialExpr((Expression)((Area3DExpr)exp).area) : exp instanceof Ref3DExpr && BgExcelFormulaPaserHelper.isHavSpecialExpr((Expression)((Ref3DExpr)exp).ref)) {
            return true;
        }
        return false;
    }

    public static boolean isHavCommonRptExpr(Expression exp) {
        if (BgExcelFormulaPaserHelper.isCommonRptExpr(exp)) {
            return true;
        }
        if (exp instanceof BinaryOperationExpr) {
            if (BgExcelFormulaPaserHelper.isHavCommonRptExpr(((BinaryOperationExpr)exp).left)) {
                return true;
            }
            if (BgExcelFormulaPaserHelper.isHavCommonRptExpr(((BinaryOperationExpr)exp).right)) {
                return true;
            }
        } else if (exp instanceof UnaryOperationExpr) {
            if (BgExcelFormulaPaserHelper.isHavCommonRptExpr(((UnaryOperationExpr)exp).operand)) {
                return true;
            }
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                if (!BgExcelFormulaPaserHelper.isHavCommonRptExpr((Expression)ps.get(i))) continue;
                return true;
            }
        } else if (exp instanceof Area3DExpr ? BgExcelFormulaPaserHelper.isHavCommonRptExpr((Expression)((Area3DExpr)exp).area) : exp instanceof Ref3DExpr && BgExcelFormulaPaserHelper.isHavCommonRptExpr((Expression)((Ref3DExpr)exp).ref)) {
            return true;
        }
        return false;
    }

    private static boolean isReferenceExprORareaExpr(Expression expr) {
        return expr instanceof ReferenceExpr || expr instanceof AreaExpr;
    }

    private static boolean isCommonRptExpr(Expression expr) {
        if (expr instanceof FunctionExpr) {
            if (BgExcelFormulaPaserHelper.isEasFormula(((FunctionExpr)expr).funcionName)) {
                return true;
            }
            List ps = ((FunctionExpr)expr).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                if (!BgExcelFormulaPaserHelper.isReferenceExprORareaExpr((Expression)ps.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isEasFormula(String formulaName) {
        if (!StringUtils.isEmpty((String)formulaName)) {
            if (easFormuls.isEmpty()) {
                RptFormulaComp comp = RptFormulaComp.getInstance();
                comp.setK3(false);
                if (!comp.isLoaded()) {
                    try {
                        comp.load();
                    }
                    catch (Exception e) {
                        logger.error((Object)"comp.load();", (Throwable)e);
                    }
                }
                Collection easFormulColl = RptFormulaComp.getInstance().getFormulasByCategory(null);
                for (Object formul : easFormulColl) {
                    easFormuls.put(((RptFormula)formul).getName().toUpperCase(), null);
                }
            }
            if (easFormuls.containsKey(formulaName.toUpperCase())) {
                return true;
            }
        }
        return false;
    }
}

