/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.Arrays;
import com.kingdee.eas.ma.mbg.utils.BgExportUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BgExportStyleUtils {
    private BgExportUtils utils = null;
    private StyleAttributes sa = Styles.getDefaultSA();
    private String number;
    private String name;
    public static final String COMMON_SHEET = "common";

    public BgExportStyleUtils(BgExportUtils utils) {
        this.sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        this.sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        this.sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        this.sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        this.sa.setBorderLineStyle(Styles.Position.DIAGONALRIGHT, LineStyle.SINGLE_LINE);
        this.sa.setBorderLineStyle(Styles.Position.DIAGONALLEFT, LineStyle.SINGLE_LINE);
        this.number = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"277_BgItemForFpF7UI");
        this.name = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"275_BgItemForFpF7UI");
        this.utils = utils;
    }

    public void outViewAndPage(int templateType, List dims, KDSSheet sheet, Integer[] coordinate, BgOrgUnitInfo bgOrgUnit) throws BOSException {
        if (dims == null || dims.isEmpty() || sheet == null || coordinate == null) {
            return;
        }
        Object obj = null;
        BgDimensionBaseInfo dimension = null;
        BgDimensionMember member = null;
        MbgDimInfo mbgDim = null;
        BgPeriodInfo bgPeriod = (BgPeriodInfo)this.utils.getExpObjs()[1];
        CurrencyInfo currency = (CurrencyInfo)this.utils.getExpObjs()[0];
        BgVersionInfo version = (BgVersionInfo)this.utils.getExpObjs()[2];
        int rowIndex = coordinate[0];
        int colIndex = coordinate[1];
        this.sa.setBackground(Color.yellow);
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            obj = dims.get(i);
            if (!(obj instanceof BgDimensionBaseInfo) || DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals((dimension = (BgDimensionBaseInfo)obj).getNumber())) continue;
            if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                BgExportUtils.transBgPeriodMember(dimension, this.utils.getMemberCacheMap(), bgPeriod);
            }
            mbgDim = this.utils.getMbgNumMap().get(dimension.getNumber());
            member = null;
            if (!dimension.getMember().isEmpty()) {
                member = (BgDimensionMember)dimension.getMember().get(0);
            }
            sheet.setCell(rowIndex, colIndex++, (Object)(mbgDim.getName() + this.number), (ShareStyleAttributes)this.sa);
            if (member != null) {
                sheet.setCell(rowIndex, colIndex++, (Object)member.getNumber(), (ShareStyleAttributes)this.sa);
            } else if (DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(mbgDim.getNumber())) {
                sheet.setCell(rowIndex, colIndex++, (Object)currency.getNumber(), (ShareStyleAttributes)this.sa);
            } else if (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(mbgDim.getNumber())) {
                sheet.setCell(rowIndex, colIndex++, (Object)version.getNumber(), (ShareStyleAttributes)this.sa);
            } else if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(mbgDim.getNumber())) {
                sheet.setCell(rowIndex, colIndex++, (Object)bgPeriod.getNumber(), (ShareStyleAttributes)this.sa);
            } else {
                sheet.setCell(rowIndex, colIndex++, null, (ShareStyleAttributes)this.sa);
            }
            sheet.setCell(rowIndex, colIndex++, (Object)(mbgDim.getName() + this.name), (ShareStyleAttributes)this.sa);
            if (member != null) {
                sheet.setCell(rowIndex, colIndex++, (Object)member.getName(), (ShareStyleAttributes)this.sa);
                continue;
            }
            if (DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(mbgDim.getNumber())) {
                sheet.setCell(rowIndex, colIndex++, (Object)currency.getName(), (ShareStyleAttributes)this.sa);
                continue;
            }
            if (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(mbgDim.getNumber())) {
                sheet.setCell(rowIndex, colIndex++, (Object)version.getName(), (ShareStyleAttributes)this.sa);
                continue;
            }
            if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(mbgDim.getNumber())) {
                sheet.setCell(rowIndex, colIndex++, (Object)bgPeriod.getName(), (ShareStyleAttributes)this.sa);
                continue;
            }
            sheet.setCell(rowIndex, colIndex++, null, (ShareStyleAttributes)this.sa);
        }
        coordinate[0] = rowIndex;
        coordinate[1] = colIndex;
    }

    public void outRowAndCol(int templateType, List rows, List cols, KDSSheet sheet, Integer[] coordinate, BgOrgUnitInfo bgOrgUnit) throws BOSException {
        boolean check;
        int i;
        if (rows == null || rows.isEmpty() || cols == null || cols.isEmpty() || sheet == null || coordinate == null) {
            return;
        }
        MbgViewListDimensionInfo obj = null;
        MbgViewListRowCol row = null;
        MbgViewListRowCol col = null;
        BgDimensionBaseInfo dimension = null;
        int rowDimSize = 0;
        int colDimSize = 0;
        if (templateType == 2) {
            int i2;
            int in = rows.size();
            for (i2 = 0; i2 < in; ++i2) {
                obj = (MbgViewListDimensionInfo)rows.get(i2);
                if (!(obj instanceof MbgViewListRowCol)) continue;
                row = (MbgViewListRowCol)((Object)obj);
                rowDimSize = row.getDimensions().size();
                break;
            }
            in = cols.size();
            for (i2 = 0; i2 < in; ++i2) {
                obj = (MbgViewListDimensionInfo)cols.get(i2);
                if (!(obj instanceof MbgViewListRowCol)) continue;
                col = (MbgViewListRowCol)((Object)obj);
                colDimSize = col.getDimensions().size();
                break;
            }
        } else if (templateType == 4) {
            rowDimSize = rows.size();
            colDimSize = cols.size();
        }
        Integer[] dimSize = new Integer[]{rowDimSize, colDimSize};
        this.sa.setBackground(Color.orange);
        if (templateType == 2) {
            if (row != null) {
                int in = row.getDimensions().size();
                for (i = 0; i < in; ++i) {
                    obj = row.getDimensions().get(i);
                    if (!(obj instanceof BgDimensionBaseInfo)) continue;
                    dimension = obj;
                    coordinate = this.outRowDimension(sheet, coordinate, dimSize, dimension, this.sa);
                }
            }
        } else if (templateType == 4) {
            int in = rows.size();
            for (i = 0; i < in; ++i) {
                obj = (MbgViewListDimensionInfo)rows.get(i);
                if (!(obj instanceof BgDimensionBaseInfo)) continue;
                dimension = obj;
                coordinate = this.outRowDimension(sheet, coordinate, dimSize, dimension, this.sa);
            }
        }
        if (check = this.checkMbgDimMember(cols)) {
            coordinate = this.outCols(templateType, cols, sheet, coordinate, bgOrgUnit);
        }
        boolean bl = check = this.checkMbgDimMember(rows) || this.checkMbgDimRelation(rows);
        if (check) {
            coordinate[0] = coordinate[0] + colDimSize;
            coordinate[1] = 0;
            coordinate = this.outRows(templateType, rows, sheet, coordinate, bgOrgUnit);
        }
    }

    public void outColDimension(KDSSheet sheet, List<BgDimensionBaseInfo> dimensions, StyleAttributes sa) {
        if (sheet == null || dimensions == null || dimensions.isEmpty()) {
            return;
        }
        BgDimensionBaseInfo dimension = null;
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            dimension = dimensions.get(i);
            sheet.setCell(2, i * 2, (Object)dimension.getNumber(), (ShareStyleAttributes)sa);
            sheet.setCell(2, i * 2 + 1, (Object)dimension.getName(), (ShareStyleAttributes)sa);
        }
        sheet.setRowHeight(2, 0.0f);
    }

    public Integer[] outRowDimension(KDSSheet sheet, Integer[] coordinate, Integer[] rowColSize, BgDimensionBaseInfo dimension, StyleAttributes sa) {
        int j;
        if (sheet == null || coordinate == null || rowColSize == null || dimension == null) {
            return coordinate;
        }
        int rowIndex = coordinate[0];
        int colIndex = coordinate[1];
        int rowDimSize = rowColSize[0];
        int colDimSize = rowColSize[1];
        MbgDimInfo mbgDim = this.utils.getMbgNumMap().get(dimension.getNumber());
        int jn = rowIndex + colDimSize;
        for (j = rowIndex; j < jn; ++j) {
            sheet.setCell(j, colIndex, null, (ShareStyleAttributes)sa);
        }
        if (colDimSize > 1) {
            sheet.getMerges().addMerge(rowIndex, colIndex, rowIndex + colDimSize - 1, colIndex);
        }
        sheet.setCell(rowIndex, colIndex++, (Object)(mbgDim.getName() + this.number), (ShareStyleAttributes)sa);
        jn = rowIndex + colDimSize;
        for (j = rowIndex; j < jn; ++j) {
            sheet.setCell(j, colIndex, null, (ShareStyleAttributes)sa);
        }
        if (colDimSize > 1) {
            sheet.getMerges().addMerge(rowIndex, colIndex, rowIndex + colDimSize - 1, colIndex);
        }
        sheet.setCell(rowIndex, colIndex++, (Object)(mbgDim.getName() + this.name), (ShareStyleAttributes)sa);
        coordinate[0] = rowIndex;
        coordinate[1] = colIndex;
        return coordinate;
    }

    private boolean checkMbgDimMember(List dims) {
        boolean check = true;
        if (dims == null || dims.isEmpty()) {
            return false;
        }
        MbgViewListDimensionInfo obj = null;
        MbgViewListRowCol viewListRowCol = null;
        BgDimensionBaseInfo dimension = null;
        MbgViewListDimensionInfo viewDim = null;
        BgPeriodInfo bgPeriod = (BgPeriodInfo)this.utils.getExpObjs()[1];
        int in = dims.size();
        block0: for (int i = 0; i < in; ++i) {
            obj = (MbgViewListDimensionInfo)dims.get(i);
            if (obj instanceof MbgViewListRowCol) {
                viewListRowCol = (MbgViewListRowCol)dims.get(i);
                int jn = viewListRowCol.getDimensions().size();
                for (int j = 0; j < jn; ++j) {
                    obj = viewListRowCol.getDimensions().get(j);
                    if (!(obj instanceof MbgViewListDimensionInfo) || !(viewDim = obj).getMember().isEmpty() || !viewDim.getSelectMembers().isEmpty()) continue;
                    check = false;
                    if (!DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(viewDim.getNumber())) continue block0;
                    check = true;
                    continue block0;
                }
                continue;
            }
            if (!(obj instanceof BgDimensionBaseInfo) || !(dimension = (BgDimensionBaseInfo)obj).getMember().isEmpty()) continue;
            check = false;
            if (!DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) break;
            check = true;
            break;
        }
        return check;
    }

    private boolean checkMbgDimRelation(List dims) {
        boolean check = false;
        if (dims == null || dims.isEmpty()) {
            return check;
        }
        Object obj = null;
        MbgViewListRowCol viewListRowCol = null;
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            obj = dims.get(i);
            if (!(obj instanceof MbgViewListRowCol)) continue;
            viewListRowCol = obj;
            if (viewListRowCol.isCombin()) {
                check = false;
                break;
            }
            if (viewListRowCol.getRelationMaps() == null || viewListRowCol.getRelationMaps().isEmpty()) continue;
            check = true;
            break;
        }
        return check;
    }

    public Integer[] outCols(int templateType, List cols, KDSSheet sheet, Integer[] coordinate, BgOrgUnitInfo bgOrgUnit) throws BOSException {
        if (cols == null || cols.isEmpty() || sheet == null || coordinate == null) {
            return coordinate;
        }
        int rowIndex = coordinate[0];
        int colIndex = coordinate[1];
        String field = null;
        String key = null;
        String[] tmpStrs = null;
        ArrayList<Collection<String>> mbgMembers = new ArrayList<Collection<String>>();
        ArrayList<String> fields = new ArrayList<String>();
        HashMap<String, String> memberNameMap = new HashMap<String, String>();
        MbgViewListDimensionInfo obj = null;
        MbgViewListRowCol viewListRowCol = null;
        BgDimensionBaseInfo dimension = null;
        MbgViewListDimensionInfo viewDim = null;
        ArrayList<BgDimensionBaseInfo> colDimensions = new ArrayList<BgDimensionBaseInfo>();
        this.sa.setBackground(Color.green);
        if (templateType == 2) {
            int in = cols.size();
            for (int i = 0; i < in; ++i) {
                obj = (MbgViewListDimensionInfo)cols.get(i);
                if (!(obj instanceof MbgViewListRowCol)) continue;
                viewListRowCol = (MbgViewListRowCol)cols.get(i);
                mbgMembers.clear();
                ArrayList<String[]> period = new ArrayList<String[]>();
                BgPeriodInfo bgPeriod = (BgPeriodInfo)this.utils.getExpObjs()[1];
                int xn = viewListRowCol.getDimensions().size();
                for (int x = 0; x < xn; ++x) {
                    obj = viewListRowCol.getDimensions().get(x);
                    if (!(obj instanceof MbgViewListDimensionInfo)) continue;
                    viewDim = obj;
                    if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(viewDim.getNumber()) && viewDim.getValue() == null || StringUtils.isEmpty((String)viewDim.getValue())) {
                        period.add(new String[]{DimensionBaseConstants.DEF_PERIOD_NUMBER, bgPeriod.getNumber() + "_" + bgPeriod.getName()});
                    }
                    this.transDimension(viewDim, fields, mbgMembers, memberNameMap, bgOrgUnit);
                    if (i != 0) continue;
                    colDimensions.add(viewDim);
                }
                int beginRow = rowIndex;
                int beginCol = colIndex;
                List<String[]> members = Arrays.Cartesian1(mbgMembers);
                members.addAll(period);
                int x = 0;
                int xn2 = members.size();
                while (x < xn2) {
                    String[] a = members.get(x);
                    if (!DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(a[0])) {
                        tmpStrs = members.get(x);
                        for (int y = 0; y < tmpStrs.length; ++y) {
                            field = (String)fields.get(y);
                            key = field + ":" + tmpStrs[y];
                            sheet.setCell(rowIndex + y, colIndex, (Object)(tmpStrs[y] + "_" + (String)memberNameMap.get(key)), (ShareStyleAttributes)this.sa);
                        }
                    } else {
                        sheet.setCell(rowIndex, colIndex, (Object)a[1], (ShareStyleAttributes)this.sa);
                    }
                    ++x;
                    ++colIndex;
                }
                this.mergeRowCols(sheet, members, new Integer[]{beginRow, beginCol}, false);
            }
        } else if (templateType == 4) {
            int jn = cols.size();
            for (int j = 0; j < jn; ++j) {
                obj = (MbgViewListDimensionInfo)cols.get(j);
                if (!(obj instanceof BgDimensionBaseInfo)) continue;
                dimension = obj;
                this.transDimension(dimension, fields, mbgMembers, memberNameMap, bgOrgUnit);
                colDimensions.add(dimension);
            }
            int beginRow = rowIndex;
            int beginCol = colIndex;
            List<String[]> members = Arrays.Cartesian1(mbgMembers);
            int x = 0;
            int xn = members.size();
            while (x < xn) {
                tmpStrs = members.get(x);
                for (int y = 0; y < tmpStrs.length; ++y) {
                    field = (String)fields.get(y);
                    key = field + ":" + tmpStrs[y];
                    sheet.setCell(rowIndex + y, colIndex, (Object)(tmpStrs[y] + "_" + (String)memberNameMap.get(key)), (ShareStyleAttributes)this.sa);
                }
                ++x;
                ++colIndex;
            }
            this.mergeRowCols(sheet, members, new Integer[]{beginRow, beginCol}, false);
        }
        this.outColDimension(sheet, colDimensions, this.sa);
        coordinate[0] = rowIndex;
        coordinate[1] = colIndex;
        return coordinate;
    }

    private void mergeRowCols(KDSSheet sheet, List<String[]> members, Integer[] coordinate, boolean hasRow) {
        if (sheet == null || members == null || members.isEmpty() || coordinate == null) {
            return;
        }
        int rowIndex = coordinate[0];
        int colIndex = coordinate[1];
        String[] member = members.get(0);
        String[] tmpMember = null;
        tmpMember = new String[member.length];
        System.arraycopy(member, 0, tmpMember, 0, member.length);
        if (hasRow) {
            int i;
            int[] rows = new int[member.length];
            for (i = 0; i < member.length; ++i) {
                rows[i] = rowIndex;
            }
            int in = members.size();
            for (i = 1; i < in; ++i) {
                member = members.get(i);
                for (int j = 0; j < member.length; ++j) {
                    if (member[j].equals(tmpMember[j])) continue;
                    if (rowIndex + i - rows[j] > 1) {
                        sheet.getMerges().addMerge(rows[j], colIndex + j * 2, rowIndex + i - 1, colIndex + j * 2);
                        sheet.getMerges().addMerge(rows[j], colIndex + j * 2 + 1, rowIndex + i - 1, colIndex + j * 2 + 1);
                    }
                    rows[j] = rowIndex + i;
                    tmpMember[j] = member[j];
                }
            }
            for (int j = 0; j < tmpMember.length; ++j) {
                if (rowIndex + members.size() - rows[j] <= 1) continue;
                sheet.getMerges().addMerge(rows[j], colIndex + j * 2, rowIndex + members.size() - 1, colIndex + j * 2);
                sheet.getMerges().addMerge(rows[j], colIndex + j * 2 + 1, rowIndex + members.size() - 1, colIndex + j * 2 + 1);
            }
        } else {
            int i;
            int[] cols = new int[member.length];
            for (i = 0; i < member.length; ++i) {
                cols[i] = colIndex;
            }
            int in = members.size();
            for (i = 1; i < in; ++i) {
                member = members.get(i);
                for (int j = 0; j < member.length; ++j) {
                    if (member[j].equals(tmpMember[j])) continue;
                    if (colIndex + i - cols[j] > 1) {
                        sheet.getMerges().addMerge(rowIndex + j, cols[j], rowIndex + j, colIndex + i - 1);
                    }
                    cols[j] = colIndex + i;
                    tmpMember[j] = member[j];
                }
            }
            for (int j = 0; j < tmpMember.length; ++j) {
                if (colIndex + members.size() - cols[j] <= 1) continue;
                sheet.getMerges().addMerge(rowIndex + j, cols[j], rowIndex + j, colIndex + members.size() - 1);
            }
        }
    }

    public Integer[] outRows(int templateType, List rows, KDSSheet sheet, Integer[] coordinate, BgOrgUnitInfo bgOrgUnit) throws BOSException {
        if (rows == null || rows.isEmpty() || sheet == null || coordinate == null) {
            return coordinate;
        }
        int rowIndex = coordinate[0];
        int colIndex = coordinate[1];
        String field = null;
        String key = null;
        String[] tmpStrs = null;
        ArrayList<Collection<String>> mbgMembers = new ArrayList<Collection<String>>();
        ArrayList<String> fields = new ArrayList<String>();
        HashMap<String, String> memberNameMap = new HashMap<String, String>();
        MbgViewListDimensionInfo obj = null;
        MbgViewListRowCol viewListRowCol = null;
        BgDimensionBaseInfo dimension = null;
        this.sa.setBackground(Styles.getNullColor());
        if (templateType == 2) {
            int in = rows.size();
            for (int i = 0; i < in; ++i) {
                obj = (MbgViewListDimensionInfo)rows.get(i);
                if (!(obj instanceof MbgViewListRowCol)) continue;
                viewListRowCol = (MbgViewListRowCol)rows.get(i);
                mbgMembers.clear();
                int xn = viewListRowCol.getDimensions().size();
                for (int x = 0; x < xn; ++x) {
                    obj = viewListRowCol.getDimensions().get(x);
                    if (!(obj instanceof BgDimensionBaseInfo)) continue;
                    dimension = obj;
                    this.transDimension(dimension, fields, mbgMembers, memberNameMap, bgOrgUnit);
                }
                int beginRow = rowIndex;
                int beginCol = colIndex;
                List<String[]> members = Arrays.Cartesian1(mbgMembers);
                int x = 0;
                int xn2 = members.size();
                while (x < xn2) {
                    tmpStrs = members.get(x);
                    for (int y = 0; y < tmpStrs.length; ++y) {
                        field = (String)fields.get(y);
                        key = field + ":" + tmpStrs[y];
                        sheet.setCell(rowIndex, colIndex + y * 2, (Object)tmpStrs[y], (ShareStyleAttributes)this.sa);
                        sheet.setCell(rowIndex, colIndex + y * 2 + 1, memberNameMap.get(key), (ShareStyleAttributes)this.sa);
                    }
                    ++x;
                    ++rowIndex;
                }
                this.mergeRowCols(sheet, members, new Integer[]{beginRow, beginCol}, true);
            }
        } else if (templateType == 4) {
            int in = rows.size();
            for (int i = 0; i < in; ++i) {
                obj = (MbgViewListDimensionInfo)rows.get(i);
                if (!(obj instanceof BgDimensionBaseInfo)) continue;
                dimension = obj;
                this.transDimension(dimension, fields, mbgMembers, memberNameMap, bgOrgUnit);
            }
            int beginRow = rowIndex;
            int beginCol = colIndex;
            List<String[]> members = Arrays.Cartesian1(mbgMembers);
            int x = 0;
            int xn = members.size();
            while (x < xn) {
                tmpStrs = members.get(x);
                for (int y = 0; y < tmpStrs.length; ++y) {
                    field = (String)fields.get(y);
                    key = field + ":" + tmpStrs[y];
                    sheet.setCell(rowIndex, colIndex + y * 2, (Object)tmpStrs[y], (ShareStyleAttributes)this.sa);
                    sheet.setCell(rowIndex, colIndex + y * 2 + 1, memberNameMap.get(key), (ShareStyleAttributes)this.sa);
                }
                ++x;
                ++rowIndex;
            }
            this.mergeRowCols(sheet, members, new Integer[]{beginRow, beginCol}, true);
        }
        coordinate[0] = rowIndex;
        coordinate[1] = colIndex;
        return coordinate;
    }

    private void transDimension(BgDimensionBaseInfo dimension, List<String> fields, Collection<Collection<String>> mbgMembers, Map<String, String> memberNameMap, BgOrgUnitInfo bgOrgUnit) throws BOSException {
        int x;
        if (dimension == null || fields == null || mbgMembers == null || memberNameMap == null || bgOrgUnit == null) {
            return;
        }
        Object obj = null;
        MbgViewListDimensionInfo viewDim = null;
        BgDimensionMember member = null;
        BgPeriodInfo bgPeriod = (BgPeriodInfo)this.utils.getExpObjs()[1];
        if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
            BgExportUtils.transBgPeriodMember(dimension, this.utils.getMemberCacheMap(), bgPeriod);
        }
        String field = DimUtils.getDimensionField(dimension);
        fields.add(field);
        HashSet<String> mbgMemberSet = new HashSet<String>();
        ArrayList<String> mbgMember = new ArrayList<String>();
        mbgMembers.add(mbgMember);
        int xn = dimension.getMember().size();
        for (x = 0; x < xn; ++x) {
            member = (BgDimensionMember)dimension.getMember().get(x);
            if (mbgMemberSet.contains(member.getNumber())) continue;
            mbgMemberSet.add(member.getNumber());
            mbgMember.add(member.getNumber());
            memberNameMap.put(field + ":" + member.getNumber(), member.getName());
        }
        if (dimension instanceof MbgViewListDimensionInfo && !(viewDim = (MbgViewListDimensionInfo)dimension).getSelectMembers().isEmpty()) {
            xn = viewDim.getSelectMembers().size();
            for (x = 0; x < xn; ++x) {
                obj = viewDim.getSelectMembers().get(x);
                if (!(obj instanceof BgDimensionMember) || mbgMemberSet.contains((member = (BgDimensionMember)obj).getNumber())) continue;
                mbgMemberSet.add(member.getNumber());
                mbgMember.add(member.getNumber());
                memberNameMap.put(field + ":" + member.getNumber(), member.getName());
            }
        }
        BgExportUtils.filterMember(bgOrgUnit, dimension.getNumber(), mbgMember);
    }

    public void outCommInfo(KDSBook kdsBook, BgTemplateInfo templateInfo, BgOrgUnitInfo bgOrgUnit, Object[] expObjs) throws Exception {
        if (kdsBook == null || templateInfo == null || bgOrgUnit == null || expObjs == null) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)expObjs[0];
        BgPeriodInfo bgPeriod = (BgPeriodInfo)expObjs[1];
        BgVersionInfo version = (BgVersionInfo)expObjs[2];
        KDSSheet sheet = new KDSSheet(kdsBook, COMMON_SHEET, (ShareStyleAttributes)this.sa);
        sheet.setCell(0, 0, (Object)bgOrgUnit.getName(), (ShareStyleAttributes)this.sa);
        sheet.setCell(0, 1, (Object)bgOrgUnit.getNumber(), (ShareStyleAttributes)this.sa);
        sheet.setCell(1, 0, (Object)bgPeriod.getName(), (ShareStyleAttributes)this.sa);
        sheet.setCell(1, 1, (Object)bgPeriod.getNumber(), (ShareStyleAttributes)this.sa);
        sheet.setCell(2, 0, (Object)templateInfo.getName(), (ShareStyleAttributes)this.sa);
        sheet.setCell(2, 1, (Object)templateInfo.getNumber(), (ShareStyleAttributes)this.sa);
        sheet.setCell(3, 0, (Object)version.getName(), (ShareStyleAttributes)this.sa);
        sheet.setCell(3, 1, (Object)version.getNumber(), (ShareStyleAttributes)this.sa);
        sheet.setCell(4, 0, (Object)currency.getName(), (ShareStyleAttributes)this.sa);
        sheet.setCell(4, 1, (Object)currency.getNumber(), (ShareStyleAttributes)this.sa);
        kdsBook.addSheet(null, sheet);
    }
}

