/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.mbg.formula.IMbgFormulaConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgExpressionsParseHelper
implements IMbgFormulaConstants {
    private static final Logger logger = Logger.getLogger(BgExpressionsParseHelper.class);
    public static final String IF_STR = "IF";
    public static final String EXPR_BGITEM_VARIABLE = "@";
    public static final String SELF_TEMPLATE_GROUPTYPE = "SelfDefineAnalysisTemplateGroup";
    public static final String CONVERT_RESULT = "CONVERT_RESULT";
    private static final String IS_TARGET_EXPR = "isTargetExpr";

    public static void processBgItemCombine(Expression expr, HashMap bgItemCombinMap) {
        if (expr == null) {
            return;
        }
        List list = null;
        FunctionExpr funExpr = null;
        if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr boExpr = (BinaryOperationExpr)expr;
            BgExpressionsParseHelper.processBinaryOperationExpr(boExpr, bgItemCombinMap);
        }
        if (expr instanceof FunctionExpr) {
            funExpr = (FunctionExpr)expr;
            list = funExpr.parameters;
        }
        if (funExpr != null && BgExpressionsParseHelper.isTheTargetExpression(funExpr.funcionName)) {
            String strItemCombi = ((StringExpr)list.get((int)3)).value;
            if ("MbgCsl".equalsIgnoreCase(funExpr.funcionName) || "MbgBgAvlBal".equalsIgnoreCase(funExpr.funcionName)) {
                strItemCombi = ((StringExpr)list.get((int)4)).value;
            } else if ("MbgCorUnit".equalsIgnoreCase(funExpr.funcionName)) {
                strItemCombi = ((StringExpr)list.get((int)5)).value;
            }
            bgItemCombinMap.put(strItemCombi, null);
        }
        if (list == null) {
            return;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof FunctionExpr)) continue;
            FunctionExpr funExprTmp = (FunctionExpr)obj;
            BgExpressionsParseHelper.processBgItemCombine((Expression)funExprTmp, bgItemCombinMap);
        }
    }

    private static void processBinaryOperationExpr(BinaryOperationExpr boExpr, HashMap bgItemCombinMap) {
        BgExpressionsParseHelper.processBgItemCombine(boExpr.left, bgItemCombinMap);
        BgExpressionsParseHelper.processBgItemCombine(boExpr.right, bgItemCombinMap);
    }

    public static boolean parseExprHasBgItemVariable(Cell cell) {
        if (BgNFSHelper.checkHasExpression(cell)) {
            String expressions = BgNFSHelper.getExpression(cell);
            String _expressions = null;
            HashMap isTargetExpr = new HashMap();
            _expressions = BgExpressionsParseHelper.processExprForBgItemCombin(expressions, new HashMap(), true, null, null, isTargetExpr);
            if (StringUtils.isEmpty((String)_expressions)) {
                return false;
            }
            if (isTargetExpr.get(IS_TARGET_EXPR) != null) {
                return (Boolean)isTargetExpr.get(IS_TARGET_EXPR);
            }
            return false;
        }
        return false;
    }

    public static String processExprForBgItemCombin(String expressions, final Map bgItemCombinMap, final boolean needItemVariable, final String itemCombinStr, final Map convertResult, final Map isTargetExpr) {
        if (StringUtils.isEmpty((String)expressions) || bgItemCombinMap == null) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (expression instanceof Ref3DExpr) {
                return null;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgExpressionsParseHelper.checkExpression(expr, bgItemCombinMap, needItemVariable, itemCombinStr, convertResult, isTargetExpr);
                }
            });
            _expressions = '=' + expression.toString();
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    protected static Expression checkExpression(Expression expression, Map bgItemCombinMap, boolean needItemVariable, String itemCombinStr, Map convertResult, Map isTargetExpr) {
        if (expression instanceof FunctionExpr) {
            expression = BgExpressionsParseHelper.checkFunctionExpr((FunctionExpr)expression, bgItemCombinMap, needItemVariable, itemCombinStr, convertResult, isTargetExpr);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgExpressionsParseHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, bgItemCombinMap, needItemVariable, itemCombinStr, convertResult, isTargetExpr);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, Map bgItemCombinMap, boolean needItemVariable, String itemCombinStr, Map convertResult, Map isTargetExpr) {
        String funcionName = funExpr.funcionName;
        try {
            if (BgExpressionsParseHelper.isTheTargetExpression(funcionName)) {
                FunctionExpr _expression = funExpr;
                Expression p0 = (Expression)funExpr.parameters.get(0);
                if (p0 instanceof StringExpr) {
                    StringExpr sp = (StringExpr)p0;
                    String valueStr = sp.value;
                    String[] pp = valueStr.split(";");
                    if (pp != null && pp.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < pp.length; ++i) {
                            funExpr.parameters.set(0, new StringExpr(pp[i]));
                            if (sb.length() > 1) {
                                sb.append('+');
                            }
                            funExpr.output(sb);
                        }
                        _expression = ExcelFormulaPaserHelper.parse((String)sb.toString());
                        _expression = BgExpressionsParseHelper.checkExpression((Expression)_expression, bgItemCombinMap, needItemVariable, itemCombinStr, convertResult, isTargetExpr);
                    }
                }
                if (_expression instanceof FunctionExpr) {
                    BgExpressionsParseHelper.checkExpressionParam(_expression, bgItemCombinMap, needItemVariable, itemCombinStr, convertResult, isTargetExpr);
                }
                return _expression;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, Map bgItemCombinMap, boolean needItemVariable, String itemCombinStr, Map convertResult, Map isTargetExpr) {
        boExpr.left = BgExpressionsParseHelper.checkExpression(boExpr.left, bgItemCombinMap, needItemVariable, itemCombinStr, convertResult, isTargetExpr);
        boExpr.right = BgExpressionsParseHelper.checkExpression(boExpr.right, bgItemCombinMap, needItemVariable, itemCombinStr, convertResult, isTargetExpr);
        return boExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, Map bgItemCombinMap, boolean needItemVariable, String itemCombinStr, Map convertResult, Map isTargetExpr) {
        String funcionName = funExpr.funcionName;
        List parameter = funExpr.parameters;
        if (BgExpressionsParseHelper.isTheTargetExpression(funcionName)) {
            StringExpr param3 = (StringExpr)parameter.get(3);
            if ("MbgCsl".equalsIgnoreCase(funcionName)) {
                param3 = (StringExpr)parameter.get(4);
            }
            BgExpressionsParseHelper.putIsTargetExpr(isTargetExpr, new Boolean(EXPR_BGITEM_VARIABLE.equals(param3.value)));
            if (!StringUtils.isEmpty((String)itemCombinStr)) {
                param3.value = itemCombinStr;
                BgExpressionsParseHelper.putConvertResult(convertResult, Boolean.TRUE);
                return;
            }
            if (EXPR_BGITEM_VARIABLE.equals(param3.value) && needItemVariable) {
                BgExpressionsParseHelper.putConvertResult(convertResult, Boolean.TRUE);
                return;
            }
            if (bgItemCombinMap.isEmpty()) {
                BgExpressionsParseHelper.putConvertResult(convertResult, Boolean.TRUE);
                return;
            }
            String strItemCombi = param3.value;
            String _strItemCombi = null;
            Object[] obj = (Object[])bgItemCombinMap.get(strItemCombi);
            if (obj != null && obj.length >= 2 && obj[1] != null && !((Boolean)obj[1]).booleanValue()) {
                _strItemCombi = (String)obj[0];
            }
            if (_strItemCombi == null) {
                param3.value = "";
                BgExpressionsParseHelper.putConvertResult(convertResult, Boolean.FALSE);
            }
            if (strItemCombi != null && _strItemCombi != null && !strItemCombi.equals(_strItemCombi) && !_strItemCombi.equals("")) {
                param3.value = _strItemCombi;
                BgExpressionsParseHelper.putConvertResult(convertResult, Boolean.TRUE);
            }
        }
    }

    private static void putConvertResult(Map convertMap, Boolean bSuccess) {
        if (convertMap != null) {
            convertMap.put(CONVERT_RESULT, bSuccess);
        }
    }

    private static void putIsTargetExpr(Map isTargetExpr, Boolean bSuccess) {
        if (isTargetExpr != null) {
            isTargetExpr.put(IS_TARGET_EXPR, bSuccess);
        }
    }

    public static boolean isTheTargetExpression(String funcionName) {
        return "Mbgadjust".equalsIgnoreCase(funcionName) || "MbgAdjustDate".equalsIgnoreCase(funcionName) || "MbgBgAvlBal".equalsIgnoreCase(funcionName) || "MbgAggregate".equalsIgnoreCase(funcionName) || "MbgCsl".equalsIgnoreCase(funcionName) || "MbgControl".equalsIgnoreCase(funcionName) || "MbgCorUnit".equalsIgnoreCase(funcionName);
    }

    public static boolean isSumExpress(String exprStr) {
        boolean isSum = false;
        try {
            Expression expression = ExcelFormulaPaserHelper.parse((String)exprStr);
            if (expression instanceof FunctionExpr && "sum".equalsIgnoreCase(((FunctionExpr)expression).funcionName)) {
                isSum = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return isSum;
    }
}

