/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.mbg.cube.query.IDimData;
import com.kingdee.eas.ma.mbg.utils.BgFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class BgFormDiversityHelper {
    public static void updateChangeValueInfo(Book _book, Map<String, IDimData> initValueMap, Map<String, BgFormDiversityData> adjustMap, Map<String, Timestamp> lastUpdateTimeMap) {
        if (_book == null || initValueMap == null || adjustMap == null) {
            return;
        }
        Sheet _sheet = null;
        int size = _book.getSheetCount();
        for (int index = 0; index < size; ++index) {
            _sheet = _book.getSheet(index);
            BgFormDiversityHelper.updateSheetChangeValueInfo(initValueMap, adjustMap, lastUpdateTimeMap, _sheet);
        }
    }

    private static void updateSheetChangeValueInfo(Map<String, IDimData> initValueMap, Map<String, BgFormDiversityData> adjustMap, Map<String, Timestamp> lastUpdateTimeMap, Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                _cell = sheet.getCell(rowIndex, colIndex, false);
                BgFormDiversityHelper.updateCellChangeValueInfo(initValueMap, adjustMap, lastUpdateTimeMap, _cell);
            }
        }
    }

    private static void updateCellChangeValueInfo(Map<String, IDimData> initValueMap, Map<String, BgFormDiversityData> adjustMap, Map<String, Timestamp> lastUpdateTimeMap, Cell cell) {
        if (cell == null) {
            return;
        }
        Timestamp lastUpdateTime = null;
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            Object _obj = null;
            BigDecimal _newValue = null;
            BigDecimal _oldValue = null;
            String _formulaStr = null;
            _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
            _obj = BgNFSHelper.getValue(cell);
            if (_obj != null) {
                if (_obj instanceof BigDecimal) {
                    _newValue = (BigDecimal)_obj;
                } else {
                    try {
                        _newValue = new BigDecimal(_obj.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if ((lastUpdateTime = BgNFSHelper.getCellChangeLastUpdataTime(cell)) == null ? lastUpdateTimeMap.containsKey(_formulaStr) : lastUpdateTimeMap.get(_formulaStr) != null && lastUpdateTime.before(lastUpdateTimeMap.get(_formulaStr))) {
                return;
            }
            lastUpdateTimeMap.put(_formulaStr, lastUpdateTime);
            if (initValueMap.containsKey(_formulaStr)) {
                _oldValue = initValueMap.get(_formulaStr).getState() < 9 ? BgNConstants.ZERO : initValueMap.get(_formulaStr).getValue();
                if (_newValue != null && initValueMap.get(_formulaStr) != null && initValueMap.get(_formulaStr).getValue().compareTo(_newValue) != 0) {
                    if (adjustMap.containsKey(_formulaStr)) {
                        BgFormDiversityHelper.updateDivInfo(cell, _formulaStr, _newValue, adjustMap);
                    } else {
                        BgFormDiversityHelper.createDivInfo(cell, _formulaStr, _newValue, _oldValue, adjustMap);
                    }
                } else if (_newValue == null && initValueMap.get(_formulaStr).getState() < 9) {
                    if (adjustMap.containsKey(_formulaStr)) {
                        BgFormDiversityHelper.updateDivInfo(cell, _formulaStr, _newValue, adjustMap);
                    } else {
                        BgFormDiversityHelper.createDivInfo(cell, _formulaStr, _newValue, _oldValue, adjustMap);
                    }
                } else if (_newValue != null && (_oldValue == null || _newValue.compareTo(_oldValue) != 0)) {
                    if (adjustMap.containsKey(_formulaStr)) {
                        BgFormDiversityHelper.updateDivInfo(cell, _formulaStr, _newValue, adjustMap);
                    } else {
                        BgFormDiversityHelper.createDivInfo(cell, _formulaStr, _newValue, _oldValue, adjustMap);
                    }
                } else {
                    BgFormDiversityHelper.removeDivInfo(cell, _formulaStr, adjustMap);
                }
            } else if (_newValue != null) {
                BgFormDiversityHelper.createDivInfo(cell, _formulaStr, _newValue, BgNConstants.ZERO, adjustMap);
            }
        }
    }

    private static void removeDivInfo(Cell cell, String formulaStr, Map adjustMap) {
        adjustMap.remove(formulaStr);
        BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
    }

    public static void createDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue, Map adjustMap) {
        BgFormDiversityData divData = new BgFormDiversityData();
        divData.setFormula(formulaStr);
        divData.setNewValue(newValue);
        divData.setOldValue(oldValue);
        divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        adjustMap.put(formulaStr, divData);
        if (newValue == null) {
            BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
        } else {
            BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
        }
    }

    private static void updateDivInfo(Cell cell, String formulaStr, BigDecimal newValue, Map adjustMap) {
        BgFormDiversityData divData = (BgFormDiversityData)adjustMap.get(formulaStr);
        if (divData != null) {
            divData.setNewValue(newValue);
            divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        }
        BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
    }

    public static Map<String, Color> getOldFormCellColor(Book oldBook) {
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        if (null == oldBook) {
            return colorMap;
        }
        for (int s = 0; s < oldBook.getSheetCount(); ++s) {
            Sheet sheet = oldBook.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula itemFormula = BgNFSHelper.getItemFormula(cell);
                    if (itemFormula == null || BgNConstants.BASE_COLOR.equals(cell.getStyle().getBackground())) continue;
                    colorMap.put(cell.getName(false, true), cell.getStyle().getBackground());
                }
            }
        }
        return colorMap;
    }
}

