/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.Excel2007Reader;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormEntryFactory;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgIEException;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgMemberFacadeFactory;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgExportUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BgImportUtils {
    public BgSchemeInfo bgScheme = null;
    public BgOrgUnitInfo bgOrgUnit = null;
    public BgOrgUnitCollection orgUnits = null;
    public Map<String, BgOrgUnitInfo> filepaths = null;
    private Map<String, Set<String>> mbgDimOrgIds = null;
    private Map<String, MbgDimInfo> mbgNameMap = new HashMap<String, MbgDimInfo>();
    private Map<String, Map<String, Map<String, String[]>>> isSegMemberMap = null;
    private Map<String, Map<String, String[]>> shareMemberMap = null;
    private Map<String, Map<String, String>> propMap = new HashMap<String, Map<String, String>>();
    private Set<String> moneyEles = new HashSet<String>();
    private Map<BOSUuid, List<String>> warnings = new HashMap<BOSUuid, List<String>>();
    public List<List<String>> result = new ArrayList<List<String>>();
    public List<String> succeed = new ArrayList<String>();
    public List<String> defeated = new ArrayList<String>();
    public List<String> warning = new ArrayList<String>();
    private FileFilter filter;
    private int COMMON_ORGUNIT_INDEX;
    private int COMMON_PERIOD_INDEX;
    private int COMMON_TEMPLATE_INDEX;
    private int COMMON_VERSION_INDEX;
    private int COMMON_CURRENCY_INDEX;
    private int PROP_MEMBER_INDEX;
    private int PROP_PROPID_INDEX;
    private static final String name = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"275_BgItemForFpF7UI");
    private static final String number = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"277_BgItemForFpF7UI");
    private Set<String> currencyType;
    private BgSchemeDimensionHelper schemeHelper;

    public BgImportUtils() {
        this.result.add(this.succeed);
        this.result.add(this.defeated);
        this.result.add(this.warning);
        this.filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname == null || !pathname.isFile()) {
                    return false;
                }
                int lastIndex = pathname.getName().lastIndexOf(46);
                String str = pathname.getName().substring(lastIndex);
                return str.equalsIgnoreCase(".xlsx") || str.equalsIgnoreCase(".xls");
            }
        };
        this.COMMON_ORGUNIT_INDEX = 0;
        this.COMMON_PERIOD_INDEX = 1;
        this.COMMON_TEMPLATE_INDEX = 2;
        this.COMMON_VERSION_INDEX = 3;
        this.COMMON_CURRENCY_INDEX = 4;
        this.PROP_MEMBER_INDEX = 0;
        this.PROP_PROPID_INDEX = 1;
        this.currencyType = null;
        this.schemeHelper = null;
    }

    public void setBgScheme(BgSchemeInfo bgScheme) {
        this.bgScheme = bgScheme;
    }

    public BgSchemeInfo getBgScheme() {
        return this.bgScheme;
    }

    public void setBgOrgUnit(BgOrgUnitInfo bgOrgUnit) {
        this.bgOrgUnit = bgOrgUnit;
    }

    public BgOrgUnitInfo getBgOrgUnit() {
        return this.bgOrgUnit;
    }

    public void setOrgUnits(BgOrgUnitCollection orgUnits) {
        this.orgUnits = orgUnits;
    }

    public BgOrgUnitCollection getOrgUnits() {
        return this.orgUnits;
    }

    public void setFilepaths(Map<String, BgOrgUnitInfo> filepaths) {
        this.filepaths = filepaths;
    }

    public Map<String, BgOrgUnitInfo> getFilepaths() {
        return this.filepaths;
    }

    public void setMbgDimOrgIds(Map<String, Set<String>> mbgDimOrgIds) {
        this.mbgDimOrgIds = mbgDimOrgIds;
    }

    public Map<String, Set<String>> getMbgDimOrgIds() {
        if (this.mbgDimOrgIds == null) {
            this.mbgDimOrgIds = new HashMap<String, Set<String>>();
        }
        return this.mbgDimOrgIds;
    }

    public Map<String, MbgDimInfo> getMbgNameMap() {
        return this.mbgNameMap;
    }

    public void setMemberMaps(Map[] memberMaps) {
        if (memberMaps != null && memberMaps.length >= 1) {
            this.setIsSegMemberMap(memberMaps[0]);
        }
        if (memberMaps != null && memberMaps.length >= 2) {
            this.setShareMemberMap(memberMaps[1]);
        }
    }

    public void setIsSegMemberMap(Map<String, Map<String, Map<String, String[]>>> isSegMemberMap) {
        this.isSegMemberMap = isSegMemberMap;
    }

    public Map<String, Map<String, Map<String, String[]>>> getIsSegMemberMap() {
        return this.isSegMemberMap;
    }

    public void setShareMemberMap(Map<String, Map<String, String[]>> shareMemberMap) {
        this.shareMemberMap = shareMemberMap;
    }

    public Map<String, Map<String, String[]>> getShareMemberMap() {
        return this.shareMemberMap;
    }

    public Map<String, Map<String, String>> getPropMap() {
        return this.propMap;
    }

    protected void initElements() throws Exception {
        BgElementCollection colls = BgElementFactory.getRemoteInstance().getBgElementCollection();
        if (colls != null) {
            BgElementInfo element = null;
            int type = 0;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                element = colls.get(i);
                type = element.getDataType().getValue();
                if (0 != type) continue;
                this.moneyEles.add(element.getNumber());
            }
        }
    }

    public List<String> getWarnings(BOSUuid billId) {
        if (billId == null) {
            return null;
        }
        List<String> tmpList = this.warnings.get(billId);
        if (tmpList == null) {
            tmpList = new ArrayList<String>();
            this.warnings.put(billId, tmpList);
        }
        return tmpList;
    }

    public Map<String, BgOrgUnitInfo> importOrgUnitPath(String filepath) throws BOSException, EASBizException {
        LinkedHashMap<String, BgOrgUnitInfo> filepaths = new LinkedHashMap<String, BgOrgUnitInfo>();
        if (StringUtils.isEmpty((String)filepath) || this.getOrgUnits() == null || this.getOrgUnits().isEmpty()) {
            return filepaths;
        }
        HashMap<String, String> numNameMap = new HashMap<String, String>();
        int in = this.getOrgUnits().size();
        for (int i = 0; i < in; ++i) {
            this.importOrgUnitPath(filepath, this.getOrgUnits().get(i), numNameMap, filepaths);
        }
        return filepaths;
    }

    private void importOrgUnitPath(String filepath, BgOrgUnitInfo bgOrgUnit, Map<String, String> numNameMap, Map<String, BgOrgUnitInfo> filepaths) {
        if (StringUtils.isEmpty((String)filepath) || bgOrgUnit == null || numNameMap == null) {
            return;
        }
        numNameMap.put(bgOrgUnit.getNumber(), bgOrgUnit.getName().trim());
        String[] tmpStrs = bgOrgUnit.getLongNumber().split("!");
        if (tmpStrs != null) {
            File[] files;
            String tmpFilePath = filepath;
            String tmpName = null;
            for (int i = 0; i < tmpStrs.length; ++i) {
                tmpName = numNameMap.get(tmpStrs[i]);
                if (tmpName == null) continue;
                tmpFilePath = tmpFilePath + "/" + tmpName;
            }
            File file = new File(tmpFilePath);
            if (file.exists() && file.isDirectory() && (files = file.listFiles(this.filter)) != null && files.length > 0) {
                filepaths.put(tmpFilePath, bgOrgUnit);
            }
        }
    }

    public List<List<String>> importDatas() throws Exception {
        if (this.getBgScheme() == null || this.getFilepaths() == null || this.getOrgUnits() == null) {
            return this.result;
        }
        String filepath = null;
        File file = null;
        File[] files = null;
        Map.Entry<String, BgOrgUnitInfo> entry2 = null;
        BgOrgUnitInfo bgOrgUnit = null;
        MbgDimInfo mbgDim = null;
        MbgDimCollection mbgDims = MbgDimFactory.getRemoteInstance().getMbgDimCollection();
        DimUtils.addDefaultMbgDim(mbgDims, null);
        Set<String> mbgDimNums = this.getBgScheme().getDimNums();
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            mbgDim = mbgDims.get(i);
            if (!mbgDimNums.contains(mbgDim.getNumber())) continue;
            this.getMbgNameMap().put(mbgDim.getName().trim(), mbgDim);
        }
        this.setMemberMaps(MbgMemberFacadeFactory.getRemoteInstance().getMember(this.getBgScheme().getId(), false));
        this.initElements();
        String bgSchemeId = this.getBgScheme().getId().toString();
        String bgOrgViewId = this.getBgScheme().getEditOrgViewId().toString();
        for (Map.Entry<String, BgOrgUnitInfo> entry2 : this.getFilepaths().entrySet()) {
            filepath = entry2.getKey();
            bgOrgUnit = entry2.getValue();
            this.setMbgDimOrgIds(BgOrgUnitFactory.getRemoteInstance().getMbgDimOrgIds(bgSchemeId, bgOrgUnit.getOrgUnitID(), bgOrgViewId, null));
            file = new File(filepath);
            if (!file.isDirectory() || (files = file.listFiles(this.filter)) == null) continue;
            int in2 = files.length;
            for (int i = 0; i < in2; ++i) {
                file = files[i];
                try {
                    this.importData(file, bgOrgUnit);
                    continue;
                }
                catch (Exception ex) {
                    this.defeated.add(file.getPath() + " : (" + ex.getMessage() + ") \r\n");
                }
            }
        }
        return this.result;
    }

    public boolean importData(File file, BgOrgUnitInfo bgOrgUnit) throws Exception {
        if (file == null || bgOrgUnit == null) {
            return false;
        }
        boolean check = BgExportUtils.checkFile(file.getPath());
        if (!check) {
            throw new BgIEException(BgIEException.ERRORFILEBYLOCK, new String[]{file.getName()});
        }
        KDSBook book = null;
        if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
            book = POIXlsReader.parse((String)file.getPath());
        } else if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".xlsx")) {
            try {
                book = new Excel2007Reader().parse(file.getPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (book == null) {
            return false;
        }
        BgFormInfo bgForm = null;
        CommObj commonInfo = this.loadCommInfo(book);
        if (commonInfo != null) {
            bgForm = BgFormFactory.getRemoteInstance().loadANDAddnew(this.getBgScheme().getId(), BOSUuid.read((String)bgOrgUnit.getOrgUnitID()), commonInfo.toArray());
            if (bgForm == null) {
                throw new BgIEException(BgIEException.ERRORBGFORM);
            }
            if (bgForm.getBgTemplate().getFormType().getValue() == 0) {
                this.createNewData(bgForm);
                bgForm.setName(BgViewHelper.getBgFormName(bgForm.getCU(), bgForm.getOrgUnit(), bgForm.getBgTemplate(), bgForm.getBgPeriod(), bgForm.getBgVersion(), 80));
                this.loadFixDataInfo(bgOrgUnit, bgForm, book, commonInfo);
            } else {
                this.loadDataInfo(bgOrgUnit, bgForm, book, commonInfo);
            }
        } else {
            throw new BgIEException(BgIEException.ERROREXCELCOMMONINFO);
        }
        List<String> warnings = this.getWarnings(bgForm.getId());
        if (!warnings.isEmpty()) {
            StringBuffer warningStr = new StringBuffer();
            warningStr.append(file.getName() + " (");
            for (String warning : warnings) {
                warningStr.append(warning + ",");
            }
            warningStr.setLength(warningStr.length() - 1);
            this.warning.add(warningStr.toString() + ")\r\n");
        } else {
            this.succeed.add(file.getName());
        }
        return true;
    }

    private CommObj loadCommInfo(KDSBook book) throws Exception {
        CommObj common = null;
        if (book == null) {
            return common;
        }
        KDSSheet sheet = book.getSheet((Object)"common");
        if (sheet != null) {
            common = new CommObj();
            common.orgUnitName = (String)sheet.getCell(this.COMMON_ORGUNIT_INDEX, 0, true).getValue();
            common.orgUnitNum = (String)sheet.getCell(this.COMMON_ORGUNIT_INDEX, 1, true).getValue();
            common.bgPeriodName = (String)sheet.getCell(this.COMMON_PERIOD_INDEX, 0, true).getValue();
            common.bgPeriodNum = (String)sheet.getCell(this.COMMON_PERIOD_INDEX, 1, true).getValue();
            common.bgTemplateName = (String)sheet.getCell(this.COMMON_TEMPLATE_INDEX, 0, true).getValue();
            common.bgTemplateNum = (String)sheet.getCell(this.COMMON_TEMPLATE_INDEX, 1, true).getValue();
            common.versionName = (String)sheet.getCell(this.COMMON_VERSION_INDEX, 0, true).getValue();
            common.versionNum = (String)sheet.getCell(this.COMMON_VERSION_INDEX, 1, true).getValue();
            common.currencyName = (String)sheet.getCell(this.COMMON_CURRENCY_INDEX, 0, true).getValue();
            common.currencyNum = (String)sheet.getCell(this.COMMON_CURRENCY_INDEX, 1, true).getValue();
            if (StringUtils.isEmpty((String)common.orgUnitNum) || StringUtils.isEmpty((String)common.bgPeriodNum) || StringUtils.isEmpty((String)common.bgTemplateNum) || StringUtils.isEmpty((String)common.versionNum) || StringUtils.isEmpty((String)common.currencyNum)) {
                throw new BgIEException(BgIEException.ERROREXCELCOMMONINFO);
            }
        }
        return common;
    }

    private void loadFixDataInfo(BgOrgUnitInfo bgOrgUnit, BgFormInfo bgForm, KDSBook book, CommObj commonInfo) throws Exception {
        Book importBook;
        Sheet commonSheet;
        if (bgOrgUnit == null || bgForm == null || book == null || commonInfo == null) {
            return;
        }
        int temType = bgForm.getBgTemplate().getFormType().getValue();
        if (temType == 0 && (commonSheet = (importBook = KDSBookToBook.traslate((KDSBook)book)).getSheetByName("common")) != null) {
            this.createNewData(bgForm);
            if (StringUtils.isEmpty((String)bgForm.getName())) {
                bgForm.setName(BgViewHelper.getBgFormName(bgForm.getCU(), bgForm.getOrgUnit(), bgForm.getBgTemplate(), bgForm.getBgPeriod(), bgForm.getBgVersion(), 80));
            }
            importBook.removeSheet(commonSheet);
            importBook.setAutoCalculate(false);
            BgNFSHelper.setBudget((IObjectValue)bgForm);
            HashMap<String, Variant> cellMap = new HashMap<String, Variant>();
            BgNFSHelper.disableUndo(importBook);
            BgNFSHelper.disableCal(importBook);
            for (int s = 0; s < importBook.getSheetCount(); ++s) {
                Sheet sheet = importBook.getSheet(s);
                for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                    for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                        Cell cell = sheet.getCell(r, c, false);
                        if (cell == null) continue;
                        String key = cell.getSheet().getSheetName() + "_" + cell.getRow() + "_" + cell.getCol();
                        if (cell.getValue() == null || cellMap.containsKey(key)) continue;
                        cellMap.put(key, cell.getValue());
                    }
                }
            }
            if (!cellMap.isEmpty()) {
                Book formBook = bgForm.getBook();
                BgNFSHelper.disableUndo(formBook);
                BgNFSHelper.disableCal(formBook);
                for (int s = 0; s < formBook.getSheetCount(); ++s) {
                    Sheet sheet = formBook.getSheet(s);
                    for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                        for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                            String key;
                            Cell cell = sheet.getCell(r, c, false);
                            if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell) || !cellMap.containsKey(key = cell.getSheet().getSheetName() + "_" + cell.getRow() + "_" + cell.getCol())) continue;
                            BgNFSHelper.setValue(cell, cellMap.get(key));
                        }
                    }
                }
                bgForm.setBook(formBook);
            }
            BgFormFactory.getRemoteInstance().save((CoreBaseInfo)bgForm);
        }
    }

    private void loadDataInfo(BgOrgUnitInfo bgOrgUnit, BgFormInfo bgForm, KDSBook book, CommObj commonInfo) throws Exception {
        IMbgViewBase mbgViewManager;
        if (bgOrgUnit == null || bgForm == null || book == null || commonInfo == null) {
            return;
        }
        IMbgViewBase viewBase = this.getViewManager(bgForm);
        if (viewBase == null) {
            throw new BgIEException(BgIEException.ERRORVIEWMANAGER);
        }
        if (viewBase.getSheetManagers().size() >= book.getSheetCount()) {
            throw new BgIEException(BgIEException.ERRORVIEWMANAGER);
        }
        Map<String, IMember> vMembers = null;
        HashMap<String, IBgNData> mbgDatas = new HashMap<String, IBgNData>();
        Map<String, IBgNData> tmpDatas = null;
        IMbgSheetBase sheetManager = null;
        IBgDimensionManagerBase dimensionManager = null;
        HashMap propMember = new HashMap();
        HashMap propIdsMap = new HashMap();
        HashMap[] propsMap = new HashMap[2];
        propsMap[this.PROP_MEMBER_INDEX] = propMember;
        propsMap[this.PROP_PROPID_INDEX] = propIdsMap;
        KDSSheet sheet = null;
        int in = book.getSheetCount() - 1;
        for (int i = 0; i < in; ++i) {
            sheet = book.getSheet((Object)i);
            sheetManager = viewBase.getSheetManagers().get(i);
            dimensionManager = sheetManager.getDimensionManager();
            vMembers = this.loadVMember(bgOrgUnit, sheet, commonInfo);
            this.updatePVMbgMember(dimensionManager, vMembers);
            tmpDatas = this.loadRCData(bgOrgUnit, bgForm, sheet, dimensionManager, vMembers, commonInfo);
            if (tmpDatas == null || tmpDatas.isEmpty()) continue;
            mbgDatas.putAll(tmpDatas);
        }
        TemplateStyleInfo style = null;
        BgFormEntryInfo entry = null;
        int temType = bgForm.getBgTemplate().getFormType().getValue();
        if (temType == 2) {
            mbgViewManager = (MbgViewListManager)viewBase;
            style = MbgViewListXMLParser.parseStyle(bgForm.getBgTemplate().getStyleSet().getData());
            entry = bgForm.getEntries().get(0);
            entry.setDimensionData(new MbgViewListXMLParser().unParse((MbgViewListManager)mbgViewManager));
        } else if (temType == 4) {
            mbgViewManager = (IMbgViewManager)viewBase;
            style = MbgXMLParser.parseStyle(bgForm.getBgTemplate().getStyleSet().getData());
            entry = bgForm.getEntries().get(0);
            entry.setDimensionData(MbgXMLParser.unParse((IMbgViewManager)mbgViewManager));
        }
        BgFormEntryFactory.getRemoteInstance().save(entry);
        if (!mbgDatas.isEmpty()) {
            this.transDataByMu(mbgDatas, style);
            HashMap<String, HashMap<String, IBgNData>> orgDataMap = new HashMap<String, HashMap<String, IBgNData>>();
            orgDataMap.put(bgForm.getOrgUnit().getId().toString(), mbgDatas);
            MBGFormFacadeFactory.getRemoteInstance().saveBgData(bgForm.getId().toString(), orgDataMap, true);
        }
    }

    private IMbgViewBase getViewManager(BgFormInfo bgForm) throws Exception {
        IMbgViewBase viewBase = BgFormFactory.getRemoteInstance().loadViewManager(bgForm.getId());
        return viewBase;
    }

    private Map<String, IMember> loadVMember(BgOrgUnitInfo bgOrgUnit, KDSSheet sheet, CommObj commonInfo) throws Exception {
        if (bgOrgUnit == null || sheet == null || commonInfo == null) {
            return null;
        }
        MbgDimInfo mbgDim = null;
        MemberObject member = null;
        String mbgDimNumber = null;
        String memberNumber = null;
        HashMap<String, IMember> vMemberMap = new HashMap<String, IMember>();
        member = new MemberObject();
        member.setId(bgOrgUnit.getOrgUnitID());
        member.setNumber(bgOrgUnit.getNumber());
        member.setName(bgOrgUnit.getName());
        member.setSrcNumber(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER);
        vMemberMap.put(DimensionBaseConstants.DEF_ORGUNIT_FIELD, member);
        int in = sheet.getColumnCount();
        for (int i = 0; i <= in; i += 4) {
            mbgDimNumber = (String)sheet.getCell(0, i, true).getValue();
            memberNumber = (String)sheet.getCell(0, i + 1, true).getValue();
            if (StringUtils.isEmpty((String)mbgDimNumber) || StringUtils.isEmpty((String)(memberNumber = this.verifyMember((mbgDim = this.verifyMbgDim(mbgDimNumber)).getNumber(), memberNumber, commonInfo)))) continue;
            member = new MemberObject();
            member.setNumber(memberNumber.trim());
            if (!this.verifyMember(mbgDim, member, false)) continue;
            vMemberMap.put(mbgDim.getRefField(), member);
        }
        return vMemberMap;
    }

    private boolean updatePVMbgMember(IBgDimensionManagerBase dimensionManager, Map<String, IMember> vMembers) throws Exception {
        boolean result = false;
        if (dimensionManager == null || vMembers == null || vMembers.isEmpty()) {
            return result;
        }
        boolean _re = false;
        Object obj = null;
        List pages = dimensionManager.getPageDimension();
        int in = pages.size();
        for (int i = 0; i < in; ++i) {
            obj = pages.get(i);
            if (!(obj instanceof BgDimensionBaseInfo) || !(_re = this.updatePVMbgMember((BgDimensionBaseInfo)obj, vMembers))) continue;
            result = _re;
        }
        List views = dimensionManager.getViewDimension();
        int in2 = pages.size();
        for (int i = 0; i < in2; ++i) {
            obj = pages.get(i);
            if (!(obj instanceof BgDimensionBaseInfo) || !(_re = this.updatePVMbgMember((BgDimensionBaseInfo)obj, vMembers))) continue;
            result = _re;
        }
        return result;
    }

    private boolean updatePVMbgMember(BgDimensionBaseInfo dimension, Map<String, IMember> vMembers) throws Exception {
        boolean result = false;
        if (dimension == null || !dimension.getMember().isEmpty() || vMembers == null) {
            return result;
        }
        String field = DimUtils.getDimensionField(dimension);
        IMember member = vMembers.get(field);
        if (member == null) {
            throw new BgIEException(BgIEException.ERRORDIMENSIONINFO, new String[]{dimension.getNumber()});
        }
        BgDimensionMember _member = null;
        HashSet<String> numbers = new HashSet<String>();
        int in = dimension.getMember().size();
        for (int i = 0; i < in; ++i) {
            _member = (BgDimensionMember)dimension.getMember().get(i);
            numbers.add(_member.getNumber());
        }
        if (!numbers.contains(member.getNumber())) {
            return dimension.getMember().add(member);
        }
        return false;
    }

    private boolean updateMbgMember(int temType, KDSSheet sheet, IBgDimensionManagerBase dimensionManager, List<Object[]> members, boolean hasRow) throws Exception {
        boolean result = false;
        if (sheet == null || dimensionManager == null || members == null || members.isEmpty()) {
            return result;
        }
        IMbgViewListObject obj = null;
        MbgViewListRowCol rc = null;
        if (temType == 2) {
            MbgViewListDimensionManager viewDimensionManager = (MbgViewListDimensionManager)dimensionManager;
            List<IMbgViewListObject> tmpList = hasRow ? viewDimensionManager.getRows() : viewDimensionManager.getColumns();
            int in = tmpList.size();
            for (int i = 0; i < in; ++i) {
                obj = tmpList.get(i);
                if (!(obj instanceof MbgViewListRowCol) || !(rc = (MbgViewListRowCol)obj).isCombin()) continue;
                result = this.updateMbgMember(sheet, rc, members);
                break;
            }
        }
        return result;
    }

    private boolean updateMbgMember(KDSSheet sheet, MbgViewListRowCol rc, List<Object[]> members) throws Exception {
        int i;
        int i2;
        boolean result = false;
        if (sheet == null || rc == null || !rc.isCombin() || members == null || members.isEmpty()) {
            return result;
        }
        Object[] head = members.get(0);
        if (head == null || head.length != rc.getDimensions().size()) {
            throw new BgIEException(BgIEException.ERRORCOMBINOFDIMENSION, new String[]{sheet.getName()});
        }
        Object obj = null;
        Object[] member = null;
        IMember _member = null;
        MbgDimInfo mbgDim = null;
        MbgViewListDimensionInfo dimension = null;
        BgDimensionMember bgMember2 = null;
        String number = null;
        String name = null;
        String type = null;
        String fields = null;
        String srcNumber = null;
        HashMap dimMemberMap = new HashMap();
        TreeMap<String, BgDimensionMember> memberMap = null;
        HashMap<Integer, String> fieldsMap = new HashMap<Integer, String>();
        HashSet<String> combinNums = new HashSet<String>();
        if (!rc.getCombinMembers().isEmpty()) {
            int in = rc.getCombinMembers().size();
            for (i2 = 0; i2 < in; ++i2) {
                bgMember2 = rc.getCombinMembers().get(i2);
                combinNums.add(bgMember2.getNumber());
            }
        }
        for (i2 = 0; i2 < head.length; ++i2) {
            obj = head[i2];
            mbgDim = (MbgDimInfo)obj;
            fieldsMap.put(i2, mbgDim.getRefField());
            if (i2 == 0) {
                fields = mbgDim.getRefField();
                srcNumber = mbgDim.getSrcNumber();
                continue;
            }
            fields = fields + "," + mbgDim.getRefField();
            srcNumber = srcNumber + "," + mbgDim.getSrcNumber();
        }
        boolean check = true;
        int in = members.size();
        for (i = 1; i < in; ++i) {
            int j;
            member = members.get(i);
            check = true;
            for (j = 0; j < member.length; ++j) {
                obj = member[j];
                if (obj != null) continue;
                check = false;
                break;
            }
            if (!check) continue;
            for (j = 0; j < member.length; ++j) {
                obj = member[j];
                mbgDim = (MbgDimInfo)head[j];
                if (!(obj instanceof IMember)) continue;
                _member = (IMember)obj;
                bgMember2 = new BgDimensionMember(mbgDim.getNumber(), (String)fieldsMap.get(j), _member.getName(), _member.getNumber());
                bgMember2.setSrcNumber(mbgDim.getSrcNumber());
                if (dimMemberMap.containsKey(mbgDim.getNumber())) {
                    memberMap = (Map)dimMemberMap.get(mbgDim.getNumber());
                } else {
                    memberMap = new TreeMap<String, BgDimensionMember>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareTo(o2);
                        }
                    });
                    dimMemberMap.put(mbgDim.getNumber(), memberMap);
                }
                if (!memberMap.containsKey(bgMember2.getNumber())) {
                    memberMap.put(bgMember2.getNumber(), bgMember2);
                }
                if (j == 0) {
                    number = _member.getNumber();
                    name = _member.getName();
                    type = mbgDim.getNumber();
                    continue;
                }
                number = number + "," + _member.getNumber();
                name = name + DimensionConstants.TICK_SEPARATOR + _member.getName();
                type = type + "," + mbgDim.getNumber();
            }
            if (!check || combinNums.contains(number)) continue;
            bgMember2 = new BgDimensionMember(type, fields, name, number);
            bgMember2.setSrcNumber(srcNumber);
            rc.getCombinMembers().add(bgMember2);
            result = true;
        }
        if (!dimMemberMap.isEmpty()) {
            in = rc.getDimensions().size();
            for (i = 0; i < in; ++i) {
                dimension = rc.getDimensions().get(i);
                memberMap = (TreeMap<String, BgDimensionMember>)dimMemberMap.get(dimension.getNumber());
                if (memberMap == null) continue;
                int jn = dimension.getMember().size();
                for (int j = 0; j < jn; ++j) {
                    bgMember2 = (BgDimensionMember)dimension.getMember().get(j);
                    memberMap.remove(bgMember2.getNumber());
                }
                if (memberMap.isEmpty()) continue;
                for (BgDimensionMember bgMember2 : memberMap.values()) {
                    dimension.getMember().add(bgMember2);
                }
            }
        }
        return result;
    }

    private Map<String, IBgNData> loadRCData(BgOrgUnitInfo bgOrgUnit, BgFormInfo bgForm, KDSSheet sheet, IBgDimensionManagerBase dimensionManager, Map<String, IMember> vMembers, CommObj commonInfo) throws Exception {
        Map<String, IBgNData> mbgDatas = null;
        if (bgForm == null || sheet == null || dimensionManager == null || vMembers == null || bgOrgUnit == null) {
            return null;
        }
        int rowDimSize = 0;
        int colDimSize = 0;
        IMbgViewListObject obj = null;
        MbgViewListRowCol rc = null;
        MbgViewListAtribute attribute = null;
        ArrayList<MbgViewListRowCol> _rows = new ArrayList<MbgViewListRowCol>();
        ArrayList<MbgViewListRowCol> _cols = new ArrayList<MbgViewListRowCol>();
        ArrayList<MbgViewListRowCol> _rowCombins = new ArrayList<MbgViewListRowCol>();
        ArrayList<MbgViewListRowCol> _colCombins = new ArrayList<MbgViewListRowCol>();
        int temType = bgForm.getBgTemplate().getFormType().getValue();
        if (temType == 2) {
            int i;
            MbgViewListDimensionManager viewDimensionManager = (MbgViewListDimensionManager)dimensionManager;
            List<IMbgViewListObject> rows = viewDimensionManager.getRows();
            List<IMbgViewListObject> cols = viewDimensionManager.getColumns();
            int in = rows.size();
            for (i = 0; i < in; ++i) {
                obj = rows.get(i);
                if (obj instanceof MbgViewListRowCol) {
                    rc = (MbgViewListRowCol)obj;
                    rowDimSize = rc.getDimensions().size();
                    _rows.add(rc);
                    if (!rc.isCombin()) continue;
                    _rowCombins.add(rc);
                    continue;
                }
                if (!(obj instanceof MbgViewListAtribute)) continue;
                attribute = (MbgViewListAtribute)obj;
            }
            in = cols.size();
            for (i = 0; i < in; ++i) {
                obj = cols.get(i);
                if (obj instanceof MbgViewListRowCol) {
                    rc = (MbgViewListRowCol)obj;
                    colDimSize = rc.getDimensions().size();
                    _cols.add(rc);
                    if (!rc.isCombin()) continue;
                    _colCombins.add(rc);
                    continue;
                }
                if (!(obj instanceof MbgViewListAtribute)) continue;
                attribute = (MbgViewListAtribute)obj;
            }
            if (_rows.size() > 1) {
                throw new BgIEException(BgIEException.ERRORMUILTCOMBINOFROWS, new String[]{sheet.getName()});
            }
            if (_cols.size() > 1 && _colCombins.size() > 1) {
                throw new BgIEException(BgIEException.ERRORMUILTCOMBINOFCOLS, new String[]{sheet.getName()});
            }
            List<Object[]> rowMembers = this.loadRowsMember(bgForm, sheet, rowDimSize, colDimSize, commonInfo);
            this.updateMbgMember(temType, sheet, dimensionManager, rowMembers, true);
            List<Object[]> colMembers = this.loadColsMember(bgForm, sheet, rowDimSize, colDimSize, commonInfo);
            this.updateMbgMember(temType, sheet, dimensionManager, rowMembers, false);
            if (bgOrgUnit.isIsLeaf()) {
                mbgDatas = this.loadData(sheet, rowDimSize, colDimSize, rowMembers, colMembers, vMembers);
            }
        } else if (temType == 4) {
            // empty if block
        }
        return mbgDatas;
    }

    private List<Object[]> loadRowsMember(BgFormInfo bgForm, KDSSheet sheet, int rowDimSize, int colDimSize, CommObj commonInfo) throws Exception {
        ArrayList<Object[]> rowMembers = new ArrayList<Object[]>();
        if (bgForm == null || sheet == null || commonInfo == null) {
            return rowMembers;
        }
        int colIndex = 0;
        String mbgDimNumber = null;
        String memberNumber = null;
        IMember[] members = null;
        MbgDimInfo mbgDim = null;
        ArrayList<MbgDimInfo> mbgDims = new ArrayList<MbgDimInfo>();
        for (int i = 0; i < rowDimSize; ++i) {
            mbgDimNumber = (String)sheet.getCell(3, i * 2, true).getValue();
            if (StringUtils.isEmpty((String)mbgDimNumber)) continue;
            mbgDim = this.verifyMbgDim(mbgDimNumber);
            if (mbgDim == null) {
                throw new BgIEException(BgIEException.ERRORDIMENSIONINFO, new String[]{mbgDimNumber});
            }
            mbgDims.add(mbgDim);
        }
        rowMembers.add(mbgDims.toArray());
        boolean hasData = false;
        int rowCount = sheet.getRowCount();
        for (int rowIndex = 3 + colDimSize; rowIndex <= rowCount; ++rowIndex) {
            members = new IMember[rowDimSize];
            hasData = false;
            for (int i = 0; i < rowDimSize; ++i) {
                colIndex = i * 2;
                memberNumber = (String)sheet.getCell(rowIndex, colIndex, true).getValue();
                mbgDim = (MbgDimInfo)mbgDims.get(i);
                memberNumber = this.verifyMember(mbgDim.getNumber(), memberNumber, commonInfo);
                if (StringUtils.isEmpty((String)memberNumber)) continue;
                members[i] = new MemberObject();
                members[i].setSrcNumber(((MbgDimInfo)mbgDims.get(i)).getSrcNumber());
                members[i].setNumber(memberNumber.trim());
                if (this.verifyMember(mbgDim, members[i], true)) {
                    hasData = true;
                    continue;
                }
                this.getWarnings(bgForm.getId()).add(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"import_member_error", (Object[])new Object[]{sheet.getName(), TableToolkit.xy2range((int)colIndex, (int)rowIndex), members[i].getNumber()}));
                members[i] = null;
            }
            if (!hasData) continue;
            rowMembers.add(members);
        }
        return rowMembers;
    }

    private List<Object[]> loadColsMember(BgFormInfo bgForm, KDSSheet sheet, int rowDimSize, int colDimSize, CommObj commonInfo) throws Exception {
        ArrayList<Object[]> colMembers = new ArrayList<Object[]>();
        if (bgForm == null || sheet == null || commonInfo == null) {
            return colMembers;
        }
        int rowIndex = 0;
        String mbgDimNumber = null;
        String memberNumber = null;
        String[] tmpStrs = null;
        IMember[] members = null;
        MbgDimInfo mbgDim = null;
        ArrayList<MbgDimInfo> mbgDims = new ArrayList<MbgDimInfo>();
        for (int i = 0; i < colDimSize; ++i) {
            mbgDimNumber = (String)sheet.getCell(2, i * 2 + 1, true).getValue();
            mbgDim = this.verifyMbgDim(mbgDimNumber);
            if (mbgDim == null) {
                throw new BgIEException(BgIEException.ERRORDIMENSIONINFO, new String[]{mbgDimNumber});
            }
            mbgDims.add(mbgDim);
        }
        colMembers.add(mbgDims.toArray());
        boolean hasData = false;
        int colCount = sheet.getColumnCount();
        for (int colIndex = rowDimSize * 2; colIndex <= colCount; ++colIndex) {
            members = new IMember[colDimSize];
            hasData = false;
            for (int i = 0; i < colDimSize; ++i) {
                rowIndex = i + 3;
                memberNumber = (String)sheet.getCell(rowIndex, colIndex, true).getValue();
                mbgDim = (MbgDimInfo)mbgDims.get(i);
                memberNumber = this.verifyMember(mbgDim.getNumber(), memberNumber, commonInfo);
                if (StringUtils.isEmpty((String)memberNumber)) continue;
                tmpStrs = memberNumber.split("_");
                members[i] = new MemberObject();
                members[i].setSrcNumber(((MbgDimInfo)mbgDims.get(i)).getSrcNumber());
                if (tmpStrs.length > 1) {
                    members[i].setNumber(tmpStrs[0]);
                    members[i].setName(tmpStrs[1]);
                } else {
                    members[i].setNumber(tmpStrs[0]);
                }
                if (this.verifyMember(mbgDim, members[i], false)) {
                    hasData = true;
                    continue;
                }
                this.getWarnings(bgForm.getId()).add(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.MBgImportAndExportResource", (String)"import_member_error", (Object[])new Object[]{sheet.getName(), TableToolkit.xy2range((int)colIndex, (int)rowIndex), members[i].getNumber()}));
                members[i] = null;
            }
            if (!hasData) continue;
            colMembers.add(members);
        }
        return colMembers;
    }

    private Map<String, IBgNData> loadData(KDSSheet sheet, int rowDimSize, int colDimSize, List<Object[]> rowMembers, List<Object[]> colMembers, Map<String, IMember> vMembers) throws Exception {
        HashMap<String, IBgNData> mbgDatas = new HashMap<String, IBgNData>();
        if (sheet == null || rowMembers == null || rowMembers.isEmpty() || colMembers == null || colMembers.isEmpty() || vMembers == null) {
            return mbgDatas;
        }
        String[] formulaParams = null;
        BigDecimal value = null;
        Object[] rowDims = null;
        Object[] colDims = null;
        Object[] rowMember = null;
        Object[] colMember = null;
        IMember member = null;
        BgNDataInfo mbgData = null;
        MbgDimInfo mbgDim = null;
        Map.Entry<String, IMember> entry2 = null;
        HashMap<String, String> members = new HashMap<String, String>();
        HashMap<String, String> rMap = new HashMap<String, String>();
        HashMap<String, String> cMap = new HashMap<String, String>();
        HashMap<String, String> vMap = new HashMap<String, String>();
        HashMap<String, String> rBaseMap = new HashMap<String, String>();
        HashMap<String, String> cBaseMap = new HashMap<String, String>();
        HashMap<String, String> vBaseMap = new HashMap<String, String>();
        for (Map.Entry<String, IMember> entry2 : vMembers.entrySet()) {
            member = entry2.getValue();
            if (!DimUtils.checkBaseDimensionByField(entry2.getKey())) {
                vMap.put(entry2.getKey(), DimUtils.getDimNumber(member.getSrcNumber(), member.getNumber()));
                continue;
            }
            vBaseMap.put(entry2.getKey(), member.getNumber());
        }
        KDSCell cell = null;
        rowDims = rowMembers.get(0);
        colDims = colMembers.get(0);
        int i = 1;
        int rowCount = sheet.getRowCount();
        for (int rowIndex = 3 + colDimSize; rowIndex <= rowCount; ++rowIndex) {
            if (i < rowMembers.size() && this.verifyMember(rowMember = (IMember[])rowMembers.get(i))) {
                rMap.clear();
                rBaseMap.clear();
                for (int x = 0; x < rowMember.length; ++x) {
                    mbgDim = (MbgDimInfo)rowDims[x];
                    if (!DimUtils.checkBaseDimensionByField(mbgDim.getRefField())) {
                        rMap.put(mbgDim.getRefField(), DimUtils.getDimNumber(rowMember[x].getSrcNumber(), rowMember[x].getNumber()));
                        continue;
                    }
                    rBaseMap.put(mbgDim.getRefField(), rowMember[x].getNumber());
                }
                int j = 1;
                int colCount = sheet.getColumnCount();
                for (int colIndex = rowDimSize * 2; colIndex <= colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (j < colMembers.size() && cell != null && cell.getValue() != null) {
                        try {
                            value = new BigDecimal(cell.getValue().toString().trim().replaceAll(",", ""));
                        }
                        catch (Exception ex) {
                            value = null;
                        }
                        if (value != null && this.verifyMember(colMember = (IMember[])colMembers.get(j))) {
                            cMap.clear();
                            for (int y = 0; y < colMember.length; ++y) {
                                mbgDim = (MbgDimInfo)colDims[y];
                                if (!DimUtils.checkBaseDimensionByField(mbgDim.getRefField())) {
                                    cMap.put(mbgDim.getRefField(), DimUtils.getDimNumber(colMember[y].getSrcNumber(), colMember[y].getNumber()));
                                    continue;
                                }
                                rBaseMap.put(mbgDim.getRefField(), colMember[y].getNumber());
                            }
                            members.clear();
                            members.putAll(rMap);
                            members.putAll(cMap);
                            members.putAll(vMap);
                            formulaParams = new String[]{DimUtils.getDimNumber(members), this.getMemberNumber(DimensionBaseConstants.DEF_PERIOD_FIELD, vBaseMap, rBaseMap, cBaseMap), this.getMemberNumber(DimensionBaseConstants.DEF_ELEMENT_FIELD, vBaseMap, rBaseMap, cBaseMap), this.getMemberNumber(DimensionBaseConstants.DEF_SCENARIO_FIELD, vBaseMap, rBaseMap, cBaseMap), this.getMemberNumber(DimensionBaseConstants.DEF_CURRENCY_FIELD, vBaseMap, rBaseMap, cBaseMap)};
                            mbgData = new BgNDataInfo();
                            mbgData.setBgPeriodNumber(formulaParams[1]);
                            mbgData.setBgElementNumber(formulaParams[2]);
                            mbgData.setCurrencyNumber(formulaParams[4]);
                            mbgData.setBgScenario(formulaParams[3]);
                            mbgData.setBgIndexNum((String)members.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
                            mbgData.setFormula(BgNFSHelper.getFormulaFromParam(formulaParams));
                            mbgData.setBgVersion(this.getMemberNumber(DimensionBaseConstants.DEF_VERSION_FIELD, vBaseMap, rBaseMap, cBaseMap));
                            mbgData.setBudgetValue(value);
                            mbgDatas.put(DimUtils.getDimDataKey(mbgData), mbgData);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return mbgDatas;
    }

    private String getMemberNumber(String field, Map<String, String> vBaseMap, Map<String, String> rBaseMap, Map<String, String> cBaseMap) {
        if (field == null || vBaseMap == null || rBaseMap == null || cBaseMap == null) {
            return null;
        }
        String number = null;
        number = vBaseMap.get(field);
        if (number == null && (number = rBaseMap.get(field)) == null) {
            number = cBaseMap.get(field);
        }
        return number;
    }

    private MbgDimInfo verifyMbgDim(String mbgDimNumber) throws Exception {
        if (StringUtils.isEmpty((String)mbgDimNumber)) {
            mbgDimNumber = "NULL";
            throw new BgIEException(BgIEException.ERRORDIMENSIONINFO, new String[]{mbgDimNumber});
        }
        MbgDimInfo mbgDim = this.getMbgNameMap().get(mbgDimNumber.trim().replaceAll(number, ""));
        if (mbgDim == null) {
            throw new BgIEException(BgIEException.ERRORDIMENSIONINFO, new String[]{mbgDimNumber});
        }
        return mbgDim;
    }

    private String verifyMember(String mbgDimNumber, String memberNumber, CommObj commonInfo) throws Exception {
        if (StringUtils.isEmpty((String)mbgDimNumber)) {
            return memberNumber;
        }
        if (StringUtils.isEmpty((String)memberNumber)) {
            if (mbgDimNumber.equals(DimensionBaseConstants.DEF_VERSION_NUMBER)) {
                memberNumber = commonInfo.versionNum;
            } else if (mbgDimNumber.equals(DimensionBaseConstants.DEF_CURRENCY_NUMBER)) {
                memberNumber = commonInfo.currencyNum;
            } else if (mbgDimNumber.equals(DimensionBaseConstants.DEF_PERIOD_NUMBER)) {
                memberNumber = commonInfo.bgPeriodNum;
            }
        }
        return memberNumber;
    }

    private boolean verifyMember(MbgDimInfo mbgDim, IMember member, boolean isIgnore) throws Exception {
        boolean check = false;
        if (mbgDim == null || member == null) {
            return check;
        }
        if (StringUtils.isEmpty((String)member.getNumber())) {
            member.setNumber("NULL");
            throw new BgIEException(BgIEException.ERRORMEMBERINFO, new String[]{member.getNumber()});
        }
        String[] _member = null;
        if (this.getShareMemberMap().containsKey(mbgDim.getNumber())) {
            Map<String, String[]> memberMap = this.getShareMemberMap().get(mbgDim.getNumber());
            _member = memberMap.get(member.getNumber());
        } else if (this.getIsSegMemberMap().containsKey(mbgDim.getNumber())) {
            Map<String, Map<String, String[]>> orgMemberMap = this.getIsSegMemberMap().get(mbgDim.getNumber());
            BOSUuid viewId = this.getBgScheme().getViewId(mbgDim.getNumber());
            Set<String> orgIds = this.getMbgDimOrgIds().get(viewId.toString());
            Map<String, String[]> memberMap = null;
            for (String orgUnitId : orgIds) {
                if (!orgMemberMap.containsKey(orgUnitId) || !(memberMap = orgMemberMap.get(orgUnitId)).containsKey(member.getNumber())) continue;
                _member = memberMap.get(member.getNumber());
                break;
            }
        }
        if (_member == null && !isIgnore) {
            throw new BgIEException(BgIEException.ERRORMEMBERINFO, new String[]{member.getNumber()});
        }
        if (_member != null) {
            member.setName(_member[2]);
            member.setSrcNumber(mbgDim.getSrcNumber());
            check = true;
        }
        return check;
    }

    private boolean verifyMember(Object[] members) throws Exception {
        if (members == null) {
            return false;
        }
        int in = members.length;
        for (int i = 0; i < in; ++i) {
            if (members[i] != null) continue;
            return false;
        }
        return true;
    }

    protected void transDataByMu(Map<String, IBgNData> mbgDatas, TemplateStyleInfo style) throws Exception {
        if (this.getBgScheme() == null || mbgDatas == null || mbgDatas.isEmpty() || style == null) {
            return;
        }
        IBgNData mbgData2 = null;
        String bgIndexNum = null;
        BigDecimal currency = new BigDecimal(MBGViewListFormClientHelper.transMeasureUnit((int)style.getCurrencyMeasureUnit()));
        BigDecimal notCurrency = new BigDecimal(MBGViewListFormClientHelper.transMeasureUnit((int)style.getNoCurrencyMeasureUnit()));
        if (this.currencyType == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)this.getBgScheme().getViewId(DimensionBaseConstants.DEF_INDEX_NUMBER).toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgAccountDataType", (Object)10));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            BgAccountCollection accounts = BgAccountFactory.getRemoteInstance().getBgAccountCollection(view);
            if (accounts != null) {
                BgAccountInfo account = null;
                this.currencyType = new HashSet<String>();
                int in = accounts.size();
                for (int i = 0; i < in; ++i) {
                    account = accounts.get(i);
                    this.currencyType.add(DimUtils.getDimNumber(DimensionBaseConstants.DEF_INDEX_SRCNUMBER, account.getNumber()));
                }
            }
        }
        for (IBgNData mbgData2 : mbgDatas.values()) {
            if (!this.moneyEles.contains(mbgData2.getBgElementNumber())) continue;
            bgIndexNum = ((BgNDataInfo)mbgData2).getBgIndexNum();
            if (this.currencyType.contains(bgIndexNum)) {
                if (mbgData2.getBudgetValueNoDef() == null) continue;
                mbgData2.setBudgetValue(mbgData2.getBudgetValue().multiply(currency));
                continue;
            }
            if (mbgData2.getBudgetValueNoDef() == null) continue;
            mbgData2.setBudgetValue(mbgData2.getBudgetValue().multiply(notCurrency));
        }
    }

    protected IObjectValue createNewData(BgFormInfo bgFormInfo) {
        bgFormInfo.setStartDate(new Date());
        bgFormInfo.setEndDate(bgFormInfo.getStartDate());
        bgFormInfo.setDataSource(BgFormDataSourceEnum.CURRENTWORKOUT);
        bgFormInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        bgFormInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        bgFormInfo.setBgType(bgFormInfo.getBgTemplate().getBgType());
        CompanyOrgUnitInfo companyInfo = null;
        try {
            FullOrgUnitInfo orgInfo = bgFormInfo.getOrgUnit();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("longnumber");
            sic.add("isCompanyOrgUnit");
            FullOrgUnitInfo tempOrg = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId().toString()), sic);
            companyInfo = this.getCompanyByOrgUnit((OrgUnitInfo)tempOrg);
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        if (companyInfo != null) {
            bgFormInfo.setCompany(companyInfo);
        } else if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            bgFormInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        }
        bgFormInfo.setAdjust(bgFormInfo);
        bgFormInfo.setVersionNo(BgNConstants.ONE);
        bgFormInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        bgFormInfo.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        bgFormInfo.setPeriodType(RptPeriodTypeEnum.YEARLY);
        return bgFormInfo;
    }

    public BgSchemeDimensionHelper getSchemeHelper(BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(bgSchemeInfo.getId().toString());
        }
        return this.schemeHelper;
    }

    protected CompanyOrgUnitInfo getCompanyByOrgUnit(OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getRemoteInstance().getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(parent);
        }
        return null;
    }

    protected SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    class CommObj {
        public String orgUnitNum = null;
        public String orgUnitName = null;
        public String bgPeriodNum = null;
        public String bgPeriodName = null;
        public String bgTemplateNum = null;
        public String bgTemplateName = null;
        public String versionNum = null;
        public String versionName = null;
        public String currencyNum = null;
        public String currencyName = null;

        CommObj() {
        }

        public String[] toArray() {
            String[] arrays = new String[]{this.orgUnitName, this.orgUnitNum, this.bgPeriodName, this.bgPeriodNum, this.bgTemplateName, this.bgTemplateNum, this.versionName, this.versionNum, this.currencyName, this.currencyNum};
            return arrays;
        }
    }
}

