/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.MbgViewCollection;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.utils.BgCommNHelper;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimGroupCollection;
import com.kingdee.eas.ma.mbg.DimGroupFactory;
import com.kingdee.eas.ma.mbg.DimGroupInfo;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionDisplayInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgMergeSchemeHelper {
    private static final Logger logger = Logger.getLogger(BgMergeSchemeHelper.class);
    private static final String FID = "FID";
    private static final String FNUMBER = "FNUMBER";
    private static final String FNAME_L2 = "FNAME_L2";
    private static final String FSTARTDATE = "FSTARTDATE";
    private static final String FENDDATE = "FENDDATE";
    public static final String CSL_OPRT_STATE = "cslOperState";
    public static final String CSL_ADDNEW = "cslAddNew";
    public static final String CSL_EDIT = "cslEdit";

    public static CoreBaseCollection getMergeScopeList(String userId) {
        CoreBaseCollection coll = new CoreBaseCollection();
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("SELECT distinct tree.FID, tree.FNUMBER, tree.FNAME_L2,tree.FStartDate,tree.FEndDate  FROM T_PM_USER u ").append("join " + BgCommNHelper.getOrgRangeTable(null) + " range on range.FUSERID = u.FID ").append("join T_ORG_Structure structure on structure.FUNITID = range.FORGID ").append("join T_ORG_TREE tree on tree.FID = structure.FTREEID ").append("join T_ORG_BaseUnit unit on unit.FID = range.FORGID  ").append("where u.FID = '").append(userId).append("' ").append("and tree.FISFORBUDGET = 1 ").append("and unit.FISUNION = 1 ").append("and tree.FSTARTDATE  is not null ").append("order by tree.FNumber ASC, tree.FStartDate DESC ");
            ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sqlBuf.toString());
            IRowSet rowSet = executor.executeSQL();
            OrgTreeInfo orgTree = null;
            while (rowSet.next()) {
                String id = rowSet.getString(FID);
                String number = rowSet.getString(FNUMBER);
                String name = rowSet.getString(FNAME_L2);
                Timestamp startDate = rowSet.getTimestamp(FSTARTDATE);
                Timestamp endDate = rowSet.getTimestamp(FENDDATE);
                orgTree = new OrgTreeInfo();
                orgTree.setId(BOSUuid.read((String)id));
                orgTree.setNumber(number);
                orgTree.setName(name);
                orgTree.setStartDate(startDate);
                orgTree.setEndDate(endDate);
                coll.add((CoreBaseInfo)orgTree);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return coll;
    }

    private static String fillDateForName(String name, Timestamp startDate, Timestamp endDate) {
        StringBuffer buff = new StringBuffer(name);
        if (startDate != null) {
            buff.append("(").append(BgMergeSchemeHelper.getDateString(startDate));
            if (endDate != null) {
                buff.append("~").append(BgMergeSchemeHelper.getDateString(endDate));
            }
            buff.append(")");
        }
        return buff.toString();
    }

    private static String getDateString(Timestamp ts) {
        if (ts == null) {
            return "";
        }
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        return dtformat.format(new Date(ts.getTime()));
    }

    public static MbgViewInfo getDefMergeDimView() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"M0NlAtvwTc+hRz1Td/e60V2BTmI=", CompareType.EQUALS));
        MbgViewCollection coll = null;
        try {
            coll = MbgViewFactory.getRemoteInstance().getMbgViewCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return coll != null && coll.size() == 1 ? coll.get(0) : null;
    }

    public static BgDimSettingsInfo filterMergeDimension(BgDimSettingsCollection coll) {
        BgDimSettingsInfo delDimSett = null;
        if (coll == null) {
            return delDimSett;
        }
        for (int i = 0; i < coll.size(); ++i) {
            BgDimSettingsInfo dimSett = coll.get(i);
            if (!dimSett.getDimNumber().equals(DimensionConstants.DEF_CSL_NUMBER)) continue;
            delDimSett = dimSett;
            break;
        }
        if (delDimSett != null) {
            coll.remove(delDimSett);
        }
        return delDimSett;
    }

    public static void filterOrgViewByType(BgDimSettingsCollection coll, MemberTypeEnum getOrgMemberType) {
        BgDimSettingsMemberCollection filterColl = new BgDimSettingsMemberCollection();
        for (int i = 0; i < coll.size(); ++i) {
            BgDimSettingsInfo dimSett = coll.get(i);
            if (!dimSett.getDimNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
            BgDimSettingsMemberCollection members = dimSett.getMembers();
            for (int j = 0; j < members.size(); ++j) {
                if (!members.get(j).getType().equals((Object)getOrgMemberType)) continue;
                filterColl.add(members.get(j));
            }
            dimSett.getMembers().clear();
            dimSett.getMembers().addCollection(filterColl);
            break;
        }
    }

    public static void storeDimGroup(BgSchemeInfo editData, List<List<Object>> dimGroupList) {
        if (editData == null || dimGroupList == null) {
            return;
        }
        DimGroupCollection coll = editData.getDimGroup();
        coll.clear();
        DimGroupInfo dimGroup = null;
        for (List<Object> item : dimGroupList) {
            BgDimensionMember acc;
            dimGroup = new DimGroupInfo();
            Object accMember = item.get(0);
            Object mbgDim = item.get(1);
            Object mbgMember = item.get(2);
            StringBuffer numberBuf = new StringBuffer();
            StringBuffer nameBuf = new StringBuffer();
            if (accMember instanceof List) {
                for (Object obj : (List)accMember) {
                    if (!(obj instanceof BgDimensionMember)) continue;
                    acc = (BgDimensionMember)obj;
                    numberBuf.append(acc.getNumber()).append(",");
                    nameBuf.append(acc.getName()).append(",");
                }
                numberBuf.delete(numberBuf.length() - 1, numberBuf.length());
                nameBuf.delete(nameBuf.length() - 1, nameBuf.length());
                dimGroup.setAccMemberNumber(numberBuf.toString());
                dimGroup.setAccMemberName(nameBuf.toString());
            }
            numberBuf.delete(0, numberBuf.length());
            nameBuf.delete(0, nameBuf.length());
            if (mbgMember instanceof List) {
                for (Object obj : (List)mbgMember) {
                    if (!(obj instanceof BgDimensionMember)) continue;
                    acc = (BgDimensionMember)obj;
                    numberBuf.append(acc.getNumber()).append(",");
                    nameBuf.append(acc.getName()).append(",");
                }
                numberBuf.delete(numberBuf.length() - 1, numberBuf.length());
                nameBuf.delete(nameBuf.length() - 1, nameBuf.length());
                dimGroup.setMbgMemberNumber(numberBuf.toString());
                dimGroup.setMbgMemberName(nameBuf.toString());
            }
            if (mbgDim instanceof BgDimensionDisplayInfo) {
                dimGroup.setMbgDimNumber(((BgDimensionDisplayInfo)mbgDim).getBgDimensionInfo().getNumber());
                dimGroup.setMbgDimName(((BgDimensionDisplayInfo)mbgDim).getBgDimensionInfo().getName());
            }
            dimGroup.setBgScheme(editData);
            coll.add(dimGroup);
        }
    }

    public static void saveDimGroup(BgSchemeInfo bgScheme, List<List<Object>> dimGroupList, Context ctx) throws Exception {
        if (dimGroupList == null || bgScheme == null) {
            return;
        }
        DimGroupCollection coll = new DimGroupCollection();
        DimGroupInfo dimGroup = null;
        for (List<Object> item : dimGroupList) {
            BgDimensionMember acc;
            dimGroup = new DimGroupInfo();
            Object accMember = item.get(0);
            Object mbgDim = item.get(1);
            Object mbgMember = item.get(2);
            StringBuffer numberBuf = new StringBuffer();
            StringBuffer nameBuf = new StringBuffer();
            if (accMember instanceof List) {
                for (Object obj : (List)accMember) {
                    if (!(obj instanceof BgDimensionMember)) continue;
                    acc = (BgDimensionMember)obj;
                    numberBuf.append(acc.getNumber()).append(",");
                    nameBuf.append(acc.getName()).append(",");
                }
                numberBuf.delete(numberBuf.length() - 1, numberBuf.length());
                nameBuf.delete(nameBuf.length() - 1, nameBuf.length());
                dimGroup.setAccMemberNumber(numberBuf.toString());
                dimGroup.setAccMemberName(nameBuf.toString());
            }
            numberBuf.delete(0, numberBuf.length());
            nameBuf.delete(0, nameBuf.length());
            if (mbgMember instanceof List) {
                for (Object obj : (List)mbgMember) {
                    if (!(obj instanceof BgDimensionMember)) continue;
                    acc = (BgDimensionMember)obj;
                    numberBuf.append(acc.getNumber()).append(",");
                    nameBuf.append(acc.getName()).append(",");
                }
                numberBuf.delete(numberBuf.length() - 1, numberBuf.length());
                nameBuf.delete(nameBuf.length() - 1, nameBuf.length());
                dimGroup.setMbgMemberNumber(numberBuf.toString());
                dimGroup.setMbgMemberName(nameBuf.toString());
            }
            if (mbgDim instanceof BgDimensionDisplayInfo) {
                dimGroup.setMbgDimNumber(((BgDimensionDisplayInfo)mbgDim).getBgDimensionInfo().getNumber());
                dimGroup.setMbgDimName(((BgDimensionDisplayInfo)mbgDim).getBgDimensionInfo().getName());
            }
            dimGroup.setBgScheme(bgScheme);
            coll.add(dimGroup);
        }
        if (ctx == null) {
            DimGroupFactory.getRemoteInstance().updateOrAddDimGroup(coll, bgScheme.getId().toString());
        } else {
            DimGroupFactory.getLocalInstance(ctx).updateOrAddDimGroup(coll, bgScheme.getId().toString());
        }
    }

    public static void initDimGroupList(BgSchemeInfo editData, List<List<Object>> dimGroupList, BgSchemeDimensionHelper bgSchemeHelper) {
        if (editData == null || dimGroupList == null || bgSchemeHelper == null) {
            return;
        }
        DimGroupCollection coll = editData.getDimGroup();
        for (int i = 0; i < coll.size(); ++i) {
            DimGroupInfo item = coll.get(i);
            dimGroupList.add(BgMergeSchemeHelper.parseDimGroup(item, bgSchemeHelper));
        }
    }

    public static void initDimGroupList(String bgSchemeID, List<List<Object>> dimGroupList, BgSchemeDimensionHelper bgSchemeHelper) throws Exception {
        if (bgSchemeID == null || dimGroupList == null || bgSchemeHelper == null) {
            return;
        }
        DimGroupCollection coll = DimGroupFactory.getRemoteInstance().getDimGroupCollection("where bgScheme.id = '" + bgSchemeID + "'");
        for (int i = 0; i < coll.size(); ++i) {
            DimGroupInfo item = coll.get(i);
            dimGroupList.add(BgMergeSchemeHelper.parseDimGroup(item, bgSchemeHelper));
        }
    }

    public static Map<String, List<List<Object>>> initDimGroup(Set<String> bgSchemeIDs, Context ctx) throws Exception {
        if (bgSchemeIDs == null || bgSchemeIDs.size() == 0) {
            return null;
        }
        Iterator<String> iterator = bgSchemeIDs.iterator();
        String schemeId = null;
        HashMap<String, BgSchemeDimensionHelper> helperMap = new HashMap<String, BgSchemeDimensionHelper>();
        BgSchemeDimensionHelper bgSchemeDimensionHelper = null;
        while (iterator.hasNext()) {
            schemeId = iterator.next();
            bgSchemeDimensionHelper = new BgSchemeDimensionHelper(ctx, schemeId);
            if (StringUtils.isEmpty((String)schemeId) || bgSchemeDimensionHelper == null || helperMap.containsKey(schemeId)) continue;
            helperMap.put(schemeId, bgSchemeDimensionHelper);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", bgSchemeIDs, CompareType.INCLUDE));
        DimGroupCollection coll = DimGroupFactory.getLocalInstance(ctx).getDimGroupCollection(viewInfo);
        return BgMergeSchemeHelper.parseDimGroup(helperMap, coll);
    }

    private static Map<String, List<List<Object>>> parseDimGroup(Map<String, BgSchemeDimensionHelper> helperMap, DimGroupCollection coll) throws Exception {
        if (helperMap == null || coll == null || coll.size() == 0) {
            return null;
        }
        BgSchemeInfo bgScheme = null;
        HashMap<String, List<List<Object>>> returnMap = new HashMap<String, List<List<Object>>>();
        List<List<Object>> dimGroupList = null;
        String schemeId = null;
        DimGroupInfo item = null;
        for (int i = 0; i < coll.size(); ++i) {
            item = coll.get(i);
            bgScheme = item.getBgScheme();
            if (bgScheme == null || bgScheme.getId() == null) continue;
            schemeId = bgScheme.getId().toString();
            if (item == null || !helperMap.containsKey(schemeId) || helperMap.get(schemeId) == null) continue;
            if (!returnMap.containsKey(schemeId)) {
                dimGroupList = new ArrayList();
                returnMap.put(schemeId, dimGroupList);
            } else {
                dimGroupList = (List)returnMap.get(schemeId);
            }
            dimGroupList.add(BgMergeSchemeHelper.parseDimGroup(item, helperMap.get(schemeId)));
        }
        return returnMap;
    }

    public static List<Object> parseDimGroup(DimGroupInfo item, BgSchemeDimensionHelper bgSchemeHelper) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (item == null) {
            return result;
        }
        String id = item.getId() != null ? item.getId().toString() : null;
        String accMemberNumber = item.getAccMemberNumber();
        String accMemberName = item.getAccMemberName();
        String mbgDimNumber = item.getMbgDimNumber();
        String mbgDimName = item.getMbgDimName();
        String mbgMemberNumber = item.getMbgMemberNumber();
        String mbgMemberName = item.getMbgMemberName();
        String[] accNumbers = accMemberNumber.split(",");
        String[] accNames = accMemberName.split(",");
        ArrayList<BgDimensionMember> accMembers = new ArrayList<BgDimensionMember>();
        for (int i = 0; i < accNumbers.length; ++i) {
            BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.DEF_BGINDEX_FIELD, accNames[i], accNumbers[i]);
            member.setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
            accMembers.add(member);
        }
        result.add(accMembers);
        BgDimensionInfo dimension = new BgDimensionInfo(null);
        dimension.setType(mbgDimNumber);
        dimension.setNumber(mbgDimNumber);
        dimension.setName(mbgDimName);
        dimension.setAlias(mbgDimName);
        result.add(new BgDimensionDisplayInfo(dimension));
        ArrayList<BgDimensionMember> mbgMembers = new ArrayList<BgDimensionMember>();
        if (mbgMemberNumber != null && mbgMemberName != null) {
            String[] mbgNumbers = mbgMemberNumber.split(",");
            String[] mbgNames = mbgMemberName.split(",");
            for (int i = 0; i < mbgNumbers.length; ++i) {
                if (StringUtils.isEmpty((String)mbgNames[i]) || StringUtils.isEmpty((String)mbgNumbers[i])) continue;
                BgDimensionMember member = new BgDimensionMember(dimension.getType(), bgSchemeHelper.getRefField(dimension.getNumber()), mbgNames[i], mbgNumbers[i]);
                member.setSrcNumber(bgSchemeHelper.getSrcNumber(dimension.getNumber()));
                mbgMembers.add(member);
            }
        }
        result.add(mbgMembers);
        if (!StringUtils.isEmpty((String)id)) {
            result.add(id);
        }
        return result;
    }
}

