/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgNPeriodNameHelper {
    private String bgFormPeriodNumber = null;
    private int bgFormPeriodType = -1;
    private Context ctx = null;
    private static Map<String, String> bgPeriodName = new HashMap<String, String>();
    private Set<String> querySet = new HashSet<String>();
    private List<Cell> cells = new ArrayList<Cell>();

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setBgFormPeriodNumber(String bgFormPeriodNumber) {
        this.bgFormPeriodNumber = bgFormPeriodNumber;
    }

    public void setBgFormPeriodType(int bgFormPeriodType) {
        this.bgFormPeriodType = bgFormPeriodType;
    }

    public void addCell(Cell cell) {
        String bgPeriodNumber = this.getConvertPeriod(cell);
        if (bgPeriodNumber != null) {
            this.cells.add(cell);
            if (!bgPeriodName.containsKey(bgPeriodNumber)) {
                this.querySet.add(bgPeriodNumber);
            }
        }
    }

    public void end() {
        if (!this.querySet.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", this.querySet, CompareType.INCLUDE));
            try {
                IBgPeriod ibp = null;
                ibp = this.ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance((Context)this.ctx);
                BgPeriodCollection col = ibp.getBgPeriodCollection(evi);
                if (col != null) {
                    for (int i = 0; i < col.size(); ++i) {
                        bgPeriodName.put(col.get(i).getNumber(), col.get(i).getName());
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.querySet.clear();
        }
        String bgPeriodNumber = null;
        Cell cell = null;
        for (int i = 0; i < this.cells.size(); ++i) {
            cell = this.cells.get(i);
            bgPeriodNumber = this.getConvertPeriod(cell);
            if (!bgPeriodName.containsKey(bgPeriodNumber)) continue;
            BgNFSHelper.setCellData(cell, "bgFillValue", bgPeriodNumber);
            BgNFSHelper.setValue(cell, bgPeriodName.get(bgPeriodNumber));
        }
    }

    private String getConvertPeriod(Cell cell) {
        if (!"bgFillValueType_period".equals(BgNFSHelper.getCellData(cell, "bgFillType"))) {
            return null;
        }
        String bgPeriodNumber = (String)BgNFSHelper.getCellData(cell, "bgFillValue");
        try {
            String newPeriod = BgPeriodNVariableHelper.getBgPeriodByN((String)this.bgFormPeriodNumber, (String)bgPeriodNumber, (int)this.bgFormPeriodType);
            if (!newPeriod.equals(bgPeriodNumber)) {
                return newPeriod;
            }
            return null;
        }
        catch (BgPeriodException e) {
            e.printStackTrace();
            return null;
        }
    }
}

