/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgOrgDataHelper {
    private Map<String, BgOrgUnitInfo> initalBgOrgMap = null;
    private Map<String, BgOrgUnitInfo> curOrgUnitMap = null;
    private Map<String, BgOrgUnitInfo> refBgDataOrgMap = null;
    private Map<String, BgOrgUnitInfo> newBgOrgMap = new HashMap<String, BgOrgUnitInfo>();
    private Map<String, BgOrgUnitInfo> delBgOrgMap = new HashMap<String, BgOrgUnitInfo>();
    private Map<String, BgOrgUnitInfo> updateBgOrgMap = new HashMap<String, BgOrgUnitInfo>();
    public static final String HAS_RELATION = "hasRelation";
    public static final String HAS_TEMPLATE = "hasTemplate";

    public BgOrgDataHelper() {
        this.initalBgOrgMap = new HashMap<String, BgOrgUnitInfo>();
        this.curOrgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        this.refBgDataOrgMap = new HashMap<String, BgOrgUnitInfo>();
    }

    public void removeOpt(BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        this.removeMapElement(this.newBgOrgMap, info);
        this.removeMapElement(this.updateBgOrgMap, info);
        this.removeMapElement(this.curOrgUnitMap, info);
        this.addDelMapElement(info);
    }

    public void addOpt(BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        this.removeMapElement(this.delBgOrgMap, info);
        this.addMapElement(this.curOrgUnitMap, info);
        this.addUpdateMapElement(info);
        this.addNewMapElement(info);
    }

    public void addOpt(Collection<BgOrgUnitInfo> collection) {
        if (EmptyUtil.isEmpty(collection)) {
            return;
        }
        for (BgOrgUnitInfo info : collection) {
            this.addOpt(info);
        }
    }

    public void addOrgUnitMapFromCol(Map<String, BgOrgUnitInfo> map, List<BgOrgUnitInfo> orgUnitColl) {
        if (EmptyUtil.isEmpty(orgUnitColl) || map == null) {
            return;
        }
        for (BgOrgUnitInfo info : orgUnitColl) {
            this.addMapElement(map, info);
        }
    }

    public void addMapElement(Map<String, BgOrgUnitInfo> map, BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info) || map == null) {
            return;
        }
        String id = info.getId().toString();
        if (map.containsKey(id) && map.get(id).equals(info) && map.get(id).isIsVirtual() == info.isIsVirtual()) {
            return;
        }
        map.put(id, info);
    }

    public void addMapElement2(Map<String, BgOrgUnitInfo> map, BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info) || map == null) {
            return;
        }
        String id = info.getId().toString();
        map.put(id, info);
    }

    public void addUpdateMapElement(BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        BgOrgUnitInfo initalOrgInfo = null;
        String id = info.getId().toString();
        if (this.initalBgOrgMap.containsKey(id)) {
            initalOrgInfo = this.initalBgOrgMap.get(id);
            info.setId(initalOrgInfo.getId());
            if (!info.equals(initalOrgInfo) || !info.equals(this.updateBgOrgMap.get(id))) {
                info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
                this.addMapElement2(this.updateBgOrgMap, info);
            }
        }
    }

    public void addNewMapElement(BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        String id = info.getId().toString();
        if (this.initalBgOrgMap.containsKey(id)) {
            return;
        }
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        this.addMapElement2(this.newBgOrgMap, info);
    }

    public void addInitalMapElement(BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        this.addMapElement(this.curOrgUnitMap, info);
        this.addMapElement(this.initalBgOrgMap, (BgOrgUnitInfo)info.clone());
    }

    public void addDelMapElement(BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        String id = info.getId().toString();
        if (!this.initalBgOrgMap.containsKey(id)) {
            return;
        }
        this.addMapElement2(this.delBgOrgMap, this.initalBgOrgMap.get(id));
    }

    public void removeMapElement(Map<String, BgOrgUnitInfo> map, BgOrgUnitInfo info) {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info) || map == null) {
            return;
        }
        String id = info.getId().toString();
        if (map.containsKey(id)) {
            map.remove(id);
        }
    }

    public List<BgOrgUnitInfo> getCurrentMap2List() {
        ArrayList<BgOrgUnitInfo> curBgOrgList = new ArrayList<BgOrgUnitInfo>();
        if (this.curOrgUnitMap.isEmpty()) {
            return curBgOrgList;
        }
        for (BgOrgUnitInfo info : this.curOrgUnitMap.values()) {
            curBgOrgList.add(info);
        }
        return curBgOrgList;
    }

    public void clear() {
        this.newBgOrgMap.clear();
        this.delBgOrgMap.clear();
        this.updateBgOrgMap.clear();
        this.initalBgOrgMap.clear();
        this.curOrgUnitMap.clear();
        this.refBgDataOrgMap.clear();
    }

    public void submit(String viewID) throws BOSException, EASBizException {
        ArrayList<BgOrgUnitInfo> addNewlist = new ArrayList<BgOrgUnitInfo>();
        ArrayList<BgOrgUnitInfo> updateList = new ArrayList<BgOrgUnitInfo>();
        ArrayList<BOSUuid> delPKList = new ArrayList<BOSUuid>();
        if (!this.newBgOrgMap.isEmpty()) {
            for (BgOrgUnitInfo info : this.newBgOrgMap.values()) {
                addNewlist.add(info);
            }
        }
        if (!this.delBgOrgMap.isEmpty()) {
            for (BgOrgUnitInfo info : this.delBgOrgMap.values()) {
                delPKList.add(info.getId());
            }
        }
        this.updateChangedShowLevelOrg(this.updateBgOrgMap, this.curOrgUnitMap, this.initalBgOrgMap);
        if (!this.updateBgOrgMap.isEmpty()) {
            for (BgOrgUnitInfo info : this.updateBgOrgMap.values()) {
                updateList.add(info);
            }
        }
        this.getBizInterface().persistData(BOSUuid.read((String)viewID), addNewlist, delPKList, updateList);
    }

    private void updateChangedShowLevelOrg(Map<String, BgOrgUnitInfo> updateBgOrgMap, Map<String, BgOrgUnitInfo> curOrgUnitMap, Map<String, BgOrgUnitInfo> initalBgOrgMap) {
        String curOrgId2 = null;
        int curShowLevel = -1;
        for (String curOrgId2 : curOrgUnitMap.keySet()) {
            curShowLevel = curOrgUnitMap.get(curOrgId2).getShowLevel();
            int initShowLevel = -1;
            if (!initalBgOrgMap.containsKey(curOrgId2) || (initShowLevel = initalBgOrgMap.get(curOrgId2).getShowLevel()) == curShowLevel) continue;
            updateBgOrgMap.put(curOrgId2, curOrgUnitMap.get(curOrgId2));
        }
    }

    protected IBgOrgUnit getBizInterface() throws BOSException {
        return BgOrgUnitFactory.getRemoteInstance();
    }

    public Map<String, BgOrgUnitInfo> getNewBgOrgMap() {
        return this.newBgOrgMap;
    }

    public Map<String, BgOrgUnitInfo> getDelBgOrgMap() {
        return this.delBgOrgMap;
    }

    public Map<String, BgOrgUnitInfo> getUpdateBgOrgMap() {
        return this.updateBgOrgMap;
    }

    public Map<String, BgOrgUnitInfo> getInitalBgOrgMap() {
        return this.initalBgOrgMap;
    }

    public Map<String, BgOrgUnitInfo> getCurOrgUnitMap() {
        return this.curOrgUnitMap;
    }

    public Map<String, BgOrgUnitInfo> getRefBgDataOrgMap() {
        return this.refBgDataOrgMap;
    }
}

