/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComponentDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ctrl.swing.util.JVM;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.client.SefKDComponentDialog;
import com.kingdee.eas.ma.mbg.client.utils.BgOrgUnitLoadAllUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgOrgTreeFindHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgOrgTreeFindHelper.class);
    private static int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    private static KDTreeView treeViewLeft = null;
    private static KDTree treeLeft = null;
    private static CoreUI owner = null;
    private static String bgOrgViewId = null;
    private static KDComponentDialog findDialog;
    private static KDButton findNextBtn;
    private static KDButton closeBtn;
    private static KDLabelContainer findNextLabel;
    private static KDTextField findNextTxt;
    private static List nodeList;
    private static String textToFound;
    private static int foundIndex;
    private static int currentIndex;
    private static KDComponentDialog notFoundDialog;
    private static KDComponentDialog finishSearchDialog;
    private static boolean finishSearch;

    public BgOrgTreeFindHelper(CoreUI owner, KDTreeView treeViewLeft, KDTree treeLeft, String bgOrgViewId) {
        BgOrgTreeFindHelper.owner = owner;
        BgOrgTreeFindHelper.treeViewLeft = treeViewLeft;
        BgOrgTreeFindHelper.treeLeft = treeLeft;
        BgOrgTreeFindHelper.bgOrgViewId = bgOrgViewId;
    }

    public static void initTreeUnitFind() {
        InputMap inputmap = owner.getInputMap(WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        inputmap.put(KeyStroke.getKeyStroke(70, 128), "findNext");
        ActionMap actionmap = treeViewLeft.getActionMap();
        actionmap.put("findNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgOrgTreeFindHelper.showFindNextDialog();
            }
        });
        for (int i = 0; i < treeViewLeft.getControlPane().getComponents().length; ++i) {
            KDWorkButton findBtn;
            if (!(treeViewLeft.getControlPane().getComponent(i) instanceof KDWorkButton) || !(findBtn = (KDWorkButton)treeViewLeft.getControlPane().getComponent(i)).getActionCommand().toString().equalsIgnoreCase("findNode") || findBtn.getActionListeners().length != 1) continue;
            findBtn.removeActionListener(findBtn.getActionListeners()[0]);
            findBtn.addActionListener((ActionListener)new FindBtnActionListener());
        }
    }

    private static void showFindNextDialog() {
        DefaultTreeModel newTreeModel;
        if (treeLeft != null && (newTreeModel = (DefaultTreeModel)treeLeft.getModel()) != null && newTreeModel.getRoot() != null) {
            Window w = SwingUtilities.windowForComponent((Component)owner);
            findDialog = w instanceof Dialog ? new KDComponentDialog((Dialog)w) : (w instanceof Frame ? new KDComponentDialog((Frame)w) : new KDComponentDialog());
            BgOrgTreeFindHelper.setFindDialogModal();
            findDialog.setLFStyle(2);
            findDialog.setTitle(BgOrgTreeFindHelper.getMLS("findNodeDialogTitle", BgNFSHelper.getHardCodeRes("findNode")));
            findNextBtn = new KDButton(BgOrgTreeFindHelper.getMLS("findNext", BgNFSHelper.getHardCodeRes("findNext")));
            findNextBtn.setLimitedSize(false);
            findNextBtn.setFocusable(false);
            closeBtn = new KDButton(BgOrgTreeFindHelper.getMLS("closeDialog", BgNFSHelper.getHardCodeRes("close")));
            closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    findDialog.dispose();
                }
            });
            findDialog.addButton(closeBtn);
            findDialog.addButton(findNextBtn);
            findNextLabel = new KDLabelContainer();
            findNextTxt = new KDTextField();
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)findNextTxt, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
            findNextLabel.setBoundLabelText(BgOrgTreeFindHelper.getMLS("findContentLabel", BgNFSHelper.getHardCodeRes("findContent") + "  "));
            findNextLabel.setBoundEditor((JComponent)findNextTxt);
            findNextLabel.setPreferredSize(new Dimension(270, 21));
            findNextLabel.setBoundLabelUnderline(true);
            findDialog.setDialogComponent((Component)findNextLabel);
            findDialog.setSize(290, 118);
            findDialog.setResizable(false);
            findNextBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        BgOrgTreeFindHelper.loadAllTree();
                    }
                    catch (EASBizException e2) {
                        logger.error((Object)("BgOrgTreeFindUtils.loadAllTree() error : " + e2.getMessage()));
                    }
                    catch (BOSException e3) {
                        logger.error((Object)("BgOrgTreeFindUtils.loadAllTree() error : " + e3.getMessage()));
                    }
                    nodeList = new ArrayList();
                    DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)((DefaultTreeModel)treeLeft.getModel()).getRoot();
                    Enumeration e1 = root.preorderEnumeration();
                    while (e1.hasMoreElements()) {
                        nodeList.add(e1.nextElement());
                    }
                    BgOrgTreeFindHelper.findNode();
                }
            });
            nodeList = new ArrayList();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)((DefaultTreeModel)treeLeft.getModel()).getRoot();
            Enumeration e = root.preorderEnumeration();
            while (e.hasMoreElements()) {
                nodeList.add(e.nextElement());
            }
            findDialog.getRootPane().setDefaultButton((JButton)findNextBtn);
            findDialog.setLocation(treeViewLeft.getControlPane().getLocationOnScreen());
            findDialog.show();
        }
    }

    private static void setFindDialogModal() {
        if (JVM.current().isOverOneDotFive() && findDialog != null) {
            findDialog.setModal(true);
        }
    }

    private static void findNode() {
        String nodeText = "";
        int size = nodeList.size();
        String input = findNextTxt.getText().toLowerCase().trim();
        if (input != null && input.trim().length() > 0) {
            DefaultKingdeeTreeNode currentNode;
            if (!textToFound.equalsIgnoreCase(input)) {
                finishSearch = false;
                textToFound = input;
                currentNode = null;
                foundIndex = -1;
                currentIndex = 0;
            }
            if ((currentIndex = foundIndex + 1) < size) {
                int i;
                for (i = currentIndex; i < size; ++i) {
                    Object node = nodeList.get(i);
                    if (!(node instanceof DefaultKingdeeTreeNode)) continue;
                    currentNode = (DefaultKingdeeTreeNode)nodeList.get(i);
                    nodeText = currentNode.getText();
                    String string = nodeText = StringUtils.isEmpty((String)nodeText) ? "" : nodeText.toLowerCase();
                    if (nodeText == null || nodeText.indexOf(textToFound) == -1) continue;
                    treeLeft.setSelectionNode(currentNode);
                    treeLeft.scrollPathToVisible(treeLeft.getSelectionPath());
                    foundIndex = i;
                    if (i != nodeList.size() - 1) break;
                    ++i;
                    break;
                }
                if (i == size) {
                    finishSearch = true;
                }
            }
            if (foundIndex == -1) {
                if (notFoundDialog == null) {
                    notFoundDialog = new KDComponentDialog((Dialog)findDialog);
                    notFoundDialog.setLFStyle(2);
                    notFoundDialog.setTitle(BgOrgTreeFindHelper.getMLS("notFindNodeDialogTitle", BgNFSHelper.getHardCodeRes("msgWarn")));
                    KDButton ok = new KDButton(BgOrgTreeFindHelper.getMLS("OKBtn", BgNFSHelper.getHardCodeRes("ok")));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            notFoundDialog.dispose();
                        }
                    });
                    KDLabel notFoundLbl = new KDLabel(BgOrgTreeFindHelper.getMLS("searchFinish", BgNFSHelper.getHardCodeRes("searchFinish")));
                    notFoundLbl.setHorizontalAlignment(0);
                    notFoundLbl.setPreferredSize(new Dimension(290, 21));
                    notFoundDialog.addButton(ok);
                    notFoundDialog.setDialogComponent((Component)notFoundLbl);
                }
                notFoundDialog.setLocation(findDialog.getLocation());
                notFoundDialog.setSize(290, 118);
                notFoundDialog.setModal(true);
                notFoundDialog.show();
            } else if (finishSearch) {
                textToFound = "";
                if (finishSearchDialog == null) {
                    finishSearchDialog = new KDComponentDialog((Dialog)findDialog);
                    finishSearchDialog.setLFStyle(2);
                    finishSearchDialog.setTitle(BgOrgTreeFindHelper.getMLS("notFindNodeDialogTitle", BgNFSHelper.getHardCodeRes("msgWarn")));
                    KDButton ok = new KDButton(BgOrgTreeFindHelper.getMLS("OKBtn", BgNFSHelper.getHardCodeRes("ok")));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            finishSearchDialog.dispose();
                        }
                    });
                    KDLabel notFoundLbl = new KDLabel(BgOrgTreeFindHelper.getMLS("searchFinish2", BgNFSHelper.getHardCodeRes("searchFinish2")));
                    notFoundLbl.setHorizontalAlignment(0);
                    notFoundLbl.setPreferredSize(new Dimension(290, 21));
                    finishSearchDialog.addButton(ok);
                    finishSearchDialog.setDialogComponent((Component)notFoundLbl);
                }
                finishSearchDialog.setLocation(findDialog.getLocation());
                finishSearchDialog.setSize(290, 118);
                finishSearchDialog.setModal(true);
                finishSearchDialog.show();
            }
        }
    }

    private static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.swing.KDTreeView", (String)defaultValue);
    }

    private static void loadAllTree() throws EASBizException, BOSException {
        if (treeLeft == null) {
            return;
        }
        int[] row = treeLeft.getSelectionRows();
        try {
            treeLeft.setModel(null);
            TreeModel treeModel = BgOrgUnitUtils.loadBgOrgTreeModel(treeLeft, null, null, bgOrgViewId, true, null, false);
            treeLeft.setModel(treeModel);
            treeLeft.expandAllNodes(true, (TreeNode)((DefaultKingdeeTreeNode)treeModel.getRoot()));
        }
        catch (Exception e) {
            logger.error((Object)("BgOrgTreeFindUtils.loadAllTree() error : " + e.getMessage()));
        }
    }

    public static BgOrgUnitLoadAllUtils replaceFindButton(KDTreeView treeViewOrgUnit, KDTree treeOrgUnit) {
        int length = treeViewOrgUnit.getControlPane().getComponentCount();
        treeViewOrgUnit.getControlPane().getComponent(length - 1).setVisible(false);
        treeViewOrgUnit.getControlPane().getComponent(length - 1).setEnabled(false);
        KDWorkButton findBtn = new KDWorkButton((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)BgOrgTreeFindHelper.getMLS("picFind", "tree_demand.png"))));
        findBtn.setActionCommand("findNode");
        findBtn.setToolTipText(BgOrgTreeFindHelper.getMLS("menuToolTipFind", BgNFSHelper.getHardCodeRes("find")));
        SefKDComponentDialog dialog = new SefKDComponentDialog(treeViewOrgUnit, treeOrgUnit);
        findBtn.addActionListener((ActionListener)new SefKDComponentDialog.FindBtnActionListener(dialog));
        treeViewOrgUnit.getControlPane().add((Component)findBtn);
        return dialog.getLoadUtils();
    }

    static {
        textToFound = "";
        foundIndex = -1;
        currentIndex = 0;
        finishSearch = false;
    }

    private static class FindBtnActionListener
    implements ActionListener {
        private FindBtnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgOrgTreeFindHelper.showFindNextDialog();
        }
    }
}

